## 4.6.0.20241004 (2024-10-04)

Add missing ssl related arguments to Redis from_url method ([#12166](https://github.com/python/typeshed/pull/12166))

## 4.6.0.20240903 (2024-09-03)

Redis: Correct ExpiryT alias ([#12611](https://github.com/python/typeshed/pull/12611))

## 4.6.0.20240819 (2024-08-19)

Forbid extremely long line lengths in non-autogenerated stubs ([#12537](https://github.com/python/typeshed/pull/12537))

Co-authored-by: Alex Waygood <Alex.Waygood@Gmail.com>

## 4.6.0.20240806 (2024-08-06)

Bump mypy to 1.11.1 ([#12463](https://github.com/python/typeshed/pull/12463))

## 4.6.0.20240726 (2024-07-26)

Mark redis as obsolete ([#12426](https://github.com/python/typeshed/pull/12426))

## 4.6.0.20240425 (2024-04-25)

Bump pyright to v1.1.360 ([#11810](https://github.com/python/typeshed/pull/11810))

## 4.6.0.20240423 (2024-04-23)

Add precise values for enum members where possible ([#11299](https://github.com/python/typeshed/pull/11299))

Co-authored-by: Jelle Zijlstra <jelle.zijlstra@gmail.com>
Co-authored-by: Alex Waygood <alex.waygood@gmail.com>

## 4.6.0.20240417 (2024-04-17)

Remove remaining bare `Incomplete`s ([#11768](https://github.com/python/typeshed/pull/11768))

Enable Y065

## 4.6.0.20240409 (2024-04-09)

Rework redis/asyncio/{connection,sentinel}.pyi ([#10370](https://github.com/python/typeshed/pull/10370))

Closes: #10362

## 4.6.0.20240311 (2024-03-11)

Make stubtest pass on libsass/passlib/redis/tree-sitter if you're using Python 3.12 ([#11561](https://github.com/python/typeshed/pull/11561))

Use PEP 570 syntax in third party stubs ([#11554](https://github.com/python/typeshed/pull/11554))

## 4.6.0.20240218 (2024-02-18)

fix(redis): make xadd fields use SupportsItems ([#10780](https://github.com/python/typeshed/pull/10780))

Co-authored-by: Alex Waygood <Alex.Waygood@Gmail.com>
Co-authored-by: Jelle Zijlstra <jelle.zijlstra@gmail.com>

## 4.6.0.20240106 (2024-01-06)

Update typing_extensions imports in third-party stubs ([#11245](https://github.com/python/typeshed/pull/11245))

## 4.6.0.11 (2023-11-24)

redis: remove unused `type: ignore`s ([#11062](https://github.com/python/typeshed/pull/11062))

## 4.6.0.10 (2023-11-07)

Remove redundant inheritances from `Generic` and various `typing` protocols ([#10981](https://github.com/python/typeshed/pull/10981))

## 4.6.0.9 (2023-11-03)

Add retry_on_error params for redis stub ([#10961](https://github.com/python/typeshed/pull/10961))

## 4.6.0.8 (2023-10-27)

Remove many redundant inheritances from `Generic[]` ([#10933](https://github.com/python/typeshed/pull/10933))

## 4.6.0.7 (2023-09-23)

Add overloads to redis.asyncio.Redis ([#10742](https://github.com/python/typeshed/pull/10742))

## 4.6.0.6 (2023-09-12)

[redis] Don't recommend uninstalling types-redis ([#10694](https://github.com/python/typeshed/pull/10694))

## 4.6.0.5 (2023-08-22)

redis: Improve typing of xadd/xdel ([#10531](https://github.com/python/typeshed/pull/10531))

typing copied from
https://redis-py.readthedocs.io/en/stable/commands.html#redis.commands.cluster.RedisClusterCommands.xadd
https://redis-py.readthedocs.io/en/stable/commands.html#redis.commands.cluster.RedisClusterCommands.xdel

## 4.6.0.4 (2023-08-16)

[stubsabot] Mark redis as obsolete since 5.0.0 ([#10587](https://github.com/python/typeshed/pull/10587))

## 4.6.0.3 (2023-07-20)

Add an upstream_repository field to METADATA.toml ([#10487](https://github.com/python/typeshed/pull/10487))

Closes: #10478

## 4.6.0.2 (2023-07-04)

Redis: Add missing types for id in xadd ([#10403](https://github.com/python/typeshed/pull/10403))

## 4.6.0.1 (2023-07-01)

Use proper return types for `__await__` methods in `redis.asyncio.client` ([#10379](https://github.com/python/typeshed/pull/10379))

## 4.6.0.0 (2023-06-27)

Bump redis to 4.6.0 ([#10360](https://github.com/python/typeshed/pull/10360))

Closes: #10359

## 4.5.5.2 (2023-05-11)

Bump `mypy` to `1.3.0` ([#10173](https://github.com/python/typeshed/pull/10173))

Co-authored-by: AlexWaygood <alex.waygood@gmail.com>

## 4.5.5.1 (2023-05-10)

Add `partial_stub` metadata field ([#10157](https://github.com/python/typeshed/pull/10157))

## 4.5.5.0 (2023-05-09)

[redis] Add new methods to `RedisClusterCommands` ([#10162](https://github.com/python/typeshed/pull/10162))

Update `redis` to `4.5.5` ([#10161](https://github.com/python/typeshed/pull/10161))

## 4.5.4.2 (2023-05-07)

Redis: Add missing exported names ([#10151](https://github.com/python/typeshed/pull/10151))

## 4.5.4.1 (2023-03-30)

[redis] Add CredentialProvider types to __init__.pyi ([#9982](https://github.com/python/typeshed/pull/9982))

## 4.5.4.0 (2023-03-29)

[redis] Fix type of connection_class in ConnectionPool ([#9981](https://github.com/python/typeshed/pull/9981))

Update stubs to 4.5.4

## 4.5.3.1 (2023-03-28)

Add retry parameters to redis.client.from_url ([#9969](https://github.com/python/typeshed/pull/9969))

Add defaults for third-party stubs Q-T ([#9959](https://github.com/python/typeshed/pull/9959))

## 4.5.3.0 (2023-03-23)

[stubsabot] Bump redis to 4.5.3 ([#9928](https://github.com/python/typeshed/pull/9928))

Release: https://pypi.org/pypi/redis/4.5.3
Homepage: https://github.com/redis/redis-py
Changelog: https://github.com/redis/redis-py/releases
Diff: https://github.com/redis/redis-py/compare/v4.5.2...v4.5.3

Stubsabot analysis of the diff between the two releases:
 - 0 public Python files have been added.
 - 0 files included in typeshed's stubs have been deleted.
 - 2 files included in typeshed's stubs have been modified or renamed: `redis/asyncio/client.py`, `redis/asyncio/cluster.py`.
 - Total lines of Python code added: 58.
 - Total lines of Python code deleted: 6.

## 4.5.2.0 (2023-03-21)

[redis] Update stubs to 4.5.2 ([#9912](https://github.com/python/typeshed/pull/9912))

## 4.5.1.5 (2023-03-11)

Add missing properties for `redis.lock.Lock` ([#9867](https://github.com/python/typeshed/pull/9867))

## 4.5.1.4 (2023-02-26)

Improve many `__(a)exit__` annotations ([#9696](https://github.com/python/typeshed/pull/9696))

## 4.5.1.3 (2023-02-22)

Update `Unused` parameters in `stubs/` ([#9704](https://github.com/python/typeshed/pull/9704))

* Update _Unused TypeAlias

* Update `object | None` params

* Replace unused `object` parameters with `Unused` alias

## 4.5.1.2 (2023-02-21)

Stubtest settings: change `ignore_missing_stub` default to `false` ([#9779](https://github.com/python/typeshed/pull/9779))

If you're reading about this commit from an autogenerated changelog entry, this should have no user-visible impact on how the stubs are interpreted by a type checker; it's just an internal change to how typeshed's tests work.

## 4.5.1.1 (2023-02-15)

Use `typing_extensions.Self` instead of `_typeshed.Self` ([#9702](https://github.com/python/typeshed/pull/9702))

## 4.5.1.0 (2023-02-10)

[redis] Update to 4.5.1 ([#9697](https://github.com/python/typeshed/pull/9697))

Also add a few argument defaults

## 4.4.0.6 (2023-02-03)

[redis] Initial stubs for `redis.asyncio.cluster` ([#9468](https://github.com/python/typeshed/pull/9468))

Co-authored-by: Nikita Sobolev <mail@sobolevn.me>
Co-authored-by: Alex Waygood <Alex.Waygood@Gmail.com>
Co-authored-by: Sebastian Rittau <srittau@rittau.biz>

## 4.4.0.5 (2023-02-02)

Manual changes of `Any` union to `Incomplete` in stubs folder ([#9566](https://github.com/python/typeshed/pull/9566))

- ClassVar[Any | None]
- Missed previous changes due to alias
- Manual review of leftover Any unions (`| Any` and `Any |`)

## 4.4.0.4 (2023-01-28)

Add some missing Self return annotations in redis ([#9601](https://github.com/python/typeshed/pull/9601))

## 4.4.0.3 (2023-01-18)

Replace `Any` with `Incomplete` in many places ([#9565](https://github.com/python/typeshed/pull/9565))

## 4.4.0.2 (2023-01-18)

Replace `Any` with `Incomplete` in many places ([#9558](https://github.com/python/typeshed/pull/9558))

## 4.4.0.1 (2023-01-17)

Complete and validate `redis.ocsp` (use requests, cryptography and pyopenssl) ([#9528](https://github.com/python/typeshed/pull/9528))

## 4.4.0.0 (2023-01-05)

Bump redis to 4.4.0 ([#9458](https://github.com/python/typeshed/pull/9458))

Co-authored-by: AlexWaygood <alex.waygood@gmail.com>

## 4.3.21.7 (2022-12-28)

Check for unused `pyright: ignore` and differentiate from mypy ignores ([#9397](https://github.com/python/typeshed/pull/9397))

## 4.3.21.6 (2022-11-28)

[redis] update to 4.3.5 ([#9284](https://github.com/python/typeshed/pull/9284))

## 4.3.21.5 (2022-11-23)

Pin `redis` to 4.3.4 in CI ([#9247](https://github.com/python/typeshed/pull/9247))

We're about to get a daily test failure with 63 stubtest errors (see the Ubuntu stubtest failure in #9187) due to the release of redis-py 4.3.5, and I'd rather that didn't happen.

## 4.3.21.4 (2022-11-08)

Fix and allow classes with missing metaclasses ([#9136](https://github.com/python/typeshed/pull/9136))

## 4.3.21.3 (2022-10-21)

Fixes redis.asyncio.client: `AsyncIterator` cannot be `async def` in stubs. ([#8961](https://github.com/python/typeshed/pull/8961))

Without the `yield` statement in the method body, these are interpreted by mypy as coroutines that return an `AsyncIterator`.

Closes #8960

## 4.3.21.1 (2022-10-03)

Add `redis.asyncio.parser` ([#8830](https://github.com/python/typeshed/pull/8830))

Source: https://github.com/redis/redis-py/blob/master/redis/asyncio/parser.py

[redis] Improve `fail` parameter of `Retry.call_with_retry` ([#8827](https://github.com/python/typeshed/pull/8827))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>
Co-authored-by: Jelle Zijlstra <jelle.zijlstra@gmail.com>

[redis] Improve `redis.asyncio.lock` types ([#8826](https://github.com/python/typeshed/pull/8826))

## 4.3.21 (2022-09-27)

Bump mypy to 0.981 ([#8796](https://github.com/python/typeshed/pull/8796))

## 4.3.20 (2022-09-02)

`redis`: Improve `kwargs` typing in `sentinel` ([#8661](https://github.com/python/typeshed/pull/8661))

## 4.3.19 (2022-08-29)

redis: Add `_Encodable` type alias ([#8638](https://github.com/python/typeshed/pull/8638))

## 4.3.18 (2022-08-27)

redis: Improve `ClusterPubSub` types ([#8627](https://github.com/python/typeshed/pull/8627))

## 4.3.17 (2022-08-22)

Update `redis/cluster.pyi` ([#8593](https://github.com/python/typeshed/pull/8593))

`redis`: Do not override `AbstractRedis.RESPONSE_CALLBACKS` ([#8592](https://github.com/python/typeshed/pull/8592))

## 4.3.16 (2022-08-21)

Further improve `redis.cluster` ([#8578](https://github.com/python/typeshed/pull/8578))

## 4.3.15 (2022-08-20)

Improve `redis.cluster` types ([#8573](https://github.com/python/typeshed/pull/8573))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>
Co-authored-by: Alex Waygood <Alex.Waygood@Gmail.com>

`redis`: correct `set` command parameter types ([#8536](https://github.com/python/typeshed/pull/8536))

## 4.3.14 (2022-08-10)

Remove a few unused `TypedDict`s ([#8522](https://github.com/python/typeshed/pull/8522))

## 4.3.13 (2022-08-01)

redis.backoff: fix  `cap` and `base` type (float) ([#8454](https://github.com/python/typeshed/pull/8454))

## 4.3.12 (2022-07-30)

Improve `redis.cluster` annotations ([#8379](https://github.com/python/typeshed/pull/8379))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>
Co-authored-by: Alex Waygood <Alex.Waygood@Gmail.com>

## 4.3.11 (2022-07-23)

Improve `redis.crc` types ([#8375](https://github.com/python/typeshed/pull/8375))

## 4.3.10 (2022-07-22)

Improve `redis.utils` types ([#8362](https://github.com/python/typeshed/pull/8362))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>
Co-authored-by: Alex Waygood <Alex.Waygood@Gmail.com>

## 4.3.9 (2022-07-21)

Improve `redis.retry` types ([#8354](https://github.com/python/typeshed/pull/8354))

## 4.3.8 (2022-07-21)

Annotate some `redis.backoff` items ([#8352](https://github.com/python/typeshed/pull/8352))

## 4.3.7 (2022-07-20)

Improve types of `redis.connection` module ([#8342](https://github.com/python/typeshed/pull/8342))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>
Co-authored-by: Alex Waygood <Alex.Waygood@Gmail.com>

## 4.3.6 (2022-07-19)

Type async Pipeline commands explicitly ([#8325](https://github.com/python/typeshed/pull/8325))

## 4.3.5 (2022-07-19)

Improve `redis.sentinel` types ([#8331](https://github.com/python/typeshed/pull/8331))

## 4.3.4 (2022-07-12)

Import `Match` and `Pattern` from `re`, not `typing` ([#8277](https://github.com/python/typeshed/pull/8277))

## 4.3.3 (2022-06-28)

Update redis stubs to 4.3.4 ([#8199](https://github.com/python/typeshed/pull/8199))

Fixes #8196

## 4.3.2 (2022-06-23)

Improve `redis/asyncio/client.pyi` ([#8141](https://github.com/python/typeshed/pull/8141))

## 4.3.1 (2022-06-21)

Rename some confusingly named type aliases ([#8129](https://github.com/python/typeshed/pull/8129))

## 4.3.0 (2022-06-20)

Update redis stubs to 4.3 ([#8108](https://github.com/python/typeshed/pull/8108))

## 4.2.8 (2022-06-18)

redis: remove duplicate allowlist entries ([#8097](https://github.com/python/typeshed/pull/8097))

Co-authored-by: hauntsaninja <>

## 4.2.7 (2022-06-15)

`redis`: fix more unconstrained `TypeVar`s ([#8084](https://github.com/python/typeshed/pull/8084))

## 4.2.6 (2022-05-26)

redis: Fix unconstrained TypeVars in a few redis commands ([#7942](https://github.com/python/typeshed/pull/7942))

Part of #7928

## 4.2.5 (2022-05-21)

Simplify and correct many numeric unions ([#7906](https://github.com/python/typeshed/pull/7906))

Unblocks PyCQA/flake8-pyi#222

## 4.2.4 (2022-05-19)

reds: commands from asyncio module must be async ([#7820](https://github.com/python/typeshed/pull/7820))

redis-py has introduced an asyncio module since 4.2 and almost all
commands should be async if the redis.asyncio.Redis is used instead of
redis.Redis.

This changes adds the types for all core commands.

Related to #7597

## 4.2.3 (2022-05-15)

Add `__version__`/`VERSION` to redis ([#7838](https://github.com/python/typeshed/pull/7838))

## 4.2.2 (2022-05-07)

Import generics from standard modules in all third-party stubs ([#7791](https://github.com/python/typeshed/pull/7791))

## 4.2.1 (2022-05-04)

Add missing redis modules and classes ([#7676](https://github.com/python/typeshed/pull/7676))

This adds asyncio support and support for redis.typing.

## 4.2.0 (2022-04-24)

Update redis stubs to 4.2 ([#7675](https://github.com/python/typeshed/pull/7675))

Closes #7597

## 4.1.22 (2022-04-20)

Use `TypeAlias` for type aliases where possible, part II ([#7667](https://github.com/python/typeshed/pull/7667))

## 4.1.21 (2022-04-16)

Third-party stubs: import from `collections.abc` where possible ([#7637](https://github.com/python/typeshed/pull/7637))

## 4.1.20 (2022-04-16)

Use `TypeAlias` where possible for type aliases ([#7630](https://github.com/python/typeshed/pull/7630))

## 4.1.19 (2022-04-01)

Third-party stubs: Improve several `__exit__` methods ([#7575](https://github.com/python/typeshed/pull/7575))

## 4.1.18 (2022-03-16)

Use PEP 604 syntax wherever possible ([#7493](https://github.com/python/typeshed/pull/7493))

## 4.1.17 (2022-02-23)

Re-export RedisCluster from redis ([#7371](https://github.com/python/typeshed/pull/7371))

## 4.1.16 (2022-02-17)

Update to redis 4.1.4 ([#7247](https://github.com/python/typeshed/pull/7247))

Closes: #7245

## 4.1.15 (2022-02-03)

Improve `__enter__` & constructor methods ([#7114](https://github.com/python/typeshed/pull/7114))

## 4.1.14 (2022-02-02)

Redis: Annotate .lolwut() ([#7104](https://github.com/python/typeshed/pull/7104))

## 4.1.13 (2022-01-31)

Redis: Annotate .pttl(), .dump(), and .getdel() ([#7091](https://github.com/python/typeshed/pull/7091))

## 4.1.12 (2022-01-31)

Upgrade black version ([#7089](https://github.com/python/typeshed/pull/7089))

## 4.1.11 (2022-01-28)

Update redis stubs for 4.1.2 ([#7064](https://github.com/python/typeshed/pull/7064))

## 4.1.10 (2022-01-19)

Update redis stubs to 4.1.1 ([#6960](https://github.com/python/typeshed/pull/6960))

Closes: #6951

## 4.1.9 (2022-01-19)

Revert "Temporarily fix redis version to 4.1.0" ([#6957](https://github.com/python/typeshed/pull/6957))

This reverts commit 7d2de33bba2808e98b3caa46904418ad9a1b07f5.

Temporarily fix redis version to 4.1.0 ([#6952](https://github.com/python/typeshed/pull/6952))

Quick fix for #6951

## 4.1.8 (2022-01-13)

Annotate command kwargs arguments ([#6721](https://github.com/python/typeshed/pull/6721))

## 4.1.7 (2022-01-10)

Always use `_typeshed.Self`, where applicable ([#6880](https://github.com/python/typeshed/pull/6880))

* Always use `_typeshed.Self`, where applicable

* Revert changes to `google-cloud-ndb` (ambiguous)

* Remove empty line added by script

* Revert changes to `stubs/python-dateutil/dateutil/relativedelta.pyi`

* Manually add a few more that the script missed

* Improve `filelock` annotation

Source code here: https://github.com/tox-dev/py-filelock/blob/79ec7b2826e33b982fe83b057f359448b9d966ba/src/filelock/_api.py#L207

* Improve `opentracing/scope` annotation

Source code here: https://github.com/opentracing/opentracing-python/blob/3e1d357a348269ef54d67f761302fab93dbfc0f7/opentracing/scope.py#L71

* Improve `redis/client` stub

Source code here: https://github.com/redis/redis-py/blob/15f315a496c3267c8cbcc6d6d9c6005ea4d4a4d5/redis/client.py#L1217

* Improve `redis/lock` annotation

Source code here: https://github.com/redis/redis-py/blob/15f315a496c3267c8cbcc6d6d9c6005ea4d4a4d5/redis/lock.py#L155

* Improve `requests/models` annotation

Source code here: https://github.com/psf/requests/blob/d718e753834b84018014a23d663369ac27d1ab9c/requests/models.py#L653

## 4.1.6 (2022-01-09)

put redis.client._ScoreCastFuncReturn back ([#6876](https://github.com/python/typeshed/pull/6876))

#6829 removed it as unused but #6790 added a usage.

Minor improvements to redis stubs for scan and zset methods ([#6790](https://github.com/python/typeshed/pull/6790))

## 4.1.5 (2022-01-08)

Use lowercase `type` everywhere ([#6853](https://github.com/python/typeshed/pull/6853))

## 4.1.3 (2022-01-05)

Remove several unused `TypeVar`s ([#6829](https://github.com/python/typeshed/pull/6829))

## 4.1.2 (2022-01-02)

Never explicitly inherit from `object` in Python 3-only stubs ([#6777](https://github.com/python/typeshed/pull/6777))

## 4.1.1 (2021-12-28)

redis: Restore type annotations of ping() and save() ([#6720](https://github.com/python/typeshed/pull/6720))

Use PEP 585 syntax wherever possible ([#6717](https://github.com/python/typeshed/pull/6717))

## 4.1.0 (2021-12-27)

Update redis stubs to 4.1 ([#6711](https://github.com/python/typeshed/pull/6711))

Co-authored-by: Akuli <akuviljanen17@gmail.com>
Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

## 4.0.6 (2021-12-25)

redis: Add stubs for lmove and blmove ([#6586](https://github.com/python/typeshed/pull/6586))

## 4.0.5 (2021-12-21)

Fix Redis.zpopmin and zpopmax ([#6642](https://github.com/python/typeshed/pull/6642))

Co-authored-by: Sebastian Rittau <srittau@rittau.biz>

## 4.0.4 (2021-12-17)

Always import Protocol from typing in stubs ([#6617](https://github.com/python/typeshed/pull/6617))

## 4.0.3 (2021-12-01)

Fix various issues in redis.client ([#6464](https://github.com/python/typeshed/pull/6464))

## 4.0.2 (2021-12-01)

redis: fix several stubtest warnings ([#6378](https://github.com/python/typeshed/pull/6378))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>
Co-authored-by: Shantanu <12621235+hauntsaninja@users.noreply.github.com>
Co-authored-by: Jelle Zijlstra <jelle.zijlstra@gmail.com>

## 4.0.1 (2021-11-26)

Add mypy error codes to '# type: ignore' comments ([#6379](https://github.com/python/typeshed/pull/6379))

## 4.0.0 (2021-11-25)

Update redis stubs to version 4 ([#6368](https://github.com/python/typeshed/pull/6368))

## 3.5.18 (2021-11-23)

Reduce use of deprecated `typing` aliases ([#6358](https://github.com/python/typeshed/pull/6358))

## 3.5.17 (2021-11-18)

Revert "do not use mypy-specific syntax in '# type: ignore' comments" ([#6338](https://github.com/python/typeshed/pull/6338))

## 3.5.16 (2021-11-12)

Redis Sentinel master_for, slave_for returns a Redis client ([#6269](https://github.com/python/typeshed/pull/6269))

## 3.5.15 (2021-10-16)

Annotate Client.decr() and decrby() ([#6179](https://github.com/python/typeshed/pull/6179))

## 3.5.14 (2021-10-15)

Add redis/sentinel.pyi ([#6174](https://github.com/python/typeshed/pull/6174))

## 3.5.13 (2021-10-15)

Use lowercase tuple where possible ([#6170](https://github.com/python/typeshed/pull/6170))

## 3.5.12 (2021-10-12)

Add star to all non-0.1 versions ([#6146](https://github.com/python/typeshed/pull/6146))

## 3.5.11 (2021-10-09)

Add Redis.memory_purge() ([#6138](https://github.com/python/typeshed/pull/6138))

## 3.5.10 (2021-10-09)

Add memory_stats() to Redis ([#6137](https://github.com/python/typeshed/pull/6137))

## 3.5.9 (2021-09-29)

redis: include local property on Lock class ([#6083](https://github.com/python/typeshed/pull/6083))

The Lock class as a property local that has a token property that sometimes
needs be accessed / set.

```python
lock = redis.lock(key)
lock.local.token = token
lock.extend(10)
```

Technically the type of `local` is `SimpleNamespace | threading.local`
but I think this setup is a bit stricter but satisfies the API.

## 3.5.8 (2021-09-10)

Fix type of blocking_timeout argument to redis.lock.Lock ([#6019](https://github.com/python/typeshed/pull/6019))

## 3.5.7 (2021-08-29)

do not use mypy-specific syntax in '# type: ignore' comments ([#5953](https://github.com/python/typeshed/pull/5953))

