# Generated by Django 4.2.8 on 2024-01-03 15:23

import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import mini_buildd.util
import mini_buildd.models
import mini_buildd.config


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='AptKey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extra_options', mini_buildd.models.UnixTextField(blank=True)),
                ('pickled_data', models.TextField(blank=True)),
                ('status', models.IntegerField(choices=[(0, 'Removed'), (1, 'Prepared'), (2, 'Active')], default=0, editable=False)),
                ('last_checked', models.DateTimeField(default=datetime.datetime(1, 1, 1, 0, 0, tzinfo=datetime.timezone.utc), editable=False)),
                ('auto_reactivate', models.BooleanField(default=False, editable=False)),
                ('key_id', models.CharField(blank=True, default='', max_length=100)),
                ('key', mini_buildd.models.UnixTextField(blank=True, default='')),
                ('key_long_id', models.CharField(blank=True, default='', max_length=254)),
                ('key_created', models.CharField(blank=True, default='', max_length=254)),
                ('key_expires', models.CharField(blank=True, default='', max_length=254)),
                ('key_name', models.CharField(blank=True, default='', max_length=254)),
                ('key_fingerprint', models.CharField(blank=True, default='', max_length=254)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Architecture',
            fields=[
                ('extra_options', mini_buildd.models.UnixTextField(blank=True)),
                ('pickled_data', models.TextField(blank=True)),
                ('name', models.CharField(max_length=50, primary_key=True, serialize=False)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ArchitectureOption',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extra_options', mini_buildd.models.UnixTextField(blank=True)),
                ('pickled_data', models.TextField(blank=True)),
                ('optional', models.BooleanField(default=False)),
                ('build_architecture_all', models.BooleanField(default=False)),
                ('architecture', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mini_buildd.architecture')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Archive',
            fields=[
                ('extra_options', mini_buildd.models.UnixTextField(blank=True)),
                ('pickled_data', models.TextField(blank=True)),
                ('url', models.URLField(default='http://ftp.debian.org/debian/', max_length=512, primary_key=True, serialize=False)),
                ('ping', models.FloatField(default=-1.0, editable=False)),
            ],
            options={
                'ordering': ['url'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Chroot',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extra_options', mini_buildd.models.UnixTextField(blank=True)),
                ('pickled_data', models.TextField(blank=True)),
                ('status', models.IntegerField(choices=[(0, 'Removed'), (1, 'Prepared'), (2, 'Active')], default=0, editable=False)),
                ('last_checked', models.DateTimeField(default=datetime.datetime(1, 1, 1, 0, 0, tzinfo=datetime.timezone.utc), editable=False)),
                ('auto_reactivate', models.BooleanField(default=False, editable=False)),
                ('personality', models.CharField(blank=True, default='', editable=False, max_length=50)),
                ('personality_override', models.CharField(blank=True, default='', max_length=50)),
                ('architecture', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mini_buildd.architecture')),
            ],
            options={
                'ordering': ['source', 'architecture'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Component',
            fields=[
                ('extra_options', mini_buildd.models.UnixTextField(blank=True)),
                ('pickled_data', models.TextField(blank=True)),
                ('name', models.CharField(max_length=50, primary_key=True, serialize=False)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Distribution',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extra_options', mini_buildd.models.UnixTextField(blank=True)),
                ('pickled_data', models.TextField(blank=True)),
                ('build_dep_resolver', models.IntegerField(choices=[(0, 'apt'), (1, 'aptitude'), (2, 'internal')], default=1)),
                ('apt_allow_unauthenticated', models.BooleanField(default=False)),
                ('lintian_mode', models.IntegerField(choices=[(0, 'DISABLED'), (1, 'IGNORE'), (2, 'ERRFAIL'), (3, 'WARNFAIL')], default=2)),
                ('lintian_extra_options', models.CharField(default='--info', max_length=200)),
                ('piuparts_mode', models.IntegerField(choices=[(0, 'DISABLED'), (1, 'IGNORE'), (2, 'ERRFAIL'), (3, 'WARNFAIL')], default=0)),
                ('piuparts_extra_options', models.CharField(default='--info', max_length=200)),
                ('piuparts_root_arg', models.CharField(default='sudo', max_length=200)),
                ('chroot_setup_script', mini_buildd.models.UnixTextField(blank=True, default='')),
                ('sbuildrc_snippet', mini_buildd.models.UnixTextField(blank=True, default='')),
                ('architectures', models.ManyToManyField(through='mini_buildd.ArchitectureOption', to='mini_buildd.architecture')),
            ],
            options={
                'ordering': ['base_source'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EmailAddress',
            fields=[
                ('extra_options', mini_buildd.models.UnixTextField(blank=True)),
                ('pickled_data', models.TextField(blank=True)),
                ('address', models.EmailField(max_length=255, primary_key=True, serialize=False)),
                ('name', models.CharField(blank=True, max_length=255)),
            ],
            options={
                'verbose_name_plural': 'Email addresses',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Layout',
            fields=[
                ('extra_options', mini_buildd.models.UnixTextField(blank=True)),
                ('pickled_data', models.TextField(blank=True)),
                ('name', models.CharField(max_length=100, primary_key=True, serialize=False)),
                ('default_version', models.CharField(default='~%IDENTITY%%CODEVERSION%+1', max_length=100)),
                ('mandatory_version_regex', models.CharField(default='~%IDENTITY%%CODEVERSION%\\+[1-9]', max_length=100)),
                ('experimental_default_version', models.CharField(default='~%IDENTITY%%CODEVERSION%+0', max_length=30)),
                ('experimental_mandatory_version_regex', models.CharField(default='~%IDENTITY%%CODEVERSION%\\+0', max_length=100)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Remote',
            fields=[
                ('extra_options', mini_buildd.models.UnixTextField(blank=True)),
                ('pickled_data', models.TextField(blank=True)),
                ('status', models.IntegerField(choices=[(0, 'Removed'), (1, 'Prepared'), (2, 'Active')], default=0, editable=False)),
                ('last_checked', models.DateTimeField(default=datetime.datetime(1, 1, 1, 0, 0, tzinfo=datetime.timezone.utc), editable=False)),
                ('auto_reactivate', models.BooleanField(default=False, editable=False)),
                ('key_id', models.CharField(blank=True, default='', max_length=100)),
                ('key', mini_buildd.models.UnixTextField(blank=True, default='')),
                ('key_long_id', models.CharField(blank=True, default='', max_length=254)),
                ('key_created', models.CharField(blank=True, default='', max_length=254)),
                ('key_expires', models.CharField(blank=True, default='', max_length=254)),
                ('key_name', models.CharField(blank=True, default='', max_length=254)),
                ('key_fingerprint', models.CharField(blank=True, default='', max_length=254)),
                ('http', models.CharField(default='tcp:host=YOUR_REMOTE_HOST:port=8066', max_length=255, primary_key=True, serialize=False)),
                ('wake_command', models.CharField(blank=True, default='', max_length=255)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Repository',
            fields=[
                ('extra_options', mini_buildd.models.UnixTextField(blank=True)),
                ('pickled_data', models.TextField(blank=True)),
                ('status', models.IntegerField(choices=[(0, 'Removed'), (1, 'Prepared'), (2, 'Active')], default=0, editable=False)),
                ('last_checked', models.DateTimeField(default=datetime.datetime(1, 1, 1, 0, 0, tzinfo=datetime.timezone.utc), editable=False)),
                ('auto_reactivate', models.BooleanField(default=False, editable=False)),
                ('identity', models.CharField(default='test', max_length=50, primary_key=True, serialize=False)),
                ('allow_unauthenticated_uploads', models.BooleanField(default=False)),
                ('extra_uploader_keyrings', mini_buildd.models.UnixTextField(blank=True)),
                ('notify_changed_by', models.BooleanField(default=False)),
                ('notify_maintainer', models.BooleanField(default=False)),
                ('reprepro_morguedir', models.BooleanField(default=False)),
                ('external_home_url', models.URLField(blank=True)),
                ('distributions', models.ManyToManyField(to='mini_buildd.distribution')),
                ('layout', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mini_buildd.layout')),
                ('notify', models.ManyToManyField(blank=True, to='mini_buildd.emailaddress')),
            ],
            options={
                'verbose_name_plural': 'Repositories',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Suite',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extra_options', mini_buildd.models.UnixTextField(blank=True)),
                ('pickled_data', models.TextField(blank=True)),
                ('name', models.CharField(max_length=100)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='BtrfsSnapshotChroot',
            fields=[
                ('chroot_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='mini_buildd.chroot')),
            ],
            options={
                'abstract': False,
            },
            bases=('mini_buildd.chroot',),
        ),
        migrations.CreateModel(
            name='DirChroot',
            fields=[
                ('chroot_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='mini_buildd.chroot')),
                ('union_type', models.IntegerField(choices=[(0, 'aufs'), (1, 'overlayfs'), (2, 'unionfs'), (3, 'overlay')], default=3)),
            ],
            options={
                'abstract': False,
            },
            bases=('mini_buildd.chroot',),
        ),
        migrations.CreateModel(
            name='FileChroot',
            fields=[
                ('chroot_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='mini_buildd.chroot')),
                ('compression', models.IntegerField(choices=[(0, 'no compression'), (1, 'gzip'), (2, 'bzip2'), (3, 'xz')], default=0)),
            ],
            options={
                'abstract': False,
            },
            bases=('mini_buildd.chroot',),
        ),
        migrations.CreateModel(
            name='LVMChroot',
            fields=[
                ('chroot_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='mini_buildd.chroot')),
                ('volume_group', models.CharField(default='auto', max_length=80)),
                ('filesystem', models.CharField(default='ext2', max_length=10)),
                ('snapshot_size', models.IntegerField(default=4)),
            ],
            options={
                'abstract': False,
            },
            bases=('mini_buildd.chroot',),
        ),
        migrations.CreateModel(
            name='Uploader',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extra_options', mini_buildd.models.UnixTextField(blank=True)),
                ('pickled_data', models.TextField(blank=True)),
                ('status', models.IntegerField(choices=[(0, 'Removed'), (1, 'Prepared'), (2, 'Active')], default=0, editable=False)),
                ('last_checked', models.DateTimeField(default=datetime.datetime(1, 1, 1, 0, 0, tzinfo=datetime.timezone.utc), editable=False)),
                ('auto_reactivate', models.BooleanField(default=False, editable=False)),
                ('key_id', models.CharField(blank=True, default='', max_length=100)),
                ('key', mini_buildd.models.UnixTextField(blank=True, default='')),
                ('key_long_id', models.CharField(blank=True, default='', max_length=254)),
                ('key_created', models.CharField(blank=True, default='', max_length=254)),
                ('key_expires', models.CharField(blank=True, default='', max_length=254)),
                ('key_name', models.CharField(blank=True, default='', max_length=254)),
                ('key_fingerprint', models.CharField(blank=True, default='', max_length=254)),
                ('may_upload_to', models.ManyToManyField(blank=True, to='mini_buildd.repository')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SuiteOption',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extra_options', mini_buildd.models.UnixTextField(blank=True)),
                ('pickled_data', models.TextField(blank=True)),
                ('uploadable', models.BooleanField(default=True)),
                ('experimental', models.BooleanField(default=False)),
                ('build_keyring_package', models.BooleanField(default=False)),
                ('auto_migrate_after', models.IntegerField(default=0)),
                ('not_automatic', models.BooleanField(default=True)),
                ('but_automatic_upgrades', models.BooleanField(default=True)),
                ('layout', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mini_buildd.layout')),
                ('migrates_to', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='mini_buildd.suiteoption')),
                ('suite', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mini_buildd.suite')),
            ],
            options={
                'abstract': False,
                'unique_together': {('suite', 'layout')},
            },
        ),
        migrations.CreateModel(
            name='Subscription',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extra_options', mini_buildd.models.UnixTextField(blank=True)),
                ('pickled_data', models.TextField(blank=True)),
                ('package', models.CharField(blank=True, max_length=100)),
                ('distribution', models.CharField(blank=True, max_length=100)),
                ('subscriber', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Source',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extra_options', mini_buildd.models.UnixTextField(blank=True)),
                ('pickled_data', models.TextField(blank=True)),
                ('status', models.IntegerField(choices=[(0, 'Removed'), (1, 'Prepared'), (2, 'Active')], default=0, editable=False)),
                ('last_checked', models.DateTimeField(default=datetime.datetime(1, 1, 1, 0, 0, tzinfo=datetime.timezone.utc), editable=False)),
                ('auto_reactivate', models.BooleanField(default=False, editable=False)),
                ('origin', models.CharField(default='Debian', max_length=60)),
                ('codename', models.CharField(default='sid', max_length=60)),
                ('description', models.CharField(blank=True, default='', editable=False, max_length=100)),
                ('codeversion', models.CharField(blank=True, default='', max_length=50)),
                ('codeversion_override', models.CharField(blank=True, default='', editable=False, max_length=50)),
                ('apt_keys', models.ManyToManyField(blank=True, to='mini_buildd.aptkey')),
                ('architectures', models.ManyToManyField(blank=True, to='mini_buildd.architecture')),
                ('archives', models.ManyToManyField(blank=True, to='mini_buildd.archive')),
                ('components', models.ManyToManyField(blank=True, to='mini_buildd.component')),
            ],
            options={
                'ordering': ['origin', '-codeversion', 'codename'],
                'abstract': False,
                'unique_together': {('origin', 'codename')},
            },
        ),
        migrations.CreateModel(
            name='PrioritySource',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extra_options', mini_buildd.models.UnixTextField(blank=True)),
                ('pickled_data', models.TextField(blank=True)),
                ('priority', models.IntegerField(default=1)),
                ('source', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mini_buildd.source')),
            ],
            options={
                'abstract': False,
                'unique_together': {('source', 'priority')},
            },
        ),
        migrations.AddField(
            model_name='layout',
            name='suites',
            field=models.ManyToManyField(through='mini_buildd.SuiteOption', to='mini_buildd.suite'),
        ),
        migrations.AddField(
            model_name='distribution',
            name='base_source',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mini_buildd.source'),
        ),
        migrations.AddField(
            model_name='distribution',
            name='components',
            field=models.ManyToManyField(to='mini_buildd.component'),
        ),
        migrations.AddField(
            model_name='distribution',
            name='extra_sources',
            field=models.ManyToManyField(blank=True, to='mini_buildd.prioritysource'),
        ),
        migrations.CreateModel(
            name='Daemon',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extra_options', mini_buildd.models.UnixTextField(blank=True)),
                ('pickled_data', models.TextField(blank=True)),
                ('status', models.IntegerField(choices=[(0, 'Removed'), (1, 'Prepared'), (2, 'Active')], default=0, editable=False)),
                ('last_checked', models.DateTimeField(default=datetime.datetime(1, 1, 1, 0, 0, tzinfo=datetime.timezone.utc), editable=False)),
                ('auto_reactivate', models.BooleanField(default=False, editable=False)),
                ('identity', models.CharField(default=mini_buildd.config.default_identity, max_length=50)),
                ('hostname', models.CharField(blank=True, max_length=200)),
                ('email_address', mini_buildd.models.DaemonEmailField(default=mini_buildd.config.default_email_address, max_length=255)),
                ('gnupg_template', mini_buildd.models.UnixTextField(default='Key-Type: RSA\nKey-Length: 4096\nExpire-Date: 0')),
                ('gnupg_keyserver', models.CharField(default='keyserver.ubuntu.com', max_length=200)),
                ('ftpd_bind', models.CharField(default='tcp:port=8067', max_length=200)),
                ('ftpd_options', models.CharField(blank=True, default='', max_length=255)),
                ('build_queue_size', models.IntegerField(default=mini_buildd.util.get_cpus)),
                ('sbuild_jobs', models.IntegerField(default=1)),
                ('smtp_server', models.CharField(default='localhost:25', max_length=254)),
                ('allow_emails_to', models.CharField(default=mini_buildd.config.default_allow_emails_to, max_length=254)),
                ('custom_hooks_directory', models.CharField(blank=True, default='', max_length=255)),
                ('show_last_packages', models.IntegerField(default=500)),
                ('show_last_builds', models.IntegerField(default=100)),
                ('wait_for_build_results', models.IntegerField(default=5)),
                ('keep_build_results', models.IntegerField(default=5)),
                ('notify', models.ManyToManyField(blank=True, to='mini_buildd.emailaddress')),
            ],
            options={
                'verbose_name_plural': 'Daemon',
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='chroot',
            name='source',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mini_buildd.source'),
        ),
        migrations.AddField(
            model_name='architectureoption',
            name='distribution',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mini_buildd.distribution'),
        ),
        migrations.CreateModel(
            name='LoopLVMChroot',
            fields=[
                ('lvmchroot_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='mini_buildd.lvmchroot')),
                ('loop_size', models.IntegerField(default=100)),
            ],
            options={
                'abstract': False,
            },
            bases=('mini_buildd.lvmchroot',),
        ),
        migrations.AlterUniqueTogether(
            name='chroot',
            unique_together={('source', 'architecture')},
        ),
        migrations.AlterUniqueTogether(
            name='architectureoption',
            unique_together={('architecture', 'distribution')},
        ),
    ]
