/*
 *  @(#) $Id: gwyfdcurvepreset.h 15598 2013-11-11 12:33:32Z yeti-dn $
 *  Copyright (C) 2005 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_FD_CURVE_PRESET_H__
#define __GWY_FD_CURVE_PRESET_H__

#include <libgwyddion/gwynlfitpreset.h>

G_BEGIN_DECLS

#define GWY_TYPE_FD_CURVE_PRESET             (gwy_fd_curve_preset_get_type())
#define GWY_FD_CURVE_PRESET(obj)             (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_FD_CURVE_PRESET, GwyFDCurvePreset))
#define GWY_FD_CURVE_PRESET_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_FD_CURVE_PRESET, GwyFDCurvePresetClass))
#define GWY_IS_FD_CURVE_PRESET(obj)          (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_FD_CURVE_PRESET))
#define GWY_IS_FD_CURVE_PRESET_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_FD_CURVE_PRESET))
#define GWY_FD_CURVE_PRESET_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_FD_CURVE_PRESET, GwyFDCurvePresetClass))

/* XXX: Keep it secret for now, it will change a lot. */
typedef struct _GwyFDCurvePresetBuiltin  GwyFDCurvePresetBuiltin;

typedef struct _GwyFDCurvePreset      GwyFDCurvePreset;
typedef struct _GwyFDCurvePresetClass GwyFDCurvePresetClass;

struct _GwyFDCurvePreset {
    GwyNLFitPreset parent_instance;

    const GwyFDCurvePresetBuiltin *builtin;
};

struct _GwyFDCurvePresetClass {
    GwyNLFitPresetClass parent_class;
};

GType         gwy_fd_curve_preset_get_type       (void) G_GNUC_CONST;
GwyInventory* gwy_fd_curve_presets               (void);

G_END_DECLS

#endif /* __GWY_FD_CURVE_PRESET_H__ */

/* vim: set cin et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
