#!/bin/sh

set -e

# called by uscan with '--upstream-version' <version> <file>
VERSION=$2
TAR=../guice_$VERSION.orig.tar.xz
DIR=guice-$VERSION

# Repack upstream source to tar.xz
mkdir $DIR
tar -xf $3 --strip-components=1 --directory $DIR
XZ_OPT=--best tar cvJf $TAR --exclude '*.jar' --exclude '*.iml' --exclude '*.ipr' --exclude '*.class' --exclude='.travis.yml' $DIR
rm -rf $DIR $3
