// Copyright (C) 2000-2007, Luca Padovani <padovani@sti.uniurb.it>.
// 
// This file is part of GtkMathView, a flexible, high-quality rendering
// engine for MathML documents.
// 
// GtkMathView is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
// 
// GtkMathView is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

#include "TFM.hh"

static TFM::Font font = {
"CMR",

  0xdb,
  "TeX text",
  0x01147ae0,
  0x44d3ed74,
  7,
  128
};

static TFM::Dimension dimension[] = {
  { 0x01, "slant", 0x00000000 },
  { 0x02, "space", 0x0004d488 },
  { 0x03, "space_stretch", 0x000281f8 },
  { 0x04, "space_shrink", 0x0001abfb },
  { 0x05, "x_height", 0x0006e34b },
  { 0x06, "quad", 0x000ead01 },
  { 0x07, "extra_space", 0x0001abfb }
};


static TFM::Kerning C_0b_Kerning[] = {
  { 0x21, 0x0000f2cc },
  { 0x27, 0x0000f2cc },
  { 0x29, 0x0000f2cc },
  { 0x3f, 0x0000f2cc },
  { 0x5d, 0x0000f2cc }
};

static TFM::Kerning C_20_Kerning[] = {
  { 0x4c, 0xfffb61ca },
  { 0x6c, 0xfffc0176 }
};

static TFM::Kerning C_27_Kerning[] = {
  { 0x21, 0x0001abfb },
  { 0x3f, 0x0001abfb }
};

static TFM::Kerning C_41_Kerning[] = {
  { 0x43, 0xffff9501 },
  { 0x47, 0xffff9501 },
  { 0x4f, 0xffff9501 },
  { 0x51, 0xffff9501 },
  { 0x54, 0xfffebf04 },
  { 0x55, 0xffff9501 },
  { 0x56, 0xfffe5405 },
  { 0x57, 0xfffe5405 },
  { 0x59, 0xfffebf04 },
  { 0x74, 0xffff9501 }
};

static TFM::Kerning C_44_Kerning[] = {
  { 0x41, 0xffff9501 },
  { 0x56, 0xffff9501 },
  { 0x57, 0xffff9501 },
  { 0x58, 0xffff9501 },
  { 0x59, 0xffff9501 }
};

static TFM::Kerning C_46_Kerning[] = {
  { 0x41, 0xfffe5405 },
  { 0x43, 0xffff9501 },
  { 0x47, 0xffff9501 },
  { 0x4f, 0xffff9501 },
  { 0x51, 0xffff9501 },
  { 0x61, 0xfffebf04 },
  { 0x65, 0xfffebf04 },
  { 0x6f, 0xfffebf04 },
  { 0x72, 0xfffebf04 },
  { 0x75, 0xfffebf04 }
};

static TFM::Kerning C_49_Kerning[] = {
  { 0x49, 0x00006aff }
};

static TFM::Kerning C_4b_Kerning[] = {
  { 0x43, 0xffff9501 },
  { 0x47, 0xffff9501 },
  { 0x4f, 0xffff9501 },
  { 0x51, 0xffff9501 }
};

static TFM::Kerning C_4c_Kerning[] = {
  { 0x54, 0xfffebf04 },
  { 0x56, 0xfffe5405 },
  { 0x57, 0xfffe5405 },
  { 0x59, 0xfffebf04 }
};

static TFM::Kerning C_4f_Kerning[] = {
  { 0x41, 0xffff9501 },
  { 0x56, 0xffff9501 },
  { 0x57, 0xffff9501 },
  { 0x58, 0xffff9501 },
  { 0x59, 0xffff9501 }
};

static TFM::Kerning C_50_Kerning[] = {
  { 0x2c, 0xfffebf04 },
  { 0x2e, 0xfffebf04 },
  { 0x41, 0xfffebf04 },
  { 0x61, 0xffff9501 },
  { 0x65, 0xffff9501 },
  { 0x6f, 0xffff9501 }
};

static TFM::Kerning C_52_Kerning[] = {
  { 0x43, 0xffff9501 },
  { 0x47, 0xffff9501 },
  { 0x4f, 0xffff9501 },
  { 0x51, 0xffff9501 },
  { 0x54, 0xfffebf04 },
  { 0x55, 0xffff9501 },
  { 0x56, 0xfffe5405 },
  { 0x57, 0xfffe5405 },
  { 0x59, 0xfffebf04 },
  { 0x74, 0xffff9501 }
};

static TFM::Kerning C_54_Kerning[] = {
  { 0x41, 0xfffebf04 },
  { 0x61, 0xfffebf04 },
  { 0x65, 0xfffebf04 },
  { 0x6f, 0xfffebf04 },
  { 0x72, 0xfffebf04 },
  { 0x75, 0xfffebf04 },
  { 0x79, 0xffff9501 }
};

static TFM::Kerning C_56_Kerning[] = {
  { 0x41, 0xfffe5405 },
  { 0x43, 0xffff9501 },
  { 0x47, 0xffff9501 },
  { 0x4f, 0xffff9501 },
  { 0x51, 0xffff9501 },
  { 0x61, 0xfffebf04 },
  { 0x65, 0xfffebf04 },
  { 0x6f, 0xfffebf04 },
  { 0x72, 0xfffebf04 },
  { 0x75, 0xfffebf04 }
};

static TFM::Kerning C_57_Kerning[] = {
  { 0x41, 0xfffe5405 },
  { 0x43, 0xffff9501 },
  { 0x47, 0xffff9501 },
  { 0x4f, 0xffff9501 },
  { 0x51, 0xffff9501 },
  { 0x61, 0xfffebf04 },
  { 0x65, 0xfffebf04 },
  { 0x6f, 0xfffebf04 },
  { 0x72, 0xfffebf04 },
  { 0x75, 0xfffebf04 }
};

static TFM::Kerning C_58_Kerning[] = {
  { 0x43, 0xffff9501 },
  { 0x47, 0xffff9501 },
  { 0x4f, 0xffff9501 },
  { 0x51, 0xffff9501 }
};

static TFM::Kerning C_59_Kerning[] = {
  { 0x41, 0xfffebf04 },
  { 0x61, 0xfffebf04 },
  { 0x65, 0xfffebf04 },
  { 0x6f, 0xfffebf04 },
  { 0x72, 0xfffebf04 },
  { 0x75, 0xfffebf04 }
};

static TFM::Kerning C_61_Kerning[] = {
  { 0x6a, 0x0000d5fd },
  { 0x76, 0xffff9501 },
  { 0x77, 0xffff9501 },
  { 0x79, 0xffff9501 }
};

static TFM::Kerning C_62_Kerning[] = {
  { 0x63, 0x00006aff },
  { 0x64, 0x00006aff },
  { 0x65, 0x00006aff },
  { 0x6a, 0x0000d5fd },
  { 0x6f, 0x00006aff },
  { 0x71, 0x00006aff },
  { 0x76, 0xffff9501 },
  { 0x77, 0xffff9501 },
  { 0x78, 0xffff9501 },
  { 0x79, 0xffff9501 }
};

static TFM::Kerning C_63_Kerning[] = {
  { 0x68, 0xffff9501 },
  { 0x6b, 0xffff9501 }
};

static TFM::Kerning C_66_Kerning[] = {
  { 0x21, 0x0000f2cc },
  { 0x27, 0x0000f2cc },
  { 0x29, 0x0000f2cc },
  { 0x3f, 0x0000f2cc },
  { 0x5d, 0x0000f2cc }
};

static TFM::Kerning C_67_Kerning[] = {
  { 0x6a, 0x00006aff }
};

static TFM::Kerning C_68_Kerning[] = {
  { 0x62, 0xffff9501 },
  { 0x74, 0xffff9501 },
  { 0x75, 0xffff9501 },
  { 0x76, 0xffff9501 },
  { 0x77, 0xffff9501 },
  { 0x79, 0xffff9501 }
};

static TFM::Kerning C_6b_Kerning[] = {
  { 0x61, 0xffff2a03 },
  { 0x61, 0xffff9501 },
  { 0x63, 0xffff9501 },
  { 0x65, 0xffff9501 },
  { 0x6f, 0xffff9501 }
};

static TFM::Kerning C_6d_Kerning[] = {
  { 0x62, 0xffff9501 },
  { 0x74, 0xffff9501 },
  { 0x75, 0xffff9501 },
  { 0x76, 0xffff9501 },
  { 0x77, 0xffff9501 },
  { 0x79, 0xffff9501 }
};

static TFM::Kerning C_6e_Kerning[] = {
  { 0x62, 0xffff9501 },
  { 0x74, 0xffff9501 },
  { 0x75, 0xffff9501 },
  { 0x76, 0xffff9501 },
  { 0x77, 0xffff9501 },
  { 0x79, 0xffff9501 }
};

static TFM::Kerning C_6f_Kerning[] = {
  { 0x63, 0x00006aff },
  { 0x64, 0x00006aff },
  { 0x65, 0x00006aff },
  { 0x6a, 0x0000d5fd },
  { 0x6f, 0x00006aff },
  { 0x71, 0x00006aff },
  { 0x76, 0xffff9501 },
  { 0x77, 0xffff9501 },
  { 0x78, 0xffff9501 },
  { 0x79, 0xffff9501 }
};

static TFM::Kerning C_70_Kerning[] = {
  { 0x63, 0x00006aff },
  { 0x64, 0x00006aff },
  { 0x65, 0x00006aff },
  { 0x6a, 0x0000d5fd },
  { 0x6f, 0x00006aff },
  { 0x71, 0x00006aff },
  { 0x76, 0xffff9501 },
  { 0x77, 0xffff9501 },
  { 0x78, 0xffff9501 },
  { 0x79, 0xffff9501 }
};

static TFM::Kerning C_74_Kerning[] = {
  { 0x77, 0xffff9501 },
  { 0x79, 0xffff9501 }
};

static TFM::Kerning C_75_Kerning[] = {
  { 0x77, 0xffff9501 }
};

static TFM::Kerning C_76_Kerning[] = {
  { 0x61, 0xffff2a03 },
  { 0x61, 0xffff9501 },
  { 0x63, 0xffff9501 },
  { 0x65, 0xffff9501 },
  { 0x6f, 0xffff9501 }
};

static TFM::Kerning C_77_Kerning[] = {
  { 0x61, 0xffff9501 },
  { 0x63, 0xffff9501 },
  { 0x65, 0xffff9501 },
  { 0x6f, 0xffff9501 }
};

static TFM::Kerning C_79_Kerning[] = {
  { 0x2c, 0xfffebf04 },
  { 0x2e, 0xfffebf04 },
  { 0x61, 0xffff9501 },
  { 0x65, 0xffff9501 },
  { 0x6f, 0xffff9501 }
};

static TFM::Ligature C_0b_Ligature[] = {
  { 0x69, 0x00, 0x0e },
  { 0x6c, 0x00, 0x0f }
};

static TFM::Ligature C_21_Ligature[] = {
  { 0x60, 0x00, 0x3c }
};

static TFM::Ligature C_27_Ligature[] = {
  { 0x27, 0x00, 0x22 }
};

static TFM::Ligature C_2d_Ligature[] = {
  { 0x2d, 0x00, 0x7b }
};

static TFM::Ligature C_3f_Ligature[] = {
  { 0x60, 0x00, 0x3e }
};

static TFM::Ligature C_60_Ligature[] = {
  { 0x60, 0x00, 0x5c }
};

static TFM::Ligature C_66_Ligature[] = {
  { 0x66, 0x00, 0x0b },
  { 0x69, 0x00, 0x0c },
  { 0x6c, 0x00, 0x0d }
};

static TFM::Ligature C_7b_Ligature[] = {
  { 0x2d, 0x00, 0x7c }
};


static TFM::Character character[] = {
  { 0x00, 0x00093728, 0x000aee5b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x01, 0x000c5a71, 0x000aee5b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x02, 0x000b8474, 0x000aee5b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x03, 0x000a41d3, 0x000aee5b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x04, 0x0009d879, 0x000aee5b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x05, 0x000b17d1, 0x000aee5b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x06, 0x000aae76, 0x000aee5b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x07, 0x000b8474, 0x000aee5b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x08, 0x000aae76, 0x000aee5b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x09, 0x000b8474, 0x000aee5b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0a, 0x000aae76, 0x000aee5b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0b, 0x00086814, 0x000b1c72, 0x00000000, 0x0000f2cc, 5, C_0b_Kerning, 2, C_0b_Ligature },
  { 0x0c, 0x0007fd15, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0d, 0x0007fd15, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0e, 0x000bfb9f, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0f, 0x000bfb9f, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x10, 0x0003fe8a, 0x0006e34b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x11, 0x00046989, 0x0006e34b, 0x00031cb5, 0x00000000, 0, 0, 0, 0 },
  { 0x12, 0x00075680, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x13, 0x00075680, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x14, 0x00075680, 0x000a0e28, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x15, 0x00075680, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x16, 0x00075680, 0x0008f3e0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x17, 0x000b17d1, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x18, 0x00068083, 0x00000000, 0x0002b91f, 0x00000000, 0, 0, 0, 0 },
  { 0x19, 0x00075680, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1a, 0x000aae76, 0x0006e34b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1b, 0x000b8474, 0x0006e34b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1c, 0x00075680, 0x000871a6, 0x00018e5b, 0x00000000, 0, 0, 0, 0 },
  { 0x1d, 0x000d651c, 0x000aee5b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1e, 0x000f1117, 0x000aee5b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1f, 0x000b8474, 0x000bb589, 0x0000c72e, 0x00000000, 0, 0, 0, 0 },
  { 0x20, 0x0003fe8a, 0x0006e34b, 0x00000000, 0x00000000, 2, C_20_Kerning, 0, 0 },
  { 0x21, 0x0003fe8a, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 1, C_21_Ligature },
  { 0x22, 0x00075680, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x23, 0x000c5a71, 0x000b1c72, 0x00031cb5, 0x00000000, 0, 0, 0, 0 },
  { 0x24, 0x00075680, 0x000bfc50, 0x0000dfde, 0x00000000, 0, 0, 0, 0 },
  { 0x25, 0x000c5a71, 0x000bfc50, 0x0000dfde, 0x00000000, 0, 0, 0, 0 },
  { 0x26, 0x000b8474, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x27, 0x0003fe8a, 0x000b1c72, 0x00000000, 0x00000000, 2, C_27_Kerning, 1, C_27_Ligature },
  { 0x28, 0x0005aa85, 0x000bfc50, 0x0003fc93, 0x00000000, 0, 0, 0, 0 },
  { 0x29, 0x0005aa85, 0x000bfc50, 0x0003fc93, 0x00000000, 0, 0, 0, 0 },
  { 0x2a, 0x00075680, 0x000bfc50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x2b, 0x000b8474, 0x000903cf, 0x00010413, 0x00000000, 0, 0, 0, 0 },
  { 0x2c, 0x0003fe8a, 0x00014fce, 0x00031cb5, 0x00000000, 0, 0, 0, 0 },
  { 0x2d, 0x0004d488, 0x0006e34b, 0x00000000, 0x00000000, 0, 0, 1, C_2d_Ligature },
  { 0x2e, 0x0003fe8a, 0x00014fce, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x2f, 0x00075680, 0x000bfc50, 0x0003fc93, 0x00000000, 0, 0, 0, 0 },
  { 0x30, 0x00075680, 0x000a5054, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x31, 0x00075680, 0x000a5054, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x32, 0x00075680, 0x000a5054, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x33, 0x00075680, 0x000a5054, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x34, 0x00075680, 0x000a5054, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x35, 0x00075680, 0x000a5054, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x36, 0x00075680, 0x000a5054, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x37, 0x00075680, 0x000a5054, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x38, 0x00075680, 0x000a5054, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x39, 0x00075680, 0x000a5054, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3a, 0x0003fe8a, 0x0006e34b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3b, 0x0003fe8a, 0x0006e34b, 0x00031cb5, 0x00000000, 0, 0, 0, 0 },
  { 0x3c, 0x0003fe8a, 0x0007ffbc, 0x00031cb5, 0x00000000, 0, 0, 0, 0 },
  { 0x3d, 0x000b8474, 0x0005b073, 0xfffdb0b7, 0x00000000, 0, 0, 0, 0 },
  { 0x3e, 0x0006eb82, 0x0007ffbc, 0x00031cb5, 0x00000000, 0, 0, 0, 0 },
  { 0x3f, 0x0006eb82, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 1, C_3f_Ligature },
  { 0x40, 0x000b8474, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x41, 0x000b17d1, 0x000aee5b, 0x00000000, 0x00000000, 10, C_41_Kerning, 0, 0 },
  { 0x42, 0x000a7825, 0x000aee5b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x43, 0x000aae76, 0x000aee5b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x44, 0x000b4e22, 0x000aee5b, 0x00000000, 0x00000000, 5, C_44_Kerning, 0, 0 },
  { 0x45, 0x000a0d26, 0x000aee5b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x46, 0x0009a227, 0x000aee5b, 0x00000000, 0x00000000, 10, C_46_Kerning, 0, 0 },
  { 0x47, 0x000b9eca, 0x000aee5b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x48, 0x000b17d1, 0x000aee5b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x49, 0x00053de2, 0x000aee5b, 0x00000000, 0x00000000, 1, C_49_Kerning, 0, 0 },
  { 0x4a, 0x00078b2e, 0x000aee5b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4b, 0x000b82cf, 0x000aee5b, 0x00000000, 0x00000000, 4, C_4b_Kerning, 0, 0 },
  { 0x4c, 0x00093728, 0x000aee5b, 0x00000000, 0x00000000, 4, C_4c_Kerning, 0, 0 },
  { 0x4d, 0x000d99c9, 0x000aee5b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4e, 0x000b17d1, 0x000aee5b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4f, 0x000b8474, 0x000aee5b, 0x00000000, 0x00000000, 5, C_4f_Kerning, 0, 0 },
  { 0x50, 0x000a0d26, 0x000aee5b, 0x00000000, 0x00000000, 6, C_50_Kerning, 0, 0 },
  { 0x51, 0x000b8474, 0x000aee5b, 0x00031cb5, 0x00000000, 0, 0, 0, 0 },
  { 0x52, 0x000ae323, 0x000aee5b, 0x00000000, 0x00000000, 10, C_52_Kerning, 0, 0 },
  { 0x53, 0x00082c7e, 0x000aee5b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x54, 0x000aae76, 0x000aee5b, 0x00000000, 0x00000000, 7, C_54_Kerning, 0, 0 },
  { 0x55, 0x000b17d1, 0x000aee5b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x56, 0x000b17d1, 0x000aee5b, 0x00000000, 0x0000357f, 10, C_56_Kerning, 0, 0 },
  { 0x57, 0x000f45c4, 0x000aee5b, 0x00000000, 0x0000357f, 10, C_57_Kerning, 0, 0 },
  { 0x58, 0x000b17d1, 0x000aee5b, 0x00000000, 0x00000000, 4, C_58_Kerning, 0, 0 },
  { 0x59, 0x000b17d1, 0x000aee5b, 0x00000000, 0x0000604c, 6, C_59_Kerning, 0, 0 },
  { 0x5a, 0x0009027b, 0x000aee5b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5b, 0x0003fe8a, 0x000bfc50, 0x0003fc93, 0x00000000, 0, 0, 0, 0 },
  { 0x5c, 0x00075680, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5d, 0x0003fe8a, 0x000bfc50, 0x0003fc93, 0x00000000, 0, 0, 0, 0 },
  { 0x5e, 0x00075680, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5f, 0x0003fe8a, 0x000a7ee5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x60, 0x0003fe8a, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 1, C_60_Ligature },
  { 0x61, 0x00075680, 0x0006e34b, 0x00000000, 0x00000000, 4, C_61_Kerning, 0, 0 },
  { 0x62, 0x00082c7e, 0x000b1c72, 0x00000000, 0x00000000, 10, C_62_Kerning, 0, 0 },
  { 0x63, 0x00068083, 0x0006e34b, 0x00000000, 0x00000000, 2, C_63_Kerning, 0, 0 },
  { 0x64, 0x00082c7e, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x65, 0x00068083, 0x0006e34b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x66, 0x00046989, 0x000b1c72, 0x00000000, 0x0000f2cc, 5, C_66_Kerning, 3, C_66_Ligature },
  { 0x67, 0x00075680, 0x0006e34b, 0x00031cb5, 0x0000357f, 1, C_67_Kerning, 0, 0 },
  { 0x68, 0x00082c7e, 0x000b1c72, 0x00000000, 0x00000000, 6, C_68_Kerning, 0, 0 },
  { 0x69, 0x0003fe8a, 0x000a7ee5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x6a, 0x00046989, 0x000a7ee5, 0x00031cb5, 0x00000000, 0, 0, 0, 0 },
  { 0x6b, 0x0007c17f, 0x000b1c72, 0x00000000, 0x00000000, 5, C_6b_Kerning, 0, 0 },
  { 0x6c, 0x0003fe8a, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x6d, 0x000c5a71, 0x0006e34b, 0x00000000, 0x00000000, 6, C_6d_Kerning, 0, 0 },
  { 0x6e, 0x00082c7e, 0x0006e34b, 0x00000000, 0x00000000, 6, C_6e_Kerning, 0, 0 },
  { 0x6f, 0x00075680, 0x0006e34b, 0x00000000, 0x00000000, 10, C_6f_Kerning, 0, 0 },
  { 0x70, 0x00082c7e, 0x0006e34b, 0x00031cb5, 0x00000000, 10, C_70_Kerning, 0, 0 },
  { 0x71, 0x0007c17f, 0x0006e34b, 0x00031cb5, 0x00000000, 0, 0, 0, 0 },
  { 0x72, 0x0005aa85, 0x0006e34b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x73, 0x0005bfec, 0x0006e34b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x74, 0x0005aa85, 0x0009d6fe, 0x00000000, 0x00000000, 2, C_74_Kerning, 0, 0 },
  { 0x75, 0x00082c7e, 0x0006e34b, 0x00000000, 0x00000000, 1, C_75_Kerning, 0, 0 },
  { 0x76, 0x0007c17f, 0x0006e34b, 0x00000000, 0x0000357f, 5, C_76_Kerning, 0, 0 },
  { 0x77, 0x000aae76, 0x0006e34b, 0x00000000, 0x0000357f, 4, C_77_Kerning, 0, 0 },
  { 0x78, 0x0007c17f, 0x0006e34b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x79, 0x0007c17f, 0x0006e34b, 0x00031cb5, 0x0000357f, 5, C_79_Kerning, 0, 0 },
  { 0x7a, 0x00068083, 0x0006e34b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x7b, 0x00075680, 0x0006e34b, 0x00000000, 0x00006aff, 0, 0, 1, C_7b_Ligature },
  { 0x7c, 0x000ead01, 0x0006e34b, 0x00000000, 0x00006aff, 0, 0, 0, 0 },
  { 0x7d, 0x00075680, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x7e, 0x00075680, 0x000a7ee5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x7f, 0x00075680, 0x000a7ee5, 0x00000000, 0x00000000, 0, 0, 0, 0 }
};

void
cmr17_tables(TFM::Font*& _font, TFM::Dimension*& _dimension, TFM::Character*& _character)
{
  _font = &font;
  _dimension = dimension;
  _character = character;
}
