/*
 *  Authors: Rodney Dawes <dobey@users.sourceforge.net>
 *
 *   ThinIce Authors: Tomas gren <stric@ing.umu.se>
 *   Clean Author: dengen40@yahoo.com
 *
 *
 *  Copyright 2002-2007 Elysium Project (elysium-project.sourceforge.net)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of version 2 of the GNU General Public License
 *  as published by the Free Software Foundation
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 *
 */

#include "cleanice.h"

static void cleanice_rc_style_init (CleanIceRCStyle * style);
static void cleanice_rc_style_class_init (CleanIceRCStyleClass * klass);

static void cleanice_rc_style_merge (GtkRcStyle * dest, GtkRcStyle * src);
static GtkStyle *cleanice_rc_style_create_style (GtkRcStyle * rc_style);

static GtkRcStyleClass * parent_class;
GType cleanice_type_rc_style = 0;

void cleanice_rc_style_register_type (GTypeModule * module) {
  static const GTypeInfo object_info = {
    sizeof (CleanIceRCStyleClass),
    (GBaseInitFunc) NULL,
    (GBaseFinalizeFunc) NULL,
    (GClassInitFunc) cleanice_rc_style_class_init,
    NULL,
    NULL,
    sizeof (CleanIceRCStyle),
    0,
    (GInstanceInitFunc) cleanice_rc_style_init,
  };

  cleanice_type_rc_style = g_type_module_register_type (module,
							GTK_TYPE_RC_STYLE,
							"CleanIceRCStyle",
							&object_info, 0);
}

static void cleanice_rc_style_init (CleanIceRCStyle * style) {
}

static void cleanice_rc_style_class_init (CleanIceRCStyleClass * klass) {
  GtkRcStyleClass * rc_style_class = GTK_RC_STYLE_CLASS (klass);

  parent_class = g_type_class_peek_parent (klass);

  rc_style_class->merge = cleanice_rc_style_merge;
  rc_style_class->create_style = cleanice_rc_style_create_style;

  gtk_rc_parse_string ("gtk-entry-select-on-focus = 0\n");

  gtk_rc_parse_string ("style \"cleanice-main-defaults\" {\n"
		       "  GtkButtonBox::child-min-width = 90\n"
		       "  GtkButtonBox::child-min-height = 30\n"
		       "  GtkButtonBox::internal-pad-x = 4\n"
		       "  GtkButtonBox::internal-pad-y = 4\n"
		       "  GtkCheckButton::indicator-size = 10\n"
		       "  GtkMenuBar::internal-padding = 2\n"
		       "  GtkPaned::handle-size = 9\n"
		       "  GtkToolbar::space-size = 12\n"
		       "  GtkToolbar::internal-padding = 2\n"
		       "} widget_class \"*\""
		       " style \"cleanice-main-defaults\"");

  /*
     GtkTreeView doesn't handle the vertical-separator style property
     correctly, so we set the horizontal one only here :-/
  */
  gtk_rc_parse_string ("style \"cleanice-tree-defaults\" {\n"
		       "  GtkTreeView::horizontal-separator = 6\n"
		       /*
		       "  GtkTreeView::vertical-separator = 6\n"
		       */
		       "} widget_class \"*TreeView*\""
		       " style \"cleanice-tree-defaults\"");

  gtk_rc_parse_string ("style \"cleanice-vport-defaults\" {\n"
		       "  xthickness = 1\n"
		       "  ythickness = 1\n"
		       "} widget_class \"*Viewport*\""
		       " style \"cleanice-vport-defaults\"");

  gtk_rc_parse_string ("style \"cleanice-scales-defaults\" {\n"
		       "  GtkRange::slider-width = 20\n"
		       "  GtkScale::slider-length = 10\n"
		       "} widget_class \"*Scale*\""
		       " style \"cleanice-scales-defaults\"");

  gtk_rc_parse_string ("style \"cleanice-vport-defaults\" {\n"
		       "  xthickness = 1\n"
		       "  ythickness = 1\n"
		       "} widget_class \"*Viewport*\""
		       " style \"cleanice-vport-defaults\"");

  gtk_rc_parse_string ("style \"cleanice-sbar-defaults\" {\n"
		       "  xthickness = 1\n"
		       "  ythickness = 1\n"
		       "  GtkRange::slider-width = 13\n"
		       "  GtkRange::stepper-size = 13\n"
		       "  GtkScrollbar::min-slider-length = 25\n"
		       "  GtkScrollbar::has_forward_stepper = 1\n"
		       "  GtkScrollbar::has_backward_stepper = 1\n"
		       "  xthickness = 1\n"
		       "  ythickness = 1\n"
		       "} widget_class \"*Scrollbar*\""
		       " style \"cleanice-sbar-defaults\"");
}

static void cleanice_rc_style_merge (GtkRcStyle * dest, GtkRcStyle * src) {
  parent_class->merge (dest, src);
}

static GtkStyle * cleanice_rc_style_create_style (GtkRcStyle * rc_style) {
  void * ptr;

  ptr = g_object_new (CLEANICE_TYPE_STYLE, NULL);
  return (GtkStyle *) ptr;
}

