// Generated by gmmproc 2.42.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gstreamermm/bufferlist.h>
#include <gstreamermm/private/bufferlist_p.h>


/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2009 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/buffer.h>


extern "C"
{

static gboolean BufferList_Foreach_gstreamermm_callback(GstBuffer** buffer, guint idx, void* data)
{
  Gst::BufferList::SlotForeach* the_slot =
    static_cast<Gst::BufferList::SlotForeach*>(data);

  try
  {
    // First wrap the original buffer.
    Glib::RefPtr<Gst::Buffer> temp = Glib::wrap(*buffer, true);

    // Call the slot which can modify the buffer (ie. set it to a new one or
    // clear it altogether).
    bool result =
      static_cast<bool>((*the_slot)(temp, idx));

    // Set the reference to the buffer according to how the temp buffer has
    // been altered.
    if(!temp)
    {
      // Clear the reference to the original buffer also.
      *buffer = 0;
    }
    else if(*buffer != temp->gobj())
    {
      // The temp buffer has been set to a new one so make the reference point
      // to it and take an extra reference for when the temp wrapper is
      // destroyed (I think that's right).
      *buffer = temp->gobj();
      temp->reference();
    }

    return result;
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  return true; // continue
}

} // extern "C"


namespace Gst
{

bool BufferList::is_writable() const
{
  return static_cast<bool>(gst_buffer_list_is_writable(gobj()));
}

Glib::RefPtr<BufferList> BufferList::create_writable()
{
  return Glib::RefPtr<BufferList>::cast_static(MiniObject::create_writable());
}

void BufferList::foreach(const SlotForeach& slot)
{
  gst_buffer_list_foreach(gobj(), &BufferList_Foreach_gstreamermm_callback,
    const_cast<SlotForeach*>(&slot));
}

} //namespace Gst

namespace
{
} // anonymous namespace


/* Why reinterpret_cast<BufferList*>(gobject) is needed:
 *
 * A BufferList instance is in fact always a GstBufferList instance.
 * Unfortunately, GstBufferList cannot be a member of BufferList,
 * because it is an opaque struct.  Also, the C interface does not provide
 * any hooks to install a destroy notification handler, thus we cannot
 * wrap it dynamically either.
 *
 * The cast works because BufferList does not have any member data, and
 * it is impossible to derive from it.  This is ensured by not implementing
 * the (protected) default constructor.  The ctor is protected rather than
 * private just to avoid a compile warning.
 */

namespace Glib
{

Glib::RefPtr<Gst::BufferList> wrap(GstBufferList* object, bool take_copy)
{
  if(take_copy && object)
    gst_buffer_list_ref(object);

  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::RefPtr<Gst::BufferList>(reinterpret_cast<Gst::BufferList*>(object));
}

} // namespace Glib


namespace Gst
{


// static
Glib::RefPtr<BufferList> BufferList::create()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::RefPtr<BufferList>(reinterpret_cast<BufferList*>(gst_buffer_list_new()));
}

void BufferList::reference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gst_buffer_list_ref(reinterpret_cast<GstBufferList*>(const_cast<BufferList*>(this)));
}

void BufferList::unreference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gst_buffer_list_unref(reinterpret_cast<GstBufferList*>(const_cast<BufferList*>(this)));
}

GstBufferList* BufferList::gobj()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<GstBufferList*>(this);
}

const GstBufferList* BufferList::gobj() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<const GstBufferList*>(this);
}

GstBufferList* BufferList::gobj_copy() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  GstBufferList *const gobject = reinterpret_cast<GstBufferList*>(const_cast<BufferList*>(this));
  gst_buffer_list_ref(gobject);
  return gobject;
}


void BufferList::remove(guint idx, guint length)
{
  gst_buffer_list_remove(gobj(), idx, length);
}

Glib::RefPtr<Gst::Buffer> BufferList::remove(guint idx)
{
  return Glib::wrap(gst_buffer_list_get(gobj(), idx));
}

void BufferList::add(gint idx, const Glib::RefPtr<Gst::Buffer>& buffer)
{
  gst_buffer_list_insert(gobj(), idx, Glib::unwrap(buffer));
}

Glib::RefPtr<Gst::Buffer> BufferList::get(guint idx)
{
  return Glib::wrap(gst_buffer_list_get(gobj(), idx));
}

Glib::RefPtr<const Gst::Buffer> BufferList::get(guint idx) const
{
  return const_cast<BufferList*>(this)->get(idx);
}


} // namespace Gst


