/* Generated by wayland-scanner 1.11.0 */

#ifndef SCALER_CLIENT_PROTOCOL_H
#define SCALER_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_scaler The scaler protocol
 * @section page_ifaces_scaler Interfaces
 * - @subpage page_iface_wl_scaler - surface cropping and scaling
 * - @subpage page_iface_wl_viewport - crop and scale interface to a wl_surface
 * @section page_copyright_scaler Copyright
 * <pre>
 *
 * Copyright © 2013-2014 Collabora, Ltd.
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct wl_scaler;
struct wl_surface;
struct wl_viewport;

/**
 * @page page_iface_wl_scaler wl_scaler
 * @section page_iface_wl_scaler_desc Description
 *
 * The global interface exposing surface cropping and scaling
 * capabilities is used to instantiate an interface extension for a
 * wl_surface object. This extended interface will then allow
 * cropping and scaling the surface contents, effectively
 * disconnecting the direct relationship between the buffer and the
 * surface size.
 * @section page_iface_wl_scaler_api API
 * See @ref iface_wl_scaler.
 */
/**
 * @defgroup iface_wl_scaler The wl_scaler interface
 *
 * The global interface exposing surface cropping and scaling
 * capabilities is used to instantiate an interface extension for a
 * wl_surface object. This extended interface will then allow
 * cropping and scaling the surface contents, effectively
 * disconnecting the direct relationship between the buffer and the
 * surface size.
 */
extern const struct wl_interface wl_scaler_interface;
/**
 * @page page_iface_wl_viewport wl_viewport
 * @section page_iface_wl_viewport_desc Description
 *
 * An additional interface to a wl_surface object, which allows the
 * client to specify the cropping and scaling of the surface
 * contents.
 *
 * This interface allows to define the source rectangle (src_x,
 * src_y, src_width, src_height) from where to take the wl_buffer
 * contents, and scale that to destination size (dst_width,
 * dst_height). This state is double-buffered, and is applied on the
 * next wl_surface.commit.
 *
 * The two parts of crop and scale state are independent: the source
 * rectangle, and the destination size. Initially both are unset, that
 * is, no scaling is applied. The whole of the current wl_buffer is
 * used as the source, and the surface size is as defined in
 * wl_surface.attach.
 *
 * If the destination size is set, it causes the surface size to become
 * dst_width, dst_height. The source (rectangle) is scaled to exactly
 * this size. This overrides whatever the attached wl_buffer size is,
 * unless the wl_buffer is NULL. If the wl_buffer is NULL, the surface
 * has no content and therefore no size. Otherwise, the size is always
 * at least 1x1 in surface coordinates.
 *
 * If the source rectangle is set, it defines what area of the
 * wl_buffer is taken as the source. If the source rectangle is set and
 * the destination size is not set, the surface size becomes the source
 * rectangle size rounded up to the nearest integer. If the source size
 * is already exactly integers, this results in cropping without scaling.
 *
 * The coordinate transformations from buffer pixel coordinates up to
 * the surface-local coordinates happen in the following order:
 * 1. buffer_transform (wl_surface.set_buffer_transform)
 * 2. buffer_scale (wl_surface.set_buffer_scale)
 * 3. crop and scale (wl_viewport.set*)
 * This means, that the source rectangle coordinates of crop and scale
 * are given in the coordinates after the buffer transform and scale,
 * i.e. in the coordinates that would be the surface-local coordinates
 * if the crop and scale was not applied.
 *
 * If the source rectangle is partially or completely outside of the
 * wl_buffer, then the surface contents are undefined (not void), and
 * the surface size is still dst_width, dst_height.
 *
 * The x, y arguments of wl_surface.attach are applied as normal to
 * the surface. They indicate how many pixels to remove from the
 * surface size from the left and the top. In other words, they are
 * still in the surface-local coordinate system, just like dst_width
 * and dst_height are.
 *
 * If the wl_surface associated with the wl_viewport is destroyed,
 * the wl_viewport object becomes inert.
 *
 * If the wl_viewport object is destroyed, the crop and scale
 * state is removed from the wl_surface. The change will be applied
 * on the next wl_surface.commit.
 * @section page_iface_wl_viewport_api API
 * See @ref iface_wl_viewport.
 */
/**
 * @defgroup iface_wl_viewport The wl_viewport interface
 *
 * An additional interface to a wl_surface object, which allows the
 * client to specify the cropping and scaling of the surface
 * contents.
 *
 * This interface allows to define the source rectangle (src_x,
 * src_y, src_width, src_height) from where to take the wl_buffer
 * contents, and scale that to destination size (dst_width,
 * dst_height). This state is double-buffered, and is applied on the
 * next wl_surface.commit.
 *
 * The two parts of crop and scale state are independent: the source
 * rectangle, and the destination size. Initially both are unset, that
 * is, no scaling is applied. The whole of the current wl_buffer is
 * used as the source, and the surface size is as defined in
 * wl_surface.attach.
 *
 * If the destination size is set, it causes the surface size to become
 * dst_width, dst_height. The source (rectangle) is scaled to exactly
 * this size. This overrides whatever the attached wl_buffer size is,
 * unless the wl_buffer is NULL. If the wl_buffer is NULL, the surface
 * has no content and therefore no size. Otherwise, the size is always
 * at least 1x1 in surface coordinates.
 *
 * If the source rectangle is set, it defines what area of the
 * wl_buffer is taken as the source. If the source rectangle is set and
 * the destination size is not set, the surface size becomes the source
 * rectangle size rounded up to the nearest integer. If the source size
 * is already exactly integers, this results in cropping without scaling.
 *
 * The coordinate transformations from buffer pixel coordinates up to
 * the surface-local coordinates happen in the following order:
 * 1. buffer_transform (wl_surface.set_buffer_transform)
 * 2. buffer_scale (wl_surface.set_buffer_scale)
 * 3. crop and scale (wl_viewport.set*)
 * This means, that the source rectangle coordinates of crop and scale
 * are given in the coordinates after the buffer transform and scale,
 * i.e. in the coordinates that would be the surface-local coordinates
 * if the crop and scale was not applied.
 *
 * If the source rectangle is partially or completely outside of the
 * wl_buffer, then the surface contents are undefined (not void), and
 * the surface size is still dst_width, dst_height.
 *
 * The x, y arguments of wl_surface.attach are applied as normal to
 * the surface. They indicate how many pixels to remove from the
 * surface size from the left and the top. In other words, they are
 * still in the surface-local coordinate system, just like dst_width
 * and dst_height are.
 *
 * If the wl_surface associated with the wl_viewport is destroyed,
 * the wl_viewport object becomes inert.
 *
 * If the wl_viewport object is destroyed, the crop and scale
 * state is removed from the wl_surface. The change will be applied
 * on the next wl_surface.commit.
 */
extern const struct wl_interface wl_viewport_interface;

#ifndef WL_SCALER_ERROR_ENUM
#define WL_SCALER_ERROR_ENUM
enum wl_scaler_error {
	/**
	 * the surface already has a viewport object associated
	 */
	WL_SCALER_ERROR_VIEWPORT_EXISTS = 0,
};
#endif /* WL_SCALER_ERROR_ENUM */

#define WL_SCALER_DESTROY	0
#define WL_SCALER_GET_VIEWPORT	1

/**
 * @ingroup iface_wl_scaler
 */
#define WL_SCALER_DESTROY_SINCE_VERSION	1
/**
 * @ingroup iface_wl_scaler
 */
#define WL_SCALER_GET_VIEWPORT_SINCE_VERSION	1

/** @ingroup iface_wl_scaler */
static inline void
wl_scaler_set_user_data(struct wl_scaler *wl_scaler, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) wl_scaler, user_data);
}

/** @ingroup iface_wl_scaler */
static inline void *
wl_scaler_get_user_data(struct wl_scaler *wl_scaler)
{
	return wl_proxy_get_user_data((struct wl_proxy *) wl_scaler);
}

static inline uint32_t
wl_scaler_get_version(struct wl_scaler *wl_scaler)
{
	return wl_proxy_get_version((struct wl_proxy *) wl_scaler);
}

/**
 * @ingroup iface_wl_scaler
 *
 * Informs the server that the client will not be using this
 * protocol object anymore. This does not affect any other objects,
 * wl_viewport objects included.
 */
static inline void
wl_scaler_destroy(struct wl_scaler *wl_scaler)
{
	wl_proxy_marshal((struct wl_proxy *) wl_scaler,
			 WL_SCALER_DESTROY);

	wl_proxy_destroy((struct wl_proxy *) wl_scaler);
}

/**
 * @ingroup iface_wl_scaler
 *
 * Instantiate an interface extension for the given wl_surface to
 * crop and scale its content. If the given wl_surface already has
 * a wl_viewport object associated, the viewport_exists
 * protocol error is raised.
 */
static inline struct wl_viewport *
wl_scaler_get_viewport(struct wl_scaler *wl_scaler, struct wl_surface *surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_constructor((struct wl_proxy *) wl_scaler,
			 WL_SCALER_GET_VIEWPORT, &wl_viewport_interface, NULL, surface);

	return (struct wl_viewport *) id;
}

#ifndef WL_VIEWPORT_ERROR_ENUM
#define WL_VIEWPORT_ERROR_ENUM
enum wl_viewport_error {
	/**
	 * negative or zero values in width or height
	 */
	WL_VIEWPORT_ERROR_BAD_VALUE = 0,
};
#endif /* WL_VIEWPORT_ERROR_ENUM */

#define WL_VIEWPORT_DESTROY	0
#define WL_VIEWPORT_SET	1
#define WL_VIEWPORT_SET_SOURCE	2
#define WL_VIEWPORT_SET_DESTINATION	3

/**
 * @ingroup iface_wl_viewport
 */
#define WL_VIEWPORT_DESTROY_SINCE_VERSION	1
/**
 * @ingroup iface_wl_viewport
 */
#define WL_VIEWPORT_SET_SINCE_VERSION	1
/**
 * @ingroup iface_wl_viewport
 */
#define WL_VIEWPORT_SET_SOURCE_SINCE_VERSION	2
/**
 * @ingroup iface_wl_viewport
 */
#define WL_VIEWPORT_SET_DESTINATION_SINCE_VERSION	2

/** @ingroup iface_wl_viewport */
static inline void
wl_viewport_set_user_data(struct wl_viewport *wl_viewport, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) wl_viewport, user_data);
}

/** @ingroup iface_wl_viewport */
static inline void *
wl_viewport_get_user_data(struct wl_viewport *wl_viewport)
{
	return wl_proxy_get_user_data((struct wl_proxy *) wl_viewport);
}

static inline uint32_t
wl_viewport_get_version(struct wl_viewport *wl_viewport)
{
	return wl_proxy_get_version((struct wl_proxy *) wl_viewport);
}

/**
 * @ingroup iface_wl_viewport
 *
 * The associated wl_surface's crop and scale state is removed.
 * The change is applied on the next wl_surface.commit.
 */
static inline void
wl_viewport_destroy(struct wl_viewport *wl_viewport)
{
	wl_proxy_marshal((struct wl_proxy *) wl_viewport,
			 WL_VIEWPORT_DESTROY);

	wl_proxy_destroy((struct wl_proxy *) wl_viewport);
}

/**
 * @ingroup iface_wl_viewport
 *
 * Set both source rectangle and destination size of the associated
 * wl_surface. See wl_viewport for the description, and relation to
 * the wl_buffer size.
 *
 * The bad_value protocol error is raised if src_width or
 * src_height is negative, or if dst_width or dst_height is not
 * positive.
 *
 * The crop and scale state is double-buffered state, and will be
 * applied on the next wl_surface.commit.
 *
 * Arguments dst_x and dst_y do not exist here, use the x and y
 * arguments to wl_surface.attach. The x, y, dst_width, and dst_height
 * define the surface-local coordinate system irrespective of the
 * attached wl_buffer size.
 */
static inline void
wl_viewport_set(struct wl_viewport *wl_viewport, wl_fixed_t src_x, wl_fixed_t src_y, wl_fixed_t src_width, wl_fixed_t src_height, int32_t dst_width, int32_t dst_height)
{
	wl_proxy_marshal((struct wl_proxy *) wl_viewport,
			 WL_VIEWPORT_SET, src_x, src_y, src_width, src_height, dst_width, dst_height);
}

/**
 * @ingroup iface_wl_viewport
 *
 * Set the source rectangle of the associated wl_surface. See
 * wl_viewport for the description, and relation to the wl_buffer
 * size.
 *
 * If width is -1.0 and height is -1.0, the destination size is unset
 * instead. Any other pair of values for width and height that
 * contains zero or negative values raises the bad_value protocol
 * error.
 *
 * The crop and scale state is double-buffered state, and will be
 * applied on the next wl_surface.commit.
 */
static inline void
wl_viewport_set_source(struct wl_viewport *wl_viewport, wl_fixed_t x, wl_fixed_t y, wl_fixed_t width, wl_fixed_t height)
{
	wl_proxy_marshal((struct wl_proxy *) wl_viewport,
			 WL_VIEWPORT_SET_SOURCE, x, y, width, height);
}

/**
 * @ingroup iface_wl_viewport
 *
 * Set the destination size of the associated wl_surface. See
 * wl_viewport for the description, and relation to the wl_buffer
 * size.
 *
 * If width is -1 and height is -1, the destination size is unset
 * instead. Any other pair of values for width and height that
 * contains zero or negative values raises the bad_value protocol
 * error.
 *
 * The crop and scale state is double-buffered state, and will be
 * applied on the next wl_surface.commit.
 *
 * Arguments x and y do not exist here, use the x and y arguments to
 * wl_surface.attach. The x, y, width, and height define the
 * surface-local coordinate system irrespective of the attached
 * wl_buffer size.
 */
static inline void
wl_viewport_set_destination(struct wl_viewport *wl_viewport, int32_t width, int32_t height)
{
	wl_proxy_marshal((struct wl_proxy *) wl_viewport,
			 WL_VIEWPORT_SET_DESTINATION, width, height);
}

#ifdef  __cplusplus
}
#endif

#endif
