// Code generated by smithy-go-codegen DO NOT EDIT.

package directoryservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Enables single sign-on for a directory. Single sign-on allows users in your
// directory to access certain Amazon Web Services services from a computer joined
// to the directory without having to enter their credentials separately.
func (c *Client) EnableSso(ctx context.Context, params *EnableSsoInput, optFns ...func(*Options)) (*EnableSsoOutput, error) {
	if params == nil {
		params = &EnableSsoInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "EnableSso", params, optFns, c.addOperationEnableSsoMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*EnableSsoOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Contains the inputs for the EnableSso operation.
type EnableSsoInput struct {

	// The identifier of the directory for which to enable single-sign on.
	//
	// This member is required.
	DirectoryId *string

	// The password of an alternate account to use to enable single-sign on. This is
	// only used for AD Connector directories. For more information, see the UserName
	// parameter.
	Password *string

	// The username of an alternate account to use to enable single-sign on. This is
	// only used for AD Connector directories. This account must have privileges to add
	// a service principal name. If the AD Connector service account does not have
	// privileges to add a service principal name, you can specify an alternate account
	// with the UserName and Password parameters. These credentials are only used to
	// enable single sign-on and are not stored by the service. The AD Connector
	// service account is not changed.
	UserName *string

	noSmithyDocumentSerde
}

// Contains the results of the EnableSso operation.
type EnableSsoOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationEnableSsoMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpEnableSso{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpEnableSso{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "EnableSso"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpEnableSsoValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opEnableSso(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opEnableSso(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "EnableSso",
	}
}
