
/*
* This code is released under the GNU General Public License.  See COPYING for
* details.  Copyright 2005 P. Jordan, C. Lewis, J. Spray
* jcspray@icculus.org
*/

#ifndef GNUDOKU_H
#define GNUDOKU_H

#include "sudoku.H"
using sudoku::Sudoku;

#include <gtkmm.h>

#define MARK_ERRORS_BY_COLOR


class GNUDoku {
	Gtk::Entry *box_[9][9];
	Gtk::Adjustment *difficultyadj_;
	Gtk::Window *mainwindow_;
	bool editupdateblock_;
	float orig_ratio_;

#ifdef MARK_ERRORS_BY_COLOR
	Gdk::Color error_color_;
#else
	Pango::FontDescription bold_desc_;
	Pango::FontDescription plain_desc_;
#endif

	void clearBoxes();
	void showAbout();
	void doQuit();
	void onBoxEdit();
	void onBoxFocus(Gtk::Entry *box);
	void fillBoxes(const Sudoku::attempt stack[], const char visited[]);
	int getFromBoxes(Sudoku::attempt *top, Sudoku::flags *flags, char visited[]);
	void generatePuzzleUI();
	void generatePuzzle(float const difficulty, int const seed);

	void solvePuzzle();
	void mark_box_erroneous (Gtk::Entry *box, bool haserror);
	void mark_box_editable (Gtk::Entry *box, bool editable);

	void onHBoxResize(Gdk::Rectangle &rect);

	int setFromString (std::string puzzle);
	std::string dumpToString (void);
	int savePuzzle (std::string filename);
	void generatePuzzleFromNumberUI ();
	void openPuzzleUI ();
	void savePuzzleUI ();
	void updateWindowTitle (Glib::ustring);

	// Sometimes a filename in the folder desired, GTK doesn't care.
	std::string working_folder;

	public:
	GNUDoku();
	void guiSetup(Gtk::Window &window);
	int openPuzzle (std::string filename);
};

#endif // GNUDOKU_H
