-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/gui_checkbutton.adb,v $
--  Description     : simplfies check box package
--  Author          : Michael Erdmann                                        --
--  Created         : 25.9.2001                                              --
--  Last Modified By: $Author: me $
--  Last Modified On: $Date: 2001/11/26 20:31:13 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Text_IO;         use Ada.Text_IO;

with Gtk.Box;             use Gtk.Box;
with Gtk.Button;          use Gtk.Button;
with Gtk.Check_Button;    use Gtk.Check_Button;

with Gtk.Handlers;        use Gtk.Handlers;
with Gtk.Label;           use Gtk.Label;
with Gtk.Widget;          use Gtk.Widget;
with Gtk;                 use Gtk;
with Glib;                use Glib;
with Gdk;                 use Gdk;

with GUI_Logging;

package body GUI_Checkbutton is

   Version    : constant String := "$Id: gui_checkbutton.adb,v 1.2 2001/11/26 20:31:13 me Exp $";

   --- ************************************************************************** ---
   --- ***                P R I V A T E    M E T H O D S                      *** ---
   --- ************************************************************************** ---
   package Check_Cb is new Handlers.User_Callback(Gtk_Check_Button_Record, Gtk_Box);

   ---------------
   -- CB_Toggle --
   ---------------
   procedure CB_Toggle (
      Button : access Gtk_Check_Button_Record'Class;
      Parent : in Gtk_Box) is
      This   : Object renames Object(Button.all);
   begin
      Put_Line("Toggle : " & Boolean'Image( This.Active ) );
      if This.Active then
         This.Active := False;
      else
         This.Active := True;
      end if;
   end CB_Toggle;

   --- ************************************************************************** ---
   --- ***                 P U B L I C     M E T H O D S                      *** ---
   --- ************************************************************************** ---

   ---------------------
   -- Add_Checkbutton --
   ---------------------
   procedure Add_Checkbutton(
      Parent : in out Gtk_Box;
      This   : out Handle;
      Title  : in String;
      Active : in Boolean := False ) is
      Result : Gtk_Check_Button := new Object;
   begin
      This := Handle(Result);
      Gtk.Check_Button.Initialize( Result, Title );

      This.Active := Active;
      Gtk.Check_Button.Set_Active( Result, Active );

      Pack_Start (Parent, Result, Expand => False );
      Check_Cb.Connect (
         Result,
         "clicked",
         Check_Cb.To_Marshaller (CB_Toggle'Access),
         Parent);


   end Add_Checkbutton;

   ---------------
   -- Is_Active --
   ---------------
   function Is_Active(
      This : in Handle ) return Boolean is
   begin
      Put_Line("Is_Active : " & Boolean'Image( This.Active ) );

      return This.Active = True;
   end Is_Active;

   ---------
   -- Set --
   ---------
   procedure Set(
      This   : in Handle;
      Active : in Boolean) is
   begin
      This.Active := Active;
      Gtk.Check_Button.Set_Active( Gtk_Check_Button(This), Active );
   end Set;

end GUI_Checkbutton;
