/*
 * Copyright (C) 2023 The Phosh Developers
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * Author: Guido Günther <agx@sigxcpu.org>
 */

#include "gm-util.h"

/**
 * gm_str_is_null_or_empty:
 * @x:(nullable): A null terminated string
 *
 * Convenience macro to check if a given string is `NULL` or empty.
 * Evaluates to a truth value if `x` is `NULL` or `x` is the empty string
 * otherwise `FALSE`.
 *
 * Since: 0.0.5
 */

/**
 * gm_strv_is_null_or_empty:
 * @x:(nullable): A `NULL` terminated `GStrv`
 *
 * Convenience macro to check if a given `GStrv` is `NULL` or empty.
 * Evaluates to a truth value if `x` is `NULL` or `x` has no elements otherwise
 * `FALSE`.
 *
 * Since: 0.0.5
 */
