<?xml version='1.0' encoding='ISO-8859-1' standalone='yes' ?>
<tagfile>
  <compound kind="page">
    <name>index</name>
    <title>Geographic library</title>
    <filename>index</filename>
    <docanchor file="index">contents</docanchor>
    <docanchor file="index">download</docanchor>
    <docanchor file="index">abstract</docanchor>
  </compound>
  <compound kind="file">
    <name>Accumulator.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>Accumulator_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <class kind="class">GeographicLib::Accumulator</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_ACCUMULATOR_HPP</name>
      <anchorfile>Accumulator_8hpp.html</anchorfile>
      <anchor>af2ea0de968b20eb37534fa6baedcba54</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>AlbersEqualArea.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>AlbersEqualArea_8cpp</filename>
    <includes id="AlbersEqualArea_8hpp" name="AlbersEqualArea.hpp" local="no" imported="no">GeographicLib/AlbersEqualArea.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_ALBERSEQUALAREA_CPP</name>
      <anchorfile>AlbersEqualArea_8cpp.html</anchorfile>
      <anchor>a0cbf05d716ed87a0d1bc3cc16e6adb2a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>AlbersEqualArea.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>AlbersEqualArea_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <class kind="class">GeographicLib::AlbersEqualArea</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_ALBERSEQUALAREA_HPP</name>
      <anchorfile>AlbersEqualArea_8hpp.html</anchorfile>
      <anchor>aa9494d369d907d2b285fcb2f45b4689c</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>AzimuthalEquidistant.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>AzimuthalEquidistant_8cpp</filename>
    <includes id="AzimuthalEquidistant_8hpp" name="AzimuthalEquidistant.hpp" local="no" imported="no">GeographicLib/AzimuthalEquidistant.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_AZIMUTHALEQUIDISTANT_CPP</name>
      <anchorfile>AzimuthalEquidistant_8cpp.html</anchorfile>
      <anchor>a66c8226c0b34ef5b0138d44829f5c394</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>AzimuthalEquidistant.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>AzimuthalEquidistant_8hpp</filename>
    <includes id="Geodesic_8hpp" name="Geodesic.hpp" local="no" imported="no">GeographicLib/Geodesic.hpp</includes>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <class kind="class">GeographicLib::AzimuthalEquidistant</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_AZIMUTHALEQUIDISTANT_HPP</name>
      <anchorfile>AzimuthalEquidistant_8hpp.html</anchorfile>
      <anchor>a70d20e83eaef9177a9dbc4503fae17b7</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>CartConvert.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/tools/</path>
    <filename>CartConvert_8cpp</filename>
    <includes id="Geocentric_8hpp" name="Geocentric.hpp" local="no" imported="no">GeographicLib/Geocentric.hpp</includes>
    <includes id="LocalCartesian_8hpp" name="LocalCartesian.hpp" local="no" imported="no">GeographicLib/LocalCartesian.hpp</includes>
    <includes id="DMS_8hpp" name="DMS.hpp" local="no" imported="no">GeographicLib/DMS.hpp</includes>
    <includes id="Utility_8hpp" name="Utility.hpp" local="no" imported="no">GeographicLib/Utility.hpp</includes>
    <member kind="function">
      <type>int</type>
      <name>main</name>
      <anchorfile>CartConvert_8cpp.html</anchorfile>
      <anchor>a0ddf1224851353fc92bfbff6f499fa97</anchor>
      <arglist>(int argc, char *argv[])</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>CassiniSoldner.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>CassiniSoldner_8cpp</filename>
    <includes id="CassiniSoldner_8hpp" name="CassiniSoldner.hpp" local="no" imported="no">GeographicLib/CassiniSoldner.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_CASSINISOLDNER_CPP</name>
      <anchorfile>CassiniSoldner_8cpp.html</anchorfile>
      <anchor>a91edbe2e2eaf2776b80aecf2107909d4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>CassiniSoldner.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>CassiniSoldner_8hpp</filename>
    <includes id="Geodesic_8hpp" name="Geodesic.hpp" local="no" imported="no">GeographicLib/Geodesic.hpp</includes>
    <includes id="GeodesicLine_8hpp" name="GeodesicLine.hpp" local="no" imported="no">GeographicLib/GeodesicLine.hpp</includes>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <class kind="class">GeographicLib::CassiniSoldner</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_CASSINISOLDNER_HPP</name>
      <anchorfile>CassiniSoldner_8hpp.html</anchorfile>
      <anchor>ab674f10f5e4e3b25dc68c65fa408e315</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>CircularEngine.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>CircularEngine_8cpp</filename>
    <includes id="CircularEngine_8hpp" name="CircularEngine.hpp" local="no" imported="no">GeographicLib/CircularEngine.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_CIRCULARENGINE_CPP</name>
      <anchorfile>CircularEngine_8cpp.html</anchorfile>
      <anchor>af686808d87a6f2cd0b1305f1aeac536d</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>CircularEngine.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>CircularEngine_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <includes id="SphericalEngine_8hpp" name="SphericalEngine.hpp" local="no" imported="no">GeographicLib/SphericalEngine.hpp</includes>
    <class kind="class">GeographicLib::CircularEngine</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_CIRCULARENGINE_HPP</name>
      <anchorfile>CircularEngine_8hpp.html</anchorfile>
      <anchor>abfcea264d0e3f7a45c8ff8de7f2e539f</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>ConicProj.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/tools/</path>
    <filename>ConicProj_8cpp</filename>
    <includes id="LambertConformalConic_8hpp" name="LambertConformalConic.hpp" local="no" imported="no">GeographicLib/LambertConformalConic.hpp</includes>
    <includes id="AlbersEqualArea_8hpp" name="AlbersEqualArea.hpp" local="no" imported="no">GeographicLib/AlbersEqualArea.hpp</includes>
    <includes id="DMS_8hpp" name="DMS.hpp" local="no" imported="no">GeographicLib/DMS.hpp</includes>
    <includes id="Utility_8hpp" name="Utility.hpp" local="no" imported="no">GeographicLib/Utility.hpp</includes>
    <member kind="function">
      <type>int</type>
      <name>main</name>
      <anchorfile>ConicProj_8cpp.html</anchorfile>
      <anchor>a0ddf1224851353fc92bfbff6f499fa97</anchor>
      <arglist>(int argc, char *argv[])</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>Constants.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>Constants_8hpp</filename>
    <includes id="Math_8hpp" name="Math.hpp" local="no" imported="no">GeographicLib/Math.hpp</includes>
    <class kind="class">GeographicLib::Constants</class>
    <class kind="class">GeographicLib::GeographicErr</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_CONSTANTS_HPP</name>
      <anchorfile>Constants_8hpp.html</anchorfile>
      <anchor>a16d93570265d8037f7dc7d5d026b2aa4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>STATIC_ASSERT</name>
      <anchorfile>Constants_8hpp.html</anchorfile>
      <anchor>a8f24445c1bccd69b63e365aa5d5bb129</anchor>
      <arglist>(cond, reason)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>RCSID_DECL</name>
      <anchorfile>Constants_8hpp.html</anchorfile>
      <anchor>af90fa899707a2ac513d5e4c76853bbf5</anchor>
      <arglist>(x)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHIC_EXPORT</name>
      <anchorfile>Constants_8hpp.html</anchorfile>
      <anchor>a59a204dcc2942f86d7b24b4233aad719</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>DMS.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>DMS_8cpp</filename>
    <includes id="DMS_8hpp" name="DMS.hpp" local="no" imported="no">GeographicLib/DMS.hpp</includes>
    <includes id="Utility_8hpp" name="Utility.hpp" local="no" imported="no">GeographicLib/Utility.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_DMS_CPP</name>
      <anchorfile>DMS_8cpp.html</anchorfile>
      <anchor>a6ef96ce6d2929e11dc6ec87433f4d7d1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>DMS.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>DMS_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <includes id="Utility_8hpp" name="Utility.hpp" local="no" imported="no">GeographicLib/Utility.hpp</includes>
    <class kind="class">GeographicLib::DMS</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_DMS_HPP</name>
      <anchorfile>DMS_8hpp.html</anchorfile>
      <anchor>a844e4c8afc70c59c842f4553ce40b9c6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>EllipticFunction.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>EllipticFunction_8cpp</filename>
    <includes id="EllipticFunction_8hpp" name="EllipticFunction.hpp" local="no" imported="no">GeographicLib/EllipticFunction.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_ELLIPTICFUNCTION_CPP</name>
      <anchorfile>EllipticFunction_8cpp.html</anchorfile>
      <anchor>a7843c8be162380a81bdd1c48d00a475b</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>EllipticFunction.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>EllipticFunction_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <class kind="class">GeographicLib::EllipticFunction</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_ELLIPTICFUNCTION_HPP</name>
      <anchorfile>EllipticFunction_8hpp.html</anchorfile>
      <anchor>a94cb49e5d48fa1a0399e4303f1ad162a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>Geocentric.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>Geocentric_8cpp</filename>
    <includes id="Geocentric_8hpp" name="Geocentric.hpp" local="no" imported="no">GeographicLib/Geocentric.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_GEOCENTRIC_CPP</name>
      <anchorfile>Geocentric_8cpp.html</anchorfile>
      <anchor>a290e33302d7c35b9465d73f33dcb0774</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>Geocentric.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>Geocentric_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <class kind="class">GeographicLib::Geocentric</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_GEOCENTRIC_HPP</name>
      <anchorfile>Geocentric_8hpp.html</anchorfile>
      <anchor>a29517663058dd79a39541248f58db55f</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>GeoConvert.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/tools/</path>
    <filename>GeoConvert_8cpp</filename>
    <includes id="GeoCoords_8hpp" name="GeoCoords.hpp" local="no" imported="no">GeographicLib/GeoCoords.hpp</includes>
    <includes id="DMS_8hpp" name="DMS.hpp" local="no" imported="no">GeographicLib/DMS.hpp</includes>
    <includes id="Utility_8hpp" name="Utility.hpp" local="no" imported="no">GeographicLib/Utility.hpp</includes>
    <member kind="function">
      <type>int</type>
      <name>main</name>
      <anchorfile>GeoConvert_8cpp.html</anchorfile>
      <anchor>a0ddf1224851353fc92bfbff6f499fa97</anchor>
      <arglist>(int argc, char *argv[])</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>GeoCoords.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>GeoCoords_8cpp</filename>
    <includes id="GeoCoords_8hpp" name="GeoCoords.hpp" local="no" imported="no">GeographicLib/GeoCoords.hpp</includes>
    <includes id="MGRS_8hpp" name="MGRS.hpp" local="no" imported="no">GeographicLib/MGRS.hpp</includes>
    <includes id="DMS_8hpp" name="DMS.hpp" local="no" imported="no">GeographicLib/DMS.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_GEOCOORDS_CPP</name>
      <anchorfile>GeoCoords_8cpp.html</anchorfile>
      <anchor>a8ca6643c26cc3909b0935409c1dbc403</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>GeoCoords.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>GeoCoords_8hpp</filename>
    <includes id="UTMUPS_8hpp" name="UTMUPS.hpp" local="no" imported="no">GeographicLib/UTMUPS.hpp</includes>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <class kind="class">GeographicLib::GeoCoords</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_GEOCOORDS_HPP</name>
      <anchorfile>GeoCoords_8hpp.html</anchorfile>
      <anchor>a20841ff1ac217be34150ce32c5ad4bb8</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>Geod.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/tools/</path>
    <filename>Geod_8cpp</filename>
    <includes id="Geodesic_8hpp" name="Geodesic.hpp" local="no" imported="no">GeographicLib/Geodesic.hpp</includes>
    <includes id="GeodesicLine_8hpp" name="GeodesicLine.hpp" local="no" imported="no">GeographicLib/GeodesicLine.hpp</includes>
    <includes id="DMS_8hpp" name="DMS.hpp" local="no" imported="no">GeographicLib/DMS.hpp</includes>
    <includes id="Utility_8hpp" name="Utility.hpp" local="no" imported="no">GeographicLib/Utility.hpp</includes>
    <member kind="typedef">
      <type>GeographicLib::Math::real</type>
      <name>real</name>
      <anchorfile>Geod_8cpp.html</anchorfile>
      <anchor>a5caf95d46b184d9ca1d3764b3781b3c9</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>LatLonString</name>
      <anchorfile>Geod_8cpp.html</anchorfile>
      <anchor>a8c3a2a4c039b4d0118416afd97a45fcf</anchor>
      <arglist>(real lat, real lon, int prec, bool dms, char dmssep)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>AzimuthString</name>
      <anchorfile>Geod_8cpp.html</anchorfile>
      <anchor>adeb84b4732b410c9fdccf799037ef245</anchor>
      <arglist>(real azi, int prec, bool dms, char dmssep)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>DistanceStrings</name>
      <anchorfile>Geod_8cpp.html</anchorfile>
      <anchor>a600021136749afe8d757335563b5b544</anchor>
      <arglist>(real s12, real a12, bool full, bool arcmode, int prec, bool dms)</arglist>
    </member>
    <member kind="function">
      <type>real</type>
      <name>ReadDistance</name>
      <anchorfile>Geod_8cpp.html</anchorfile>
      <anchor>a01ac56deedd203bd66c8c7328654b7e9</anchor>
      <arglist>(const std::string &amp;s, bool arcmode)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>main</name>
      <anchorfile>Geod_8cpp.html</anchorfile>
      <anchor>a0ddf1224851353fc92bfbff6f499fa97</anchor>
      <arglist>(int argc, char *argv[])</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>Geodesic.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>Geodesic_8cpp</filename>
    <includes id="Geodesic_8hpp" name="Geodesic.hpp" local="no" imported="no">GeographicLib/Geodesic.hpp</includes>
    <includes id="GeodesicLine_8hpp" name="GeodesicLine.hpp" local="no" imported="no">GeographicLib/GeodesicLine.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_GEODESIC_CPP</name>
      <anchorfile>Geodesic_8cpp.html</anchorfile>
      <anchor>a61dcde881d6a80b561fc2b4c4b327883</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>Geodesic.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>Geodesic_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <class kind="class">GeographicLib::Geodesic</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_GEODESIC_HPP</name>
      <anchorfile>Geodesic_8hpp.html</anchorfile>
      <anchor>ab538cb707d6ff36056dd372c7e9e6d7e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOD_ORD</name>
      <anchorfile>Geodesic_8hpp.html</anchorfile>
      <anchor>a1927ca941a173c95631417cbd8cc8e0c</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>GeodesicLine.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>GeodesicLine_8cpp</filename>
    <includes id="GeodesicLine_8hpp" name="GeodesicLine.hpp" local="no" imported="no">GeographicLib/GeodesicLine.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_GEODESICLINE_CPP</name>
      <anchorfile>GeodesicLine_8cpp.html</anchorfile>
      <anchor>a8c325bf3ebfa8126888b62b16495d64e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>GeodesicLine.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>GeodesicLine_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <includes id="Geodesic_8hpp" name="Geodesic.hpp" local="no" imported="no">GeographicLib/Geodesic.hpp</includes>
    <class kind="class">GeographicLib::GeodesicLine</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_GEODESICLINE_HPP</name>
      <anchorfile>GeodesicLine_8hpp.html</anchorfile>
      <anchor>a45305d595b59bfb061a5a0c6e1044485</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>GeodesicProj.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/tools/</path>
    <filename>GeodesicProj_8cpp</filename>
    <includes id="Geodesic_8hpp" name="Geodesic.hpp" local="no" imported="no">GeographicLib/Geodesic.hpp</includes>
    <includes id="AzimuthalEquidistant_8hpp" name="AzimuthalEquidistant.hpp" local="no" imported="no">GeographicLib/AzimuthalEquidistant.hpp</includes>
    <includes id="CassiniSoldner_8hpp" name="CassiniSoldner.hpp" local="no" imported="no">GeographicLib/CassiniSoldner.hpp</includes>
    <includes id="Gnomonic_8hpp" name="Gnomonic.hpp" local="no" imported="no">GeographicLib/Gnomonic.hpp</includes>
    <includes id="DMS_8hpp" name="DMS.hpp" local="no" imported="no">GeographicLib/DMS.hpp</includes>
    <includes id="Utility_8hpp" name="Utility.hpp" local="no" imported="no">GeographicLib/Utility.hpp</includes>
    <member kind="function">
      <type>int</type>
      <name>main</name>
      <anchorfile>GeodesicProj_8cpp.html</anchorfile>
      <anchor>a0ddf1224851353fc92bfbff6f499fa97</anchor>
      <arglist>(int argc, char *argv[])</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>Geographic.doc</name>
    <path>/scratch/geographic-dist/gita/geographiclib/doc/</path>
    <filename>Geographic_8doc</filename>
  </compound>
  <compound kind="file">
    <name>Geoid.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>Geoid_8cpp</filename>
    <includes id="Geoid_8hpp" name="Geoid.hpp" local="no" imported="no">GeographicLib/Geoid.hpp</includes>
    <includes id="Utility_8hpp" name="Utility.hpp" local="no" imported="no">GeographicLib/Utility.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_GEOID_CPP</name>
      <anchorfile>Geoid_8cpp.html</anchorfile>
      <anchor>ad2cadd66a2a8fe0322579f4a1922a907</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_DATA</name>
      <anchorfile>Geoid_8cpp.html</anchorfile>
      <anchor>a45687ef771d809c1c369daea074cc109</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOID_DEFAULT_NAME</name>
      <anchorfile>Geoid_8cpp.html</anchorfile>
      <anchor>a2999d90c0556a04490ea239ddcb052b8</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>Geoid.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>Geoid_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <class kind="class">GeographicLib::Geoid</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_GEOID_HPP</name>
      <anchorfile>Geoid_8hpp.html</anchorfile>
      <anchor>a81966978f2fe7fad1effabc667a99820</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PGM_PIXEL_WIDTH</name>
      <anchorfile>Geoid_8hpp.html</anchorfile>
      <anchor>aa34d236045b829973cbc0d958d3ed139</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>GeoidEval.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/tools/</path>
    <filename>GeoidEval_8cpp</filename>
    <includes id="Geoid_8hpp" name="Geoid.hpp" local="no" imported="no">GeographicLib/Geoid.hpp</includes>
    <includes id="DMS_8hpp" name="DMS.hpp" local="no" imported="no">GeographicLib/DMS.hpp</includes>
    <includes id="Utility_8hpp" name="Utility.hpp" local="no" imported="no">GeographicLib/Utility.hpp</includes>
    <includes id="GeoCoords_8hpp" name="GeoCoords.hpp" local="no" imported="no">GeographicLib/GeoCoords.hpp</includes>
    <member kind="function">
      <type>int</type>
      <name>main</name>
      <anchorfile>GeoidEval_8cpp.html</anchorfile>
      <anchor>a0ddf1224851353fc92bfbff6f499fa97</anchor>
      <arglist>(int argc, char *argv[])</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>Gnomonic.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>Gnomonic_8cpp</filename>
    <includes id="Gnomonic_8hpp" name="Gnomonic.hpp" local="no" imported="no">GeographicLib/Gnomonic.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_GNOMONIC_CPP</name>
      <anchorfile>Gnomonic_8cpp.html</anchorfile>
      <anchor>ad62c02d3264b4069476f2f1aa21f223e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>Gnomonic.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>Gnomonic_8hpp</filename>
    <includes id="Geodesic_8hpp" name="Geodesic.hpp" local="no" imported="no">GeographicLib/Geodesic.hpp</includes>
    <includes id="GeodesicLine_8hpp" name="GeodesicLine.hpp" local="no" imported="no">GeographicLib/GeodesicLine.hpp</includes>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <class kind="class">GeographicLib::Gnomonic</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_GNOMONIC_HPP</name>
      <anchorfile>Gnomonic_8hpp.html</anchorfile>
      <anchor>af85f3f443620d568666f526ee193308a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>Gravity.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/tools/</path>
    <filename>Gravity_8cpp</filename>
    <includes id="GravityModel_8hpp" name="GravityModel.hpp" local="no" imported="no">GeographicLib/GravityModel.hpp</includes>
    <includes id="GravityCircle_8hpp" name="GravityCircle.hpp" local="no" imported="no">GeographicLib/GravityCircle.hpp</includes>
    <includes id="DMS_8hpp" name="DMS.hpp" local="no" imported="no">GeographicLib/DMS.hpp</includes>
    <includes id="Utility_8hpp" name="Utility.hpp" local="no" imported="no">GeographicLib/Utility.hpp</includes>
    <member kind="function">
      <type>int</type>
      <name>main</name>
      <anchorfile>Gravity_8cpp.html</anchorfile>
      <anchor>a0ddf1224851353fc92bfbff6f499fa97</anchor>
      <arglist>(int argc, char *argv[])</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>GravityCircle.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>GravityCircle_8cpp</filename>
    <includes id="GravityCircle_8hpp" name="GravityCircle.hpp" local="no" imported="no">GeographicLib/GravityCircle.hpp</includes>
    <includes id="Geocentric_8hpp" name="Geocentric.hpp" local="no" imported="no">GeographicLib/Geocentric.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_GRAVITYCIRCLE_CPP</name>
      <anchorfile>GravityCircle_8cpp.html</anchorfile>
      <anchor>a57d7b0412922810faed5fb35173f561c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GRAVITY_DEFAULT_PATH</name>
      <anchorfile>GravityCircle_8cpp.html</anchorfile>
      <anchor>a21f239249a382b864294a231061d97d4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>GravityCircle.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>GravityCircle_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <includes id="CircularEngine_8hpp" name="CircularEngine.hpp" local="no" imported="no">GeographicLib/CircularEngine.hpp</includes>
    <includes id="GravityModel_8hpp" name="GravityModel.hpp" local="no" imported="no">GeographicLib/GravityModel.hpp</includes>
    <class kind="class">GeographicLib::GravityCircle</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_GRAVITYCIRCLE_HPP</name>
      <anchorfile>GravityCircle_8hpp.html</anchorfile>
      <anchor>a07d4fadabf913f2115556a6de80f6115</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>GravityModel.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>GravityModel_8cpp</filename>
    <includes id="GravityModel_8hpp" name="GravityModel.hpp" local="no" imported="no">GeographicLib/GravityModel.hpp</includes>
    <includes id="SphericalEngine_8hpp" name="SphericalEngine.hpp" local="no" imported="no">GeographicLib/SphericalEngine.hpp</includes>
    <includes id="GravityCircle_8hpp" name="GravityCircle.hpp" local="no" imported="no">GeographicLib/GravityCircle.hpp</includes>
    <includes id="Utility_8hpp" name="Utility.hpp" local="no" imported="no">GeographicLib/Utility.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_GRAVITYMODEL_CPP</name>
      <anchorfile>GravityModel_8cpp.html</anchorfile>
      <anchor>a65e1bf85112eafa00622f95531afc180</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_DATA</name>
      <anchorfile>GravityModel_8cpp.html</anchorfile>
      <anchor>a45687ef771d809c1c369daea074cc109</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GRAVITY_DEFAULT_NAME</name>
      <anchorfile>GravityModel_8cpp.html</anchorfile>
      <anchor>a05d4f5b688275acf184933e85a0063bd</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>GravityModel.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>GravityModel_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <includes id="NormalGravity_8hpp" name="NormalGravity.hpp" local="no" imported="no">GeographicLib/NormalGravity.hpp</includes>
    <includes id="SphericalHarmonic_8hpp" name="SphericalHarmonic.hpp" local="no" imported="no">GeographicLib/SphericalHarmonic.hpp</includes>
    <includes id="SphericalHarmonic1_8hpp" name="SphericalHarmonic1.hpp" local="no" imported="no">GeographicLib/SphericalHarmonic1.hpp</includes>
    <class kind="class">GeographicLib::GravityModel</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_GRAVITYMODEL_HPP</name>
      <anchorfile>GravityModel_8hpp.html</anchorfile>
      <anchor>ace85f3a4d35d4657064e289e2bf57dab</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>LambertConformalConic.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>LambertConformalConic_8cpp</filename>
    <includes id="LambertConformalConic_8hpp" name="LambertConformalConic.hpp" local="no" imported="no">GeographicLib/LambertConformalConic.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_LAMBERTCONFORMALCONIC_CPP</name>
      <anchorfile>LambertConformalConic_8cpp.html</anchorfile>
      <anchor>adf8d4ab2a5f0e2571915d27d31758930</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>LambertConformalConic.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>LambertConformalConic_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <class kind="class">GeographicLib::LambertConformalConic</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_LAMBERTCONFORMALCONIC_HPP</name>
      <anchorfile>LambertConformalConic_8hpp.html</anchorfile>
      <anchor>aac2fbd995d5b75016781c58b97093c67</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>LocalCartesian.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>LocalCartesian_8cpp</filename>
    <includes id="LocalCartesian_8hpp" name="LocalCartesian.hpp" local="no" imported="no">GeographicLib/LocalCartesian.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_LOCALCARTESIAN_CPP</name>
      <anchorfile>LocalCartesian_8cpp.html</anchorfile>
      <anchor>a0917de4aed4abb985b1e2830077aea45</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>LocalCartesian.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>LocalCartesian_8hpp</filename>
    <includes id="Geocentric_8hpp" name="Geocentric.hpp" local="no" imported="no">GeographicLib/Geocentric.hpp</includes>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <class kind="class">GeographicLib::LocalCartesian</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_LOCALCARTESIAN_HPP</name>
      <anchorfile>LocalCartesian_8hpp.html</anchorfile>
      <anchor>a628d4dcde137e8249cb7fdbcaab30acd</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>MagneticCircle.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>MagneticCircle_8cpp</filename>
    <includes id="MagneticCircle_8hpp" name="MagneticCircle.hpp" local="no" imported="no">GeographicLib/MagneticCircle.hpp</includes>
    <includes id="Geocentric_8hpp" name="Geocentric.hpp" local="no" imported="no">GeographicLib/Geocentric.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_MAGNETICCIRCLE_CPP</name>
      <anchorfile>MagneticCircle_8cpp.html</anchorfile>
      <anchor>a0ca864788d9c9fdd4987afdc16db17ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>MAGNETIC_DEFAULT_PATH</name>
      <anchorfile>MagneticCircle_8cpp.html</anchorfile>
      <anchor>adda468b8dc758dd6d082ccf33c5e1b75</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>MagneticCircle.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>MagneticCircle_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <includes id="CircularEngine_8hpp" name="CircularEngine.hpp" local="no" imported="no">GeographicLib/CircularEngine.hpp</includes>
    <class kind="class">GeographicLib::MagneticCircle</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_MAGNETICCIRCLE_HPP</name>
      <anchorfile>MagneticCircle_8hpp.html</anchorfile>
      <anchor>a5bc784ff412658d1c422828506b424da</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>MagneticField.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/tools/</path>
    <filename>MagneticField_8cpp</filename>
    <includes id="MagneticModel_8hpp" name="MagneticModel.hpp" local="no" imported="no">GeographicLib/MagneticModel.hpp</includes>
    <includes id="MagneticCircle_8hpp" name="MagneticCircle.hpp" local="no" imported="no">GeographicLib/MagneticCircle.hpp</includes>
    <includes id="DMS_8hpp" name="DMS.hpp" local="no" imported="no">GeographicLib/DMS.hpp</includes>
    <includes id="Utility_8hpp" name="Utility.hpp" local="no" imported="no">GeographicLib/Utility.hpp</includes>
    <member kind="function">
      <type>int</type>
      <name>main</name>
      <anchorfile>MagneticField_8cpp.html</anchorfile>
      <anchor>a0ddf1224851353fc92bfbff6f499fa97</anchor>
      <arglist>(int argc, char *argv[])</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>MagneticModel.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>MagneticModel_8cpp</filename>
    <includes id="MagneticModel_8hpp" name="MagneticModel.hpp" local="no" imported="no">GeographicLib/MagneticModel.hpp</includes>
    <includes id="SphericalEngine_8hpp" name="SphericalEngine.hpp" local="no" imported="no">GeographicLib/SphericalEngine.hpp</includes>
    <includes id="MagneticCircle_8hpp" name="MagneticCircle.hpp" local="no" imported="no">GeographicLib/MagneticCircle.hpp</includes>
    <includes id="Utility_8hpp" name="Utility.hpp" local="no" imported="no">GeographicLib/Utility.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_MAGNETICMODEL_CPP</name>
      <anchorfile>MagneticModel_8cpp.html</anchorfile>
      <anchor>ac744ec56ccbc33cff2c75c204b4c7ae1</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_DATA</name>
      <anchorfile>MagneticModel_8cpp.html</anchorfile>
      <anchor>a45687ef771d809c1c369daea074cc109</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>MAGNETIC_DEFAULT_NAME</name>
      <anchorfile>MagneticModel_8cpp.html</anchorfile>
      <anchor>a302055ff69e445c8103c09913de840ff</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>MagneticModel.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>MagneticModel_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <includes id="Geocentric_8hpp" name="Geocentric.hpp" local="no" imported="no">GeographicLib/Geocentric.hpp</includes>
    <includes id="SphericalHarmonic_8hpp" name="SphericalHarmonic.hpp" local="no" imported="no">GeographicLib/SphericalHarmonic.hpp</includes>
    <class kind="class">GeographicLib::MagneticModel</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_MAGNETICMODEL_HPP</name>
      <anchorfile>MagneticModel_8hpp.html</anchorfile>
      <anchor>a8f9f091785b789fbe080c650bc0b8654</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>Math.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>Math_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <class kind="class">GeographicLib::Math</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_MATH_HPP</name>
      <anchorfile>Math_8hpp.html</anchorfile>
      <anchor>afb2818ef5e2f2bed96dcaa151b3edca4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_CPLUSPLUS11_MATH</name>
      <anchorfile>Math_8hpp.html</anchorfile>
      <anchor>a2769cdfa2277e2728e4e157ec3f6318b</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>WORDS_BIGENDIAN</name>
      <anchorfile>Math_8hpp.html</anchorfile>
      <anchor>a82e69009d3cd108c8aad8afe44fb1132</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_PREC</name>
      <anchorfile>Math_8hpp.html</anchorfile>
      <anchor>a8df061fdb3d6e90d150d4fdd749f96b1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>MGRS.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>MGRS_8cpp</filename>
    <includes id="MGRS_8hpp" name="MGRS.hpp" local="no" imported="no">GeographicLib/MGRS.hpp</includes>
    <includes id="Utility_8hpp" name="Utility.hpp" local="no" imported="no">GeographicLib/Utility.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_MGRS_CPP</name>
      <anchorfile>MGRS_8cpp.html</anchorfile>
      <anchor>a7882927f72a62a7131868e387edd4dac</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>MGRS.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>MGRS_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <includes id="UTMUPS_8hpp" name="UTMUPS.hpp" local="no" imported="no">GeographicLib/UTMUPS.hpp</includes>
    <class kind="class">GeographicLib::MGRS</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_MGRS_HPP</name>
      <anchorfile>MGRS_8hpp.html</anchorfile>
      <anchor>a1c5e778121820c6ec16b6180ffab51ac</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>NormalGravity.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>NormalGravity_8cpp</filename>
    <includes id="NormalGravity_8hpp" name="NormalGravity.hpp" local="no" imported="no">GeographicLib/NormalGravity.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_NORMALGRAVITY_CPP</name>
      <anchorfile>NormalGravity_8cpp.html</anchorfile>
      <anchor>ae09694799ad8f72c9b216b9729848655</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>NormalGravity.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>NormalGravity_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <includes id="Geocentric_8hpp" name="Geocentric.hpp" local="no" imported="no">GeographicLib/Geocentric.hpp</includes>
    <class kind="class">GeographicLib::NormalGravity</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_NORMALGRAVITY_HPP</name>
      <anchorfile>NormalGravity_8hpp.html</anchorfile>
      <anchor>a3f83059dc418514a79fa4e6c94869b58</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>OSGB.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>OSGB_8cpp</filename>
    <includes id="OSGB_8hpp" name="OSGB.hpp" local="no" imported="no">GeographicLib/OSGB.hpp</includes>
    <includes id="Utility_8hpp" name="Utility.hpp" local="no" imported="no">GeographicLib/Utility.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_OSGB_CPP</name>
      <anchorfile>OSGB_8cpp.html</anchorfile>
      <anchor>af7fa9aa83a3be95cccc572fc3b399b58</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>OSGB.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>OSGB_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <includes id="TransverseMercator_8hpp" name="TransverseMercator.hpp" local="no" imported="no">GeographicLib/TransverseMercator.hpp</includes>
    <class kind="class">GeographicLib::OSGB</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_OSGB_HPP</name>
      <anchorfile>OSGB_8hpp.html</anchorfile>
      <anchor>a786c5942146679103feb716bea66a0a7</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>Planimeter.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/tools/</path>
    <filename>Planimeter_8cpp</filename>
    <includes id="PolygonArea_8hpp" name="PolygonArea.hpp" local="no" imported="no">GeographicLib/PolygonArea.hpp</includes>
    <includes id="DMS_8hpp" name="DMS.hpp" local="no" imported="no">GeographicLib/DMS.hpp</includes>
    <includes id="Utility_8hpp" name="Utility.hpp" local="no" imported="no">GeographicLib/Utility.hpp</includes>
    <includes id="GeoCoords_8hpp" name="GeoCoords.hpp" local="no" imported="no">GeographicLib/GeoCoords.hpp</includes>
    <member kind="function">
      <type>int</type>
      <name>main</name>
      <anchorfile>Planimeter_8cpp.html</anchorfile>
      <anchor>a0ddf1224851353fc92bfbff6f499fa97</anchor>
      <arglist>(int argc, char *argv[])</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>PolarStereographic.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>PolarStereographic_8cpp</filename>
    <includes id="PolarStereographic_8hpp" name="PolarStereographic.hpp" local="no" imported="no">GeographicLib/PolarStereographic.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_POLARSTEREOGRAPHIC_CPP</name>
      <anchorfile>PolarStereographic_8cpp.html</anchorfile>
      <anchor>a2887f1d8fd2633373698a2d1468befc2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>PolarStereographic.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>PolarStereographic_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <class kind="class">GeographicLib::PolarStereographic</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_POLARSTEREOGRAPHIC_HPP</name>
      <anchorfile>PolarStereographic_8hpp.html</anchorfile>
      <anchor>a7450566a6ed1475dc10f7c0dc85f5dd9</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>PolygonArea.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>PolygonArea_8cpp</filename>
    <includes id="PolygonArea_8hpp" name="PolygonArea.hpp" local="no" imported="no">GeographicLib/PolygonArea.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_POLYGONAREA_CPP</name>
      <anchorfile>PolygonArea_8cpp.html</anchorfile>
      <anchor>adda27aeacbbca888326b0f4cd9577254</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>PolygonArea.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>PolygonArea_8hpp</filename>
    <includes id="Geodesic_8hpp" name="Geodesic.hpp" local="no" imported="no">GeographicLib/Geodesic.hpp</includes>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <includes id="Accumulator_8hpp" name="Accumulator.hpp" local="no" imported="no">GeographicLib/Accumulator.hpp</includes>
    <class kind="class">GeographicLib::PolygonArea</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_POLYGONAREA_HPP</name>
      <anchorfile>PolygonArea_8hpp.html</anchorfile>
      <anchor>a284051319ec399ec9363ace180fc1203</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SphericalEngine.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>SphericalEngine_8cpp</filename>
    <includes id="SphericalEngine_8hpp" name="SphericalEngine.hpp" local="no" imported="no">GeographicLib/SphericalEngine.hpp</includes>
    <includes id="CircularEngine_8hpp" name="CircularEngine.hpp" local="no" imported="no">GeographicLib/CircularEngine.hpp</includes>
    <includes id="Utility_8hpp" name="Utility.hpp" local="no" imported="no">GeographicLib/Utility.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_SPHERICALENGINE_CPP</name>
      <anchorfile>SphericalEngine_8cpp.html</anchorfile>
      <anchor>acbb0476075cd231855709ab48c95fa7e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SphericalEngine.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>SphericalEngine_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <class kind="class">GeographicLib::SphericalEngine</class>
    <class kind="class">GeographicLib::SphericalEngine::coeff</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_SPHERICALENGINE_HPP</name>
      <anchorfile>SphericalEngine_8hpp.html</anchorfile>
      <anchor>a46e29e0e930e205c8f9a059ae458b44e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SphericalHarmonic.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>SphericalHarmonic_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <includes id="SphericalEngine_8hpp" name="SphericalEngine.hpp" local="no" imported="no">GeographicLib/SphericalEngine.hpp</includes>
    <includes id="CircularEngine_8hpp" name="CircularEngine.hpp" local="no" imported="no">GeographicLib/CircularEngine.hpp</includes>
    <includes id="Geocentric_8hpp" name="Geocentric.hpp" local="no" imported="no">GeographicLib/Geocentric.hpp</includes>
    <class kind="class">GeographicLib::SphericalHarmonic</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_SPHERICALHARMONIC_HPP</name>
      <anchorfile>SphericalHarmonic_8hpp.html</anchorfile>
      <anchor>ab6742c760b0220c0a0d6423bed5b8bf8</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SphericalHarmonic1.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>SphericalHarmonic1_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <includes id="SphericalEngine_8hpp" name="SphericalEngine.hpp" local="no" imported="no">GeographicLib/SphericalEngine.hpp</includes>
    <includes id="CircularEngine_8hpp" name="CircularEngine.hpp" local="no" imported="no">GeographicLib/CircularEngine.hpp</includes>
    <class kind="class">GeographicLib::SphericalHarmonic1</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_SPHERICALHARMONIC1_HPP</name>
      <anchorfile>SphericalHarmonic1_8hpp.html</anchorfile>
      <anchor>a16f04a6cf043288bc2d78f51d9c42186</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SphericalHarmonic2.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>SphericalHarmonic2_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <includes id="SphericalEngine_8hpp" name="SphericalEngine.hpp" local="no" imported="no">GeographicLib/SphericalEngine.hpp</includes>
    <includes id="CircularEngine_8hpp" name="CircularEngine.hpp" local="no" imported="no">GeographicLib/CircularEngine.hpp</includes>
    <class kind="class">GeographicLib::SphericalHarmonic2</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_SPHERICALHARMONIC2_HPP</name>
      <anchorfile>SphericalHarmonic2_8hpp.html</anchorfile>
      <anchor>a15f930b306cf77dee059d32d2bb417ad</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>TransverseMercator.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>TransverseMercator_8cpp</filename>
    <includes id="TransverseMercator_8hpp" name="TransverseMercator.hpp" local="no" imported="no">GeographicLib/TransverseMercator.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_TRANSVERSEMERCATOR_CPP</name>
      <anchorfile>TransverseMercator_8cpp.html</anchorfile>
      <anchor>ab09ba83d5531a4ca91dc8ce82ae98084</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>TransverseMercator.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>TransverseMercator_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <class kind="class">GeographicLib::TransverseMercator</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_TRANSVERSEMERCATOR_HPP</name>
      <anchorfile>TransverseMercator_8hpp.html</anchorfile>
      <anchor>abbbe2faaff284db3183ddf3afcbf5623</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>TM_TX_MAXPOW</name>
      <anchorfile>TransverseMercator_8hpp.html</anchorfile>
      <anchor>a823820984cba9dabe0517925bf18c77b</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>TransverseMercatorExact.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>TransverseMercatorExact_8cpp</filename>
    <includes id="TransverseMercatorExact_8hpp" name="TransverseMercatorExact.hpp" local="no" imported="no">GeographicLib/TransverseMercatorExact.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_TRANSVERSEMERCATOREXACT_CPP</name>
      <anchorfile>TransverseMercatorExact_8cpp.html</anchorfile>
      <anchor>a019dc2a5f6ac9aa9ba03ad8dd974e438</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>TransverseMercatorExact.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>TransverseMercatorExact_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <includes id="EllipticFunction_8hpp" name="EllipticFunction.hpp" local="no" imported="no">GeographicLib/EllipticFunction.hpp</includes>
    <class kind="class">GeographicLib::TransverseMercatorExact</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_TRANSVERSEMERCATOREXACT_HPP</name>
      <anchorfile>TransverseMercatorExact_8hpp.html</anchorfile>
      <anchor>a33c80ffd2f74ea9ed9dd4c11bf9e1198</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>TransverseMercatorProj.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/tools/</path>
    <filename>TransverseMercatorProj_8cpp</filename>
    <includes id="EllipticFunction_8hpp" name="EllipticFunction.hpp" local="no" imported="no">GeographicLib/EllipticFunction.hpp</includes>
    <includes id="TransverseMercatorExact_8hpp" name="TransverseMercatorExact.hpp" local="no" imported="no">GeographicLib/TransverseMercatorExact.hpp</includes>
    <includes id="TransverseMercator_8hpp" name="TransverseMercator.hpp" local="no" imported="no">GeographicLib/TransverseMercator.hpp</includes>
    <includes id="DMS_8hpp" name="DMS.hpp" local="no" imported="no">GeographicLib/DMS.hpp</includes>
    <includes id="Utility_8hpp" name="Utility.hpp" local="no" imported="no">GeographicLib/Utility.hpp</includes>
    <member kind="function">
      <type>int</type>
      <name>main</name>
      <anchorfile>TransverseMercatorProj_8cpp.html</anchorfile>
      <anchor>a0ddf1224851353fc92bfbff6f499fa97</anchor>
      <arglist>(int argc, char *argv[])</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>Utility.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>Utility_8cpp</filename>
    <includes id="Utility_8hpp" name="Utility.hpp" local="no" imported="no">GeographicLib/Utility.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_UTILITY_CPP</name>
      <anchorfile>Utility_8cpp.html</anchorfile>
      <anchor>a572751ca8465c95b9e157dc20175f6bc</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>Utility.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>Utility_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <class kind="class">GeographicLib::Utility</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_UTILITY_HPP</name>
      <anchorfile>Utility_8hpp.html</anchorfile>
      <anchor>aba45651243cd7449a073dd2c8b11a88a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>UTMUPS.cpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>UTMUPS_8cpp</filename>
    <includes id="UTMUPS_8hpp" name="UTMUPS.hpp" local="no" imported="no">GeographicLib/UTMUPS.hpp</includes>
    <includes id="MGRS_8hpp" name="MGRS.hpp" local="no" imported="no">GeographicLib/MGRS.hpp</includes>
    <includes id="PolarStereographic_8hpp" name="PolarStereographic.hpp" local="no" imported="no">GeographicLib/PolarStereographic.hpp</includes>
    <includes id="TransverseMercator_8hpp" name="TransverseMercator.hpp" local="no" imported="no">GeographicLib/TransverseMercator.hpp</includes>
    <includes id="Utility_8hpp" name="Utility.hpp" local="no" imported="no">GeographicLib/Utility.hpp</includes>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_UTMUPS_CPP</name>
      <anchorfile>UTMUPS_8cpp.html</anchorfile>
      <anchor>af7026e1ac5bb37428765d957f2f14a6b</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>UTMUPS.hpp</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>UTMUPS_8hpp</filename>
    <includes id="Constants_8hpp" name="Constants.hpp" local="no" imported="no">GeographicLib/Constants.hpp</includes>
    <class kind="class">GeographicLib::UTMUPS</class>
    <namespace>GeographicLib</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOGRAPHICLIB_UTMUPS_HPP</name>
      <anchorfile>UTMUPS_8hpp.html</anchorfile>
      <anchor>aab4dce5d203c0d98ae740800332ed9d9</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="page">
    <name>intro</name>
    <title>Introduction</title>
    <filename>intro</filename>
  </compound>
  <compound kind="page">
    <name>install</name>
    <title>Installing %GeographicLib</title>
    <filename>install</filename>
    <docanchor file="install">maintainer</docanchor>
    <docanchor file="install">windowsbin</docanchor>
    <docanchor file="install">qt</docanchor>
    <docanchor file="install">windows</docanchor>
    <docanchor file="install">gnu</docanchor>
    <docanchor file="install">autoconf</docanchor>
    <docanchor file="install">cmake</docanchor>
  </compound>
  <compound kind="page">
    <name>start</name>
    <title>Getting started</title>
    <filename>start</filename>
  </compound>
  <compound kind="page">
    <name>utilities</name>
    <title>Utility programs</title>
    <filename>utilities</filename>
  </compound>
  <compound kind="page">
    <name>organization</name>
    <title>Code organization</title>
    <filename>organization</filename>
  </compound>
  <compound kind="page">
    <name>other</name>
    <title>Other interfaces (Javascript, Python, Matlab, Octave)</title>
    <filename>other</filename>
    <docanchor file="other">javascript</docanchor>
    <docanchor file="other">python</docanchor>
    <docanchor file="other">matlab</docanchor>
  </compound>
  <compound kind="page">
    <name>geoid</name>
    <title>Geoid height</title>
    <filename>geoid</filename>
    <docanchor file="geoid">geoidinterp</docanchor>
    <docanchor file="geoid">geoidformat</docanchor>
    <docanchor file="geoid">geoidcache</docanchor>
    <docanchor file="geoid">geoidinst</docanchor>
    <docanchor file="geoid">testgeoid</docanchor>
  </compound>
  <compound kind="page">
    <name>gravity</name>
    <title>Gravity models</title>
    <filename>gravity</filename>
    <docanchor file="gravity">gravityatmos</docanchor>
    <docanchor file="gravity">gravityformat</docanchor>
    <docanchor file="gravity">gravityinst</docanchor>
    <docanchor file="gravity">gravityparallel</docanchor>
    <docanchor file="gravity">gravitygeoid</docanchor>
    <docanchor file="gravity">gravitynga</docanchor>
  </compound>
  <compound kind="page">
    <name>magnetic</name>
    <title>Magnetic models</title>
    <filename>magnetic</filename>
    <docanchor file="magnetic">magneticformat</docanchor>
    <docanchor file="magnetic">magneticinst</docanchor>
  </compound>
  <compound kind="page">
    <name>geodesic</name>
    <title>Geodesics on the ellipsoid</title>
    <filename>geodesic</filename>
    <docanchor file="geodesic">testgeod</docanchor>
    <docanchor file="geodesic">geodseries</docanchor>
  </compound>
  <compound kind="page">
    <name>transversemercator</name>
    <title>Transverse Mercator projection</title>
    <filename>transversemercator</filename>
    <docanchor file="transversemercator">tmseries</docanchor>
    <docanchor file="transversemercator">testmerc</docanchor>
  </compound>
  <compound kind="page">
    <name>geocentric</name>
    <title>Geocentric coordinates</title>
    <filename>geocentric</filename>
  </compound>
  <compound kind="page">
    <name>old</name>
    <title>Old versions</title>
    <filename>old</filename>
  </compound>
  <compound kind="namespace">
    <name>GeographicLib</name>
    <filename>namespaceGeographicLib.html</filename>
    <class kind="class">GeographicLib::Accumulator</class>
    <class kind="class">GeographicLib::AlbersEqualArea</class>
    <class kind="class">GeographicLib::AzimuthalEquidistant</class>
    <class kind="class">GeographicLib::CassiniSoldner</class>
    <class kind="class">GeographicLib::CircularEngine</class>
    <class kind="class">GeographicLib::Constants</class>
    <class kind="class">GeographicLib::GeographicErr</class>
    <class kind="class">GeographicLib::DMS</class>
    <class kind="class">GeographicLib::EllipticFunction</class>
    <class kind="class">GeographicLib::Geocentric</class>
    <class kind="class">GeographicLib::GeoCoords</class>
    <class kind="class">GeographicLib::Geodesic</class>
    <class kind="class">GeographicLib::GeodesicLine</class>
    <class kind="class">GeographicLib::Geoid</class>
    <class kind="class">GeographicLib::Gnomonic</class>
    <class kind="class">GeographicLib::GravityCircle</class>
    <class kind="class">GeographicLib::GravityModel</class>
    <class kind="class">GeographicLib::LambertConformalConic</class>
    <class kind="class">GeographicLib::LocalCartesian</class>
    <class kind="class">GeographicLib::MagneticCircle</class>
    <class kind="class">GeographicLib::MagneticModel</class>
    <class kind="class">GeographicLib::Math</class>
    <class kind="class">GeographicLib::MGRS</class>
    <class kind="class">GeographicLib::NormalGravity</class>
    <class kind="class">GeographicLib::OSGB</class>
    <class kind="class">GeographicLib::PolarStereographic</class>
    <class kind="class">GeographicLib::PolygonArea</class>
    <class kind="class">GeographicLib::SphericalEngine</class>
    <class kind="class">GeographicLib::SphericalHarmonic</class>
    <class kind="class">GeographicLib::SphericalHarmonic1</class>
    <class kind="class">GeographicLib::SphericalHarmonic2</class>
    <class kind="class">GeographicLib::TransverseMercator</class>
    <class kind="class">GeographicLib::TransverseMercatorExact</class>
    <class kind="class">GeographicLib::Utility</class>
    <class kind="class">GeographicLib::UTMUPS</class>
  </compound>
  <compound kind="class">
    <name>GeographicLib::Accumulator</name>
    <filename>classGeographicLib_1_1Accumulator.html</filename>
    <member kind="function">
      <type></type>
      <name>Accumulator</name>
      <anchorfile>classGeographicLib_1_1Accumulator.html</anchorfile>
      <anchor>a6d30e4a792644ffc78546dda4b5d0022</anchor>
      <arglist>(T y=T(0))</arglist>
    </member>
    <member kind="function">
      <type>Accumulator &amp;</type>
      <name>operator=</name>
      <anchorfile>classGeographicLib_1_1Accumulator.html</anchorfile>
      <anchor>a9cd31c9155208a2de0fdd9810f2a9dd8</anchor>
      <arglist>(T y)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>operator()</name>
      <anchorfile>classGeographicLib_1_1Accumulator.html</anchorfile>
      <anchor>af74ec2f9a77fcc82819111e6bb87b375</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>operator()</name>
      <anchorfile>classGeographicLib_1_1Accumulator.html</anchorfile>
      <anchor>a1a2b7ac3fd3b067a1c9930cb02a102b2</anchor>
      <arglist>(T y) const </arglist>
    </member>
    <member kind="function">
      <type>Accumulator &amp;</type>
      <name>operator+=</name>
      <anchorfile>classGeographicLib_1_1Accumulator.html</anchorfile>
      <anchor>adc56d12f08b8a61b19dd78ce532285d4</anchor>
      <arglist>(T y)</arglist>
    </member>
    <member kind="function">
      <type>Accumulator &amp;</type>
      <name>operator-=</name>
      <anchorfile>classGeographicLib_1_1Accumulator.html</anchorfile>
      <anchor>abf3e43f38791c48d1fa09e4fb569827b</anchor>
      <arglist>(T y)</arglist>
    </member>
    <member kind="function">
      <type>Accumulator &amp;</type>
      <name>operator*=</name>
      <anchorfile>classGeographicLib_1_1Accumulator.html</anchorfile>
      <anchor>a2b0bc40e9722e1ffac89ecfeb601fb23</anchor>
      <arglist>(int n)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGeographicLib_1_1Accumulator.html</anchorfile>
      <anchor>a6ea5d769a36e01327f3633b39cd38290</anchor>
      <arglist>(T y) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>classGeographicLib_1_1Accumulator.html</anchorfile>
      <anchor>a4102ce7aac36753c2b0390c4fc951a42</anchor>
      <arglist>(T y) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>classGeographicLib_1_1Accumulator.html</anchorfile>
      <anchor>a9a7299c02ec8805d951309fdae60e57f</anchor>
      <arglist>(T y) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>classGeographicLib_1_1Accumulator.html</anchorfile>
      <anchor>afb83bdb43b78e20f76e2a7e5e2440386</anchor>
      <arglist>(T y) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>classGeographicLib_1_1Accumulator.html</anchorfile>
      <anchor>af0e4a35c09b0b179ebf1e2f6912ddeb3</anchor>
      <arglist>(T y) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>classGeographicLib_1_1Accumulator.html</anchorfile>
      <anchor>aeafc5d10683648d37fe18ec75725196b</anchor>
      <arglist>(T y) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::AlbersEqualArea</name>
    <filename>classGeographicLib_1_1AlbersEqualArea.html</filename>
    <member kind="function">
      <type></type>
      <name>AlbersEqualArea</name>
      <anchorfile>classGeographicLib_1_1AlbersEqualArea.html</anchorfile>
      <anchor>a08edd228ba175a5ae71d783c4a712e50</anchor>
      <arglist>(real a, real f, real stdlat, real k0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>AlbersEqualArea</name>
      <anchorfile>classGeographicLib_1_1AlbersEqualArea.html</anchorfile>
      <anchor>a3851897cd1944503f81b46b7ce372d2a</anchor>
      <arglist>(real a, real f, real stdlat1, real stdlat2, real k1)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>AlbersEqualArea</name>
      <anchorfile>classGeographicLib_1_1AlbersEqualArea.html</anchorfile>
      <anchor>a58535d87e148d0cc474f3139c5188371</anchor>
      <arglist>(real a, real f, real sinlat1, real coslat1, real sinlat2, real coslat2, real k1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SetScale</name>
      <anchorfile>classGeographicLib_1_1AlbersEqualArea.html</anchorfile>
      <anchor>a0c00022edeb6b67dcd4e00f087b412c4</anchor>
      <arglist>(real lat, real k=real(1))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Forward</name>
      <anchorfile>classGeographicLib_1_1AlbersEqualArea.html</anchorfile>
      <anchor>aac57f3a9c0c08fb897a1e37034d127c1</anchor>
      <arglist>(real lon0, real lat, real lon, real &amp;x, real &amp;y, real &amp;gamma, real &amp;k) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Reverse</name>
      <anchorfile>classGeographicLib_1_1AlbersEqualArea.html</anchorfile>
      <anchor>a577a9f43be8c1e238a4d56158acf8625</anchor>
      <arglist>(real lon0, real x, real y, real &amp;lat, real &amp;lon, real &amp;gamma, real &amp;k) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Forward</name>
      <anchorfile>classGeographicLib_1_1AlbersEqualArea.html</anchorfile>
      <anchor>a68a13780a73bcf9c8e50a3ce4eae3086</anchor>
      <arglist>(real lon0, real lat, real lon, real &amp;x, real &amp;y) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Reverse</name>
      <anchorfile>classGeographicLib_1_1AlbersEqualArea.html</anchorfile>
      <anchor>a871246cba03145512f3f12ceb3e3e3a8</anchor>
      <arglist>(real lon0, real x, real y, real &amp;lat, real &amp;lon) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MajorRadius</name>
      <anchorfile>classGeographicLib_1_1AlbersEqualArea.html</anchorfile>
      <anchor>a55d5ca45e7c80a96b3faf0094714ac59</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Flattening</name>
      <anchorfile>classGeographicLib_1_1AlbersEqualArea.html</anchorfile>
      <anchor>a565c63954715204781ae458db0d6b1f7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>OriginLatitude</name>
      <anchorfile>classGeographicLib_1_1AlbersEqualArea.html</anchorfile>
      <anchor>ad780e943e9a9ba168b350d809d0bfe08</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>CentralScale</name>
      <anchorfile>classGeographicLib_1_1AlbersEqualArea.html</anchorfile>
      <anchor>af407e835eaf76895ee25ec9e7a9c090c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const AlbersEqualArea</type>
      <name>CylindricalEqualArea</name>
      <anchorfile>classGeographicLib_1_1AlbersEqualArea.html</anchorfile>
      <anchor>ae643f7f82f5864f95da4cb14571ccf55</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const AlbersEqualArea</type>
      <name>AzimuthalEqualAreaNorth</name>
      <anchorfile>classGeographicLib_1_1AlbersEqualArea.html</anchorfile>
      <anchor>ae65fcb68843b36d206751527ebd08f44</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const AlbersEqualArea</type>
      <name>AzimuthalEqualAreaSouth</name>
      <anchorfile>classGeographicLib_1_1AlbersEqualArea.html</anchorfile>
      <anchor>aff0ff4e2f162107bd136310b44444cc1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::AzimuthalEquidistant</name>
    <filename>classGeographicLib_1_1AzimuthalEquidistant.html</filename>
    <member kind="function">
      <type></type>
      <name>AzimuthalEquidistant</name>
      <anchorfile>classGeographicLib_1_1AzimuthalEquidistant.html</anchorfile>
      <anchor>a125571cdeed68d10192611cc12e221ce</anchor>
      <arglist>(const Geodesic &amp;earth=Geodesic::WGS84)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Forward</name>
      <anchorfile>classGeographicLib_1_1AzimuthalEquidistant.html</anchorfile>
      <anchor>a8b4951b7c732f97aedeb8e869c9349d2</anchor>
      <arglist>(real lat0, real lon0, real lat, real lon, real &amp;x, real &amp;y, real &amp;azi, real &amp;rk) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Reverse</name>
      <anchorfile>classGeographicLib_1_1AzimuthalEquidistant.html</anchorfile>
      <anchor>a26d1b6fe3af8750babaeb60efdfec062</anchor>
      <arglist>(real lat0, real lon0, real x, real y, real &amp;lat, real &amp;lon, real &amp;azi, real &amp;rk) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Forward</name>
      <anchorfile>classGeographicLib_1_1AzimuthalEquidistant.html</anchorfile>
      <anchor>a950431c3d269fb82e9410f332c401786</anchor>
      <arglist>(real lat0, real lon0, real lat, real lon, real &amp;x, real &amp;y) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Reverse</name>
      <anchorfile>classGeographicLib_1_1AzimuthalEquidistant.html</anchorfile>
      <anchor>a6b86b19f2e1c773e028e386a0f5e00e0</anchor>
      <arglist>(real lat0, real lon0, real x, real y, real &amp;lat, real &amp;lon) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MajorRadius</name>
      <anchorfile>classGeographicLib_1_1AzimuthalEquidistant.html</anchorfile>
      <anchor>a42c4103265af804395b8b5260a4c25e0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Flattening</name>
      <anchorfile>classGeographicLib_1_1AzimuthalEquidistant.html</anchorfile>
      <anchor>a3f300fcc10aeee9dc88ff93fb991f191</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::CassiniSoldner</name>
    <filename>classGeographicLib_1_1CassiniSoldner.html</filename>
    <member kind="function">
      <type></type>
      <name>CassiniSoldner</name>
      <anchorfile>classGeographicLib_1_1CassiniSoldner.html</anchorfile>
      <anchor>a948f9d934615c4120eb23740635200bc</anchor>
      <arglist>(const Geodesic &amp;earth=Geodesic::WGS84)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CassiniSoldner</name>
      <anchorfile>classGeographicLib_1_1CassiniSoldner.html</anchorfile>
      <anchor>a1b19cedb287ec9bbe59ec18a0ad2a5e4</anchor>
      <arglist>(real lat0, real lon0, const Geodesic &amp;earth=Geodesic::WGS84)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Reset</name>
      <anchorfile>classGeographicLib_1_1CassiniSoldner.html</anchorfile>
      <anchor>af9bdc7088bca547dcc191691b2737759</anchor>
      <arglist>(real lat0, real lon0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Forward</name>
      <anchorfile>classGeographicLib_1_1CassiniSoldner.html</anchorfile>
      <anchor>a37656c7551b10ad75a40758d0bba570d</anchor>
      <arglist>(real lat, real lon, real &amp;x, real &amp;y, real &amp;azi, real &amp;rk) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Reverse</name>
      <anchorfile>classGeographicLib_1_1CassiniSoldner.html</anchorfile>
      <anchor>aea917b790f577026184a0bb262102db4</anchor>
      <arglist>(real x, real y, real &amp;lat, real &amp;lon, real &amp;azi, real &amp;rk) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Forward</name>
      <anchorfile>classGeographicLib_1_1CassiniSoldner.html</anchorfile>
      <anchor>a87bf8d3b416bbfd8b7a2c5269245e693</anchor>
      <arglist>(real lat, real lon, real &amp;x, real &amp;y) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Reverse</name>
      <anchorfile>classGeographicLib_1_1CassiniSoldner.html</anchorfile>
      <anchor>a27a675e995d2c1fdd0ab4c0ab397e065</anchor>
      <arglist>(real x, real y, real &amp;lat, real &amp;lon) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>Init</name>
      <anchorfile>classGeographicLib_1_1CassiniSoldner.html</anchorfile>
      <anchor>a3f71bb8b662438a7954be174315ce974</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>LatitudeOrigin</name>
      <anchorfile>classGeographicLib_1_1CassiniSoldner.html</anchorfile>
      <anchor>a2aa51120af199603f57d54b8c9a0bdde</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>LongitudeOrigin</name>
      <anchorfile>classGeographicLib_1_1CassiniSoldner.html</anchorfile>
      <anchor>aeb5c42b5cb6202a2371ba84bf76e0161</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MajorRadius</name>
      <anchorfile>classGeographicLib_1_1CassiniSoldner.html</anchorfile>
      <anchor>a0019eeb70b5493de687c5cc36ae7f43c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Flattening</name>
      <anchorfile>classGeographicLib_1_1CassiniSoldner.html</anchorfile>
      <anchor>a8d618d5abe71a49fc5ec4f2801d22555</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::CircularEngine</name>
    <filename>classGeographicLib_1_1CircularEngine.html</filename>
    <member kind="function">
      <type></type>
      <name>CircularEngine</name>
      <anchorfile>classGeographicLib_1_1CircularEngine.html</anchorfile>
      <anchor>a91dd2b9cc408e35f8cb6482cdf3aadbf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>operator()</name>
      <anchorfile>classGeographicLib_1_1CircularEngine.html</anchorfile>
      <anchor>a8e39d83fcbed23df36ef4fefe2a86420</anchor>
      <arglist>(real coslon, real sinlon) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>operator()</name>
      <anchorfile>classGeographicLib_1_1CircularEngine.html</anchorfile>
      <anchor>a48d2327412e0c674285ff6bb85440054</anchor>
      <arglist>(real lon) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>operator()</name>
      <anchorfile>classGeographicLib_1_1CircularEngine.html</anchorfile>
      <anchor>aa15c408a0ff4cf17575e62edfeae77a6</anchor>
      <arglist>(real coslon, real sinlon, real &amp;gradx, real &amp;grady, real &amp;gradz) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>operator()</name>
      <anchorfile>classGeographicLib_1_1CircularEngine.html</anchorfile>
      <anchor>a88a0726718baa7b457c77b5681fabb0a</anchor>
      <arglist>(real lon, real &amp;gradx, real &amp;grady, real &amp;gradz) const </arglist>
    </member>
    <member kind="friend" protection="private">
      <type>friend class</type>
      <name>SphericalEngine</name>
      <anchorfile>classGeographicLib_1_1CircularEngine.html</anchorfile>
      <anchor>ab89064f7f3c32a745c72d8c3188f7485</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="private">
      <type>friend class</type>
      <name>GravityCircle</name>
      <anchorfile>classGeographicLib_1_1CircularEngine.html</anchorfile>
      <anchor>a243c90a7f9bf3f7aa96877a4b0667a89</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="private">
      <type>friend class</type>
      <name>MagneticCircle</name>
      <anchorfile>classGeographicLib_1_1CircularEngine.html</anchorfile>
      <anchor>a7294f6a1cc932f8fd1562a15602e9e86</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::Constants</name>
    <filename>classGeographicLib_1_1Constants.html</filename>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>degree</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>a26ff02acd8141a815428cddf0ff3ff66</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>arcminute</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>a8f8e6d3bd08abb72b686a0f4398b587b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>arcsecond</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>a04858f922295d2a04bb021eecac07179</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>WGS84_a</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>ae12127984ac6713823746d917b4abfa7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>WGS84_a</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>a53f39f52837f47490fbdf7332a37dd8b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>WGS84_f</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>acc5244425bb484594be51b27d56cd335</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>WGS84_f</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>acd335c7f28440e0774666cedffed84f0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>WGS84_GM</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>af7806106d7bd289bb63d5290e79c87a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>WGS84_omega</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>a98c114d5a6ca42d3e4ece8595a0c2180</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>WGS84_r</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>a199810de7ff3351be6473d20ef045789</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>GRS80_a</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>a9b955c3556dcfcebce6a2926bfeaf464</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>GRS80_GM</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>a7541474ca70cbec7fccb08d3e3fbfe31</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>GRS80_omega</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>a9caea97ab2be0959c7972155141bfd1b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>GRS80_J2</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>a59c7a1d298eb72256119894b67470974</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>UTM_k0</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>ab5cc487ab160c0a213fdf8e12cde198a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>UTM_k0</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>aebbe37ebfb407a851f72caa95e5dc94f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>UPS_k0</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>a3fe287ab1a0847f5392c1aaf9c5e635a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>UPS_k0</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>a49d415263ee320d1a63a857f784439a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>meter</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>ac1b17e7cf67ef42b9b91f3677c2eaa75</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>meter</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>afeffc10d6b8171b39a50949cac149063</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>kilometer</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>a4ec5a9d91ab0ccbd3bd921cda4bfc836</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>nauticalmile</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>afedc242aa3ee9b3bf9c72d6d81fc6740</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>square_meter</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>ab92200b36f9d306a2710738c6d9bc705</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>square_meter</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>a702b928c9a29dbcc7324b9d835b38d94</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>hectare</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>a4cc4ae77e3136d7784cd7c69d6927adc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>square_kilometer</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>a1956824e4f2b22705d57566229a7c311</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>square_nauticalmile</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>a5acf6b2c23d1c9ddf140a6b4e588e88a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>foot</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>ac69f40e7e56c71bc72011c7591f7bef9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>yard</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>a00057328caa45bc216d18243786920c2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>fathom</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>a51cf3e97984ac301b1f27b667b360be0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>chain</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>ac4f3792bce075999b0c9b9485e4079d0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>furlong</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>a824d39311cf43f916d4ac19e46da3713</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>mile</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>a49cb7b828f7c85c36761d47b8db6518c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>acre</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>ae5aa419ea6c6ce121c912c8afea0a0b7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>square_mile</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>ab7f473c27ad50da450b4192155cc92f9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>surveyfoot</name>
      <anchorfile>classGeographicLib_1_1Constants.html</anchorfile>
      <anchor>a7faf6e7435791c0a8061296a79c0be08</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::GeographicErr</name>
    <filename>classGeographicLib_1_1GeographicErr.html</filename>
    <member kind="function">
      <type></type>
      <name>GeographicErr</name>
      <anchorfile>classGeographicLib_1_1GeographicErr.html</anchorfile>
      <anchor>ae0f338af58f073657b012c8a9a64b006</anchor>
      <arglist>(const std::string &amp;msg)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::DMS</name>
    <filename>classGeographicLib_1_1DMS.html</filename>
    <member kind="enumeration">
      <name>flag</name>
      <anchorfile>classGeographicLib_1_1DMS.html</anchorfile>
      <anchor>a7a1101fd2577636863753baae3e54869</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NONE</name>
      <anchorfile>classGeographicLib_1_1DMS.html</anchorfile>
      <anchor>a7a1101fd2577636863753baae3e54869adc80eee37727cca42f9805cfefb83fc1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LATITUDE</name>
      <anchorfile>classGeographicLib_1_1DMS.html</anchorfile>
      <anchor>a7a1101fd2577636863753baae3e54869a6b5a0451ce4c199bd82f5d87d50b523b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LONGITUDE</name>
      <anchorfile>classGeographicLib_1_1DMS.html</anchorfile>
      <anchor>a7a1101fd2577636863753baae3e54869a321624c1b510f7f1e392e7509a85914f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>AZIMUTH</name>
      <anchorfile>classGeographicLib_1_1DMS.html</anchorfile>
      <anchor>a7a1101fd2577636863753baae3e54869a92264580521b3a1c1df2a7421b435e24</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NUMBER</name>
      <anchorfile>classGeographicLib_1_1DMS.html</anchorfile>
      <anchor>a7a1101fd2577636863753baae3e54869a5a65ec03b2682ad76873829167882518</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>component</name>
      <anchorfile>classGeographicLib_1_1DMS.html</anchorfile>
      <anchor>ab9fa04b3a9156f36f18852eed9b7ce09</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DEGREE</name>
      <anchorfile>classGeographicLib_1_1DMS.html</anchorfile>
      <anchor>ab9fa04b3a9156f36f18852eed9b7ce09a8ee59944227e74901b71f27410d70781</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MINUTE</name>
      <anchorfile>classGeographicLib_1_1DMS.html</anchorfile>
      <anchor>ab9fa04b3a9156f36f18852eed9b7ce09a9884bea675fd214061e534e76a1c15d6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SECOND</name>
      <anchorfile>classGeographicLib_1_1DMS.html</anchorfile>
      <anchor>ab9fa04b3a9156f36f18852eed9b7ce09a10c28c85ddfa71db5f1d46d362333075</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>Decode</name>
      <anchorfile>classGeographicLib_1_1DMS.html</anchorfile>
      <anchor>ae802c666ad53884ce062281409bd78b4</anchor>
      <arglist>(const std::string &amp;dms, flag &amp;ind)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>Decode</name>
      <anchorfile>classGeographicLib_1_1DMS.html</anchorfile>
      <anchor>a4987f8eb6c1ba5402eb25d6225ab58e1</anchor>
      <arglist>(real d, real m=0, real s=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>DecodeLatLon</name>
      <anchorfile>classGeographicLib_1_1DMS.html</anchorfile>
      <anchor>a2d38adcfecb7a41865092e870e19730f</anchor>
      <arglist>(const std::string &amp;dmsa, const std::string &amp;dmsb, real &amp;lat, real &amp;lon, bool swaplatlong=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>DecodeAngle</name>
      <anchorfile>classGeographicLib_1_1DMS.html</anchorfile>
      <anchor>a868248d72f6b0bf2dae18a15d741ac43</anchor>
      <arglist>(const std::string &amp;angstr)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>DecodeAzimuth</name>
      <anchorfile>classGeographicLib_1_1DMS.html</anchorfile>
      <anchor>a0512cc1275e089138e1550efbee421d9</anchor>
      <arglist>(const std::string &amp;azistr)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static std::string</type>
      <name>Encode</name>
      <anchorfile>classGeographicLib_1_1DMS.html</anchorfile>
      <anchor>a0777e26ef4507f8123549723bf3cb56f</anchor>
      <arglist>(real angle, component trailing, unsigned prec, flag ind, char dmssep)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static std::string</type>
      <name>Encode</name>
      <anchorfile>classGeographicLib_1_1DMS.html</anchorfile>
      <anchor>a3e36baa6114d46f82a8900d002784369</anchor>
      <arglist>(real angle, component trailing, unsigned prec, flag ind=NONE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static std::string</type>
      <name>Encode</name>
      <anchorfile>classGeographicLib_1_1DMS.html</anchorfile>
      <anchor>aeb9d338b12e885092a611bda7e52f9f4</anchor>
      <arglist>(real angle, unsigned prec, flag ind=NONE, char dmssep=char(0))</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>Encode</name>
      <anchorfile>classGeographicLib_1_1DMS.html</anchorfile>
      <anchor>a1ae785976e5d7c6346cfb68863884b55</anchor>
      <arglist>(real ang, real &amp;d, real &amp;m)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>Encode</name>
      <anchorfile>classGeographicLib_1_1DMS.html</anchorfile>
      <anchor>af27df7ef6ac42bf0e6341749b4b96eec</anchor>
      <arglist>(real ang, real &amp;d, real &amp;m, real &amp;s)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::EllipticFunction</name>
    <filename>classGeographicLib_1_1EllipticFunction.html</filename>
    <member kind="function">
      <type></type>
      <name>EllipticFunction</name>
      <anchorfile>classGeographicLib_1_1EllipticFunction.html</anchorfile>
      <anchor>ada122111b55eb0ab9c7b9fafb0a4b1e6</anchor>
      <arglist>(real m)</arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>m</name>
      <anchorfile>classGeographicLib_1_1EllipticFunction.html</anchorfile>
      <anchor>aba29c348874db7880ab7b1065f03ff7c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>m1</name>
      <anchorfile>classGeographicLib_1_1EllipticFunction.html</anchorfile>
      <anchor>ad1fbe801f6731285462d35d874a149ba</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>K</name>
      <anchorfile>classGeographicLib_1_1EllipticFunction.html</anchorfile>
      <anchor>a6c6c8029d93946b32184ee964525938c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>E</name>
      <anchorfile>classGeographicLib_1_1EllipticFunction.html</anchorfile>
      <anchor>a184174d29953891896b41c597c34eb9a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>KE</name>
      <anchorfile>classGeographicLib_1_1EllipticFunction.html</anchorfile>
      <anchor>a12bcdf2c3fc7bcb165318822171328f7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sncndn</name>
      <anchorfile>classGeographicLib_1_1EllipticFunction.html</anchorfile>
      <anchor>a0b8d63970c4276503d03d4133ee6c321</anchor>
      <arglist>(real x, real &amp;sn, real &amp;cn, real &amp;dn) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>E</name>
      <anchorfile>classGeographicLib_1_1EllipticFunction.html</anchorfile>
      <anchor>a8be312b5da54b01f2976416aa82e7d08</anchor>
      <arglist>(real phi) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>E</name>
      <anchorfile>classGeographicLib_1_1EllipticFunction.html</anchorfile>
      <anchor>af1b3b2265bca5d2b52c17ca44dabffa8</anchor>
      <arglist>(real sn, real cn, real dn) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::Geocentric</name>
    <filename>classGeographicLib_1_1Geocentric.html</filename>
    <member kind="function">
      <type></type>
      <name>Geocentric</name>
      <anchorfile>classGeographicLib_1_1Geocentric.html</anchorfile>
      <anchor>a6527d3ab1df78de8277122581dbcdaff</anchor>
      <arglist>(real a, real f)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Geocentric</name>
      <anchorfile>classGeographicLib_1_1Geocentric.html</anchorfile>
      <anchor>adc92d7214526b4cfcd0b9a0171fc8448</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Forward</name>
      <anchorfile>classGeographicLib_1_1Geocentric.html</anchorfile>
      <anchor>a65320594cad8c03d28beaa409f3d6fae</anchor>
      <arglist>(real lat, real lon, real h, real &amp;X, real &amp;Y, real &amp;Z) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Forward</name>
      <anchorfile>classGeographicLib_1_1Geocentric.html</anchorfile>
      <anchor>a54e09e4673ddbf99feeba81036c81345</anchor>
      <arglist>(real lat, real lon, real h, real &amp;X, real &amp;Y, real &amp;Z, std::vector&lt; real &gt; &amp;M) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Reverse</name>
      <anchorfile>classGeographicLib_1_1Geocentric.html</anchorfile>
      <anchor>a1907735ce8f5f915a14a5f7a8b3adfea</anchor>
      <arglist>(real X, real Y, real Z, real &amp;lat, real &amp;lon, real &amp;h) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Reverse</name>
      <anchorfile>classGeographicLib_1_1Geocentric.html</anchorfile>
      <anchor>aeddd854d52064bcb1f068052057edf2c</anchor>
      <arglist>(real X, real Y, real Z, real &amp;lat, real &amp;lon, real &amp;h, std::vector&lt; real &gt; &amp;M) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>Init</name>
      <anchorfile>classGeographicLib_1_1Geocentric.html</anchorfile>
      <anchor>a7d2e34d1be6009caf4576c6cc884a589</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MajorRadius</name>
      <anchorfile>classGeographicLib_1_1Geocentric.html</anchorfile>
      <anchor>ae20c62c298f1724412fec581285cf269</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Flattening</name>
      <anchorfile>classGeographicLib_1_1Geocentric.html</anchorfile>
      <anchor>a30ba434524b5836c9852d454e61d795f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const Geocentric</type>
      <name>WGS84</name>
      <anchorfile>classGeographicLib_1_1Geocentric.html</anchorfile>
      <anchor>a4762989f3d1d30bca597f644e8b2b52e</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="private">
      <type>friend class</type>
      <name>LocalCartesian</name>
      <anchorfile>classGeographicLib_1_1Geocentric.html</anchorfile>
      <anchor>a8904c4eadcf94e3803743e8cd9ffbc1c</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="private">
      <type>friend class</type>
      <name>MagneticCircle</name>
      <anchorfile>classGeographicLib_1_1Geocentric.html</anchorfile>
      <anchor>a7294f6a1cc932f8fd1562a15602e9e86</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="private">
      <type>friend class</type>
      <name>MagneticModel</name>
      <anchorfile>classGeographicLib_1_1Geocentric.html</anchorfile>
      <anchor>af6619ebe4c078705fc49a0d9f950b431</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="private">
      <type>friend class</type>
      <name>GravityCircle</name>
      <anchorfile>classGeographicLib_1_1Geocentric.html</anchorfile>
      <anchor>a243c90a7f9bf3f7aa96877a4b0667a89</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="private">
      <type>friend class</type>
      <name>GravityModel</name>
      <anchorfile>classGeographicLib_1_1Geocentric.html</anchorfile>
      <anchor>ada1db1d9f480d8044753ed869c995519</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="private">
      <type>friend class</type>
      <name>NormalGravity</name>
      <anchorfile>classGeographicLib_1_1Geocentric.html</anchorfile>
      <anchor>ae7298549755c5982fe1be124d6631561</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="private">
      <type>friend class</type>
      <name>SphericalHarmonic</name>
      <anchorfile>classGeographicLib_1_1Geocentric.html</anchorfile>
      <anchor>ae0383f6b1ce413d48e258750c3177f21</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="private">
      <type>friend class</type>
      <name>SphericalHarmonic1</name>
      <anchorfile>classGeographicLib_1_1Geocentric.html</anchorfile>
      <anchor>accac7c5b7843a1e4fb2baf0c83cc24f0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="private">
      <type>friend class</type>
      <name>SphericalHarmonic2</name>
      <anchorfile>classGeographicLib_1_1Geocentric.html</anchorfile>
      <anchor>a3eabc426b6edd718324c791ef3536360</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::GeoCoords</name>
    <filename>classGeographicLib_1_1GeoCoords.html</filename>
    <member kind="function">
      <type></type>
      <name>GeoCoords</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>a8b3f4a919ba4478c4fec0e7b01e84c57</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GeoCoords</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>acdfe641aaea6b68aee25cfee822f782a</anchor>
      <arglist>(const std::string &amp;s, bool centerp=true, bool swaplatlong=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GeoCoords</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>a7bde6a5cba74adf66d831788e6be8e65</anchor>
      <arglist>(real latitude, real longitude, int zone=UTMUPS::STANDARD)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GeoCoords</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>aaab765054416e1243f2d7b36edc8e0d4</anchor>
      <arglist>(int zone, bool northp, real easting, real northing)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Reset</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>a4a1e0a65a8a344dfe519fcbf25078e37</anchor>
      <arglist>(const std::string &amp;s, bool centerp=true, bool swaplatlong=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Reset</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>a0cbbebaa7bb77f91f3f8dbbadfd6532a</anchor>
      <arglist>(real latitude, real longitude, int zone=UTMUPS::STANDARD)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Reset</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>ab072761684d992f508b5a3b9440653fb</anchor>
      <arglist>(int zone, bool northp, real easting, real northing)</arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Latitude</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>a1bc1bb3a2377fa6b70be046dcf5d3e97</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Longitude</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>a7db5459efae411dfebec758a8244a95a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Easting</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>a9a84801f0b383860b24cc1344e4015fb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Northing</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>ac0202def9c16ce856f62485b5c249083</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Convergence</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>ad92c8fa1b34bd11dbd908dfffbb836a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Scale</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>aafd68e75d223b821abcbf20179c7a9e0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>Northp</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>a5bcf16f97750a6be77f72d50e304a007</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>char</type>
      <name>Hemisphere</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>a0764b9f389a6ce851f9c7c8317ecebb3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>Zone</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>a3ce32259b53a9ea9a5346d9e418ad6a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SetAltZone</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>a7782c2d78462bde2ba6277b2b60af8f6</anchor>
      <arglist>(int zone=UTMUPS::STANDARD) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>AltZone</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>a590600b600395c7914e4854faee08f8e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>AltEasting</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>af4a5b63a1931973338f71ef2ec4e27fa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>AltNorthing</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>a2f5a9665712214ad34b061d35ce89659</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>AltConvergence</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>a2b62e667ce462d8102fdfa6ece6ff50e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>AltScale</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>a299131cd5383ad0adc5af92c84dc6afe</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>GeoRepresentation</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>a79af2d72afdfeede78f2ba65b809d6b3</anchor>
      <arglist>(int prec=0, bool swaplatlong=false) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>DMSRepresentation</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>af6e9f9087a407b01dc24401df8610257</anchor>
      <arglist>(int prec, bool swaplatlong, char dmssep) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>DMSRepresentation</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>ab37746606876eb77335268054589390a</anchor>
      <arglist>(int prec=0, bool swaplatlong=false) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>MGRSRepresentation</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>a36594aaa4f293b0ddf00b1c78bb04595</anchor>
      <arglist>(int prec=0) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>UTMUPSRepresentation</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>a056efc42fe4c653aad40be5d5b865ea3</anchor>
      <arglist>(int prec=0) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>AltMGRSRepresentation</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>ad602893cd4a81ccc511daff76b411413</anchor>
      <arglist>(int prec=0) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>AltUTMUPSRepresentation</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>a020732ccba257d7f5248692afd318b93</anchor>
      <arglist>(int prec=0) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MajorRadius</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>a897e6bbfb71f78b0646045bf47e09696</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Flattening</name>
      <anchorfile>classGeographicLib_1_1GeoCoords.html</anchorfile>
      <anchor>a4d892f5e55df8cbb597d1a693da4783c</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::Geodesic</name>
    <filename>classGeographicLib_1_1Geodesic.html</filename>
    <member kind="enumeration">
      <name>mask</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>aab966190e69651b86661fc2628d20828</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NONE</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>aab966190e69651b86661fc2628d20828ab10adfebcb73de5356c4787246f056af</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LATITUDE</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>aab966190e69651b86661fc2628d20828a7c1f4742e41ae5e75c8133ee7fb8fd90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LONGITUDE</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>aab966190e69651b86661fc2628d20828aa1e019a4815f6c23ca30d4b3efcf6c6b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>AZIMUTH</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>aab966190e69651b86661fc2628d20828aa413d0b81ccb4b5302285b1a01f16c08</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DISTANCE</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>aab966190e69651b86661fc2628d20828a0fe3400fb8dcc92274fbac2839cc4e0d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DISTANCE_IN</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>aab966190e69651b86661fc2628d20828ae20140cdf788fa0497df59630d3211ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REDUCEDLENGTH</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>aab966190e69651b86661fc2628d20828a7a27709e1377a8c34704cf1cec64db6c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GEODESICSCALE</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>aab966190e69651b86661fc2628d20828afb114302395314a68dfef3c14693ea2e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>AREA</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>aab966190e69651b86661fc2628d20828a9aea7d24f8e437d6ea38defbe4ec9b14</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ALL</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>aab966190e69651b86661fc2628d20828a30e0c9456c5df9e6ff23880014bd11e0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Geodesic</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>a455300c36e6caa70968115416e1573a4</anchor>
      <arglist>(real a, real f)</arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Direct</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>a6e31d7655895a61a49258de00fd14603</anchor>
      <arglist>(real lat1, real lon1, real azi1, real s12, real &amp;lat2, real &amp;lon2, real &amp;azi2, real &amp;m12, real &amp;M12, real &amp;M21, real &amp;S12) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Direct</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>ac8b9e451fc4093253cfe3f8051d72a14</anchor>
      <arglist>(real lat1, real lon1, real azi1, real s12, real &amp;lat2, real &amp;lon2) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Direct</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>ac8f0b5f4db73c5d8d11797698f937402</anchor>
      <arglist>(real lat1, real lon1, real azi1, real s12, real &amp;lat2, real &amp;lon2, real &amp;azi2) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Direct</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>a63f7681d1239902dc3f528ded0f90352</anchor>
      <arglist>(real lat1, real lon1, real azi1, real s12, real &amp;lat2, real &amp;lon2, real &amp;azi2, real &amp;m12) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Direct</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>a7fb2003b8f1d68976fac43d158b4b8b4</anchor>
      <arglist>(real lat1, real lon1, real azi1, real s12, real &amp;lat2, real &amp;lon2, real &amp;azi2, real &amp;M12, real &amp;M21) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Direct</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>a65cf95dc7f5c0bfd427e963281e044f0</anchor>
      <arglist>(real lat1, real lon1, real azi1, real s12, real &amp;lat2, real &amp;lon2, real &amp;azi2, real &amp;m12, real &amp;M12, real &amp;M21) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ArcDirect</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>abfb6553227e1534b451900240b39d058</anchor>
      <arglist>(real lat1, real lon1, real azi1, real a12, real &amp;lat2, real &amp;lon2, real &amp;azi2, real &amp;s12, real &amp;m12, real &amp;M12, real &amp;M21, real &amp;S12) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ArcDirect</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>aa1bed6c11200c0323cffd0e7027e4df2</anchor>
      <arglist>(real lat1, real lon1, real azi1, real a12, real &amp;lat2, real &amp;lon2) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ArcDirect</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>a6f8eabd951b2fe23ffacb6209b2d43bc</anchor>
      <arglist>(real lat1, real lon1, real azi1, real a12, real &amp;lat2, real &amp;lon2, real &amp;azi2) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ArcDirect</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>a223802b76bae1665f360b2e343d7afd7</anchor>
      <arglist>(real lat1, real lon1, real azi1, real a12, real &amp;lat2, real &amp;lon2, real &amp;azi2, real &amp;s12) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ArcDirect</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>a63ffe80d449adad813dc98805adcca81</anchor>
      <arglist>(real lat1, real lon1, real azi1, real a12, real &amp;lat2, real &amp;lon2, real &amp;azi2, real &amp;s12, real &amp;m12) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ArcDirect</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>a55c17605d76f6c46ac5b11f36e8e8641</anchor>
      <arglist>(real lat1, real lon1, real azi1, real a12, real &amp;lat2, real &amp;lon2, real &amp;azi2, real &amp;s12, real &amp;M12, real &amp;M21) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ArcDirect</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>adc8a4d02e631e8966d5842056a49be9c</anchor>
      <arglist>(real lat1, real lon1, real azi1, real a12, real &amp;lat2, real &amp;lon2, real &amp;azi2, real &amp;s12, real &amp;m12, real &amp;M12, real &amp;M21) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>GenDirect</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>acaef3032846a71fc730e1ea26ea32d20</anchor>
      <arglist>(real lat1, real lon1, real azi1, bool arcmode, real s12_a12, unsigned outmask, real &amp;lat2, real &amp;lon2, real &amp;azi2, real &amp;s12, real &amp;m12, real &amp;M12, real &amp;M21, real &amp;S12) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Inverse</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>ad7e59a242125a35a95c96cdb20573081</anchor>
      <arglist>(real lat1, real lon1, real lat2, real lon2, real &amp;s12, real &amp;azi1, real &amp;azi2, real &amp;m12, real &amp;M12, real &amp;M21, real &amp;S12) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Inverse</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>a7c35218473b1784b1a80b8631f2d345d</anchor>
      <arglist>(real lat1, real lon1, real lat2, real lon2, real &amp;s12) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Inverse</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>a599e587407713f7019906881d6116873</anchor>
      <arglist>(real lat1, real lon1, real lat2, real lon2, real &amp;azi1, real &amp;azi2) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Inverse</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>a3e07eef498c82ac25b482cadf129d8ae</anchor>
      <arglist>(real lat1, real lon1, real lat2, real lon2, real &amp;s12, real &amp;azi1, real &amp;azi2) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Inverse</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>aa6da95e73bec6443a03bf3928f401d19</anchor>
      <arglist>(real lat1, real lon1, real lat2, real lon2, real &amp;s12, real &amp;azi1, real &amp;azi2, real &amp;m12) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Inverse</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>ac668b5d0f82b28440dac5a44719fd61a</anchor>
      <arglist>(real lat1, real lon1, real lat2, real lon2, real &amp;s12, real &amp;azi1, real &amp;azi2, real &amp;M12, real &amp;M21) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Inverse</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>ad3f98a5f2adf39ff26cf3d6fe32258a8</anchor>
      <arglist>(real lat1, real lon1, real lat2, real lon2, real &amp;s12, real &amp;azi1, real &amp;azi2, real &amp;m12, real &amp;M12, real &amp;M21) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>GenInverse</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>a84a3b9b457dd87b1059045b9d50303fd</anchor>
      <arglist>(real lat1, real lon1, real lat2, real lon2, unsigned outmask, real &amp;s12, real &amp;azi1, real &amp;azi2, real &amp;m12, real &amp;M12, real &amp;M21, real &amp;S12) const </arglist>
    </member>
    <member kind="function">
      <type>GeodesicLine</type>
      <name>Line</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>a3ac241c18897bb9bec4b839d7e1a7c59</anchor>
      <arglist>(real lat1, real lon1, real azi1, unsigned caps=ALL) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MajorRadius</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>acd276bb113cfdf3fe59aa43fb3d7289b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Flattening</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>a7abba09bec76f8f97f1e3bc81a7456e2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>EllipsoidArea</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>a0dde7d12d4bafedef63d371c5fe40f50</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const Geodesic</type>
      <name>WGS84</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>ae918bb7e1555fba38483449cbbac0ca1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="private">
      <type>friend class</type>
      <name>GeodesicLine</name>
      <anchorfile>classGeographicLib_1_1Geodesic.html</anchorfile>
      <anchor>ac4a8bd684285e00b12427c052697a106</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::GeodesicLine</name>
    <filename>classGeographicLib_1_1GeodesicLine.html</filename>
    <member kind="enumeration">
      <name>mask</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>adeec76cf92a8c30770e1199bdadacbcc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NONE</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>adeec76cf92a8c30770e1199bdadacbcca0f2ec05e56540d908a326a872b9aa68f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LATITUDE</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>adeec76cf92a8c30770e1199bdadacbcca34e259b158b7fa5441e91d32eae20c23</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LONGITUDE</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>adeec76cf92a8c30770e1199bdadacbccac41b1e2e1d73c8d323f92b94e57a0cc9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>AZIMUTH</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>adeec76cf92a8c30770e1199bdadacbcca654b16d956cdd16a70605a6b54a1228e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DISTANCE</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>adeec76cf92a8c30770e1199bdadacbcca6d8b294c13e0495120b9bfd6a9281184</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DISTANCE_IN</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>adeec76cf92a8c30770e1199bdadacbcca7929baa71a65e8399073f67382e4d0bc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REDUCEDLENGTH</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>adeec76cf92a8c30770e1199bdadacbccab6649103de9393f5f18a5d2e44624411</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GEODESICSCALE</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>adeec76cf92a8c30770e1199bdadacbcca74f896572150d24be4667cf66ed696a6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>AREA</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>adeec76cf92a8c30770e1199bdadacbcca71c623894b3e6bb0864f3da89d1a1915</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ALL</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>adeec76cf92a8c30770e1199bdadacbccabf2df1a904dc1c546a122ac0ebe1acd6</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GeodesicLine</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>a5669be85b4a574258f4a136f12d3f1bb</anchor>
      <arglist>(const Geodesic &amp;g, real lat1, real lon1, real azi1, unsigned caps=ALL)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GeodesicLine</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>ae5ad84103d70f252c66bf61afbda3fa0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Position</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>ac9843cbfff45e8163b78e184a3126d82</anchor>
      <arglist>(real s12, real &amp;lat2, real &amp;lon2, real &amp;azi2, real &amp;m12, real &amp;M12, real &amp;M21, real &amp;S12) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Position</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>a50feb9c64d66b6518c640584d25e9507</anchor>
      <arglist>(real s12, real &amp;lat2, real &amp;lon2) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Position</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>ac736a0cc3300e443d42bbd2dc901962c</anchor>
      <arglist>(real s12, real &amp;lat2, real &amp;lon2, real &amp;azi2) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Position</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>a10b743a14701f620c0f41f1c6e1cee76</anchor>
      <arglist>(real s12, real &amp;lat2, real &amp;lon2, real &amp;azi2, real &amp;m12) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Position</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>ada48245beb736fe9ff3d8c491e9a691f</anchor>
      <arglist>(real s12, real &amp;lat2, real &amp;lon2, real &amp;azi2, real &amp;M12, real &amp;M21) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Position</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>aa42e5028aa78ef3ce8fbcb01b25eb458</anchor>
      <arglist>(real s12, real &amp;lat2, real &amp;lon2, real &amp;azi2, real &amp;m12, real &amp;M12, real &amp;M21) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ArcPosition</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>a9270eecb58eaac3115a5f08879990482</anchor>
      <arglist>(real a12, real &amp;lat2, real &amp;lon2, real &amp;azi2, real &amp;s12, real &amp;m12, real &amp;M12, real &amp;M21, real &amp;S12) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ArcPosition</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>afa377ee7344df5759cb7ea1022ff8288</anchor>
      <arglist>(real a12, real &amp;lat2, real &amp;lon2) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ArcPosition</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>a2d147b25bcef6a7258fabc581a2d64a1</anchor>
      <arglist>(real a12, real &amp;lat2, real &amp;lon2, real &amp;azi2) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ArcPosition</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>afdedfa0bc105dbe5de4c292115c7b7ae</anchor>
      <arglist>(real a12, real &amp;lat2, real &amp;lon2, real &amp;azi2, real &amp;s12) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ArcPosition</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>ad6b2013f9dcde3f4bf867632f6a2d1ff</anchor>
      <arglist>(real a12, real &amp;lat2, real &amp;lon2, real &amp;azi2, real &amp;s12, real &amp;m12) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ArcPosition</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>a2e0249a548d2dd9c882cb4a8de17d8eb</anchor>
      <arglist>(real a12, real &amp;lat2, real &amp;lon2, real &amp;azi2, real &amp;s12, real &amp;M12, real &amp;M21) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ArcPosition</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>af286d2071bdc59e68046dd2557115f21</anchor>
      <arglist>(real a12, real &amp;lat2, real &amp;lon2, real &amp;azi2, real &amp;s12, real &amp;m12, real &amp;M12, real &amp;M21) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>GenPosition</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>ad9522110fe6a5a0c7f912a6b1a23094d</anchor>
      <arglist>(bool arcmode, real s12_a12, unsigned outmask, real &amp;lat2, real &amp;lon2, real &amp;azi2, real &amp;s12, real &amp;m12, real &amp;M12, real &amp;M21, real &amp;S12) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>Init</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>af7e248d7632f56cf7abc6eac4927a587</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Latitude</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>a00a291e94d0c688a168a58623a360659</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Longitude</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>ac567ccf20c683319370f4c747f23966a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Azimuth</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>a40707b9e989c95418b2559b271cc2699</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>EquatorialAzimuth</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>ad117912c4fc4ef29bf4050c9be3267f2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>EquatorialArc</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>a308c7fb4f7c562a8c604453bf2ee2ca2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MajorRadius</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>af8953029b9985a3929fe406f7530143b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Flattening</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>a42e1f97e3ed564f98b305450b0d04590</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned</type>
      <name>Capabilities</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>a21d07549d1171ad05c7318533c4c8970</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>Capabilities</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>a4e12366c2ce02e7a96ee778eedb55bf9</anchor>
      <arglist>(unsigned testcaps) const </arglist>
    </member>
    <member kind="friend" protection="private">
      <type>friend class</type>
      <name>Geodesic</name>
      <anchorfile>classGeographicLib_1_1GeodesicLine.html</anchorfile>
      <anchor>a088c26ef9558197029bbeb317f3104c0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::Geoid</name>
    <filename>classGeographicLib_1_1Geoid.html</filename>
    <member kind="enumeration">
      <name>convertflag</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>a58ddbd0fd48c25b361f45bdb70dadb96</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ELLIPSOIDTOGEOID</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>a58ddbd0fd48c25b361f45bdb70dadb96a4a1db06e9dcfa1ebb345c616151ab70d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NONE</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>a58ddbd0fd48c25b361f45bdb70dadb96a677322ba74ea5494e67478c3dc1780d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GEOIDTOELLIPSOID</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>a58ddbd0fd48c25b361f45bdb70dadb96a96385bcbc41f3d933588f6d6a9868473</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Geoid</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>ac3556c755dad0d43c3be0913df08b395</anchor>
      <arglist>(const std::string &amp;name, const std::string &amp;path=&quot;&quot;, bool cubic=true, bool threadsafe=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>CacheArea</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>a52b5dc2d976796046aaeb8765e4a9c0f</anchor>
      <arglist>(real south, real west, real north, real east) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>CacheAll</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>a482c6482d5ab4c5d661210327848170e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>CacheClear</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>ad948f48545c9c40f1705f2892887cdab</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>operator()</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>accb63bfbbadae10af79b3a3028a3045a</anchor>
      <arglist>(real lat, real lon) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>operator()</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>a3bb5740c3a38a77caeb5eabd54c77cbc</anchor>
      <arglist>(real lat, real lon, real &amp;gradn, real &amp;grade) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>ConvertHeight</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>adf98d0f0d881893a4f5ff711a3be0e04</anchor>
      <arglist>(real lat, real lon, real h, convertflag d) const </arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>Description</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>a37d76bcfe0ddf9b84042d701c312e941</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>DateTime</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>a9cd7304b5df37001f4ad3c91cdbc56f4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>GeoidFile</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>a07e5f704f2684ce5acf824b7e0b17d30</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>GeoidName</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>aa244668a189e35ce5ff248fb8fa2e57b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>GeoidDirectory</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>a83b17b17045c49984bcdd032e637155e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::string</type>
      <name>Interpolation</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>a0ddfefaef196023486fc7642af45cf96</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MaxError</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>aff538da14578a02c551b411a899e567a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>RMSError</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>a207f98316d20a5b9d47846e559c5e2a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Offset</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>ac798950a643e4286aa8d3bb8cd9b0815</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Scale</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>ab2346300c12ff7e70d35e08479ecede1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>ThreadSafe</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>a286e947c13592f21e45cbdd404b283c7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>Cache</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>ade5715c0d1428a409383b1acd2cbe9be</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>CacheWest</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>aa0d2e119f089ee4182987ddd3faaf62a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>CacheEast</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>acb34cfbcfb8be2794b16a3d18209dbbe</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>CacheNorth</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>a26742332938bb8f22be23c979ffb02a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>CacheSouth</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>aa3db8f9639eb231539376e4617a3d59e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MajorRadius</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>aada99465d9ddfc1b34ccf2ef3d86dbd7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Flattening</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>abd2076cab3455b816e9477cdb410b187</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static std::string</type>
      <name>DefaultGeoidPath</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>a2daf81f5c648cf190a83981f441ab08f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static std::string</type>
      <name>DefaultGeoidName</name>
      <anchorfile>classGeographicLib_1_1Geoid.html</anchorfile>
      <anchor>a048865342b2b12ed2272e547209381fd</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::Gnomonic</name>
    <filename>classGeographicLib_1_1Gnomonic.html</filename>
    <member kind="function">
      <type></type>
      <name>Gnomonic</name>
      <anchorfile>classGeographicLib_1_1Gnomonic.html</anchorfile>
      <anchor>a2ac973ebbd7aaf18c451b152cd92db99</anchor>
      <arglist>(const Geodesic &amp;earth=Geodesic::WGS84)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Forward</name>
      <anchorfile>classGeographicLib_1_1Gnomonic.html</anchorfile>
      <anchor>ab851ea19db5671f8d4a4151820bc6853</anchor>
      <arglist>(real lat0, real lon0, real lat, real lon, real &amp;x, real &amp;y, real &amp;azi, real &amp;rk) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Reverse</name>
      <anchorfile>classGeographicLib_1_1Gnomonic.html</anchorfile>
      <anchor>afccbed660a482ef73d33ad16406ee626</anchor>
      <arglist>(real lat0, real lon0, real x, real y, real &amp;lat, real &amp;lon, real &amp;azi, real &amp;rk) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Forward</name>
      <anchorfile>classGeographicLib_1_1Gnomonic.html</anchorfile>
      <anchor>a2c08cf2bad190ee9ab88f7d877223208</anchor>
      <arglist>(real lat0, real lon0, real lat, real lon, real &amp;x, real &amp;y) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Reverse</name>
      <anchorfile>classGeographicLib_1_1Gnomonic.html</anchorfile>
      <anchor>a8700d59a1e244f8dd211e344587dfed3</anchor>
      <arglist>(real lat0, real lon0, real x, real y, real &amp;lat, real &amp;lon) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MajorRadius</name>
      <anchorfile>classGeographicLib_1_1Gnomonic.html</anchorfile>
      <anchor>a8598fe6d8c3896fa3fd58d24023f78ee</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Flattening</name>
      <anchorfile>classGeographicLib_1_1Gnomonic.html</anchorfile>
      <anchor>a06b559fa72aa1e51da966c43d22b983d</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::GravityCircle</name>
    <filename>classGeographicLib_1_1GravityCircle.html</filename>
    <member kind="function">
      <type></type>
      <name>GravityCircle</name>
      <anchorfile>classGeographicLib_1_1GravityCircle.html</anchorfile>
      <anchor>a4a000e07f0856a130ab11f1b26c933ed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Gravity</name>
      <anchorfile>classGeographicLib_1_1GravityCircle.html</anchorfile>
      <anchor>a5d8053ee66ae22217ae0b61e96194b64</anchor>
      <arglist>(real lon, real &amp;gx, real &amp;gy, real &amp;gz) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Disturbance</name>
      <anchorfile>classGeographicLib_1_1GravityCircle.html</anchorfile>
      <anchor>a2c3bde01c9d822b0cdd935314193a466</anchor>
      <arglist>(real lon, real &amp;deltax, real &amp;deltay, real &amp;deltaz) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>GeoidHeight</name>
      <anchorfile>classGeographicLib_1_1GravityCircle.html</anchorfile>
      <anchor>a5d5a577c99cf4649d9286f1b4afacab5</anchor>
      <arglist>(real lon) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SphericalAnomaly</name>
      <anchorfile>classGeographicLib_1_1GravityCircle.html</anchorfile>
      <anchor>ac94672db5e450f4394e6df69eda99e69</anchor>
      <arglist>(real lon, real &amp;Dg01, real &amp;xi, real &amp;eta) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>W</name>
      <anchorfile>classGeographicLib_1_1GravityCircle.html</anchorfile>
      <anchor>a04ae0659ec2eb766ae360d3bcbe332c4</anchor>
      <arglist>(real lon, real &amp;gX, real &amp;gY, real &amp;gZ) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>V</name>
      <anchorfile>classGeographicLib_1_1GravityCircle.html</anchorfile>
      <anchor>aba5f3ec3cb7b620e13dafa6fa4e48ae0</anchor>
      <arglist>(real lon, real &amp;GX, real &amp;GY, real &amp;GZ) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>T</name>
      <anchorfile>classGeographicLib_1_1GravityCircle.html</anchorfile>
      <anchor>afae12e4bbf17809f1dd6c32b41dfde03</anchor>
      <arglist>(real lon, real &amp;deltaX, real &amp;deltaY, real &amp;deltaZ) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>T</name>
      <anchorfile>classGeographicLib_1_1GravityCircle.html</anchorfile>
      <anchor>a408d52806d43fe61b53af3ffb306bec5</anchor>
      <arglist>(real lon) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>Init</name>
      <anchorfile>classGeographicLib_1_1GravityCircle.html</anchorfile>
      <anchor>aee7b6c92dc9264345048a8ad7c230e4c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MajorRadius</name>
      <anchorfile>classGeographicLib_1_1GravityCircle.html</anchorfile>
      <anchor>a19c5d003a9981cb3ece5b44ee836553a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Flattening</name>
      <anchorfile>classGeographicLib_1_1GravityCircle.html</anchorfile>
      <anchor>ad9bfc60d802b662ffc1a41566882b743</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Latitude</name>
      <anchorfile>classGeographicLib_1_1GravityCircle.html</anchorfile>
      <anchor>a9628e97c53a2532959c5c8af75e1c14b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Height</name>
      <anchorfile>classGeographicLib_1_1GravityCircle.html</anchorfile>
      <anchor>a026b2b79ff3ae70b4fee5d9c4d1ffb70</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned</type>
      <name>Capabilities</name>
      <anchorfile>classGeographicLib_1_1GravityCircle.html</anchorfile>
      <anchor>a08ecc2b31ca7d0ddc2d25950a6bc247f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>Capabilities</name>
      <anchorfile>classGeographicLib_1_1GravityCircle.html</anchorfile>
      <anchor>a2fa608c25be9b8caa087102c4c311768</anchor>
      <arglist>(unsigned testcaps) const </arglist>
    </member>
    <member kind="friend" protection="private">
      <type>friend class</type>
      <name>GravityModel</name>
      <anchorfile>classGeographicLib_1_1GravityCircle.html</anchorfile>
      <anchor>ada1db1d9f480d8044753ed869c995519</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::GravityModel</name>
    <filename>classGeographicLib_1_1GravityModel.html</filename>
    <member kind="enumeration">
      <name>mask</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>af8691d0f13d6d42278cd1e615903d365</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NONE</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>af8691d0f13d6d42278cd1e615903d365add4ee1aa94e38a8283826704105dc2e1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GRAVITY</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>af8691d0f13d6d42278cd1e615903d365ae6a4573c13b932c98ab95e7f9dbd0952</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DISTURBANCE</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>af8691d0f13d6d42278cd1e615903d365a83daf366a2c7ab93495f0e6b4144d885</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DISTURBING_POTENTIAL</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>af8691d0f13d6d42278cd1e615903d365abe1f6d891a721a4f544cd8a341abcb28</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPHERICAL_ANOMALY</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>af8691d0f13d6d42278cd1e615903d365ada02eebe918ebb3764a62b9323dceac9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GEOID_HEIGHT</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>af8691d0f13d6d42278cd1e615903d365a0ac768bffe3f104069c3fd5af1ddaa69</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ALL</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>af8691d0f13d6d42278cd1e615903d365a8e0e6b9a6d629d05f22f41996fe98068</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GravityModel</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>ac351170c1104f41754d5c0b8371d3e15</anchor>
      <arglist>(const std::string &amp;name, const std::string &amp;path=&quot;&quot;)</arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Gravity</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>a2dc8bf4cfa3c1914f4c7e93a5a3b3eac</anchor>
      <arglist>(real lat, real lon, real h, real &amp;gx, real &amp;gy, real &amp;gz) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Disturbance</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>a75cf57146334d9ce0856222a6814ae6f</anchor>
      <arglist>(real lat, real lon, real h, real &amp;deltax, real &amp;deltay, real &amp;deltaz) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>GeoidHeight</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>a7e75bdba6b9c8e64cc64403335a6fba4</anchor>
      <arglist>(real lat, real lon) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SphericalAnomaly</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>aaf89eb4a9b7266f0aa2ef2c341fc264e</anchor>
      <arglist>(real lat, real lon, real h, real &amp;Dg01, real &amp;xi, real &amp;eta) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>W</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>ab6767f3833caa34095a7ef83c43a46f0</anchor>
      <arglist>(real X, real Y, real Z, real &amp;gX, real &amp;gY, real &amp;gZ) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>V</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>a7aec9ecfa959b257dd0a965331598368</anchor>
      <arglist>(real X, real Y, real Z, real &amp;GX, real &amp;GY, real &amp;GZ) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>T</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>a257022f1f125d88b0a6efdccfc5e7a41</anchor>
      <arglist>(real X, real Y, real Z, real &amp;deltaX, real &amp;deltaY, real &amp;deltaZ) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>T</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>a690657dedac8ccea22052eda2829fea3</anchor>
      <arglist>(real X, real Y, real Z) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>U</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>af368d4f9015e076e5cc57ad87b8a185f</anchor>
      <arglist>(real X, real Y, real Z, real &amp;gammaX, real &amp;gammaY, real &amp;gammaZ) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Phi</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>a80477ccafa1049964ee0cef40ae2eea6</anchor>
      <arglist>(real X, real Y, real &amp;fX, real &amp;fY) const </arglist>
    </member>
    <member kind="function">
      <type>GravityCircle</type>
      <name>Circle</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>aadafafc09b9b707d47606da1e413d54f</anchor>
      <arglist>(real lat, real h, unsigned caps=ALL) const </arglist>
    </member>
    <member kind="function">
      <type>const NormalGravity &amp;</type>
      <name>ReferenceEllipsoid</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>a0467e44598b65fb403109ba0d0fbf182</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>Description</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>af2c1c74254e3193adb155987f6dd0a59</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>DateTime</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>acbed448c2423cd45e800d03fab059500</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>GravityFile</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>a26a87d363713ba3d1aa1b16da2fc2f27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>GravityModelName</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>a9ca1191e449bf7c04595ebd8a299af78</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>GravityModelDirectory</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>a17f2da4cd5abbb5f38f1b90d75975898</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MajorRadius</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>a07f361e231e1725a4f8e3c37a06cf304</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MassConstant</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>aa63d1c6e71abfa9455df695f4a3e6bdd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>ReferenceMassConstant</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>a4e6b9d48f26544a45c5509a87eb334e7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>AngularVelocity</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>aeb3d751ba7719e57e0266b65ee7d63d8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Flattening</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>aa2316f6d328435417627d49046c45308</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static std::string</type>
      <name>DefaultGravityPath</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>a0fdf62e41828ae7ae183d9e876f37954</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static std::string</type>
      <name>DefaultGravityName</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>ad4a776d68b60e85275c0e580d3c7caba</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="friend" protection="private">
      <type>friend class</type>
      <name>GravityCircle</name>
      <anchorfile>classGeographicLib_1_1GravityModel.html</anchorfile>
      <anchor>a243c90a7f9bf3f7aa96877a4b0667a89</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::LambertConformalConic</name>
    <filename>classGeographicLib_1_1LambertConformalConic.html</filename>
    <member kind="function">
      <type></type>
      <name>LambertConformalConic</name>
      <anchorfile>classGeographicLib_1_1LambertConformalConic.html</anchorfile>
      <anchor>a21dc9fa160a5b96a1c11ab30af0eb129</anchor>
      <arglist>(real a, real f, real stdlat, real k0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LambertConformalConic</name>
      <anchorfile>classGeographicLib_1_1LambertConformalConic.html</anchorfile>
      <anchor>a6273d61ce32ad6016471a7bd0e155ca4</anchor>
      <arglist>(real a, real f, real stdlat1, real stdlat2, real k1)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LambertConformalConic</name>
      <anchorfile>classGeographicLib_1_1LambertConformalConic.html</anchorfile>
      <anchor>a4d772372388f32029359b156dc43e4cd</anchor>
      <arglist>(real a, real f, real sinlat1, real coslat1, real sinlat2, real coslat2, real k1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SetScale</name>
      <anchorfile>classGeographicLib_1_1LambertConformalConic.html</anchorfile>
      <anchor>aac6267f7f970b35043b17e12e4163ff2</anchor>
      <arglist>(real lat, real k=real(1))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Forward</name>
      <anchorfile>classGeographicLib_1_1LambertConformalConic.html</anchorfile>
      <anchor>a2bafb6c1a81d4b6cf04f172b9e96278c</anchor>
      <arglist>(real lon0, real lat, real lon, real &amp;x, real &amp;y, real &amp;gamma, real &amp;k) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Reverse</name>
      <anchorfile>classGeographicLib_1_1LambertConformalConic.html</anchorfile>
      <anchor>a085d37693f5e95fd650b7f59f61ab744</anchor>
      <arglist>(real lon0, real x, real y, real &amp;lat, real &amp;lon, real &amp;gamma, real &amp;k) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Forward</name>
      <anchorfile>classGeographicLib_1_1LambertConformalConic.html</anchorfile>
      <anchor>a14a3757d85e81488afe476f7ceb8a720</anchor>
      <arglist>(real lon0, real lat, real lon, real &amp;x, real &amp;y) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Reverse</name>
      <anchorfile>classGeographicLib_1_1LambertConformalConic.html</anchorfile>
      <anchor>a1bffe1259895569e6834a4b1df9b22ab</anchor>
      <arglist>(real lon0, real x, real y, real &amp;lat, real &amp;lon) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MajorRadius</name>
      <anchorfile>classGeographicLib_1_1LambertConformalConic.html</anchorfile>
      <anchor>a21f9bc21f3f40c56d2f5d12fb4b7f75a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Flattening</name>
      <anchorfile>classGeographicLib_1_1LambertConformalConic.html</anchorfile>
      <anchor>abd47e48c75ed958f5aa91bcaa80ddc8c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>OriginLatitude</name>
      <anchorfile>classGeographicLib_1_1LambertConformalConic.html</anchorfile>
      <anchor>a7c589335b43b2274d3a68c0f68f29d77</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>CentralScale</name>
      <anchorfile>classGeographicLib_1_1LambertConformalConic.html</anchorfile>
      <anchor>a2298a4e48e550cfd7346cf5f2dd175ad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const LambertConformalConic</type>
      <name>Mercator</name>
      <anchorfile>classGeographicLib_1_1LambertConformalConic.html</anchorfile>
      <anchor>a7fbb6973b77593245db52c9759740f9a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::LocalCartesian</name>
    <filename>classGeographicLib_1_1LocalCartesian.html</filename>
    <member kind="function">
      <type></type>
      <name>LocalCartesian</name>
      <anchorfile>classGeographicLib_1_1LocalCartesian.html</anchorfile>
      <anchor>ad277a6798293d5d66168c3c1438d10a2</anchor>
      <arglist>(real lat0, real lon0, real h0=0, const Geocentric &amp;earth=Geocentric::WGS84)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LocalCartesian</name>
      <anchorfile>classGeographicLib_1_1LocalCartesian.html</anchorfile>
      <anchor>a3474a0434b2ff8b258111fe6d8468f0d</anchor>
      <arglist>(const Geocentric &amp;earth=Geocentric::WGS84)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Reset</name>
      <anchorfile>classGeographicLib_1_1LocalCartesian.html</anchorfile>
      <anchor>a85b9c15b843cf6a84be08e0cc4de9122</anchor>
      <arglist>(real lat0, real lon0, real h0=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Forward</name>
      <anchorfile>classGeographicLib_1_1LocalCartesian.html</anchorfile>
      <anchor>a6426e95f904f224eabedb8fcd17fe537</anchor>
      <arglist>(real lat, real lon, real h, real &amp;x, real &amp;y, real &amp;z) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Forward</name>
      <anchorfile>classGeographicLib_1_1LocalCartesian.html</anchorfile>
      <anchor>a774332be14e894536f13b3cc7a8323c7</anchor>
      <arglist>(real lat, real lon, real h, real &amp;x, real &amp;y, real &amp;z, std::vector&lt; real &gt; &amp;M) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Reverse</name>
      <anchorfile>classGeographicLib_1_1LocalCartesian.html</anchorfile>
      <anchor>ac34878de3ae995e7d54f0347a1f34118</anchor>
      <arglist>(real x, real y, real z, real &amp;lat, real &amp;lon, real &amp;h) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Reverse</name>
      <anchorfile>classGeographicLib_1_1LocalCartesian.html</anchorfile>
      <anchor>a7baa88b38b320d763f6cba3ece4f518d</anchor>
      <arglist>(real x, real y, real z, real &amp;lat, real &amp;lon, real &amp;h, std::vector&lt; real &gt; &amp;M) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>LatitudeOrigin</name>
      <anchorfile>classGeographicLib_1_1LocalCartesian.html</anchorfile>
      <anchor>af4905164de5157c7ae2678f7716cbad7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>LongitudeOrigin</name>
      <anchorfile>classGeographicLib_1_1LocalCartesian.html</anchorfile>
      <anchor>a45656227b4fff45249f1844bc6d233ad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>HeightOrigin</name>
      <anchorfile>classGeographicLib_1_1LocalCartesian.html</anchorfile>
      <anchor>ac8e00f262d70da122f45afa15b9381e2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MajorRadius</name>
      <anchorfile>classGeographicLib_1_1LocalCartesian.html</anchorfile>
      <anchor>a795356c736f1170fe5ef075ebbf34354</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Flattening</name>
      <anchorfile>classGeographicLib_1_1LocalCartesian.html</anchorfile>
      <anchor>a99907eda4b863acbe8e7d159a6482abb</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::MagneticCircle</name>
    <filename>classGeographicLib_1_1MagneticCircle.html</filename>
    <member kind="function">
      <type></type>
      <name>MagneticCircle</name>
      <anchorfile>classGeographicLib_1_1MagneticCircle.html</anchorfile>
      <anchor>a49170460b1833722ad9bc45b92c86e5a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>operator()</name>
      <anchorfile>classGeographicLib_1_1MagneticCircle.html</anchorfile>
      <anchor>a8669d47d20b03e9185d358440d3da9b1</anchor>
      <arglist>(real lon, real &amp;Bx, real &amp;By, real &amp;Bz) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>operator()</name>
      <anchorfile>classGeographicLib_1_1MagneticCircle.html</anchorfile>
      <anchor>ac715ae0394bd7f8c23288f80c406e5bc</anchor>
      <arglist>(real lon, real &amp;Bx, real &amp;By, real &amp;Bz, real &amp;Bxt, real &amp;Byt, real &amp;Bzt) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>Init</name>
      <anchorfile>classGeographicLib_1_1MagneticCircle.html</anchorfile>
      <anchor>a8ec84cd0b1d97b51464ec80d9e2dcf57</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MajorRadius</name>
      <anchorfile>classGeographicLib_1_1MagneticCircle.html</anchorfile>
      <anchor>a78721d381d21f676152394dd576f2e77</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Flattening</name>
      <anchorfile>classGeographicLib_1_1MagneticCircle.html</anchorfile>
      <anchor>a4c3fc40a49332ddcd042e5cb41c3cb2a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Latitude</name>
      <anchorfile>classGeographicLib_1_1MagneticCircle.html</anchorfile>
      <anchor>aaf14e89275bffd8253acdbe4840b65d0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Height</name>
      <anchorfile>classGeographicLib_1_1MagneticCircle.html</anchorfile>
      <anchor>aadd95eac0650f195e4d7acdc9819716b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Time</name>
      <anchorfile>classGeographicLib_1_1MagneticCircle.html</anchorfile>
      <anchor>a44783c9e44f16bbd48cc5061b30ce8e9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="friend" protection="private">
      <type>friend class</type>
      <name>MagneticModel</name>
      <anchorfile>classGeographicLib_1_1MagneticCircle.html</anchorfile>
      <anchor>af6619ebe4c078705fc49a0d9f950b431</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::MagneticModel</name>
    <filename>classGeographicLib_1_1MagneticModel.html</filename>
    <member kind="function">
      <type></type>
      <name>MagneticModel</name>
      <anchorfile>classGeographicLib_1_1MagneticModel.html</anchorfile>
      <anchor>a84a020586d58c4da61ec6ffbc7b4fa37</anchor>
      <arglist>(const std::string &amp;name, const std::string &amp;path=&quot;&quot;, const Geocentric &amp;earth=Geocentric::WGS84)</arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>Description</name>
      <anchorfile>classGeographicLib_1_1MagneticModel.html</anchorfile>
      <anchor>a204e8d3c4ebf6f8c13eb9e1817921ea2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>DateTime</name>
      <anchorfile>classGeographicLib_1_1MagneticModel.html</anchorfile>
      <anchor>a230648296f87ff6fc12a3e65ff01bc3b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>MagneticFile</name>
      <anchorfile>classGeographicLib_1_1MagneticModel.html</anchorfile>
      <anchor>aa072d202531c0cacdd7bca128d670705</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>MagneticModelName</name>
      <anchorfile>classGeographicLib_1_1MagneticModel.html</anchorfile>
      <anchor>ad500f0d76997b4026b75805fad71dbee</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>MagneticModelDirectory</name>
      <anchorfile>classGeographicLib_1_1MagneticModel.html</anchorfile>
      <anchor>a2476aee96f07071de17c24dbbf80f521</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MinHeight</name>
      <anchorfile>classGeographicLib_1_1MagneticModel.html</anchorfile>
      <anchor>a8a170290542bf8e694cda4b4d329c881</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MaxHeight</name>
      <anchorfile>classGeographicLib_1_1MagneticModel.html</anchorfile>
      <anchor>a41e16617bc2cdd89ab7b7a02b4bd4dcf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MinTime</name>
      <anchorfile>classGeographicLib_1_1MagneticModel.html</anchorfile>
      <anchor>a1e8624990112edc3c6503c9c9acb9309</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MaxTime</name>
      <anchorfile>classGeographicLib_1_1MagneticModel.html</anchorfile>
      <anchor>a5d538204401200c87b37cdc37509311a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MajorRadius</name>
      <anchorfile>classGeographicLib_1_1MagneticModel.html</anchorfile>
      <anchor>a0b55df676607204a2d44687ffafe8d9e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Flattening</name>
      <anchorfile>classGeographicLib_1_1MagneticModel.html</anchorfile>
      <anchor>a38ad95b421f5fbce40abff5733421370</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static std::string</type>
      <name>DefaultMagneticPath</name>
      <anchorfile>classGeographicLib_1_1MagneticModel.html</anchorfile>
      <anchor>a469db97d257876c1abafa3da3c5f0f7e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static std::string</type>
      <name>DefaultMagneticName</name>
      <anchorfile>classGeographicLib_1_1MagneticModel.html</anchorfile>
      <anchor>ab2ac8cc598c0d9a6b448c9a45e9642d9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>operator()</name>
      <anchorfile>classGeographicLib_1_1MagneticModel.html</anchorfile>
      <anchor>a550eb1739712fbbae1a167c2559d6dbc</anchor>
      <arglist>(real t, real lat, real lon, real h, real &amp;Bx, real &amp;By, real &amp;Bz) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>operator()</name>
      <anchorfile>classGeographicLib_1_1MagneticModel.html</anchorfile>
      <anchor>a11fed1ca7a45947f6f43f6ba7897250f</anchor>
      <arglist>(real t, real lat, real lon, real h, real &amp;Bx, real &amp;By, real &amp;Bz, real &amp;Bxt, real &amp;Byt, real &amp;Bzt) const </arglist>
    </member>
    <member kind="function">
      <type>MagneticCircle</type>
      <name>Circle</name>
      <anchorfile>classGeographicLib_1_1MagneticModel.html</anchorfile>
      <anchor>ae4275d73128fc2c6c62f53677ce70bd5</anchor>
      <arglist>(real t, real lat, real h) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>FieldComponents</name>
      <anchorfile>classGeographicLib_1_1MagneticModel.html</anchorfile>
      <anchor>af553c42337b9a9a1d51b81fea7083ea2</anchor>
      <arglist>(real Bx, real By, real Bz, real &amp;H, real &amp;F, real &amp;D, real &amp;I)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>FieldComponents</name>
      <anchorfile>classGeographicLib_1_1MagneticModel.html</anchorfile>
      <anchor>a54aa849393ab2a7e37aa1f086e64cffb</anchor>
      <arglist>(real Bx, real By, real Bz, real Bxt, real Byt, real Bzt, real &amp;H, real &amp;F, real &amp;D, real &amp;I, real &amp;Ht, real &amp;Ft, real &amp;Dt, real &amp;It)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::Math</name>
    <filename>classGeographicLib_1_1Math.html</filename>
    <member kind="typedef">
      <type>double</type>
      <name>extended</name>
      <anchorfile>classGeographicLib_1_1Math.html</anchorfile>
      <anchor>a436f350a6a9539e176dda19d0e4811f8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>double</type>
      <name>real</name>
      <anchorfile>classGeographicLib_1_1Math.html</anchorfile>
      <anchor>aeee4778d7cf2f9fb9648efe4911da59d</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>pi</name>
      <anchorfile>classGeographicLib_1_1Math.html</anchorfile>
      <anchor>aca1580c771e7019bfe826512fba9b2f1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static real</type>
      <name>pi</name>
      <anchorfile>classGeographicLib_1_1Math.html</anchorfile>
      <anchor>abb031de2a30d6fbac4c634b344e46df4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>degree</name>
      <anchorfile>classGeographicLib_1_1Math.html</anchorfile>
      <anchor>a0f3b4ea16cc2cb21557555fca3b1c201</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static real</type>
      <name>degree</name>
      <anchorfile>classGeographicLib_1_1Math.html</anchorfile>
      <anchor>a5bb8bea024e11eb402ecbcf9bae28bb5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>sq</name>
      <anchorfile>classGeographicLib_1_1Math.html</anchorfile>
      <anchor>a6a092f38e231c80a1f144814c90f1895</anchor>
      <arglist>(T x)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>hypot</name>
      <anchorfile>classGeographicLib_1_1Math.html</anchorfile>
      <anchor>a62b6fca06c571481aafba3f1716a8bb2</anchor>
      <arglist>(T x, T y)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>expm1</name>
      <anchorfile>classGeographicLib_1_1Math.html</anchorfile>
      <anchor>a2fd4e8930d9dd953352d25fc184d843e</anchor>
      <arglist>(T x)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>log1p</name>
      <anchorfile>classGeographicLib_1_1Math.html</anchorfile>
      <anchor>a90eddd5a6d0c9dcc4a9f18dd647ac520</anchor>
      <arglist>(T x)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>asinh</name>
      <anchorfile>classGeographicLib_1_1Math.html</anchorfile>
      <anchor>aba75669f9d52fc672a8faaf69261bd8a</anchor>
      <arglist>(T x)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>atanh</name>
      <anchorfile>classGeographicLib_1_1Math.html</anchorfile>
      <anchor>a372ac604592d9de9cf608cfdfc463447</anchor>
      <arglist>(T x)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>cbrt</name>
      <anchorfile>classGeographicLib_1_1Math.html</anchorfile>
      <anchor>a04b87b033b845f4812a5700661c64a2a</anchor>
      <arglist>(T x)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>isfinite</name>
      <anchorfile>classGeographicLib_1_1Math.html</anchorfile>
      <anchor>af61f7360e67c35131d80083e7b53dda8</anchor>
      <arglist>(T x)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>NaN</name>
      <anchorfile>classGeographicLib_1_1Math.html</anchorfile>
      <anchor>ad1dc13a367125d3f8d291eaa98339186</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static real</type>
      <name>NaN</name>
      <anchorfile>classGeographicLib_1_1Math.html</anchorfile>
      <anchor>a28304be9b5cb17eeb7413b059604a154</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>isnan</name>
      <anchorfile>classGeographicLib_1_1Math.html</anchorfile>
      <anchor>a554d35e9f54bf304447833a21ee2047c</anchor>
      <arglist>(T x)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>infinity</name>
      <anchorfile>classGeographicLib_1_1Math.html</anchorfile>
      <anchor>a82ccc01be301f14061c681ee93a5120b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static real</type>
      <name>infinity</name>
      <anchorfile>classGeographicLib_1_1Math.html</anchorfile>
      <anchor>a1606218c36b8d7c60a5ad5847a94ab9c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>swab</name>
      <anchorfile>classGeographicLib_1_1Math.html</anchorfile>
      <anchor>aec7f95c2bb99422f1f047cb628a232f8</anchor>
      <arglist>(T x)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const bool</type>
      <name>bigendian</name>
      <anchorfile>classGeographicLib_1_1Math.html</anchorfile>
      <anchor>ab14e512a1867b98ecb38e9175426596c</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::MGRS</name>
    <filename>classGeographicLib_1_1MGRS.html</filename>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>Forward</name>
      <anchorfile>classGeographicLib_1_1MGRS.html</anchorfile>
      <anchor>a91de10ebde478dbb85b3c7d057ff97b9</anchor>
      <arglist>(int zone, bool northp, real x, real y, int prec, std::string &amp;mgrs)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>Forward</name>
      <anchorfile>classGeographicLib_1_1MGRS.html</anchorfile>
      <anchor>a37f9dd9b12dbc74381116d842be47ccd</anchor>
      <arglist>(int zone, bool northp, real x, real y, real lat, int prec, std::string &amp;mgrs)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>Reverse</name>
      <anchorfile>classGeographicLib_1_1MGRS.html</anchorfile>
      <anchor>a066b79e78cd85bf4b50df50808bed7e3</anchor>
      <arglist>(const std::string &amp;mgrs, int &amp;zone, bool &amp;northp, real &amp;x, real &amp;y, int &amp;prec, bool centerp=true)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>MajorRadius</name>
      <anchorfile>classGeographicLib_1_1MGRS.html</anchorfile>
      <anchor>a8942a1dfafa3ea845ccc5fafb6ca4dc2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>Flattening</name>
      <anchorfile>classGeographicLib_1_1MGRS.html</anchorfile>
      <anchor>a8eee27799bda8238d6d0525dffdddd4e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="friend" protection="private">
      <type>friend class</type>
      <name>UTMUPS</name>
      <anchorfile>classGeographicLib_1_1MGRS.html</anchorfile>
      <anchor>a6a0cfac496024eaf645c7a2f98a02a75</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::NormalGravity</name>
    <filename>classGeographicLib_1_1NormalGravity.html</filename>
    <member kind="function">
      <type></type>
      <name>NormalGravity</name>
      <anchorfile>classGeographicLib_1_1NormalGravity.html</anchorfile>
      <anchor>af625bbc7df2d36ba5c43c8f20f61c134</anchor>
      <arglist>(real a, real GM, real omega, real f, real J2)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>NormalGravity</name>
      <anchorfile>classGeographicLib_1_1NormalGravity.html</anchorfile>
      <anchor>a55f749c3bb3e9d19626105041bf1b6fb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>SurfaceGravity</name>
      <anchorfile>classGeographicLib_1_1NormalGravity.html</anchorfile>
      <anchor>a019541fea3712f8ca73aec8a0b29c71c</anchor>
      <arglist>(real lat) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Gravity</name>
      <anchorfile>classGeographicLib_1_1NormalGravity.html</anchorfile>
      <anchor>acfca8d6e44778501b54cd0b38dbbddde</anchor>
      <arglist>(real lat, real h, real &amp;gammay, real &amp;gammaz) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>U</name>
      <anchorfile>classGeographicLib_1_1NormalGravity.html</anchorfile>
      <anchor>a258290ade5fd46c42fdc4199683cf563</anchor>
      <arglist>(real X, real Y, real Z, real &amp;gammaX, real &amp;gammaY, real &amp;gammaZ) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>V0</name>
      <anchorfile>classGeographicLib_1_1NormalGravity.html</anchorfile>
      <anchor>aa656e36306bc396ac6d32dcdfc2069a2</anchor>
      <arglist>(real X, real Y, real Z, real &amp;GammaX, real &amp;GammaY, real &amp;GammaZ) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Phi</name>
      <anchorfile>classGeographicLib_1_1NormalGravity.html</anchorfile>
      <anchor>af0f50fd88d8b647a1b7bb209a4cfae0f</anchor>
      <arglist>(real X, real Y, real &amp;fX, real &amp;fY) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>Init</name>
      <anchorfile>classGeographicLib_1_1NormalGravity.html</anchorfile>
      <anchor>a1d96cafc362959215eaa553a712b6908</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MajorRadius</name>
      <anchorfile>classGeographicLib_1_1NormalGravity.html</anchorfile>
      <anchor>a9155d22c5a64a7ef346ce7f590a6264f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MassConstant</name>
      <anchorfile>classGeographicLib_1_1NormalGravity.html</anchorfile>
      <anchor>a3c6693dc7efe04cdbed408b2510c69da</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>DynamicalFormFactor</name>
      <anchorfile>classGeographicLib_1_1NormalGravity.html</anchorfile>
      <anchor>aa52b03157eb0b199d331d6fca28a259a</anchor>
      <arglist>(int n=2) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>AngularVelocity</name>
      <anchorfile>classGeographicLib_1_1NormalGravity.html</anchorfile>
      <anchor>aefd6dfb7e6f806b63d099316dcc97f55</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Flattening</name>
      <anchorfile>classGeographicLib_1_1NormalGravity.html</anchorfile>
      <anchor>aba396954f43e623e755bdff7db7d850b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>EquatorialGravity</name>
      <anchorfile>classGeographicLib_1_1NormalGravity.html</anchorfile>
      <anchor>a3610ec908c7b168b39f00946e2fc3fad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>PolarGravity</name>
      <anchorfile>classGeographicLib_1_1NormalGravity.html</anchorfile>
      <anchor>a3079310d3a7af97ccb50b91be01d5a50</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>GravityFlattening</name>
      <anchorfile>classGeographicLib_1_1NormalGravity.html</anchorfile>
      <anchor>a7e9329f7b3120b7777a0c5be3ca424a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>SurfacePotential</name>
      <anchorfile>classGeographicLib_1_1NormalGravity.html</anchorfile>
      <anchor>a5bc3756dd7dbc82c07ef4afd1a182372</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const Geocentric &amp;</type>
      <name>Earth</name>
      <anchorfile>classGeographicLib_1_1NormalGravity.html</anchorfile>
      <anchor>ab15ded1ab7ec9a30e8053fc330ed76ac</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const NormalGravity</type>
      <name>WGS84</name>
      <anchorfile>classGeographicLib_1_1NormalGravity.html</anchorfile>
      <anchor>a70c328a95e05964180106d89c2583b78</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const NormalGravity</type>
      <name>GRS80</name>
      <anchorfile>classGeographicLib_1_1NormalGravity.html</anchorfile>
      <anchor>a78cf6878967ad52adadbe06b5f7c4146</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="private">
      <type>friend class</type>
      <name>GravityModel</name>
      <anchorfile>classGeographicLib_1_1NormalGravity.html</anchorfile>
      <anchor>ada1db1d9f480d8044753ed869c995519</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::OSGB</name>
    <filename>classGeographicLib_1_1OSGB.html</filename>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>Forward</name>
      <anchorfile>classGeographicLib_1_1OSGB.html</anchorfile>
      <anchor>a92618eea9870908e11446875d80aab6b</anchor>
      <arglist>(real lat, real lon, real &amp;x, real &amp;y, real &amp;gamma, real &amp;k)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>Reverse</name>
      <anchorfile>classGeographicLib_1_1OSGB.html</anchorfile>
      <anchor>ae006380e574858a81011752dd1d4af60</anchor>
      <arglist>(real x, real y, real &amp;lat, real &amp;lon, real &amp;gamma, real &amp;k)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>Forward</name>
      <anchorfile>classGeographicLib_1_1OSGB.html</anchorfile>
      <anchor>a0f705bee98c6669ca7a95394712fd758</anchor>
      <arglist>(real lat, real lon, real &amp;x, real &amp;y)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>Reverse</name>
      <anchorfile>classGeographicLib_1_1OSGB.html</anchorfile>
      <anchor>ab804929a4126ed390a40d35e837b4001</anchor>
      <arglist>(real x, real y, real &amp;lat, real &amp;lon)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>GridReference</name>
      <anchorfile>classGeographicLib_1_1OSGB.html</anchorfile>
      <anchor>a0a79e8f2babae1eb0305a0e728fea8c8</anchor>
      <arglist>(real x, real y, int prec, std::string &amp;gridref)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>GridReference</name>
      <anchorfile>classGeographicLib_1_1OSGB.html</anchorfile>
      <anchor>a3693cfef49442747750e8393c81014aa</anchor>
      <arglist>(const std::string &amp;gridref, real &amp;x, real &amp;y, int &amp;prec, bool centerp=true)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>MajorRadius</name>
      <anchorfile>classGeographicLib_1_1OSGB.html</anchorfile>
      <anchor>a9bb3b0ff55a462ac2ebcd0cfd446d811</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>Flattening</name>
      <anchorfile>classGeographicLib_1_1OSGB.html</anchorfile>
      <anchor>aae688ebd8c126f22517eaa0a01d659f8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>CentralScale</name>
      <anchorfile>classGeographicLib_1_1OSGB.html</anchorfile>
      <anchor>a65210bfdcac362f393a8f81f28259ad0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>OriginLatitude</name>
      <anchorfile>classGeographicLib_1_1OSGB.html</anchorfile>
      <anchor>ad6bcef7e2dcc2992831e101bf0b05fa8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>OriginLongitude</name>
      <anchorfile>classGeographicLib_1_1OSGB.html</anchorfile>
      <anchor>a4eb3b20734af47c9661d40581555c345</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>FalseNorthing</name>
      <anchorfile>classGeographicLib_1_1OSGB.html</anchorfile>
      <anchor>a74072d4e62fcd4ca679b222716b6a6a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>FalseEasting</name>
      <anchorfile>classGeographicLib_1_1OSGB.html</anchorfile>
      <anchor>ab27e19f7688f6b472d217b31aeae079c</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::PolarStereographic</name>
    <filename>classGeographicLib_1_1PolarStereographic.html</filename>
    <member kind="function">
      <type></type>
      <name>PolarStereographic</name>
      <anchorfile>classGeographicLib_1_1PolarStereographic.html</anchorfile>
      <anchor>a170d21f9c7a2e922c57fc83a44ea3dfa</anchor>
      <arglist>(real a, real f, real k0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SetScale</name>
      <anchorfile>classGeographicLib_1_1PolarStereographic.html</anchorfile>
      <anchor>a3f957214eb1d1248277a680e4c4ceed5</anchor>
      <arglist>(real lat, real k=real(1))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Forward</name>
      <anchorfile>classGeographicLib_1_1PolarStereographic.html</anchorfile>
      <anchor>a30ef1a1f906ee389e2a5f7e5fd7d8fa4</anchor>
      <arglist>(bool northp, real lat, real lon, real &amp;x, real &amp;y, real &amp;gamma, real &amp;k) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Reverse</name>
      <anchorfile>classGeographicLib_1_1PolarStereographic.html</anchorfile>
      <anchor>a01302b8dba43c57e3c3849f94123a157</anchor>
      <arglist>(bool northp, real x, real y, real &amp;lat, real &amp;lon, real &amp;gamma, real &amp;k) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Forward</name>
      <anchorfile>classGeographicLib_1_1PolarStereographic.html</anchorfile>
      <anchor>ac2fe4c9524ec35f8d05336555f96e1b1</anchor>
      <arglist>(bool northp, real lat, real lon, real &amp;x, real &amp;y) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Reverse</name>
      <anchorfile>classGeographicLib_1_1PolarStereographic.html</anchorfile>
      <anchor>a16572cc552eeb24ebf84319cdcd6652e</anchor>
      <arglist>(bool northp, real x, real y, real &amp;lat, real &amp;lon) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MajorRadius</name>
      <anchorfile>classGeographicLib_1_1PolarStereographic.html</anchorfile>
      <anchor>ab1746576356a2409f34d9527064adfdd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Flattening</name>
      <anchorfile>classGeographicLib_1_1PolarStereographic.html</anchorfile>
      <anchor>a3b08d03e475dae2c2a81c76420946942</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>CentralScale</name>
      <anchorfile>classGeographicLib_1_1PolarStereographic.html</anchorfile>
      <anchor>ad6f7bd8a35208d91706ac8c258387e6f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const PolarStereographic</type>
      <name>UPS</name>
      <anchorfile>classGeographicLib_1_1PolarStereographic.html</anchorfile>
      <anchor>a2db6bcb1b59a6ddc6087ee04c64c9825</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::PolygonArea</name>
    <filename>classGeographicLib_1_1PolygonArea.html</filename>
    <member kind="function">
      <type></type>
      <name>PolygonArea</name>
      <anchorfile>classGeographicLib_1_1PolygonArea.html</anchorfile>
      <anchor>a060a1dc499bd079c62f62ed5cad929e5</anchor>
      <arglist>(const Geodesic &amp;earth, bool polyline=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Clear</name>
      <anchorfile>classGeographicLib_1_1PolygonArea.html</anchorfile>
      <anchor>a66198bec67036ad09aa58ec43166fe60</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>AddPoint</name>
      <anchorfile>classGeographicLib_1_1PolygonArea.html</anchorfile>
      <anchor>acfec56f0e136a534192e1e71589299f1</anchor>
      <arglist>(real lat, real lon)</arglist>
    </member>
    <member kind="function">
      <type>unsigned</type>
      <name>Compute</name>
      <anchorfile>classGeographicLib_1_1PolygonArea.html</anchorfile>
      <anchor>a60e1c288358818c849356c9921191215</anchor>
      <arglist>(bool reverse, bool sign, real &amp;perimeter, real &amp;area) const </arglist>
    </member>
    <member kind="function">
      <type>unsigned</type>
      <name>TestCompute</name>
      <anchorfile>classGeographicLib_1_1PolygonArea.html</anchorfile>
      <anchor>ac46ac5567223b3db2ee11e6c4f72c257</anchor>
      <arglist>(real lat, real lon, bool reverse, bool sign, real &amp;perimeter, real &amp;area) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MajorRadius</name>
      <anchorfile>classGeographicLib_1_1PolygonArea.html</anchorfile>
      <anchor>afcdd74fcb4a0f57aa193e5fd08239369</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Flattening</name>
      <anchorfile>classGeographicLib_1_1PolygonArea.html</anchorfile>
      <anchor>aba3543baed0f014b64890d174b8c62a0</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::SphericalEngine</name>
    <filename>classGeographicLib_1_1SphericalEngine.html</filename>
    <class kind="class">GeographicLib::SphericalEngine::coeff</class>
    <member kind="enumeration">
      <name>normalization</name>
      <anchorfile>classGeographicLib_1_1SphericalEngine.html</anchorfile>
      <anchor>a5332d09191e018cbddc568c1fc71949f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FULL</name>
      <anchorfile>classGeographicLib_1_1SphericalEngine.html</anchorfile>
      <anchor>a5332d09191e018cbddc568c1fc71949fac720ca87adfc478dbfc13a37f0cf8ba9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SCHMIDT</name>
      <anchorfile>classGeographicLib_1_1SphericalEngine.html</anchorfile>
      <anchor>a5332d09191e018cbddc568c1fc71949fa2e3db3efd68d118e3f357a97eb77a131</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>Value</name>
      <anchorfile>classGeographicLib_1_1SphericalEngine.html</anchorfile>
      <anchor>a1157f59596dd15bf0a21b6a7fb99630b</anchor>
      <arglist>(const coeff c[], const real f[], real x, real y, real z, real a, real &amp;gradx, real &amp;grady, real &amp;gradz)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static CircularEngine</type>
      <name>Circle</name>
      <anchorfile>classGeographicLib_1_1SphericalEngine.html</anchorfile>
      <anchor>af6a5fa63535d47cf528b733bb6a97901</anchor>
      <arglist>(const coeff c[], const real f[], real p, real z, real a)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>RootTable</name>
      <anchorfile>classGeographicLib_1_1SphericalEngine.html</anchorfile>
      <anchor>a7fac63262c0a8bb18aee8c962a08d429</anchor>
      <arglist>(int N)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>ClearRootTable</name>
      <anchorfile>classGeographicLib_1_1SphericalEngine.html</anchorfile>
      <anchor>ab3fb8f933adb257df6b7537268d55a75</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="friend" protection="private">
      <type>friend class</type>
      <name>CircularEngine</name>
      <anchorfile>classGeographicLib_1_1SphericalEngine.html</anchorfile>
      <anchor>a0c689dbf7b6bf2fb4cffb109085b1d3b</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::SphericalEngine::coeff</name>
    <filename>classGeographicLib_1_1SphericalEngine_1_1coeff.html</filename>
    <member kind="function">
      <type></type>
      <name>coeff</name>
      <anchorfile>classGeographicLib_1_1SphericalEngine_1_1coeff.html</anchorfile>
      <anchor>a98ee0fd797434667a8cb5093d7644af4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>coeff</name>
      <anchorfile>classGeographicLib_1_1SphericalEngine_1_1coeff.html</anchorfile>
      <anchor>a45a4378903a4f3ee817c47b72d086183</anchor>
      <arglist>(const std::vector&lt; real &gt; &amp;C, const std::vector&lt; real &gt; &amp;S, int N, int nmx, int mmx)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>coeff</name>
      <anchorfile>classGeographicLib_1_1SphericalEngine_1_1coeff.html</anchorfile>
      <anchor>a2f453e210345b33a364bf5a3bee84b7b</anchor>
      <arglist>(const std::vector&lt; real &gt; &amp;C, const std::vector&lt; real &gt; &amp;S, int N)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>N</name>
      <anchorfile>classGeographicLib_1_1SphericalEngine_1_1coeff.html</anchorfile>
      <anchor>a38ab91101bb639963e094327a22fed59</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>nmx</name>
      <anchorfile>classGeographicLib_1_1SphericalEngine_1_1coeff.html</anchorfile>
      <anchor>a96467118f9c16c16259d4fbbed3917ff</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>mmx</name>
      <anchorfile>classGeographicLib_1_1SphericalEngine_1_1coeff.html</anchorfile>
      <anchor>a2a1ff83503433c64bd4399689a3e40f6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>index</name>
      <anchorfile>classGeographicLib_1_1SphericalEngine_1_1coeff.html</anchorfile>
      <anchor>a356d705a99ee15089d1faabd0c01084c</anchor>
      <arglist>(int n, int m) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Cv</name>
      <anchorfile>classGeographicLib_1_1SphericalEngine_1_1coeff.html</anchorfile>
      <anchor>ab591ddf74f5653c16b58ed2f5bde5ffe</anchor>
      <arglist>(int k) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Sv</name>
      <anchorfile>classGeographicLib_1_1SphericalEngine_1_1coeff.html</anchorfile>
      <anchor>ac93aaebb09086ab14330aafc0f105a17</anchor>
      <arglist>(int k) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Cv</name>
      <anchorfile>classGeographicLib_1_1SphericalEngine_1_1coeff.html</anchorfile>
      <anchor>ad30081b2dfdee79652aacbc24bacb635</anchor>
      <arglist>(int k, int n, int m, real f) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Sv</name>
      <anchorfile>classGeographicLib_1_1SphericalEngine_1_1coeff.html</anchorfile>
      <anchor>a4fc7e6c7faf3f5940ee8f3ab28216897</anchor>
      <arglist>(int k, int n, int m, real f) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static int</type>
      <name>Csize</name>
      <anchorfile>classGeographicLib_1_1SphericalEngine_1_1coeff.html</anchorfile>
      <anchor>a8a126c9790a7a1609046fbae7934e587</anchor>
      <arglist>(int N, int M)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static int</type>
      <name>Ssize</name>
      <anchorfile>classGeographicLib_1_1SphericalEngine_1_1coeff.html</anchorfile>
      <anchor>a98a75827d68247cf5ad1843d9d68b222</anchor>
      <arglist>(int N, int M)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>readcoeffs</name>
      <anchorfile>classGeographicLib_1_1SphericalEngine_1_1coeff.html</anchorfile>
      <anchor>a2d545f589894683e7de297c42b7c995a</anchor>
      <arglist>(std::istream &amp;stream, int &amp;N, int &amp;M, std::vector&lt; real &gt; &amp;C, std::vector&lt; real &gt; &amp;S)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::SphericalHarmonic</name>
    <filename>classGeographicLib_1_1SphericalHarmonic.html</filename>
    <member kind="enumeration">
      <name>normalization</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic.html</anchorfile>
      <anchor>a889791c67edc32865996842c600104eb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FULL</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic.html</anchorfile>
      <anchor>a889791c67edc32865996842c600104ebaee7040963f955b45b5a8ab0ea325c782</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SCHMIDT</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic.html</anchorfile>
      <anchor>a889791c67edc32865996842c600104eba014c2f3300abd50ff65ea8d73ef3c69e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SphericalHarmonic</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic.html</anchorfile>
      <anchor>adb71d28aa60a813ca3384f9c58ef8fa1</anchor>
      <arglist>(const std::vector&lt; real &gt; &amp;C, const std::vector&lt; real &gt; &amp;S, int N, real a, unsigned norm=FULL)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SphericalHarmonic</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic.html</anchorfile>
      <anchor>a2ed62c0ad8fb1ab36d5a331a3f33c3d7</anchor>
      <arglist>(const std::vector&lt; real &gt; &amp;C, const std::vector&lt; real &gt; &amp;S, int N, int nmx, int mmx, real a, unsigned norm=FULL)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SphericalHarmonic</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic.html</anchorfile>
      <anchor>a6d97388f273d1511a8191d812e9bde3e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>operator()</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic.html</anchorfile>
      <anchor>a42480d85a81238f612a6178410bf97ff</anchor>
      <arglist>(real x, real y, real z) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>operator()</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic.html</anchorfile>
      <anchor>a5046d787c241c5216cfeb0062673cbd7</anchor>
      <arglist>(real x, real y, real z, real &amp;gradx, real &amp;grady, real &amp;gradz) const </arglist>
    </member>
    <member kind="function">
      <type>CircularEngine</type>
      <name>Circle</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic.html</anchorfile>
      <anchor>a2b2b2ad35bba090a4956693ba5ef0f32</anchor>
      <arglist>(real p, real z, bool gradp) const </arglist>
    </member>
    <member kind="function">
      <type>const SphericalEngine::coeff &amp;</type>
      <name>Coefficients</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic.html</anchorfile>
      <anchor>ac8886de1d1400ecf6482f6441c76a8a0</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::SphericalHarmonic1</name>
    <filename>classGeographicLib_1_1SphericalHarmonic1.html</filename>
    <member kind="enumeration">
      <name>normalization</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic1.html</anchorfile>
      <anchor>ac4aaa81e0f753894ecef173c4d667916</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FULL</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic1.html</anchorfile>
      <anchor>ac4aaa81e0f753894ecef173c4d667916aafd320d946e992459e0013da6b769638</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SCHMIDT</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic1.html</anchorfile>
      <anchor>ac4aaa81e0f753894ecef173c4d667916aa1959e3e2bdf7c01f596692757858231</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SphericalHarmonic1</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic1.html</anchorfile>
      <anchor>aeb3299ea40b0bedae55fd0a6f0c1fa40</anchor>
      <arglist>(const std::vector&lt; real &gt; &amp;C, const std::vector&lt; real &gt; &amp;S, int N, const std::vector&lt; real &gt; &amp;C1, const std::vector&lt; real &gt; &amp;S1, int N1, real a, unsigned norm=FULL)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SphericalHarmonic1</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic1.html</anchorfile>
      <anchor>aca472a143f7e000e232f4c261550b626</anchor>
      <arglist>(const std::vector&lt; real &gt; &amp;C, const std::vector&lt; real &gt; &amp;S, int N, int nmx, int mmx, const std::vector&lt; real &gt; &amp;C1, const std::vector&lt; real &gt; &amp;S1, int N1, int nmx1, int mmx1, real a, unsigned norm=FULL)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SphericalHarmonic1</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic1.html</anchorfile>
      <anchor>aa976378e6eae1e85ce04976b631ccb5f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>operator()</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic1.html</anchorfile>
      <anchor>a43098674b6bb823ccbac8908a7831234</anchor>
      <arglist>(real tau, real x, real y, real z) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>operator()</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic1.html</anchorfile>
      <anchor>ac732f25af07eee71ad0ca288a2e86fbd</anchor>
      <arglist>(real tau, real x, real y, real z, real &amp;gradx, real &amp;grady, real &amp;gradz) const </arglist>
    </member>
    <member kind="function">
      <type>CircularEngine</type>
      <name>Circle</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic1.html</anchorfile>
      <anchor>a32dd4989c40181939d667298681625f6</anchor>
      <arglist>(real tau, real p, real z, bool gradp) const </arglist>
    </member>
    <member kind="function">
      <type>const SphericalEngine::coeff &amp;</type>
      <name>Coefficients</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic1.html</anchorfile>
      <anchor>a67fe3c8ab08be94a300d07c98814aab0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const SphericalEngine::coeff &amp;</type>
      <name>Coefficients1</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic1.html</anchorfile>
      <anchor>ad200e309790cd6e41bb79529d9076274</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::SphericalHarmonic2</name>
    <filename>classGeographicLib_1_1SphericalHarmonic2.html</filename>
    <member kind="enumeration">
      <name>normalization</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic2.html</anchorfile>
      <anchor>adbdc59ce4e6f1e4ce0fc7169c760f8be</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FULL</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic2.html</anchorfile>
      <anchor>adbdc59ce4e6f1e4ce0fc7169c760f8bea4b8746ff0805a8a819130794c103e946</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SCHMIDT</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic2.html</anchorfile>
      <anchor>adbdc59ce4e6f1e4ce0fc7169c760f8bea326a84d3094b558a1c43b4b61f9c2d58</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SphericalHarmonic2</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic2.html</anchorfile>
      <anchor>a897f6b15b82812e874a2b0927cfc3912</anchor>
      <arglist>(const std::vector&lt; real &gt; &amp;C, const std::vector&lt; real &gt; &amp;S, int N, const std::vector&lt; real &gt; &amp;C1, const std::vector&lt; real &gt; &amp;S1, int N1, const std::vector&lt; real &gt; &amp;C2, const std::vector&lt; real &gt; &amp;S2, int N2, real a, unsigned norm=FULL)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SphericalHarmonic2</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic2.html</anchorfile>
      <anchor>a19300de2d629c014883026bf0042b6f0</anchor>
      <arglist>(const std::vector&lt; real &gt; &amp;C, const std::vector&lt; real &gt; &amp;S, int N, int nmx, int mmx, const std::vector&lt; real &gt; &amp;C1, const std::vector&lt; real &gt; &amp;S1, int N1, int nmx1, int mmx1, const std::vector&lt; real &gt; &amp;C2, const std::vector&lt; real &gt; &amp;S2, int N2, int nmx2, int mmx2, real a, unsigned norm=FULL)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SphericalHarmonic2</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic2.html</anchorfile>
      <anchor>a2fad42164df6175bc376e2f78e3e0c5a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>operator()</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic2.html</anchorfile>
      <anchor>a48f85ac41417815e6735ff5aa7d74155</anchor>
      <arglist>(real tau1, real tau2, real x, real y, real z) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>operator()</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic2.html</anchorfile>
      <anchor>a762d48fc2c3dc902859286de4df7672c</anchor>
      <arglist>(real tau1, real tau2, real x, real y, real z, real &amp;gradx, real &amp;grady, real &amp;gradz) const </arglist>
    </member>
    <member kind="function">
      <type>CircularEngine</type>
      <name>Circle</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic2.html</anchorfile>
      <anchor>a3aa683a43a8e9232a16390b09c6be920</anchor>
      <arglist>(real tau1, real tau2, real p, real z, bool gradp) const </arglist>
    </member>
    <member kind="function">
      <type>const SphericalEngine::coeff &amp;</type>
      <name>Coefficients</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic2.html</anchorfile>
      <anchor>a166338f0b4ccf89c48278bb9514046f0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const SphericalEngine::coeff &amp;</type>
      <name>Coefficients1</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic2.html</anchorfile>
      <anchor>a51751279dc4e0b6e19886723f8e8b493</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const SphericalEngine::coeff &amp;</type>
      <name>Coefficients2</name>
      <anchorfile>classGeographicLib_1_1SphericalHarmonic2.html</anchorfile>
      <anchor>a676b4c36923744bf5057b24484d9cf60</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::TransverseMercator</name>
    <filename>classGeographicLib_1_1TransverseMercator.html</filename>
    <member kind="function">
      <type></type>
      <name>TransverseMercator</name>
      <anchorfile>classGeographicLib_1_1TransverseMercator.html</anchorfile>
      <anchor>a9a4074c9d0ea35f0ebfc9c9f73bd3183</anchor>
      <arglist>(real a, real f, real k0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Forward</name>
      <anchorfile>classGeographicLib_1_1TransverseMercator.html</anchorfile>
      <anchor>a07d73a6d94e2434cbb937978d61a5ae7</anchor>
      <arglist>(real lon0, real lat, real lon, real &amp;x, real &amp;y, real &amp;gamma, real &amp;k) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Reverse</name>
      <anchorfile>classGeographicLib_1_1TransverseMercator.html</anchorfile>
      <anchor>a15611aee4e3707e155278bab02403a07</anchor>
      <arglist>(real lon0, real x, real y, real &amp;lat, real &amp;lon, real &amp;gamma, real &amp;k) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Forward</name>
      <anchorfile>classGeographicLib_1_1TransverseMercator.html</anchorfile>
      <anchor>af689c212234963734354347d56bf12f6</anchor>
      <arglist>(real lon0, real lat, real lon, real &amp;x, real &amp;y) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Reverse</name>
      <anchorfile>classGeographicLib_1_1TransverseMercator.html</anchorfile>
      <anchor>ac3bd58646dd6c06731a9baadee11f7e5</anchor>
      <arglist>(real lon0, real x, real y, real &amp;lat, real &amp;lon) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MajorRadius</name>
      <anchorfile>classGeographicLib_1_1TransverseMercator.html</anchorfile>
      <anchor>a47e93a8cde548b6e8d7c4c076bac4be6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Flattening</name>
      <anchorfile>classGeographicLib_1_1TransverseMercator.html</anchorfile>
      <anchor>a6571ba8c59fd7e5e32c9994d37d4cdb5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>CentralScale</name>
      <anchorfile>classGeographicLib_1_1TransverseMercator.html</anchorfile>
      <anchor>a63876dc20e8765501ca62022f9a73432</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const TransverseMercator</type>
      <name>UTM</name>
      <anchorfile>classGeographicLib_1_1TransverseMercator.html</anchorfile>
      <anchor>aa25b52e35bc54c368e6c8b17e02b0542</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::TransverseMercatorExact</name>
    <filename>classGeographicLib_1_1TransverseMercatorExact.html</filename>
    <member kind="function">
      <type></type>
      <name>TransverseMercatorExact</name>
      <anchorfile>classGeographicLib_1_1TransverseMercatorExact.html</anchorfile>
      <anchor>a72ffcc89eee6f30a6d1f4d061518a6f1</anchor>
      <arglist>(real a, real f, real k0, bool extendp=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Forward</name>
      <anchorfile>classGeographicLib_1_1TransverseMercatorExact.html</anchorfile>
      <anchor>a0dab8d1a275df9e4796d2d858f42f7e3</anchor>
      <arglist>(real lon0, real lat, real lon, real &amp;x, real &amp;y, real &amp;gamma, real &amp;k) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Reverse</name>
      <anchorfile>classGeographicLib_1_1TransverseMercatorExact.html</anchorfile>
      <anchor>a350070780708de5a622d4f4c4757104c</anchor>
      <arglist>(real lon0, real x, real y, real &amp;lat, real &amp;lon, real &amp;gamma, real &amp;k) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Forward</name>
      <anchorfile>classGeographicLib_1_1TransverseMercatorExact.html</anchorfile>
      <anchor>a39c294a3389af325c41a8de51fd9228a</anchor>
      <arglist>(real lon0, real lat, real lon, real &amp;x, real &amp;y) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Reverse</name>
      <anchorfile>classGeographicLib_1_1TransverseMercatorExact.html</anchorfile>
      <anchor>a56ff2f371d59e2ca0da8644571706169</anchor>
      <arglist>(real lon0, real x, real y, real &amp;lat, real &amp;lon) const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>MajorRadius</name>
      <anchorfile>classGeographicLib_1_1TransverseMercatorExact.html</anchorfile>
      <anchor>a19083f16ecfc51f9020d7242b3ded43e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>Flattening</name>
      <anchorfile>classGeographicLib_1_1TransverseMercatorExact.html</anchorfile>
      <anchor>a4045ec4b01c99c4bb589b1b3e7e07ca4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Math::real</type>
      <name>CentralScale</name>
      <anchorfile>classGeographicLib_1_1TransverseMercatorExact.html</anchorfile>
      <anchor>a355a827f45c194d56a465e0d4f91c3a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const TransverseMercatorExact</type>
      <name>UTM</name>
      <anchorfile>classGeographicLib_1_1TransverseMercatorExact.html</anchorfile>
      <anchor>a68668637e754201897bddb82baaf634b</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::Utility</name>
    <filename>classGeographicLib_1_1Utility.html</filename>
    <member kind="function" static="yes">
      <type>static int</type>
      <name>day</name>
      <anchorfile>classGeographicLib_1_1Utility.html</anchorfile>
      <anchor>a877a58000a56bc84c354cf42b4b1cd99</anchor>
      <arglist>(int y, int m=1, int d=1)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static int</type>
      <name>day</name>
      <anchorfile>classGeographicLib_1_1Utility.html</anchorfile>
      <anchor>a0590e044fe0352adc10a58c46fa1e529</anchor>
      <arglist>(int y, int m, int d, bool check)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>date</name>
      <anchorfile>classGeographicLib_1_1Utility.html</anchorfile>
      <anchor>aa6955e745deebb79795b12ab139798e0</anchor>
      <arglist>(int s, int &amp;y, int &amp;m, int &amp;d)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>date</name>
      <anchorfile>classGeographicLib_1_1Utility.html</anchorfile>
      <anchor>a3b62cb71f8b7cafd49c1bf3389298525</anchor>
      <arglist>(const std::string &amp;s, int &amp;y, int &amp;m, int &amp;d)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static int</type>
      <name>dow</name>
      <anchorfile>classGeographicLib_1_1Utility.html</anchorfile>
      <anchor>a42a6f8679c068dcb06f1da26aa21dfb1</anchor>
      <arglist>(int y, int m, int d)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static int</type>
      <name>dow</name>
      <anchorfile>classGeographicLib_1_1Utility.html</anchorfile>
      <anchor>a4687c34e55dc7ccc135e31a72402f008</anchor>
      <arglist>(int s)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>fractionalyear</name>
      <anchorfile>classGeographicLib_1_1Utility.html</anchorfile>
      <anchor>a074607cb34326b7109532c8fdd07e38c</anchor>
      <arglist>(const std::string &amp;s)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static std::string</type>
      <name>str</name>
      <anchorfile>classGeographicLib_1_1Utility.html</anchorfile>
      <anchor>ae87a7ae2bee75f724907af9f753f03b7</anchor>
      <arglist>(T x, int p=-1)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>num</name>
      <anchorfile>classGeographicLib_1_1Utility.html</anchorfile>
      <anchor>aa35f1f83c0543558a79b3cf42ddf50c8</anchor>
      <arglist>(const std::string &amp;s)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>nummatch</name>
      <anchorfile>classGeographicLib_1_1Utility.html</anchorfile>
      <anchor>ad0d89bfe63814bab5312306fe3ac2b43</anchor>
      <arglist>(const std::string &amp;s)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>fract</name>
      <anchorfile>classGeographicLib_1_1Utility.html</anchorfile>
      <anchor>a46b13d9ce2893f7e0fe6e7da093f528f</anchor>
      <arglist>(const std::string &amp;s)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static int</type>
      <name>lookup</name>
      <anchorfile>classGeographicLib_1_1Utility.html</anchorfile>
      <anchor>a9a47fdaaa00a92e9a42035e62bd98faa</anchor>
      <arglist>(const std::string &amp;s, char c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>readarray</name>
      <anchorfile>classGeographicLib_1_1Utility.html</anchorfile>
      <anchor>a23e88040ceb60bd3fe28efc04f9119f8</anchor>
      <arglist>(std::istream &amp;str, IntT array[], size_t num)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>readarray</name>
      <anchorfile>classGeographicLib_1_1Utility.html</anchorfile>
      <anchor>a044796b4fc14a952abec27da27fc20be</anchor>
      <arglist>(std::istream &amp;str, std::vector&lt; IntT &gt; &amp;array)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>writearray</name>
      <anchorfile>classGeographicLib_1_1Utility.html</anchorfile>
      <anchor>a276eb20ace49c5260e1878c7d8aefd31</anchor>
      <arglist>(std::ostream &amp;str, const IntT array[], size_t num)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>writearray</name>
      <anchorfile>classGeographicLib_1_1Utility.html</anchorfile>
      <anchor>a0621066e4aa146a2c100802375e70389</anchor>
      <arglist>(std::ostream &amp;str, std::vector&lt; IntT &gt; &amp;array)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>ParseLine</name>
      <anchorfile>classGeographicLib_1_1Utility.html</anchorfile>
      <anchor>a96252f445a912b77517bff04d4d6ea74</anchor>
      <arglist>(const std::string &amp;line, std::string &amp;key, std::string &amp;val)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GeographicLib::UTMUPS</name>
    <filename>classGeographicLib_1_1UTMUPS.html</filename>
    <member kind="enumeration">
      <name>zonespec</name>
      <anchorfile>classGeographicLib_1_1UTMUPS.html</anchorfile>
      <anchor>a0c459615da18cc899a960bdc8c5b11b7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MINPSEUDOZONE</name>
      <anchorfile>classGeographicLib_1_1UTMUPS.html</anchorfile>
      <anchor>a0c459615da18cc899a960bdc8c5b11b7a058ac8a834bbc78ce73d9b37a1a5dfb9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INVALID</name>
      <anchorfile>classGeographicLib_1_1UTMUPS.html</anchorfile>
      <anchor>a0c459615da18cc899a960bdc8c5b11b7aeb6750fb82edce6e5b58178a38ee8bd0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MATCH</name>
      <anchorfile>classGeographicLib_1_1UTMUPS.html</anchorfile>
      <anchor>a0c459615da18cc899a960bdc8c5b11b7a9059a8e3b4721e27869e99ed1ae3d320</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UTM</name>
      <anchorfile>classGeographicLib_1_1UTMUPS.html</anchorfile>
      <anchor>a0c459615da18cc899a960bdc8c5b11b7aacc8f89ac6144b1e445ca21cbe9a2533</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STANDARD</name>
      <anchorfile>classGeographicLib_1_1UTMUPS.html</anchorfile>
      <anchor>a0c459615da18cc899a960bdc8c5b11b7adf96495ab4bfbf495f1fe31aebb9e406</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MAXPSEUDOZONE</name>
      <anchorfile>classGeographicLib_1_1UTMUPS.html</anchorfile>
      <anchor>a0c459615da18cc899a960bdc8c5b11b7ac22db7e136b6e06fba7c3c06b5888362</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MINZONE</name>
      <anchorfile>classGeographicLib_1_1UTMUPS.html</anchorfile>
      <anchor>a0c459615da18cc899a960bdc8c5b11b7af91adc987ae7295bfb6d3786b23c58e1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UPS</name>
      <anchorfile>classGeographicLib_1_1UTMUPS.html</anchorfile>
      <anchor>a0c459615da18cc899a960bdc8c5b11b7a40256f9ab9f277957f8ab697bcd2fd42</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MINUTMZONE</name>
      <anchorfile>classGeographicLib_1_1UTMUPS.html</anchorfile>
      <anchor>a0c459615da18cc899a960bdc8c5b11b7a1413e6cc83d4bf1eb4ad1c0f1d745eb6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MAXUTMZONE</name>
      <anchorfile>classGeographicLib_1_1UTMUPS.html</anchorfile>
      <anchor>a0c459615da18cc899a960bdc8c5b11b7ae8e04ab8df50a062c1fe277a6880bc19</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MAXZONE</name>
      <anchorfile>classGeographicLib_1_1UTMUPS.html</anchorfile>
      <anchor>a0c459615da18cc899a960bdc8c5b11b7a12dabceb6da15aa0fc94b9406aca921a</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static int</type>
      <name>StandardZone</name>
      <anchorfile>classGeographicLib_1_1UTMUPS.html</anchorfile>
      <anchor>a62623c295d1b43318a9fa762c3da94ea</anchor>
      <arglist>(real lat, real lon, int setzone=STANDARD)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>Forward</name>
      <anchorfile>classGeographicLib_1_1UTMUPS.html</anchorfile>
      <anchor>a921d6c23e728e0b17651902d43fb56e8</anchor>
      <arglist>(real lat, real lon, int &amp;zone, bool &amp;northp, real &amp;x, real &amp;y, real &amp;gamma, real &amp;k, int setzone=STANDARD, bool mgrslimits=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>Reverse</name>
      <anchorfile>classGeographicLib_1_1UTMUPS.html</anchorfile>
      <anchor>aaf417ae6bed6da324aa03fc96ee0dda4</anchor>
      <arglist>(int zone, bool northp, real x, real y, real &amp;lat, real &amp;lon, real &amp;gamma, real &amp;k, bool mgrslimits=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>Forward</name>
      <anchorfile>classGeographicLib_1_1UTMUPS.html</anchorfile>
      <anchor>aa21ec1bc26f691e0a6f2ccc44debe6f0</anchor>
      <arglist>(real lat, real lon, int &amp;zone, bool &amp;northp, real &amp;x, real &amp;y, int setzone=STANDARD, bool mgrslimits=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>Reverse</name>
      <anchorfile>classGeographicLib_1_1UTMUPS.html</anchorfile>
      <anchor>ac8cbfd7b15c96b52b876b54ce68f7b4d</anchor>
      <arglist>(int zone, bool northp, real x, real y, real &amp;lat, real &amp;lon, bool mgrslimits=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>DecodeZone</name>
      <anchorfile>classGeographicLib_1_1UTMUPS.html</anchorfile>
      <anchor>ad74d52d7ebeff195019745f791f30562</anchor>
      <arglist>(const std::string &amp;zonestr, int &amp;zone, bool &amp;northp)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static std::string</type>
      <name>EncodeZone</name>
      <anchorfile>classGeographicLib_1_1UTMUPS.html</anchorfile>
      <anchor>a3410e1e221158962f34147255653818f</anchor>
      <arglist>(int zone, bool northp)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>UTMShift</name>
      <anchorfile>classGeographicLib_1_1UTMUPS.html</anchorfile>
      <anchor>abd70d3f90f5c79a09bdd217b67e6729b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>MajorRadius</name>
      <anchorfile>classGeographicLib_1_1UTMUPS.html</anchorfile>
      <anchor>a293aa30508096d49db77a23917ea1092</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Math::real</type>
      <name>Flattening</name>
      <anchorfile>classGeographicLib_1_1UTMUPS.html</anchorfile>
      <anchor>a182de2e29f1181c55a266777039b8a9d</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="dir">
    <name>include/GeographicLib/</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/GeographicLib/</path>
    <filename>dir_b4d36717c8020107727c093197410e9d.html</filename>
    <file>Accumulator.hpp</file>
    <file>AlbersEqualArea.hpp</file>
    <file>AzimuthalEquidistant.hpp</file>
    <file>CassiniSoldner.hpp</file>
    <file>CircularEngine.hpp</file>
    <file>Constants.hpp</file>
    <file>DMS.hpp</file>
    <file>EllipticFunction.hpp</file>
    <file>Geocentric.hpp</file>
    <file>GeoCoords.hpp</file>
    <file>Geodesic.hpp</file>
    <file>GeodesicLine.hpp</file>
    <file>Geoid.hpp</file>
    <file>Gnomonic.hpp</file>
    <file>GravityCircle.hpp</file>
    <file>GravityModel.hpp</file>
    <file>LambertConformalConic.hpp</file>
    <file>LocalCartesian.hpp</file>
    <file>MagneticCircle.hpp</file>
    <file>MagneticModel.hpp</file>
    <file>Math.hpp</file>
    <file>MGRS.hpp</file>
    <file>NormalGravity.hpp</file>
    <file>OSGB.hpp</file>
    <file>PolarStereographic.hpp</file>
    <file>PolygonArea.hpp</file>
    <file>SphericalEngine.hpp</file>
    <file>SphericalHarmonic.hpp</file>
    <file>SphericalHarmonic1.hpp</file>
    <file>SphericalHarmonic2.hpp</file>
    <file>TransverseMercator.hpp</file>
    <file>TransverseMercatorExact.hpp</file>
    <file>Utility.hpp</file>
    <file>UTMUPS.hpp</file>
  </compound>
  <compound kind="dir">
    <name>include/</name>
    <path>/scratch/geographic-dist/gita/geographiclib/include/</path>
    <filename>dir_addd23a7fcb542c6c8ac894d486b21be.html</filename>
    <dir>include/GeographicLib/</dir>
  </compound>
  <compound kind="dir">
    <name>src/</name>
    <path>/scratch/geographic-dist/gita/geographiclib/src/</path>
    <filename>dir_20dd3cf0f425f295158796088ceb05f4.html</filename>
    <file>AlbersEqualArea.cpp</file>
    <file>AzimuthalEquidistant.cpp</file>
    <file>CassiniSoldner.cpp</file>
    <file>CircularEngine.cpp</file>
    <file>DMS.cpp</file>
    <file>EllipticFunction.cpp</file>
    <file>Geocentric.cpp</file>
    <file>GeoCoords.cpp</file>
    <file>Geodesic.cpp</file>
    <file>GeodesicLine.cpp</file>
    <file>Geoid.cpp</file>
    <file>Gnomonic.cpp</file>
    <file>GravityCircle.cpp</file>
    <file>GravityModel.cpp</file>
    <file>LambertConformalConic.cpp</file>
    <file>LocalCartesian.cpp</file>
    <file>MagneticCircle.cpp</file>
    <file>MagneticModel.cpp</file>
    <file>MGRS.cpp</file>
    <file>NormalGravity.cpp</file>
    <file>OSGB.cpp</file>
    <file>PolarStereographic.cpp</file>
    <file>PolygonArea.cpp</file>
    <file>SphericalEngine.cpp</file>
    <file>TransverseMercator.cpp</file>
    <file>TransverseMercatorExact.cpp</file>
    <file>Utility.cpp</file>
    <file>UTMUPS.cpp</file>
  </compound>
  <compound kind="dir">
    <name>tools/</name>
    <path>/scratch/geographic-dist/gita/geographiclib/tools/</path>
    <filename>dir_27ad12676aedce3065ab152db424ea04.html</filename>
    <file>CartConvert.cpp</file>
    <file>ConicProj.cpp</file>
    <file>GeoConvert.cpp</file>
    <file>Geod.cpp</file>
    <file>GeodesicProj.cpp</file>
    <file>GeoidEval.cpp</file>
    <file>Gravity.cpp</file>
    <file>MagneticField.cpp</file>
    <file>Planimeter.cpp</file>
    <file>TransverseMercatorProj.cpp</file>
  </compound>
</tagfile>
