/*
 * Copyright (C) 2023 Chris Talbot
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <adwaita.h>
#include <shumate/shumate.h>

G_BEGIN_DECLS

#define GEOCLUE_STUMBLER_TYPE_MARKER (geoclue_stumbler_marker_get_type())
G_DECLARE_FINAL_TYPE (GeoclueStumblerMarker, geoclue_stumbler_marker, GEOCLUE_STUMBLER, MARKER, ShumateMarker)

GeoclueStumblerMarker *geoclue_stumbler_marker_new (void);
void geoclue_stumbler_marker_set_map (GeoclueStumblerMarker *self,
                                      ShumateSimpleMap  *simple_map);
void geoclue_stumbler_marker_set_accuracy (GeoclueStumblerMarker *self,
                                           unsigned int accuracy_in_meters);

G_END_DECLS
