/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.modelingwizard.gui;

import com.modeliosoft.modelio.api.model.IUmlModel;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IAttribute;
import com.modeliosoft.modelio.api.model.uml.statik.IAttributeLink;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.model.uml.statik.IGeneralization;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IInterfaceRealization;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.modelingwizard.utils.ModelingWizardDlg;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AttributeCreationWizard {
    protected int nbAtt = 0;
    protected IInstance instance;
    protected Vector<IAttributeLink> toDelete = new Vector();
    protected HashMap<String, IAttributeLink> links = new HashMap();
    protected HashMap<String, IAttribute> atts = new HashMap();
    protected IClassifier base;
    protected Vector<Label> column1 = new Vector();
    protected Vector<Button> column2 = new Vector();
    protected Vector<Text> column3 = new Vector();
    protected Shell shell;
    protected Composite composite;
    protected Composite mainGroup;

    public AttributeCreationWizard(IClassifier cl, IInstance inst) {
        this.instance = inst;
        this.base = cl;
    }

    public void open() {
        Display display = Display.getDefault();
        this.createContents();
        this.centerOnPrimaryScreen(this.shell, display);
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected void updateModel() {
        IUmlModel model = Modelio.getInstance().getModelingSession().getModel();
        int i = 0;
        while (i < this.nbAtt) {
            IAttributeLink link = this.links.get(this.column1.get(i).getText());
            if (this.column2.get(i).getSelection()) {
                String value = this.column3.get(i).getText();
                String name = this.column1.get(i).getText();
                if (link == null) {
                    link = model.createAttributeLink();
                    link.setBase(this.atts.get(name));
                    link.setAttributed(this.instance);
                    link.setName(name);
                }
                link.setValue(value);
            } else if (link != null) {
                this.toDelete.add(link);
            }
            ++i;
        }
        i = 0;
        while (i < this.toDelete.size()) {
            model.deleteElement((IElement)this.toDelete.get(i));
            ++i;
        }
    }

    protected void createContents() {
        if (System.getProperty("os.name").equals("Linux")) {
            this.shell = new Shell(2144);
        } else {
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            this.shell = new Shell(display, 2144);
        }
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(ModelingWizardDlg.getString("mdac.gui.attributeWizard.title"));
        this.createButtons();
        this.createLines();
        this.shell.pack();
        this.shell.setSize(this.shell.getSize().x + 30, this.shell.getSize().y);
        this.updateValues(this.base, this.instance);
    }

    private List<IAttribute> getAttributs(IClassifier cl) {
        ArrayList<IAttribute> result = new ArrayList<IAttribute>();
        HashSet<Object> done = new HashSet<Object>();
        ArrayList<Object> childs = new ArrayList<Object>();
        result.addAll((Collection<IAttribute>)cl.getPart(IAttribute.class));
        childs.add(cl);
        done.add(cl);
        while (childs.size() > 0) {
            ArrayList<INameSpace> parents = new ArrayList<INameSpace>();
            for (INameSpace iNameSpace : childs) {
                INameSpace parent;
                for (IGeneralization generalization : iNameSpace.getParent()) {
                    parent = generalization.getSuperType();
                    if (done.contains(parent) || !(parent instanceof IClassifier)) continue;
                    done.add(parent);
                    parents.add(parent);
                    result.addAll((Collection<IAttribute>)((IClassifier)parent).getPart(IAttribute.class));
                }
                for (IInterfaceRealization realization : iNameSpace.getRealized()) {
                    parent = realization.getImplemented();
                    if (done.contains(parent)) continue;
                    done.add(parent);
                    parents.add(parent);
                    result.addAll((Collection<IAttribute>)parent.getPart(IAttribute.class));
                }
            }
            childs = new ArrayList();
            childs.addAll(parents);
        }
        return result;
    }

    private void organizeVectors(Composite group, IClassifier cl, IInstance inst) {
        if (cl != null && inst != null) {
            List<IAttribute> oldAtts = this.getAttributs(cl);
            boolean heritedAttr = false;
            for (IAttribute att : oldAtts) {
                if (att.getOwner().equals((Object)cl)) continue;
                heritedAttr = true;
                break;
            }
            for (IAttribute att : oldAtts) {
                this.atts.put(att.getName(), att);
                Label att1Label = new Label(group, 0);
                att1Label.setLayoutData((Object)new GridData(4, 16384, false, false));
                if (heritedAttr) {
                    att1Label.setText(String.valueOf(att.getOwner().getName()) + "::" + att.getName());
                } else {
                    att1Label.setText(att.getName());
                }
                this.column1.add(att1Label);
                Button check = new Button(group, 32);
                check.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
                check.setData((Object)Integer.toString(this.nbAtt));
                check.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        int i = Integer.parseInt(((Button)evt.getSource()).getData().toString());
                        if (AttributeCreationWizard.this.column2.get(i).getSelection()) {
                            AttributeCreationWizard.this.column3.get(i).setEnabled(true);
                        } else {
                            AttributeCreationWizard.this.column3.get(i).setEnabled(false);
                        }
                    }
                });
                this.column2.add(check);
                Text value = new Text(group, 2048);
                value.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                this.column3.add(value);
                ++this.nbAtt;
            }
        }
    }

    private Composite createLines() {
        this.mainGroup = new Composite((Composite)this.shell, 2048);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.mainGroup.setLayout((Layout)gridLayout);
        FormData fd_group = new FormData();
        fd_group.right = new FormAttachment(100, -5);
        fd_group.top = new FormAttachment(0, 5);
        fd_group.left = new FormAttachment(0, 5);
        fd_group.bottom = new FormAttachment((Control)this.composite, 0);
        this.mainGroup.setLayoutData((Object)fd_group);
        Label nameLabel = new Label(this.mainGroup, 0);
        nameLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        nameLabel.setText(ModelingWizardDlg.getString("mdac.gui.attributeWizard.name"));
        Label creationLabel = new Label(this.mainGroup, 0);
        creationLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        creationLabel.setText(ModelingWizardDlg.getString("mdac.gui.attributeWizard.create"));
        Label valueLabel = new Label(this.mainGroup, 0);
        valueLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        valueLabel.setText(ModelingWizardDlg.getString("mdac.gui.attributeWizard.value"));
        this.organizeVectors(this.mainGroup, this.base, this.instance);
        return this.mainGroup;
    }

    private void updateValues(IClassifier cl, IInstance inst) {
        if (cl != null && inst != null) {
            ObList oldAtts = cl.getPart(IAttribute.class);
            Vector<IAttributeLink> oldLinks = new Vector<IAttributeLink>();
            Iterator iter = inst.getSlot().iterator();
            while (iter.hasNext()) {
                oldLinks.add((IAttributeLink)iter.next());
            }
            int i = 0;
            for (IAttribute att : oldAtts.select(IAttribute.class)) {
                boolean found = false;
                int j = 0;
                while (j < oldLinks.size()) {
                    IAttributeLink link = (IAttributeLink)oldLinks.get(j);
                    if (link.getBase() != null && att.equals((Object)link.getBase())) {
                        if (found) {
                            this.toDelete.add(link);
                        } else {
                            this.column2.get(i).setSelection(true);
                            this.column3.get(i).setText(link.getValue());
                            found = true;
                            this.links.put(att.getName(), link);
                        }
                        oldLinks.remove(link);
                        --j;
                    }
                    ++j;
                }
                if (!found) {
                    this.links.put(att.getName(), null);
                    this.column3.get(i).setEnabled(false);
                }
                ++i;
            }
            int j = 0;
            while (j < oldLinks.size()) {
                IAttributeLink link = (IAttributeLink)oldLinks.get(j);
                this.toDelete.add(link);
                ++j;
            }
        }
    }

    private void createButtons() {
        this.composite = new Composite((Composite)this.shell, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.justify = true;
        this.composite.setLayout((Layout)rowLayout);
        FormData fd_composite_1 = new FormData();
        fd_composite_1.left = new FormAttachment(0, 5);
        fd_composite_1.bottom = new FormAttachment(100, 0);
        fd_composite_1.right = new FormAttachment(100, -5);
        this.composite.setLayoutData((Object)fd_composite_1);
        Composite composite_2 = new Composite(this.composite, 0);
        composite_2.setLayout((Layout)new FillLayout());
        Button okButton = new Button(composite_2, 0);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AttributeCreationWizard.this.updateModel();
                AttributeCreationWizard.this.dispose();
            }
        });
        okButton.setText(ModelingWizardDlg.getString("mdac.gui.ok"));
        Button cancelButton = new Button(composite_2, 0);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AttributeCreationWizard.this.dispose();
            }
        });
        cancelButton.setText(ModelingWizardDlg.getString("mdac.gui.cancel"));
    }

    protected void dispose() {
        this.shell.dispose();
    }

    private void centerOnPrimaryScreen(Shell parentShell, Display display) {
        Monitor primary = display.getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = parentShell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        parentShell.setLocation(x, y);
    }
}

