/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.modelingwizard.impl.commands;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.commands.DefaultMdacContextualCommand;
import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.ITransaction;
import com.modeliosoft.modelio.api.model.InvalidTransactionException;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IState;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IStateMachine;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.modelingwizard.impl.engine.StateUpdater;

public class CreateStateMachineFromState
extends DefaultMdacContextualCommand {
    public void actionPerformed(ObList<IElement> selectedElements, IMdac mdac) {
        IModelingSession session = mdac.getModelingSession();
        ITransaction transaction = session.createTransaction("CreateStateMachineFromState");
        try {
            try {
                IState state = (IState)selectedElements.get(0);
                StateUpdater stateWizard = new StateUpdater();
                stateWizard.createStateMachineFromState(session, state);
                session.commit(transaction);
                transaction = null;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction != null) {
                    session.rollback(transaction);
                }
            }
        }
        finally {
            if (transaction != null) {
                session.rollback(transaction);
            }
        }
    }

    public boolean accept(ObList<IElement> selectedElements, IMdac mdac) {
        return selectedElements.size() > 0;
    }

    public boolean isActiveFor(ObList<IElement> selectedElements, IMdac mdac) {
        IState selectedState = (IState)selectedElements.get(0);
        IStateMachine stateMachine = selectedState.getSubMachine();
        return stateMachine == null;
    }
}

