#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

import datetime
import time

from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment
        self.last_time = datetime.datetime.now()
        self.lastDateString = ""
        self.lastTimeString = ""

    def shutdown(self):
        pass

    def get_description(self):
        return "No Description found"

    def run(self):
        if not self.env["runtime"]["SettingsManager"].get_setting_as_bool(
            "time", "enabled"
        ):
            return

        on_minutes = self.env["runtime"]["SettingsManager"].get_setting(
            "time", "on_minutes"
        )
        delay_sec = self.env["runtime"]["SettingsManager"].get_setting_as_int(
            "time", "delay_sec"
        )

        # no need
        if on_minutes == "" and delay_sec <= 0:
            return

        on_minutes = on_minutes.split(",")
        now = datetime.datetime.now()

        # ignore on_minutes if there is a delay_sec
        if delay_sec > 0:
            if int((now - self.last_time).total_seconds()) < delay_sec:
                return
        else:
            # should announce?
            if not str(now.minute).zfill(2) in on_minutes:
                return
            # already announced?
            if now.hour == self.last_time.hour:
                if now.minute == self.last_time.minute:
                    return

        date_format = self.env["runtime"]["SettingsManager"].get_setting(
            "general", "date_format"
        )
        date_string = datetime.datetime.strftime(now, date_format)

        present_date = (
            self.env["runtime"]["SettingsManager"].get_setting_as_bool(
                "time", "present_date"
            )
            and self.lastDateString != date_string
        )
        present_time = self.env["runtime"][
            "SettingsManager"
        ].get_setting_as_bool("time", "present_time")

        # no changed value to announce
        if not (present_date or present_time):
            return

        time_format = self.env["runtime"]["SettingsManager"].get_setting(
            "general", "time_format"
        )
        time_string = datetime.datetime.strftime(now, time_format)

        if self.env["runtime"]["SettingsManager"].get_setting_as_bool(
            "time", "interrupt"
        ):
            self.env["runtime"]["OutputManager"].interrupt_output()
        if self.env["runtime"]["SettingsManager"].get_setting_as_bool(
            "time", "announce"
        ):
            self.env["runtime"]["OutputManager"].play_sound_icon("announce")

        if present_time:
            # present the time
            self.env["runtime"]["OutputManager"].present_text(
                _("It's {0}").format(
                    time_string.replace(":00", " O'clock ").lstrip("0")
                ),
                sound_icon="",
                interrupt=False,
            )
            # Check if it's 12:00 AM
            if now.hour == 0 and now.minute == 0:
                # present the date
                self.env["runtime"]["OutputManager"].present_text(
                    date_string, sound_icon="", interrupt=False
                )

        self.last_time = datetime.datetime.now()
        self.lastTimeString = time_string

    def set_callback(self, callback):
        pass
