# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems


class V1Container(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Swagger model

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'image': 'str',
            'command': 'list[str]',
            'args': 'list[str]',
            'working_dir': 'str',
            'ports': 'list[V1ContainerPort]',
            'env': 'list[V1EnvVar]',
            'resources': 'V1ResourceRequirements',
            'volume_mounts': 'list[V1VolumeMount]',
            'liveness_probe': 'V1Probe',
            'readiness_probe': 'V1Probe',
            'lifecycle': 'V1Lifecycle',
            'termination_message_path': 'str',
            'image_pull_policy': 'str',
            'security_context': 'V1SecurityContext',
            'stdin': 'bool',
            'stdin_once': 'bool',
            'tty': 'bool'
        }

        self.attribute_map = {
            'name': 'name',
            'image': 'image',
            'command': 'command',
            'args': 'args',
            'working_dir': 'workingDir',
            'ports': 'ports',
            'env': 'env',
            'resources': 'resources',
            'volume_mounts': 'volumeMounts',
            'liveness_probe': 'livenessProbe',
            'readiness_probe': 'readinessProbe',
            'lifecycle': 'lifecycle',
            'termination_message_path': 'terminationMessagePath',
            'image_pull_policy': 'imagePullPolicy',
            'security_context': 'securityContext',
            'stdin': 'stdin',
            'stdin_once': 'stdinOnce',
            'tty': 'tty'
        }

        self._name = None
        self._image = None
        self._command = None
        self._args = None
        self._working_dir = None
        self._ports = None
        self._env = None
        self._resources = None
        self._volume_mounts = None
        self._liveness_probe = None
        self._readiness_probe = None
        self._lifecycle = None
        self._termination_message_path = None
        self._image_pull_policy = None
        self._security_context = None
        self._stdin = None
        self._stdin_once = None
        self._tty = None

    @property
    def name(self):
        """
        Gets the name of this V1Container.
        Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.

        :return: The name of this V1Container.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this V1Container.
        Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.

        :param name: The name of this V1Container.
        :type: str
        """
        self._name = name

    @property
    def image(self):
        """
        Gets the image of this V1Container.
        Docker image name. More info: http://releases.k8s.io/release-1.2/docs/user-guide/images.md

        :return: The image of this V1Container.
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image):
        """
        Sets the image of this V1Container.
        Docker image name. More info: http://releases.k8s.io/release-1.2/docs/user-guide/images.md

        :param image: The image of this V1Container.
        :type: str
        """
        self._image = image

    @property
    def command(self):
        """
        Gets the command of this V1Container.
        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: http://releases.k8s.io/release-1.2/docs/user-guide/containers.md#containers-and-commands

        :return: The command of this V1Container.
        :rtype: list[str]
        """
        return self._command

    @command.setter
    def command(self, command):
        """
        Sets the command of this V1Container.
        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: http://releases.k8s.io/release-1.2/docs/user-guide/containers.md#containers-and-commands

        :param command: The command of this V1Container.
        :type: list[str]
        """
        self._command = command

    @property
    def args(self):
        """
        Gets the args of this V1Container.
        Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: http://releases.k8s.io/release-1.2/docs/user-guide/containers.md#containers-and-commands

        :return: The args of this V1Container.
        :rtype: list[str]
        """
        return self._args

    @args.setter
    def args(self, args):
        """
        Sets the args of this V1Container.
        Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: http://releases.k8s.io/release-1.2/docs/user-guide/containers.md#containers-and-commands

        :param args: The args of this V1Container.
        :type: list[str]
        """
        self._args = args

    @property
    def working_dir(self):
        """
        Gets the working_dir of this V1Container.
        Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.

        :return: The working_dir of this V1Container.
        :rtype: str
        """
        return self._working_dir

    @working_dir.setter
    def working_dir(self, working_dir):
        """
        Sets the working_dir of this V1Container.
        Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.

        :param working_dir: The working_dir of this V1Container.
        :type: str
        """
        self._working_dir = working_dir

    @property
    def ports(self):
        """
        Gets the ports of this V1Container.
        List of ports to expose from the container. Exposing a port here gives the system additional information about the network connections a container uses, but is primarily informational. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default \"0.0.0.0\" address inside a container will be accessible from the network. Cannot be updated.

        :return: The ports of this V1Container.
        :rtype: list[V1ContainerPort]
        """
        return self._ports

    @ports.setter
    def ports(self, ports):
        """
        Sets the ports of this V1Container.
        List of ports to expose from the container. Exposing a port here gives the system additional information about the network connections a container uses, but is primarily informational. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default \"0.0.0.0\" address inside a container will be accessible from the network. Cannot be updated.

        :param ports: The ports of this V1Container.
        :type: list[V1ContainerPort]
        """
        self._ports = ports

    @property
    def env(self):
        """
        Gets the env of this V1Container.
        List of environment variables to set in the container. Cannot be updated.

        :return: The env of this V1Container.
        :rtype: list[V1EnvVar]
        """
        return self._env

    @env.setter
    def env(self, env):
        """
        Sets the env of this V1Container.
        List of environment variables to set in the container. Cannot be updated.

        :param env: The env of this V1Container.
        :type: list[V1EnvVar]
        """
        self._env = env

    @property
    def resources(self):
        """
        Gets the resources of this V1Container.
        Compute Resources required by this container. Cannot be updated. More info: http://releases.k8s.io/release-1.2/docs/user-guide/persistent-volumes.md#resources

        :return: The resources of this V1Container.
        :rtype: V1ResourceRequirements
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """
        Sets the resources of this V1Container.
        Compute Resources required by this container. Cannot be updated. More info: http://releases.k8s.io/release-1.2/docs/user-guide/persistent-volumes.md#resources

        :param resources: The resources of this V1Container.
        :type: V1ResourceRequirements
        """
        self._resources = resources

    @property
    def volume_mounts(self):
        """
        Gets the volume_mounts of this V1Container.
        Pod volumes to mount into the container's filesyste. Cannot be updated.

        :return: The volume_mounts of this V1Container.
        :rtype: list[V1VolumeMount]
        """
        return self._volume_mounts

    @volume_mounts.setter
    def volume_mounts(self, volume_mounts):
        """
        Sets the volume_mounts of this V1Container.
        Pod volumes to mount into the container's filesyste. Cannot be updated.

        :param volume_mounts: The volume_mounts of this V1Container.
        :type: list[V1VolumeMount]
        """
        self._volume_mounts = volume_mounts

    @property
    def liveness_probe(self):
        """
        Gets the liveness_probe of this V1Container.
        Periodic probe of container liveness. Container will be restarted if the probe fails. Cannot be updated. More info: http://releases.k8s.io/release-1.2/docs/user-guide/pod-states.md#container-probes

        :return: The liveness_probe of this V1Container.
        :rtype: V1Probe
        """
        return self._liveness_probe

    @liveness_probe.setter
    def liveness_probe(self, liveness_probe):
        """
        Sets the liveness_probe of this V1Container.
        Periodic probe of container liveness. Container will be restarted if the probe fails. Cannot be updated. More info: http://releases.k8s.io/release-1.2/docs/user-guide/pod-states.md#container-probes

        :param liveness_probe: The liveness_probe of this V1Container.
        :type: V1Probe
        """
        self._liveness_probe = liveness_probe

    @property
    def readiness_probe(self):
        """
        Gets the readiness_probe of this V1Container.
        Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: http://releases.k8s.io/release-1.2/docs/user-guide/pod-states.md#container-probes

        :return: The readiness_probe of this V1Container.
        :rtype: V1Probe
        """
        return self._readiness_probe

    @readiness_probe.setter
    def readiness_probe(self, readiness_probe):
        """
        Sets the readiness_probe of this V1Container.
        Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: http://releases.k8s.io/release-1.2/docs/user-guide/pod-states.md#container-probes

        :param readiness_probe: The readiness_probe of this V1Container.
        :type: V1Probe
        """
        self._readiness_probe = readiness_probe

    @property
    def lifecycle(self):
        """
        Gets the lifecycle of this V1Container.
        Actions that the management system should take in response to container lifecycle events. Cannot be updated.

        :return: The lifecycle of this V1Container.
        :rtype: V1Lifecycle
        """
        return self._lifecycle

    @lifecycle.setter
    def lifecycle(self, lifecycle):
        """
        Sets the lifecycle of this V1Container.
        Actions that the management system should take in response to container lifecycle events. Cannot be updated.

        :param lifecycle: The lifecycle of this V1Container.
        :type: V1Lifecycle
        """
        self._lifecycle = lifecycle

    @property
    def termination_message_path(self):
        """
        Gets the termination_message_path of this V1Container.
        Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Defaults to /dev/termination-log. Cannot be updated.

        :return: The termination_message_path of this V1Container.
        :rtype: str
        """
        return self._termination_message_path

    @termination_message_path.setter
    def termination_message_path(self, termination_message_path):
        """
        Sets the termination_message_path of this V1Container.
        Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Defaults to /dev/termination-log. Cannot be updated.

        :param termination_message_path: The termination_message_path of this V1Container.
        :type: str
        """
        self._termination_message_path = termination_message_path

    @property
    def image_pull_policy(self):
        """
        Gets the image_pull_policy of this V1Container.
        Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: http://releases.k8s.io/release-1.2/docs/user-guide/images.md#updating-images

        :return: The image_pull_policy of this V1Container.
        :rtype: str
        """
        return self._image_pull_policy

    @image_pull_policy.setter
    def image_pull_policy(self, image_pull_policy):
        """
        Sets the image_pull_policy of this V1Container.
        Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: http://releases.k8s.io/release-1.2/docs/user-guide/images.md#updating-images

        :param image_pull_policy: The image_pull_policy of this V1Container.
        :type: str
        """
        self._image_pull_policy = image_pull_policy

    @property
    def security_context(self):
        """
        Gets the security_context of this V1Container.
        Security options the pod should run with. More info: http://releases.k8s.io/release-1.2/docs/design/security_context.md

        :return: The security_context of this V1Container.
        :rtype: V1SecurityContext
        """
        return self._security_context

    @security_context.setter
    def security_context(self, security_context):
        """
        Sets the security_context of this V1Container.
        Security options the pod should run with. More info: http://releases.k8s.io/release-1.2/docs/design/security_context.md

        :param security_context: The security_context of this V1Container.
        :type: V1SecurityContext
        """
        self._security_context = security_context

    @property
    def stdin(self):
        """
        Gets the stdin of this V1Container.
        Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.

        :return: The stdin of this V1Container.
        :rtype: bool
        """
        return self._stdin

    @stdin.setter
    def stdin(self, stdin):
        """
        Sets the stdin of this V1Container.
        Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.

        :param stdin: The stdin of this V1Container.
        :type: bool
        """
        self._stdin = stdin

    @property
    def stdin_once(self):
        """
        Gets the stdin_once of this V1Container.
        Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false

        :return: The stdin_once of this V1Container.
        :rtype: bool
        """
        return self._stdin_once

    @stdin_once.setter
    def stdin_once(self, stdin_once):
        """
        Sets the stdin_once of this V1Container.
        Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false

        :param stdin_once: The stdin_once of this V1Container.
        :type: bool
        """
        self._stdin_once = stdin_once

    @property
    def tty(self):
        """
        Gets the tty of this V1Container.
        Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.

        :return: The tty of this V1Container.
        :rtype: bool
        """
        return self._tty

    @tty.setter
    def tty(self, tty):
        """
        Sets the tty of this V1Container.
        Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.

        :param tty: The tty of this V1Container.
        :type: bool
        """
        self._tty = tty

    def to_dict(self):
        """
        Return model properties dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Return model properties str
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()
