# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.managednetworkfabric import ManagedNetworkFabricMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-managednetworkfabric
# USAGE
    python external_networks_update_maximum_set_gen.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ManagedNetworkFabricMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="subscriptionId",
    )

    response = client.external_networks.begin_update(
        resource_group_name="resourceGroupName",
        l3_isolation_domain_name="example-l3domain",
        external_network_name="example-externalnetwork",
        body={
            "properties": {
                "annotation": "Lab 1",
                "exportRoutePolicyId": "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName",
                "importRoutePolicyId": "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName",
                "optionAProperties": {
                    "bfdConfiguration": {},
                    "mtu": 1500,
                    "peerASN": 65047,
                    "primaryIpv4Prefix": "10.1.1.0/30",
                    "primaryIpv6Prefix": "3FFE:FFFF:0:CD30::a0/126",
                    "secondaryIpv4Prefix": "10.1.1.4/30",
                    "secondaryIpv6Prefix": "3FFE:FFFF:0:CD30::a4/126",
                    "vlanId": 1001,
                },
                "optionBProperties": {"exportRouteTargets": ["65046:10039"], "importRouteTargets": ["65046:10039"]},
                "peeringOption": "OptionA",
            }
        },
    ).result()
    print(response)


# x-ms-original-file: specification/managednetworkfabric/resource-manager/Microsoft.ManagedNetworkFabric/preview/2023-02-01-preview/examples/ExternalNetworks_Update_MaximumSet_Gen.json
if __name__ == "__main__":
    main()
