//                                               -*- C++ -*-
/**
 *  @brief SRCAnalysis computes the Standard Regression Coefficients
 *
 *  Copyright 2015-2023 EDF-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
#ifndef PERSALYS_SRCANALYSIS_HXX
#define PERSALYS_SRCANALYSIS_HXX

#include "SimulationAnalysis.hxx"
#include "SRCResult.hxx"

namespace PERSALYS
{
class PERSALYS_BASE_API SRCAnalysis : public SimulationAnalysis
{
  CLASSNAME

public:
  /** Default constructor */
  SRCAnalysis();
  /** Constructor with parameters */
  SRCAnalysis(const OT::String & name, const PhysicalModel & physicalModel, const OT::UnsignedInteger nbSimu = 10000);

  /** Virtual constructor */
  SRCAnalysis * clone() const override;

  OT::UnsignedInteger getSimulationsNumber() const;
  void setSimulationsNumber(const OT::UnsignedInteger number);

  SRCResult getResult() const;

  Parameters getParameters() const override;
  OT::String getPythonScript() const override;
  bool hasValidResult() const override;
  bool canBeLaunched(OT::String &errorMessage) const override;

  /** String converter */
  OT::String __repr__() const override;

  /** Method save() stores the object through the StorageManager */
  void save(OT::Advocate & adv) const override;

  /** Method load() reloads the object from the StorageManager */
  void load(OT::Advocate & adv) override;

protected:
  void initialize() override;
  void launch() override;

private:
  OT::UnsignedInteger simulationsNumber_ = 0;
  SRCResult result_;
};
}
#endif
