#!/usr/bin/perl
use strict;
use Nmap::Parser;
use File::Spec;
use Cwd;
use Test::More 'no_plan';
use constant HOST1 => '127.0.0.1';
my @UP_HOSTS = (HOST1);
use constant TOTAL_HOSTS => 1;

use constant TEST_FILE =>'test1.xml';
use vars qw($host $np $session $svc $os $FH);

$FH = File::Spec->catfile(cwd(),'t',TEST_FILE);
$FH = File::Spec->catfile(cwd(),    TEST_FILE)  unless(-e $FH);

my $np = new Nmap::Parser;

parser_test();
session_test();
host_1();

sub parser_test {
    ok($np->parsefile($FH),"Parsing nmap data: $FH");
    
    #TESTING GET_IPS()
    is_deeply([$np->get_ips()],[HOST1], 'Testing get_ips for correct number of hosts');
    is_deeply([$np->get_ips('up')],[HOST1], 'Testing get_ips for correct hosts with status = up');
    #is_deeply([$np->get_ips('down')],[HOST2], 'Testing get_ips for correct hosts for with status = down');
}



sub session_test {
    
    isa_ok($session = $np->get_session(), 'Nmap::Parser::Session');
    print $session->nmap_version() . "\n";;
    is($session->numservices(),1670,'Session: total number of services');
    is($session->numservices('syn'),1670,'Session: numservices type = connect');
    is($session->numservices('udp'),undef,'Session: numservices type = udp');
    is($session->start_time(),1144909629,'Session: start_time');
    is($session->start_str(),'Thu Apr 13 02:27:09 2006','Session: start_str');
    is($session->finish_time(),1144909633,'Session: finish_time');
    is($session->time_str(),'Thu Apr 13 02:27:13 2006','Session: time_str');
    is($session->nmap_version(),'3.95','Session: nmap_version');
    is($session->xml_version(),'1.01','Session: xml_version');
    is($session->scan_args(),'nmap -A -vv -O -oX test1 127.0.0.1','Session: scan_args');
    is($session->scan_type_proto(),undef,'Session: scan_type_proto()');
    is($session->scan_type_proto('syn'),'tcp','Session: scan_type_proto(syn)');

    }


sub host_1 {
    
    isa_ok($host = $np->get_host(HOST1), 'Nmap::Parser::Host','GET '.HOST1);
    is($host->status,'up','Host1: status');
    is($host->addr,HOST1,'Host1: addr');
    is($host->addrtype,'ipv4','Host1: addrtype');
    is($host->ipv4_addr,HOST1,'Host1: ipv4_addr');
    is($host->hostname,'localhost.localdomain','Host1: hostname()');
    is($host->hostname(0),$host->hostname, 'Host1: hostname(0)');
    is($host->hostname(1),'localhost.localdomain', 'Host1: hostname(1)');
    is($host->extraports_state(),'closed','Host1: extraports_state');
    is($host->extraports_count(),1670,'Host1: extraports_count');
    
    
    is($host->tcp_port_count(),0,'Host1: tcp_port_count');
    is($host->udp_port_count(),0,'Host1: udp_port_count');

    is_deeply([$host->tcp_ports()],[qw()],'Host1: tcp_ports()');
    is_deeply([$host->tcp_ports('open')],[qw()],'Host1: tcp_ports(open)');
    is_deeply([$host->tcp_ports('closed')], [qw()],'Host1: tcp_ports(closed)');
    is_deeply([$host->tcp_ports('filtered')],[qw()],'Host1: tcp_ports(filtered)');
    is_deeply([$host->tcp_ports('open|filtered')],[qw()],'Host1: tcp_ports(open|filtered)');
    is_deeply([$host->udp_ports()], [qw()],'Host1: udp_ports()');
    is_deeply([$host->udp_ports('open')],[qw()],'Host1: udp_ports(open)');
    is_deeply([$host->udp_ports('filtered')], [qw()],'Host1: udp_ports(filtered)');
    is_deeply([$host->udp_ports('closed')],  [qw()],'Host1: udp_ports(closed)');
    
    is($host->tcp_ports('open'),    $host->tcp_open_ports(),    'Host1: tcp_open_ports');
    is($host->tcp_ports('filtered'),$host->tcp_filtered_ports(),'Host1: tcp_filtered_ports');
    is($host->tcp_ports('closed'),  $host->tcp_closed_ports(),  'Host1: tcp_closed_ports');
    
    is($host->udp_ports('open'),    $host->udp_open_ports(),    'Host1: udp_open_ports');
    is($host->udp_ports('filtered'),$host->udp_filtered_ports(),'Host1: udp_filtered_ports');
    is($host->udp_ports('closed'),  $host->udp_closed_ports(),  'Host1: udp_closed_ports');
    
    isa_ok($np->del_host(HOST1), 'Nmap::Parser::Host','DEL '.HOST1);
    is($np->get_host(HOST1),undef, 'Testing deletion of '.HOST1);
    
    
    #TESTING OS OBJECT FOR HOST 1
    my $os;
    isa_ok($os = $host->os_sig(),'Nmap::Parser::Host::OS','os_sig()');
    
    }
