///
// Copyright (C) 2002 - 2004, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "aboutdialog.h"
#include "defines.h"
#include "widget/wmisc.h"
#include "widget/programs.h"
#include <gtkmm/label.h>
#include <gtkmm/image.h>
#include <gtkmm/box.h>
#include <gtkmm/stock.h>
#include <gtkmm/notebook.h>
#include <gtkmm/scrolledwindow.h>
#include "icons/logo.h"

AboutDialog *AboutDialog::_instance = 0;

extern const char *builddate;  
// The date this program was linked.
// Defined in builddate.cc.

// The contents of the AUTHORS file as a string in authors.cc
extern const char *authors;

namespace {
  const std::string mail_address = "passepartout@stacken.kth.se";

#ifdef HAVE_GNOME
  bool have_gnome = true;
#else
  bool have_gnome = false;
#endif

}

AboutDialog::AboutDialog()
  : DialogWrap("About")
{
  set_resizable(false);

  // Info
  Gtk::Box *hbox = manage(new Gtk::HBox(false, double_space));
  hbox->set_border_width(double_space);

  Gtk::Image *image = 
    manage(new Gtk::Image(Gdk::Pixbuf::create_from_inline(69624, logo)));
  hbox->pack_start(*image, Gtk::PACK_SHRINK);

  Gtk::Box *message = manage(new Gtk::VBox());
  hbox->pack_start(*message, Gtk::PACK_SHRINK);

  Gtk::Label *label =
    manage(new Gtk::Label("", Gtk::JUSTIFY_LEFT, Gtk::ALIGN_BOTTOM));
  label->set_markup("<big><b>Passepartout " + std::string(VERSION) 
		    + "</b></big>"
		    "\nCopyright &#169; 2002 - 2004,"
		    " Fredrik Arnerup &amp; Rasmus Kaj");
  label->set_selectable();
  message->pack_start(*label);

  label =
    manage(new Gtk::Label("", Gtk::JUSTIFY_LEFT, Gtk::ALIGN_TOP));
  label->set_markup("<u><span foreground=\"blue\">" + homepage + 
		    "</span></u>");
  Gtk::Button *webpage = manage(new Gtk::Button());
  webpage->add(*label);
  webpage->set_relief(Gtk::RELIEF_NONE);
  webpage->set_border_width(0);
  webpage->signal_clicked().connect(sigc::ptr_fun(&Programs::open_homepage));
  message->pack_start(*webpage, Gtk::PACK_SHRINK);

  label =
    manage(new Gtk::Label("", Gtk::JUSTIFY_LEFT, Gtk::ALIGN_TOP));
  label->set_markup("<u><span foreground=\"blue\">" + mail_address
                    + "</span></u>");
  Gtk::Button *mail = manage(new Gtk::Button());
  mail->add(*label);
  mail->set_relief(Gtk::RELIEF_NONE);
  mail->set_border_width(0);
  mail->signal_clicked().connect
    (sigc::bind(sigc::ptr_fun(&Programs::open_url), "mailto:" + mail_address));
  message->pack_start(*mail, Gtk::PACK_SHRINK);

  label =
    manage(new Gtk::Label("", Gtk::JUSTIFY_LEFT, Gtk::ALIGN_BOTTOM));
  label->set_markup("\nBuild date: " + std::string(builddate) + "\n"
                    "GNOME support: " + (have_gnome ? "yes" : "no"));
  label->set_selectable();
  message->pack_start(*label, Gtk::PACK_SHRINK);

  add_button(Gtk::Stock::CLOSE, Gtk::RESPONSE_CLOSE)->grab_focus();

  // Credits
  Gtk::ScrolledWindow *scroller = manage(new Gtk::ScrolledWindow());
  scroller->set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
  label = manage(new Gtk::Label(Glib::ustring("\n") + authors));
  scroller->add(*label);
  label->set_selectable();

  // Notebook
  Gtk::Notebook *book = manage(new Gtk::Notebook());
  book->append_page(*hbox, *manage(new Gtk::Label("_Info", 
						  0.0, 0.5, true)));
  book->append_page(*scroller, *manage(new Gtk::Label("_Credits", 
						      0.0, 0.5, true)));
  get_vbox()->pack_start(*book);
  show_all_children();
}

AboutDialog &AboutDialog::instance() {
  if(!_instance)
    _instance = new AboutDialog(); 
  return *_instance;
}

void AboutDialog::on_response(int response_id) {
  hide();
}
