:+1::tada: Hello, and thanks for contributing to
[GNSS-SDR](https://gnss-sdr.org)! :tada::+1:

<!-- prettier-ignore-start -->
[comment]: # (
SPDX-License-Identifier: GPL-3.0-or-later
)

[comment]: # (
SPDX-FileCopyrightText: 2011-2021 Carles Fernandez-Prades <carles.fernandez@cttc.es>
)
<!-- prettier-ignore-end -->

Any code contributions going into GNSS-SDR will become part of a GPL-licensed,
open source repository. It is therefore imperative that code submissions belong
to the authors, and that submitters have the authority to merge that code into
the public GNSS-SDR codebase.

For that purpose, we use the
[Developer's Certificate of Origin](https://github.com/gnss-sdr/gnss-sdr/blob/next/.github/DCO.txt).
It is the same document used by other projects. Signing the DCO states that
there are no legal reasons to not merge your code.

To sign the DCO, suffix your git commits with a `Signed-off-by:` line. When
using the command line, you can use `git commit -s` to automatically add this
line. If there were multiple authors of the code, or other types of
stakeholders, make sure that all are listed, each with a separate
`Signed-off-by:` line.

Before submitting your pull request, please make sure the following is done:

1.  You undertake the
    [Contributor Covenant Code of Conduct](https://github.com/gnss-sdr/gnss-sdr/blob/main/CODE_OF_CONDUCT.md).
2.  You have read the
    [Developer's Certificate of Origin](https://github.com/gnss-sdr/gnss-sdr/blob/next/.github/DCO.txt)
    and
    [signed your commits](https://gnss-sdr.org/docs/tutorials/using-git/#sign-your-commits)
    as an indication of fulfillment.
3.  You have read the
    [Contributing Guidelines](https://github.com/gnss-sdr/gnss-sdr/blob/main/CONTRIBUTING.md).
4.  You have read the [coding style guide](https://gnss-sdr.org/coding-style/).
    Specifically, you have read
    [about clang-format](https://gnss-sdr.org/coding-style/#use-tools-for-automated-code-formatting)
    and [about clang-tidy](https://gnss-sdr.org/coding-style/#use-code-linters),
    and you have applied those tools to your changes.
5.  You have forked the
    [gnss-sdr upstream repository](https://github.com/gnss-sdr/gnss-sdr) and
    have created your branch from `next` (or any other currently living branch
    in the upstream repository).
6.  Please include a description of your changes here.

**Please feel free to delete this line and the above text once you have read it
and in case you want to go on with your pull request, and explain your intend
below.**
