static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include <stdlib.h>                                                           \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_int (x, _(\"Width\"), 16)                                            \n"
"    description (_(\"Horizontal width of cells pixels\"))                     \n"
"    value_range (1, G_MAXINT)                                                 \n"
"    ui_range    (1, 256)                                                      \n"
"    ui_gamma    (1.5)                                                         \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"    ui_meta     (\"axis\", \"x\")                                             \n"
"                                                                              \n"
"property_int (y, _(\"Height\"), 16)                                           \n"
"    description (_(\"Vertical width of cells pixels\"))                       \n"
"    value_range (1, G_MAXINT)                                                 \n"
"    ui_range    (1, 256)                                                      \n"
"    ui_gamma    (1.5)                                                         \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"    ui_meta     (\"axis\", \"y\")                                             \n"
"                                                                              \n"
"property_int (x_offset, _(\"Offset X\"), 0.0)                                 \n"
"    description (_(\"Horizontal offset (from origin) for start of grid\"))    \n"
"    ui_range    (-128, 128)                                                   \n"
"    ui_meta     (\"unit\", \"pixel-coordinate\")                              \n"
"    ui_meta     (\"axis\", \"x\")                                             \n"
"                                                                              \n"
"property_int (y_offset, _(\"Offset Y\"), 0)                                   \n"
"    description (_(\"Vertical offset (from origin) for start of grid\"))      \n"
"    ui_range    (-128, 128)                                                   \n"
"    ui_meta     (\"unit\", \"pixel-coordinate\")                              \n"
"    ui_meta     (\"axis\", \"y\")                                             \n"
"                                                                              \n"
"property_color  (color1, _(\"Color 1\"), \"black\")                           \n"
"    description (_(\"The first cell color\"))                                 \n"
"    ui_meta     (\"role\", \"color-primary\")                                 \n"
"                                                                              \n"
"property_color  (color2, _(\"Color 2\"), \"white\")                           \n"
"    description (_(\"The second cell color\"))                                \n"
"    ui_meta     (\"role\", \"color-secondary\")                               \n"
"                                                                              \n"
"property_format (format, _(\"Babl Format\"), NULL)                            \n"
"    description ( _(\"The babl format of the output\"))                       \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_RENDER                                                  \n"
"#define GEGL_OP_C_SOURCE checkerboard.c                                       \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <gegl-buffer-cl-iterator.h>                                          \n"
"#include <gegl-debug.h>                                                       \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  if (o->format)                                                              \n"
"    gegl_operation_set_format (operation, \"output\", o->format);             \n"
"  else                                                                        \n"
"    gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  return gegl_rectangle_infinite_plane ();                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#define TILE_INDEX(coordinate,stride) \\                                      \n"
"  (((coordinate) >= 0)?\\                                                     \n"
"      (coordinate) / (stride):\\                                              \n"
"      ((((coordinate) + 1) /(stride)) - 1))                                   \n"
"                                                                              \n"
"                                                                              \n"
"#include \"opencl/checkerboard.cl.h\"                                         \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"                                                                              \n"
"static gboolean                                                               \n"
"checkerboard_cl_process (GeglOperation       *operation,                      \n"
"                         cl_mem               out_tex,                        \n"
"                         size_t               global_worksize,                \n"
"                         const GeglRectangle *roi,                            \n"
"                         gint                 level)                          \n"
"{                                                                             \n"
"  GeglProperties *o         = GEGL_PROPERTIES (operation);                    \n"
"  const Babl   *out_format  = gegl_operation_get_format (operation, \"output\");\n"
"  const size_t  gbl_size[2] = {roi->width, roi->height};                      \n"
"  const size_t  gbl_offs[2] = {roi->x, roi->y};                               \n"
"  cl_int        cl_err      = 0;                                              \n"
"  float         color1[4];                                                    \n"
"  float         color2[4];                                                    \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"  {                                                                           \n"
"    const char *kernel_name[] = {\"kernel_checkerboard\", NULL};              \n"
"    cl_data = gegl_cl_compile_and_build (checkerboard_cl_source, kernel_name);\n"
"                                                                              \n"
"    if (!cl_data)                                                             \n"
"      return TRUE;                                                            \n"
"  }                                                                           \n"
"                                                                              \n"
"  gegl_color_get_pixel (o->color1, out_format, color1);                       \n"
"  gegl_color_get_pixel (o->color2, out_format, color2);                       \n"
"                                                                              \n"
"  cl_err = gegl_cl_set_kernel_args (cl_data->kernel[0],                       \n"
"                                    sizeof(cl_mem), &out_tex,                 \n"
"                                    sizeof(color1), &color1,                  \n"
"                                    sizeof(color2), &color2,                  \n"
"                                    sizeof(cl_int), &o->x,                    \n"
"                                    sizeof(cl_int), &o->y,                    \n"
"                                    sizeof(cl_int), &o->x_offset,             \n"
"                                    sizeof(cl_int), &o->y_offset,             \n"
"                                    NULL);                                    \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel (gegl_cl_get_command_queue (),         \n"
"                                        cl_data->kernel[0], 2,                \n"
"                                        gbl_offs, gbl_size, NULL,             \n"
"                                        0, NULL, NULL);                       \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"error:                                                                        \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static gboolean                                                               \n"
"checkerboard_process_simple (GeglOperation       *operation,                  \n"
"                             void                *out_buf,                    \n"
"                             glong                n_pixels,                   \n"
"                             const GeglRectangle *roi,                        \n"
"                             gint                 level)                      \n"
"{                                                                             \n"
"  gint        factor = 1 << level;                                            \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  const Babl *out_format = gegl_operation_get_format (operation, \"output\"); \n"
"                                                                              \n"
"  gint        pixel_size = babl_format_get_bytes_per_pixel (out_format);      \n"
"  guchar     *out_pixel = out_buf;                                            \n"
"  void       *color1 = alloca(pixel_size);                                    \n"
"  void       *color2 = alloca(pixel_size);                                    \n"
"                                                                              \n"
"  gint        x = roi->x; /* initial x                   */                   \n"
"  gint        y = roi->y; /*           and y coordinates */                   \n"
"                                                                              \n"
"  gegl_color_get_pixel (o->color1, out_format, color1);                       \n"
"  gegl_color_get_pixel (o->color2, out_format, color2);                       \n"
"                                                                              \n"
"  while (n_pixels--)                                                          \n"
"    {                                                                         \n"
"      gint nx,ny;                                                             \n"
"                                                                              \n"
"      if ((x - o->x_offset) < 0)                                              \n"
"        {                                                                     \n"
"          nx = div (x - o->x_offset + 1, o->x / factor).quot;                 \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          nx = div (x - o->x_offset, o->x / factor).quot;                     \n"
"        }                                                                     \n"
"                                                                              \n"
"      if ((y - o->y_offset) < 0)                                              \n"
"        {                                                                     \n"
"          ny = div (y - o->y_offset + 1, o->y / factor).quot;                 \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          ny = div (y - o->y_offset, o->y / factor).quot;                     \n"
"        }                                                                     \n"
"                                                                              \n"
"      /* shift negative cell indices */                                       \n"
"      nx -= (x - o->x_offset) < 0 ? 1 : 0;                                    \n"
"      ny -= (y - o->y_offset) < 0 ? 1 : 0;                                    \n"
"                                                                              \n"
"      if ( (nx+ny) % 2 == 0)                                                  \n"
"        memcpy (out_pixel, color1, pixel_size);                               \n"
"      else                                                                    \n"
"        memcpy (out_pixel, color2, pixel_size);                               \n"
"                                                                              \n"
"      out_pixel += pixel_size;                                                \n"
"                                                                              \n"
"      /* update x and y coordinates */                                        \n"
"      x++;                                                                    \n"
"      if (x>=roi->x + roi->width)                                             \n"
"        {                                                                     \n"
"          x=roi->x;                                                           \n"
"          y++;                                                                \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"checkerboard_process (GeglOperation       *operation,                         \n"
"                      void                *out_buf,                           \n"
"                      glong                n_pixels,                          \n"
"                      const GeglRectangle *roi,                               \n"
"                      gint                 level)                             \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  const Babl *out_format = gegl_operation_get_format (operation, \"output\"); \n"
"  gint        pixel_size = babl_format_get_bytes_per_pixel (out_format);      \n"
"  guchar     *out_pixel = out_buf;                                            \n"
"  void       *color1 = alloca(pixel_size);                                    \n"
"  void       *color2 = alloca(pixel_size);                                    \n"
"  gint        y;                                                              \n"
"  const gint  x_min = roi->x - o->x_offset;                                   \n"
"  const gint  y_min = roi->y - o->y_offset;                                   \n"
"  const gint  x_max = roi->x + roi->width - o->x_offset;                      \n"
"  const gint  y_max = roi->y + roi->height - o->y_offset;                     \n"
"                                                                              \n"
"  const gint  square_width  = o->x;                                           \n"
"  const gint  square_height = o->y;                                           \n"
"                                                                              \n"
"  if (level)                                                                  \n"
"    return checkerboard_process_simple (operation, out_buf, n_pixels, roi, level);\n"
"                                                                              \n"
"  gegl_color_get_pixel (o->color1, out_format, color1);                       \n"
"  gegl_color_get_pixel (o->color2, out_format, color2);                       \n"
"                                                                              \n"
"  for (y = y_min; y < y_max; y++)                                             \n"
"    {                                                                         \n"
"      gint  x = x_min;                                                        \n"
"      void *cur_color;                                                        \n"
"                                                                              \n"
"      /* Figure out which box we're in */                                     \n"
"      gint tilex = TILE_INDEX (x, square_width);                              \n"
"      gint tiley = TILE_INDEX (y, square_height);                             \n"
"      if ((tilex + tiley) % 2 == 0)                                           \n"
"        cur_color = color1;                                                   \n"
"      else                                                                    \n"
"        cur_color = color2;                                                   \n"
"                                                                              \n"
"      while (x < x_max)                                                       \n"
"        {                                                                     \n"
"          /* Figure out how long this stripe is */                            \n"
"          gint count;                                                         \n"
"          gint stripe_end = (TILE_INDEX (x, square_width) + 1) * square_width;\n"
"               stripe_end = stripe_end > x_max ? x_max : stripe_end;          \n"
"                                                                              \n"
"          count = stripe_end - x;                                             \n"
"                                                                              \n"
"          gegl_memset_pattern (out_pixel, cur_color, pixel_size, count);      \n"
"          out_pixel += count * pixel_size;                                    \n"
"          x = stripe_end;                                                     \n"
"                                                                              \n"
"          if (cur_color == color1)                                            \n"
"            cur_color = color2;                                               \n"
"          else                                                                \n"
"            cur_color = color1;                                               \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static gboolean                                                               \n"
"operation_source_process (GeglOperation       *operation,                     \n"
"                          GeglBuffer          *output,                        \n"
"                          const GeglRectangle *result,                        \n"
"                          gint                 level)                         \n"
"{                                                                             \n"
"  const Babl *out_format = gegl_operation_get_format (operation, \"output\"); \n"
"                                                                              \n"
"  if ((result->width > 0) && (result->height > 0))                            \n"
"    {                                                                         \n"
"      GeglBufferIterator *iter;                                               \n"
"      if (gegl_operation_use_opencl (operation) &&                            \n"
"          babl_format_get_n_components (out_format) == 4 &&                   \n"
"          babl_format_get_type (out_format, 0) == babl_type (\"float\"))      \n"
"        {                                                                     \n"
"          GeglBufferClIterator *cl_iter;                                      \n"
"          gboolean err;                                                       \n"
"                                                                              \n"
"          GEGL_NOTE (GEGL_DEBUG_OPENCL, \"GEGL_OPERATION_POINT_RENDER: %s\", GEGL_OPERATION_GET_CLASS (operation)->name);\n"
"                                                                              \n"
"          cl_iter = gegl_buffer_cl_iterator_new (output, result, out_format, GEGL_CL_BUFFER_WRITE);\n"
"                                                                              \n"
"          while (gegl_buffer_cl_iterator_next (cl_iter, &err) && !err)        \n"
"            {                                                                 \n"
"              err = checkerboard_cl_process (operation, cl_iter->tex[0], cl_iter->size[0], &cl_iter->roi[0], level);\n"
"                                                                              \n"
"              if (err)                                                        \n"
"                {                                                             \n"
"                  gegl_buffer_cl_iterator_stop (cl_iter);                     \n"
"                  break;                                                      \n"
"                }                                                             \n"
"            }                                                                 \n"
"                                                                              \n"
"          if (err)                                                            \n"
"            GEGL_NOTE (GEGL_DEBUG_OPENCL, \"Error: %s\", GEGL_OPERATION_GET_CLASS (operation)->name);\n"
"          else                                                                \n"
"            return TRUE;                                                      \n"
"        }                                                                     \n"
"                                                                              \n"
"      iter = gegl_buffer_iterator_new (output, result, level, out_format,     \n"
"                                       GEGL_ACCESS_WRITE, GEGL_ABYSS_NONE);   \n"
"                                                                              \n"
"      while (gegl_buffer_iterator_next (iter))                                \n"
"        checkerboard_process (operation, iter->data[0], iter->length, &iter->roi[0], level);\n"
"    }                                                                         \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationSourceClass      *source_class;                                \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  source_class = GEGL_OPERATION_SOURCE_CLASS (klass);                         \n"
"                                                                              \n"
"  source_class->process = operation_source_process;                           \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",               \"gegl:checkerboard\",                            \n"
"    \"categories\",         \"render\",                                       \n"
"    \"title\",              _(\"Checkerboard\"),                              \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"description\",        _(\"Create a checkerboard pattern\"),             \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
