#!/usr/bin/env python

# $Id: setup.py.in,v 1.1.1.1 2003/02/08 00:42:17 dairiki Exp $
#
# Copyright (C) 2003  Geoffrey T. Dairiki <dairiki@dairiki.org>
#
# This file is part of Pyxine, Python bindings for xine.
#
# Pyxine is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# Pyxine is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


# Check version of python
try:
    import sys
    if sys.version_info[0] < 2:
        raise Exception
except Exception:
    print "You need python version 2.x (or higher) to run this"
    sys.exit(1)
    

libxine_src  = "pyxine/libxine_wrap.c".split(' ')
pxlib_src    = "pxlib/Mutex.cc pxlib/Thread.cc pxlib/XDisplay.cc pxlib/Traits.cc pxlib/Callback.cc pxlib/Geometry.cc pxlib/WindowList.cc pxlib/PxWindow.cc pxlib/pxlib_wrap.cc".split(' ')
xine_libs    = "xine z pthread Xext".split(' ')
xine_libpath = "/usr/lib /usr/X11R6/lib".split(' ')

from distutils.core import setup, Extension

long_description="""Pyxine is a Python package which provides bindings
to libxine, the back-end of the xine move player.  Using pyxine it is
possible to write simple (or complex) movie players in the Python language.
"""

setup(name="pyxine",
      version="0.1alpha2",
      description="Python bindings for the xine media player",
      long_description=long_description,
      license="GPL",
      platforms=['linux2', '<probably others>'],
      keywords=["xine","multimedia","video player"],
      author="Geoffrey T. Dairiki",
      author_email="dairiki@dairiki.org",
      url="http://pyxine.sourceforge.net/",
      packages=['pyxine'],
      ext_package="pyxine",
      ext_modules=[ Extension("libxine", libxine_src,
                              library_dirs = xine_libpath,
                              libraries = xine_libs),
                    Extension("pxlibc", pxlib_src,
                              library_dirs = xine_libpath,
                              libraries = xine_libs + ['stdc++'])
                    ]
      )

# Local Variables:
# mode: python
# End:
