import torch

from torch_geometric.data import Data
from torch_geometric.transforms import Distance


def test_distance():
    assert str(Distance()) == 'Distance(norm=True, max_value=None)'

    pos = torch.tensor([[-1.0, 0.0], [0.0, 0.0], [2.0, 0.0]])
    edge_index = torch.tensor([[0, 1, 1, 2], [1, 0, 2, 1]])
    edge_attr = torch.tensor([1.0, 1.0, 1.0, 1.0])

    data = Data(edge_index=edge_index, pos=pos)
    data = Distance(norm=False)(data)
    assert len(data) == 3
    assert data.pos.tolist() == pos.tolist()
    assert data.edge_index.tolist() == edge_index.tolist()
    assert data.edge_attr.tolist() == [[1.0], [1.0], [2.0], [2.0]]

    data = Data(edge_index=edge_index, pos=pos, edge_attr=edge_attr)
    data = Distance(norm=True)(data)
    assert len(data) == 3
    assert data.pos.tolist() == pos.tolist()
    assert data.edge_index.tolist() == edge_index.tolist()
    assert data.edge_attr.tolist() == [
        [1.0, 0.5],
        [1.0, 0.5],
        [1.0, 1.0],
        [1.0, 1.0],
    ]
