# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class QueryKey(Model):
    """Describes an API key for a given Azure Search service that has permissions
    for query operations only.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The name of the query API key; may be empty.
    :vartype name: str
    :ivar key: The value of the query API key.
    :vartype key: str
    """

    _validation = {
        'name': {'readonly': True},
        'key': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(QueryKey, self).__init__(**kwargs)
        self.name = None
        self.key = None
