#! /bin/sh

# run tests, ignore the ones which cannot be executed on buildd, allow timeouts
# and make sure that a sub-failure is detected as failure by the build scripts.
# Don't stop when a single sub-test failed to get all errors
#
# these features are currently not supported by the upstream build tests

PYTHON=${1:-python}

err=0
for t in sdl2/test/*_test.py; do
	# buildd don't have the necessary hardware acceleration for this test
	if [ "${t}" = "sdl2/test/render_test.py" ]; then
		continue
	fi

	timeout --kill-after=180s 120s "${PYTHON}" -B -m sdl2.test.util.runtests -f "${t}"
	ret="${?}"
	if [ "${ret}" != "0" ]; then
		err="${ret}"
	fi
done
exit "${err}"
