//
//  MyDocument.m
//  PRICE
//
//  Created by Riccardo Mottola on Thu Dec 12 2002.
//  Copyright (c) 2002-2010 Carduus. All rights reserved.
//
// This application is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

#import "MyDocument.h"
#include <limits.h>

#import "PRGrayscaleFilter.h"
#import "PRInvert.h"
#import "PRConvolve55.h"
#import "PRTransforms.h"
#import "PRFourier.h"
#import "PRDFTLowPass.h"
#import "PRDFTHighPass.h"
#import "PREqualize.h"
#import "PRTraceEdges.h"
#import "PRCustTraceEdges.h"
#import "PRMedian.h"
#import "PRScale.h"
#import "PRCrop.h"
#import "PRBriCon.h"
#import "PRCurves.h"

@implementation MyDocument


- (NSData *)dataRepresentationOfType:(NSString *)aType
{
    // Insert code here to write your document from the given data.  You can also choose to override -fileWrapperRepresentationOfType: or -writeToFile:ofType: instead.
    return [activeImage TIFFRepresentation];
}

- (BOOL)loadDataRepresentation:(NSData *)data ofType:(NSString *)aType
{
    PRImage *tempImage;
    
    tempImage = [[PRImage alloc] initWithData:data];
    if (tempImage != nil)
    {
        NSBitmapImageRep *tmpImageRep;
        PRImage *newImage;
        NSBitmapImageRep *newImageRep;
        unsigned char *dataPtr;
        unsigned char *dataPtr2;
        unsigned int k;
        unsigned int w, h, s;
        BOOL convertColorSpace;
        BOOL convertPlanar;
        int destSamplesPerPixel;

        /* if the loaded image is in BlackColorSpace we convert it to WhiteColorSpace */
        /* which is the only TIFF rep used internally and generated by PRICE */
        /* we also need to convert Planar images into a meshed configuration */
        tmpImageRep = [[tempImage representations] objectAtIndex: 0];
        w = [tmpImageRep pixelsWide];
        h = [tmpImageRep pixelsHigh];
        destSamplesPerPixel = 1;
        convertColorSpace = [[tmpImageRep colorSpaceName] isEqualToString: NSCalibratedBlackColorSpace] || [[tmpImageRep colorSpaceName] isEqualToString: NSDeviceBlackColorSpace];
        convertPlanar = [tmpImageRep isPlanar];
        if (convertColorSpace || convertPlanar)
        {
            /* converting the colorspace */
            newImage = [[PRImage alloc] initWithSize:NSMakeSize(w, h)];
            newImageRep = [[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                                  pixelsWide:w
                                  pixelsHigh:h
                               bitsPerSample:8
                             samplesPerPixel:destSamplesPerPixel
                                    hasAlpha:NO
                                    isPlanar:NO
                              colorSpaceName:NSCalibratedWhiteColorSpace
                                 bytesPerRow:w*destSamplesPerPixel
                                bitsPerPixel:0];
            s = w * h;
            dataPtr = [tmpImageRep bitmapData];
            dataPtr2 = [newImageRep bitmapData];
            if (convertPlanar)
            {
                int x, y;
                int xp;
                if (convertColorSpace)
                {
                    for (y = 0; y < h; y++)
                    {
                        xp = 0;
                        for (x = 0; x < w*3; x += 3)
                        {
                            dataPtr2[y*(w*3) + x] = UCHAR_MAX - dataPtr[y*w + x];
                            dataPtr2[y*(w*3) + x + 1] = UCHAR_MAX - dataPtr[y*w*2 + x];
                            dataPtr2[y*(w*3) + x + 2] = UCHAR_MAX - dataPtr[y*w*3 + x];
                            xp++;
                        }
                    }                            
                } else
                {
                    for (y = 0; y < h; y++)
                    {
                        xp = 0;
                        for (x = 0; x < w*3; x += 3)
                        {
                            dataPtr2[y*(w*3) + x] = dataPtr[y*w + x];
                            dataPtr2[y*(w*3) + x + 1] = dataPtr[y*w*2 + x];
                            dataPtr2[y*(w*3) + x + 2] = dataPtr[y*w*3 + x];
                            xp++;
                        }
                    }

                }
            } else
            {
                if (convertColorSpace)
                {
                    for (k = 0; k < s; k++)
                        *dataPtr2++ = UCHAR_MAX - *dataPtr++;
                } else
                {
                    /* shall never happen */
                    NSLog(@"Internal error: tried to convert image when it wasn't necessary");
                }                
            }
            [newImageRep setColorSpaceName:NSCalibratedWhiteColorSpace];
            [newImage addRepresentation:newImageRep];
            [newImageRep release];
            [tempImage release];
            tempImage = newImage;
        }
    }

    oldImage = nil;
    /* returns a bool to be able to know if loading was successul */
    if (tempImage != nil)
    {
        /* we setActiveImage won't set the image info yet (why?)  */
        [self setActiveImage:tempImage];
        [tempImage release];
        return YES;
    } else
        return NO;
}


- (IBAction)saveDocumentAs:(id)sender
/* we override the super class to change the extensionand type of the file */
{
    NSString *filepath;
    
    filepath = [self fileName];
    filepath = [[filepath stringByDeletingPathExtension] stringByAppendingString: @".tiff"];
    [self setFileName:filepath];
    [self setFileType: @"tiff"];
    [super saveDocumentAs: sender];
}

- (void)makeWindowControllers
/* instantiate PRWindowController */
{
    windowController = [[PRWindowController alloc] initWithWindowNibName:@"PRWindow"];
    [self addWindowController:windowController];
    
    /* set undo levels */
    [[self undoManager] setLevelsOfUndo:1];
}

- (NSWindow *)window
{
    return [windowController window];
}

- (NSView *)view
{
    return [windowController view];
}

- (PRImage *)activeImage
/* method to access the active image */
{
    return activeImage;
}

- (void)setActiveImage: (PRImage *)theImage
/* method to set the active image */
{
    if (activeImage != nil)
        [activeImage release];
    activeImage = [theImage retain];
    /* window controller is still nil here the first time we load an image
     * thus the info must be manually set after the nib finished loading */
    [windowController setImageToDraw:activeImage];
}

- (void)copy:(id)sender
{
    NSPasteboard *pboard;

    pboard = [NSPasteboard generalPasteboard];

    [pboard declareTypes:[NSArray arrayWithObjects:NSTIFFPboardType, nil] owner:nil];
    [pboard setData:[activeImage TIFFRepresentation] forType:NSTIFFPboardType];
}

- (void)paste:(id)sender
{
    NSUndoManager *uMgr;
    NSPasteboard  *pboard;
    NSString      *type;
    NSData        *tempData;
    PRImage       *tempImage;

    pboard = [NSPasteboard generalPasteboard];
    type = [pboard availableTypeFromArray:[NSArray arrayWithObjects:NSTIFFPboardType, nil]];

    if (type != nil)
    {
        if ([type isEqualToString:NSTIFFPboardType])
        {
            /* get the clipboard data */
            tempData = [pboard dataForType:NSTIFFPboardType];
            if (tempData != nil)
            {
                uMgr = [self undoManager];
                /* save the method on the undo stack */
                [[uMgr prepareWithInvocationTarget: self] restoreLastImage];
                [uMgr setActionName:@"Paste"];

                /* save the current image */
                [self saveCurrentImage];

                tempImage = [[PRImage alloc] initWithData:tempData];
                [self setActiveImage: tempImage];
                [tempImage release];
                [[windowController view] setFrameSize:[activeImage size]];
                [[windowController view] setNeedsDisplay:YES];
            } else
            {
                /* guidelines say I should put a panel */
                /* #### fixme */
                NSLog(@"something went wrong in paste");
            }
        } else
            NSLog(@"received a paste of unhandled type: %@", type);
    }
}

- (void)runFilter:(PRFilter *)filter with:(NSArray *)parameters
{
    NSUndoManager *uMgr;
    PRCProgress   *filterProgr;
    
    uMgr = [self undoManager];
    /* save the method on the undo stack */
    [[uMgr prepareWithInvocationTarget: self] restoreLastImage];
    [uMgr setActionName:[filter actionName]];
    
    filterProgr = nil;
    if ([filter displayProgress])
    {
        filterProgr = [[PRCProgress alloc] init];
        [filterProgr showProgress:self];
        [filterProgr setTitle: [filter actionName]];
    }
    
    /* save the current image */
    [self saveCurrentImage];

    /* instantiate and run the filter */
    [self setActiveImage: [filter filterImage: activeImage with:parameters progressPanel:filterProgr]];
    
    [filterProgr release];
    
    /* reset the selected zoom ration, this will also cause a view update */
    [windowController scaleImage];
}

- (void)restoreLastImage
{
    PRImage *tempImage;
    
    tempImage = [[PRImage alloc] initWithData: [activeImage TIFFRepresentation]];
    [self setActiveImage: oldImage];
    [oldImage release];
    oldImage = tempImage;
    [[[self undoManager] prepareWithInvocationTarget: self] restoreLastImage];
    [[windowController view] setFrameSize:[activeImage size]];
    [windowController scaleImage];
    [[windowController view] setNeedsDisplay:YES];
}

- (void)saveCurrentImage
{
    if (activeImage != nil)
    {
        if (oldImage != nil)
            [oldImage release];
        oldImage = [[PRImage alloc] initWithData: [activeImage TIFFRepresentation]];
    }
}

- (void)dealloc
{
    [activeImage release];
    [windowController release];
    [super dealloc];
}


- (void)setPrintInfo:(NSPrintInfo *)anObject
{
    if (printInfo != anObject)
    {
        [printInfo autorelease];
        printInfo = [anObject copyWithZone:[self zone]];
    }
}

- (NSPrintInfo *)printInfo
{
    if (printInfo == nil)
    {
        [self setPrintInfo:[NSPrintInfo sharedPrintInfo]];
        [printInfo setHorizontallyCentered:YES];
        [printInfo setVerticallyCentered:YES];
        [printInfo setLeftMargin:5.0];
        [printInfo setRightMargin:5.0];
        [printInfo setTopMargin:5.0];
        [printInfo setBottomMargin:5.0];
    }
    return printInfo;
}


- (void)printShowingPrintPanel:(BOOL)showPanels
{
    NSPrintOperation *op = [NSPrintOperation printOperationWithView:[windowController view] printInfo:[self printInfo]];
    [op setShowPanels:showPanels];
    [op runOperationModalForWindow:[self window] delegate:nil didRunSelector:NULL contextInfo:NULL];
}


@end
