#ifndef _FIND_RANDOM_SEQUENCE_HPP_
#define _FIND_RANDOM_SEQUENCE_HPP_

#include <vector>
#include "DNASequence.hpp"
#include "statistics/StatUtils.hpp"


template<typename T_Sequence>
void FindRandomPos(vector<T_Sequence> &sequences, DNALength &seqIndex, DNALength &seqPos, DNALength seqLength=0 ) {
    vector<UInt> cumulativeLengths;
    cumulativeLengths.resize(sequences.size());
    int i;
    if (sequences.size() == 0) {
        return;
    }
    DNALength cumulativeLength;
    cumulativeLengths[0] = sequences[0].length;
    cumulativeLength = cumulativeLengths[0];
    for (i = 1; i < sequences.size(); i++) {
        cumulativeLengths[i] = cumulativeLength = cumulativeLengths[i-1] + sequences[i].length;
    }
    bool validPosFound = false;
    int iter = 0;
    int max_iter = 100000;
    while (validPosFound == false and iter < max_iter) {
        ++iter;
        if (seqLength > cumulativeLength) {
            validPosFound = false;
            iter = max_iter;
            break;
        }
        DNALength pos = RandomUnsignedInt(cumulativeLength - seqLength);
        // Make sure this sequence fits 
        for (seqIndex = 0; seqIndex < sequences.size(); seqIndex++) {
            if (cumulativeLengths[seqIndex] > pos) break;
        }
        if (cumulativeLengths[seqIndex] - pos < seqLength) {
            continue;
        }
        UInt pi;
        if (seqIndex == 0) {
            seqPos = pos;
        }
        else {
            seqPos = pos - cumulativeLengths[seqIndex-1];
        }
        bool seqContainsN = false;
        for (pi = seqPos; pi < seqPos + seqLength; pi++) {
            if (toupper(sequences[seqIndex].seq[pi]) == 'N') {
                seqContainsN = true;
                break;
            }
        }
        if (seqContainsN) {
            continue;
        }
        else {
            validPosFound = true;
        }
    }
    if (iter == max_iter) {
        cout << "ERROR! Unable to generate a random seq/pos pair!, maybe length " << seqLength << endl
            << " is too high, or there are too many N's in the references." << endl;
        exit(1);
    }
}


#endif
