// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotroborunner

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateDestination = "CreateDestination"

// CreateDestinationRequest generates a "aws/request.Request" representing the
// client's request for the CreateDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDestination for more information on using the CreateDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDestinationRequest method.
//	req, resp := client.CreateDestinationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/CreateDestination
func (c *IoTRoboRunner) CreateDestinationRequest(input *CreateDestinationInput) (req *request.Request, output *CreateDestinationOutput) {
	op := &request.Operation{
		Name:       opCreateDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/createDestination",
	}

	if input == nil {
		input = &CreateDestinationInput{}
	}

	output = &CreateDestinationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDestination API operation for AWS IoT RoboRunner.
//
// # Grants permission to create a destination
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT RoboRunner's
// API operation CreateDestination for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Exception thrown if a resource in a create request already exists.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     Exception thrown if an invalid parameter is provided to an API.
//
//   - ResourceNotFoundException
//     Exception thrown if a resource referenced in the request doesn't exist.
//
//   - ThrottlingException
//     Exception thrown if the api has been called too quickly be the client.
//
//   - InternalServerException
//     Exception thrown if something goes wrong within the service.
//
//   - ServiceQuotaExceededException
//     Exception thrown if the user's AWS account has reached a service limit and
//     the operation cannot proceed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/CreateDestination
func (c *IoTRoboRunner) CreateDestination(input *CreateDestinationInput) (*CreateDestinationOutput, error) {
	req, out := c.CreateDestinationRequest(input)
	return out, req.Send()
}

// CreateDestinationWithContext is the same as CreateDestination with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTRoboRunner) CreateDestinationWithContext(ctx aws.Context, input *CreateDestinationInput, opts ...request.Option) (*CreateDestinationOutput, error) {
	req, out := c.CreateDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSite = "CreateSite"

// CreateSiteRequest generates a "aws/request.Request" representing the
// client's request for the CreateSite operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSite for more information on using the CreateSite
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSiteRequest method.
//	req, resp := client.CreateSiteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/CreateSite
func (c *IoTRoboRunner) CreateSiteRequest(input *CreateSiteInput) (req *request.Request, output *CreateSiteOutput) {
	op := &request.Operation{
		Name:       opCreateSite,
		HTTPMethod: "POST",
		HTTPPath:   "/createSite",
	}

	if input == nil {
		input = &CreateSiteInput{}
	}

	output = &CreateSiteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSite API operation for AWS IoT RoboRunner.
//
// # Grants permission to create a site
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT RoboRunner's
// API operation CreateSite for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Exception thrown if a resource in a create request already exists.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     Exception thrown if an invalid parameter is provided to an API.
//
//   - ThrottlingException
//     Exception thrown if the api has been called too quickly be the client.
//
//   - InternalServerException
//     Exception thrown if something goes wrong within the service.
//
//   - ServiceQuotaExceededException
//     Exception thrown if the user's AWS account has reached a service limit and
//     the operation cannot proceed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/CreateSite
func (c *IoTRoboRunner) CreateSite(input *CreateSiteInput) (*CreateSiteOutput, error) {
	req, out := c.CreateSiteRequest(input)
	return out, req.Send()
}

// CreateSiteWithContext is the same as CreateSite with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSite for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTRoboRunner) CreateSiteWithContext(ctx aws.Context, input *CreateSiteInput, opts ...request.Option) (*CreateSiteOutput, error) {
	req, out := c.CreateSiteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorker = "CreateWorker"

// CreateWorkerRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorker for more information on using the CreateWorker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateWorkerRequest method.
//	req, resp := client.CreateWorkerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/CreateWorker
func (c *IoTRoboRunner) CreateWorkerRequest(input *CreateWorkerInput) (req *request.Request, output *CreateWorkerOutput) {
	op := &request.Operation{
		Name:       opCreateWorker,
		HTTPMethod: "POST",
		HTTPPath:   "/createWorker",
	}

	if input == nil {
		input = &CreateWorkerInput{}
	}

	output = &CreateWorkerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorker API operation for AWS IoT RoboRunner.
//
// # Grants permission to create a worker
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT RoboRunner's
// API operation CreateWorker for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Exception thrown if a resource in a create request already exists.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     Exception thrown if an invalid parameter is provided to an API.
//
//   - ResourceNotFoundException
//     Exception thrown if a resource referenced in the request doesn't exist.
//
//   - ThrottlingException
//     Exception thrown if the api has been called too quickly be the client.
//
//   - InternalServerException
//     Exception thrown if something goes wrong within the service.
//
//   - ServiceQuotaExceededException
//     Exception thrown if the user's AWS account has reached a service limit and
//     the operation cannot proceed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/CreateWorker
func (c *IoTRoboRunner) CreateWorker(input *CreateWorkerInput) (*CreateWorkerOutput, error) {
	req, out := c.CreateWorkerRequest(input)
	return out, req.Send()
}

// CreateWorkerWithContext is the same as CreateWorker with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTRoboRunner) CreateWorkerWithContext(ctx aws.Context, input *CreateWorkerInput, opts ...request.Option) (*CreateWorkerOutput, error) {
	req, out := c.CreateWorkerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkerFleet = "CreateWorkerFleet"

// CreateWorkerFleetRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkerFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkerFleet for more information on using the CreateWorkerFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateWorkerFleetRequest method.
//	req, resp := client.CreateWorkerFleetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/CreateWorkerFleet
func (c *IoTRoboRunner) CreateWorkerFleetRequest(input *CreateWorkerFleetInput) (req *request.Request, output *CreateWorkerFleetOutput) {
	op := &request.Operation{
		Name:       opCreateWorkerFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/createWorkerFleet",
	}

	if input == nil {
		input = &CreateWorkerFleetInput{}
	}

	output = &CreateWorkerFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkerFleet API operation for AWS IoT RoboRunner.
//
// # Grants permission to create a worker fleet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT RoboRunner's
// API operation CreateWorkerFleet for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Exception thrown if a resource in a create request already exists.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     Exception thrown if an invalid parameter is provided to an API.
//
//   - ResourceNotFoundException
//     Exception thrown if a resource referenced in the request doesn't exist.
//
//   - ThrottlingException
//     Exception thrown if the api has been called too quickly be the client.
//
//   - InternalServerException
//     Exception thrown if something goes wrong within the service.
//
//   - ServiceQuotaExceededException
//     Exception thrown if the user's AWS account has reached a service limit and
//     the operation cannot proceed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/CreateWorkerFleet
func (c *IoTRoboRunner) CreateWorkerFleet(input *CreateWorkerFleetInput) (*CreateWorkerFleetOutput, error) {
	req, out := c.CreateWorkerFleetRequest(input)
	return out, req.Send()
}

// CreateWorkerFleetWithContext is the same as CreateWorkerFleet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkerFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTRoboRunner) CreateWorkerFleetWithContext(ctx aws.Context, input *CreateWorkerFleetInput, opts ...request.Option) (*CreateWorkerFleetOutput, error) {
	req, out := c.CreateWorkerFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDestination = "DeleteDestination"

// DeleteDestinationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDestination for more information on using the DeleteDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDestinationRequest method.
//	req, resp := client.DeleteDestinationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/DeleteDestination
func (c *IoTRoboRunner) DeleteDestinationRequest(input *DeleteDestinationInput) (req *request.Request, output *DeleteDestinationOutput) {
	op := &request.Operation{
		Name:       opDeleteDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/deleteDestination",
	}

	if input == nil {
		input = &DeleteDestinationInput{}
	}

	output = &DeleteDestinationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDestination API operation for AWS IoT RoboRunner.
//
// # Grants permission to delete a destination
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT RoboRunner's
// API operation DeleteDestination for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Exception thrown if a resource in a create request already exists.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     Exception thrown if an invalid parameter is provided to an API.
//
//   - ResourceNotFoundException
//     Exception thrown if a resource referenced in the request doesn't exist.
//
//   - ThrottlingException
//     Exception thrown if the api has been called too quickly be the client.
//
//   - InternalServerException
//     Exception thrown if something goes wrong within the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/DeleteDestination
func (c *IoTRoboRunner) DeleteDestination(input *DeleteDestinationInput) (*DeleteDestinationOutput, error) {
	req, out := c.DeleteDestinationRequest(input)
	return out, req.Send()
}

// DeleteDestinationWithContext is the same as DeleteDestination with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTRoboRunner) DeleteDestinationWithContext(ctx aws.Context, input *DeleteDestinationInput, opts ...request.Option) (*DeleteDestinationOutput, error) {
	req, out := c.DeleteDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSite = "DeleteSite"

// DeleteSiteRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSite operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSite for more information on using the DeleteSite
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSiteRequest method.
//	req, resp := client.DeleteSiteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/DeleteSite
func (c *IoTRoboRunner) DeleteSiteRequest(input *DeleteSiteInput) (req *request.Request, output *DeleteSiteOutput) {
	op := &request.Operation{
		Name:       opDeleteSite,
		HTTPMethod: "POST",
		HTTPPath:   "/deleteSite",
	}

	if input == nil {
		input = &DeleteSiteInput{}
	}

	output = &DeleteSiteOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSite API operation for AWS IoT RoboRunner.
//
// # Grants permission to delete a site
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT RoboRunner's
// API operation DeleteSite for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Exception thrown if a resource in a create request already exists.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     Exception thrown if an invalid parameter is provided to an API.
//
//   - ResourceNotFoundException
//     Exception thrown if a resource referenced in the request doesn't exist.
//
//   - ThrottlingException
//     Exception thrown if the api has been called too quickly be the client.
//
//   - InternalServerException
//     Exception thrown if something goes wrong within the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/DeleteSite
func (c *IoTRoboRunner) DeleteSite(input *DeleteSiteInput) (*DeleteSiteOutput, error) {
	req, out := c.DeleteSiteRequest(input)
	return out, req.Send()
}

// DeleteSiteWithContext is the same as DeleteSite with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSite for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTRoboRunner) DeleteSiteWithContext(ctx aws.Context, input *DeleteSiteInput, opts ...request.Option) (*DeleteSiteOutput, error) {
	req, out := c.DeleteSiteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorker = "DeleteWorker"

// DeleteWorkerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorker for more information on using the DeleteWorker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteWorkerRequest method.
//	req, resp := client.DeleteWorkerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/DeleteWorker
func (c *IoTRoboRunner) DeleteWorkerRequest(input *DeleteWorkerInput) (req *request.Request, output *DeleteWorkerOutput) {
	op := &request.Operation{
		Name:       opDeleteWorker,
		HTTPMethod: "POST",
		HTTPPath:   "/deleteWorker",
	}

	if input == nil {
		input = &DeleteWorkerInput{}
	}

	output = &DeleteWorkerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWorker API operation for AWS IoT RoboRunner.
//
// # Grants permission to delete a worker
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT RoboRunner's
// API operation DeleteWorker for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Exception thrown if a resource in a create request already exists.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     Exception thrown if an invalid parameter is provided to an API.
//
//   - ResourceNotFoundException
//     Exception thrown if a resource referenced in the request doesn't exist.
//
//   - ThrottlingException
//     Exception thrown if the api has been called too quickly be the client.
//
//   - InternalServerException
//     Exception thrown if something goes wrong within the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/DeleteWorker
func (c *IoTRoboRunner) DeleteWorker(input *DeleteWorkerInput) (*DeleteWorkerOutput, error) {
	req, out := c.DeleteWorkerRequest(input)
	return out, req.Send()
}

// DeleteWorkerWithContext is the same as DeleteWorker with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTRoboRunner) DeleteWorkerWithContext(ctx aws.Context, input *DeleteWorkerInput, opts ...request.Option) (*DeleteWorkerOutput, error) {
	req, out := c.DeleteWorkerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkerFleet = "DeleteWorkerFleet"

// DeleteWorkerFleetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkerFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkerFleet for more information on using the DeleteWorkerFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteWorkerFleetRequest method.
//	req, resp := client.DeleteWorkerFleetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/DeleteWorkerFleet
func (c *IoTRoboRunner) DeleteWorkerFleetRequest(input *DeleteWorkerFleetInput) (req *request.Request, output *DeleteWorkerFleetOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkerFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/deleteWorkerFleet",
	}

	if input == nil {
		input = &DeleteWorkerFleetInput{}
	}

	output = &DeleteWorkerFleetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWorkerFleet API operation for AWS IoT RoboRunner.
//
// # Grants permission to delete a worker fleet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT RoboRunner's
// API operation DeleteWorkerFleet for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Exception thrown if a resource in a create request already exists.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     Exception thrown if an invalid parameter is provided to an API.
//
//   - ResourceNotFoundException
//     Exception thrown if a resource referenced in the request doesn't exist.
//
//   - ThrottlingException
//     Exception thrown if the api has been called too quickly be the client.
//
//   - InternalServerException
//     Exception thrown if something goes wrong within the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/DeleteWorkerFleet
func (c *IoTRoboRunner) DeleteWorkerFleet(input *DeleteWorkerFleetInput) (*DeleteWorkerFleetOutput, error) {
	req, out := c.DeleteWorkerFleetRequest(input)
	return out, req.Send()
}

// DeleteWorkerFleetWithContext is the same as DeleteWorkerFleet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkerFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTRoboRunner) DeleteWorkerFleetWithContext(ctx aws.Context, input *DeleteWorkerFleetInput, opts ...request.Option) (*DeleteWorkerFleetOutput, error) {
	req, out := c.DeleteWorkerFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDestination = "GetDestination"

// GetDestinationRequest generates a "aws/request.Request" representing the
// client's request for the GetDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDestination for more information on using the GetDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDestinationRequest method.
//	req, resp := client.GetDestinationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/GetDestination
func (c *IoTRoboRunner) GetDestinationRequest(input *GetDestinationInput) (req *request.Request, output *GetDestinationOutput) {
	op := &request.Operation{
		Name:       opGetDestination,
		HTTPMethod: "GET",
		HTTPPath:   "/getDestination",
	}

	if input == nil {
		input = &GetDestinationInput{}
	}

	output = &GetDestinationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDestination API operation for AWS IoT RoboRunner.
//
// # Grants permission to get a destination
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT RoboRunner's
// API operation GetDestination for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     Exception thrown if an invalid parameter is provided to an API.
//
//   - ResourceNotFoundException
//     Exception thrown if a resource referenced in the request doesn't exist.
//
//   - ThrottlingException
//     Exception thrown if the api has been called too quickly be the client.
//
//   - InternalServerException
//     Exception thrown if something goes wrong within the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/GetDestination
func (c *IoTRoboRunner) GetDestination(input *GetDestinationInput) (*GetDestinationOutput, error) {
	req, out := c.GetDestinationRequest(input)
	return out, req.Send()
}

// GetDestinationWithContext is the same as GetDestination with the addition of
// the ability to pass a context and additional request options.
//
// See GetDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTRoboRunner) GetDestinationWithContext(ctx aws.Context, input *GetDestinationInput, opts ...request.Option) (*GetDestinationOutput, error) {
	req, out := c.GetDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSite = "GetSite"

// GetSiteRequest generates a "aws/request.Request" representing the
// client's request for the GetSite operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSite for more information on using the GetSite
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSiteRequest method.
//	req, resp := client.GetSiteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/GetSite
func (c *IoTRoboRunner) GetSiteRequest(input *GetSiteInput) (req *request.Request, output *GetSiteOutput) {
	op := &request.Operation{
		Name:       opGetSite,
		HTTPMethod: "GET",
		HTTPPath:   "/getSite",
	}

	if input == nil {
		input = &GetSiteInput{}
	}

	output = &GetSiteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSite API operation for AWS IoT RoboRunner.
//
// # Grants permission to get a site
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT RoboRunner's
// API operation GetSite for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     Exception thrown if an invalid parameter is provided to an API.
//
//   - ResourceNotFoundException
//     Exception thrown if a resource referenced in the request doesn't exist.
//
//   - ThrottlingException
//     Exception thrown if the api has been called too quickly be the client.
//
//   - InternalServerException
//     Exception thrown if something goes wrong within the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/GetSite
func (c *IoTRoboRunner) GetSite(input *GetSiteInput) (*GetSiteOutput, error) {
	req, out := c.GetSiteRequest(input)
	return out, req.Send()
}

// GetSiteWithContext is the same as GetSite with the addition of
// the ability to pass a context and additional request options.
//
// See GetSite for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTRoboRunner) GetSiteWithContext(ctx aws.Context, input *GetSiteInput, opts ...request.Option) (*GetSiteOutput, error) {
	req, out := c.GetSiteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWorker = "GetWorker"

// GetWorkerRequest generates a "aws/request.Request" representing the
// client's request for the GetWorker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWorker for more information on using the GetWorker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetWorkerRequest method.
//	req, resp := client.GetWorkerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/GetWorker
func (c *IoTRoboRunner) GetWorkerRequest(input *GetWorkerInput) (req *request.Request, output *GetWorkerOutput) {
	op := &request.Operation{
		Name:       opGetWorker,
		HTTPMethod: "GET",
		HTTPPath:   "/getWorker",
	}

	if input == nil {
		input = &GetWorkerInput{}
	}

	output = &GetWorkerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWorker API operation for AWS IoT RoboRunner.
//
// # Grants permission to get a worker
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT RoboRunner's
// API operation GetWorker for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     Exception thrown if an invalid parameter is provided to an API.
//
//   - ResourceNotFoundException
//     Exception thrown if a resource referenced in the request doesn't exist.
//
//   - ThrottlingException
//     Exception thrown if the api has been called too quickly be the client.
//
//   - InternalServerException
//     Exception thrown if something goes wrong within the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/GetWorker
func (c *IoTRoboRunner) GetWorker(input *GetWorkerInput) (*GetWorkerOutput, error) {
	req, out := c.GetWorkerRequest(input)
	return out, req.Send()
}

// GetWorkerWithContext is the same as GetWorker with the addition of
// the ability to pass a context and additional request options.
//
// See GetWorker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTRoboRunner) GetWorkerWithContext(ctx aws.Context, input *GetWorkerInput, opts ...request.Option) (*GetWorkerOutput, error) {
	req, out := c.GetWorkerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWorkerFleet = "GetWorkerFleet"

// GetWorkerFleetRequest generates a "aws/request.Request" representing the
// client's request for the GetWorkerFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWorkerFleet for more information on using the GetWorkerFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetWorkerFleetRequest method.
//	req, resp := client.GetWorkerFleetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/GetWorkerFleet
func (c *IoTRoboRunner) GetWorkerFleetRequest(input *GetWorkerFleetInput) (req *request.Request, output *GetWorkerFleetOutput) {
	op := &request.Operation{
		Name:       opGetWorkerFleet,
		HTTPMethod: "GET",
		HTTPPath:   "/getWorkerFleet",
	}

	if input == nil {
		input = &GetWorkerFleetInput{}
	}

	output = &GetWorkerFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWorkerFleet API operation for AWS IoT RoboRunner.
//
// # Grants permission to get a worker fleet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT RoboRunner's
// API operation GetWorkerFleet for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     Exception thrown if an invalid parameter is provided to an API.
//
//   - ResourceNotFoundException
//     Exception thrown if a resource referenced in the request doesn't exist.
//
//   - ThrottlingException
//     Exception thrown if the api has been called too quickly be the client.
//
//   - InternalServerException
//     Exception thrown if something goes wrong within the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/GetWorkerFleet
func (c *IoTRoboRunner) GetWorkerFleet(input *GetWorkerFleetInput) (*GetWorkerFleetOutput, error) {
	req, out := c.GetWorkerFleetRequest(input)
	return out, req.Send()
}

// GetWorkerFleetWithContext is the same as GetWorkerFleet with the addition of
// the ability to pass a context and additional request options.
//
// See GetWorkerFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTRoboRunner) GetWorkerFleetWithContext(ctx aws.Context, input *GetWorkerFleetInput, opts ...request.Option) (*GetWorkerFleetOutput, error) {
	req, out := c.GetWorkerFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDestinations = "ListDestinations"

// ListDestinationsRequest generates a "aws/request.Request" representing the
// client's request for the ListDestinations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDestinations for more information on using the ListDestinations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDestinationsRequest method.
//	req, resp := client.ListDestinationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/ListDestinations
func (c *IoTRoboRunner) ListDestinationsRequest(input *ListDestinationsInput) (req *request.Request, output *ListDestinationsOutput) {
	op := &request.Operation{
		Name:       opListDestinations,
		HTTPMethod: "GET",
		HTTPPath:   "/listDestinations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDestinationsInput{}
	}

	output = &ListDestinationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDestinations API operation for AWS IoT RoboRunner.
//
// # Grants permission to list destinations
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT RoboRunner's
// API operation ListDestinations for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     Exception thrown if an invalid parameter is provided to an API.
//
//   - ResourceNotFoundException
//     Exception thrown if a resource referenced in the request doesn't exist.
//
//   - ThrottlingException
//     Exception thrown if the api has been called too quickly be the client.
//
//   - InternalServerException
//     Exception thrown if something goes wrong within the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/ListDestinations
func (c *IoTRoboRunner) ListDestinations(input *ListDestinationsInput) (*ListDestinationsOutput, error) {
	req, out := c.ListDestinationsRequest(input)
	return out, req.Send()
}

// ListDestinationsWithContext is the same as ListDestinations with the addition of
// the ability to pass a context and additional request options.
//
// See ListDestinations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTRoboRunner) ListDestinationsWithContext(ctx aws.Context, input *ListDestinationsInput, opts ...request.Option) (*ListDestinationsOutput, error) {
	req, out := c.ListDestinationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDestinationsPages iterates over the pages of a ListDestinations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDestinations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDestinations operation.
//	pageNum := 0
//	err := client.ListDestinationsPages(params,
//	    func(page *iotroborunner.ListDestinationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTRoboRunner) ListDestinationsPages(input *ListDestinationsInput, fn func(*ListDestinationsOutput, bool) bool) error {
	return c.ListDestinationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDestinationsPagesWithContext same as ListDestinationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTRoboRunner) ListDestinationsPagesWithContext(ctx aws.Context, input *ListDestinationsInput, fn func(*ListDestinationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDestinationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDestinationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDestinationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSites = "ListSites"

// ListSitesRequest generates a "aws/request.Request" representing the
// client's request for the ListSites operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSites for more information on using the ListSites
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSitesRequest method.
//	req, resp := client.ListSitesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/ListSites
func (c *IoTRoboRunner) ListSitesRequest(input *ListSitesInput) (req *request.Request, output *ListSitesOutput) {
	op := &request.Operation{
		Name:       opListSites,
		HTTPMethod: "GET",
		HTTPPath:   "/listSites",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSitesInput{}
	}

	output = &ListSitesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSites API operation for AWS IoT RoboRunner.
//
// # Grants permission to list sites
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT RoboRunner's
// API operation ListSites for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     Exception thrown if an invalid parameter is provided to an API.
//
//   - ThrottlingException
//     Exception thrown if the api has been called too quickly be the client.
//
//   - InternalServerException
//     Exception thrown if something goes wrong within the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/ListSites
func (c *IoTRoboRunner) ListSites(input *ListSitesInput) (*ListSitesOutput, error) {
	req, out := c.ListSitesRequest(input)
	return out, req.Send()
}

// ListSitesWithContext is the same as ListSites with the addition of
// the ability to pass a context and additional request options.
//
// See ListSites for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTRoboRunner) ListSitesWithContext(ctx aws.Context, input *ListSitesInput, opts ...request.Option) (*ListSitesOutput, error) {
	req, out := c.ListSitesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSitesPages iterates over the pages of a ListSites operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSites method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSites operation.
//	pageNum := 0
//	err := client.ListSitesPages(params,
//	    func(page *iotroborunner.ListSitesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTRoboRunner) ListSitesPages(input *ListSitesInput, fn func(*ListSitesOutput, bool) bool) error {
	return c.ListSitesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSitesPagesWithContext same as ListSitesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTRoboRunner) ListSitesPagesWithContext(ctx aws.Context, input *ListSitesInput, fn func(*ListSitesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSitesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSitesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSitesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWorkerFleets = "ListWorkerFleets"

// ListWorkerFleetsRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkerFleets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkerFleets for more information on using the ListWorkerFleets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListWorkerFleetsRequest method.
//	req, resp := client.ListWorkerFleetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/ListWorkerFleets
func (c *IoTRoboRunner) ListWorkerFleetsRequest(input *ListWorkerFleetsInput) (req *request.Request, output *ListWorkerFleetsOutput) {
	op := &request.Operation{
		Name:       opListWorkerFleets,
		HTTPMethod: "GET",
		HTTPPath:   "/listWorkerFleets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkerFleetsInput{}
	}

	output = &ListWorkerFleetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkerFleets API operation for AWS IoT RoboRunner.
//
// # Grants permission to list worker fleets
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT RoboRunner's
// API operation ListWorkerFleets for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     Exception thrown if an invalid parameter is provided to an API.
//
//   - ResourceNotFoundException
//     Exception thrown if a resource referenced in the request doesn't exist.
//
//   - ThrottlingException
//     Exception thrown if the api has been called too quickly be the client.
//
//   - InternalServerException
//     Exception thrown if something goes wrong within the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/ListWorkerFleets
func (c *IoTRoboRunner) ListWorkerFleets(input *ListWorkerFleetsInput) (*ListWorkerFleetsOutput, error) {
	req, out := c.ListWorkerFleetsRequest(input)
	return out, req.Send()
}

// ListWorkerFleetsWithContext is the same as ListWorkerFleets with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkerFleets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTRoboRunner) ListWorkerFleetsWithContext(ctx aws.Context, input *ListWorkerFleetsInput, opts ...request.Option) (*ListWorkerFleetsOutput, error) {
	req, out := c.ListWorkerFleetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkerFleetsPages iterates over the pages of a ListWorkerFleets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkerFleets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListWorkerFleets operation.
//	pageNum := 0
//	err := client.ListWorkerFleetsPages(params,
//	    func(page *iotroborunner.ListWorkerFleetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTRoboRunner) ListWorkerFleetsPages(input *ListWorkerFleetsInput, fn func(*ListWorkerFleetsOutput, bool) bool) error {
	return c.ListWorkerFleetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkerFleetsPagesWithContext same as ListWorkerFleetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTRoboRunner) ListWorkerFleetsPagesWithContext(ctx aws.Context, input *ListWorkerFleetsInput, fn func(*ListWorkerFleetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkerFleetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkerFleetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorkerFleetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWorkers = "ListWorkers"

// ListWorkersRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkers for more information on using the ListWorkers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListWorkersRequest method.
//	req, resp := client.ListWorkersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/ListWorkers
func (c *IoTRoboRunner) ListWorkersRequest(input *ListWorkersInput) (req *request.Request, output *ListWorkersOutput) {
	op := &request.Operation{
		Name:       opListWorkers,
		HTTPMethod: "GET",
		HTTPPath:   "/listWorkers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkersInput{}
	}

	output = &ListWorkersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkers API operation for AWS IoT RoboRunner.
//
// # Grants permission to list workers
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT RoboRunner's
// API operation ListWorkers for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     Exception thrown if an invalid parameter is provided to an API.
//
//   - ResourceNotFoundException
//     Exception thrown if a resource referenced in the request doesn't exist.
//
//   - ThrottlingException
//     Exception thrown if the api has been called too quickly be the client.
//
//   - InternalServerException
//     Exception thrown if something goes wrong within the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/ListWorkers
func (c *IoTRoboRunner) ListWorkers(input *ListWorkersInput) (*ListWorkersOutput, error) {
	req, out := c.ListWorkersRequest(input)
	return out, req.Send()
}

// ListWorkersWithContext is the same as ListWorkers with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTRoboRunner) ListWorkersWithContext(ctx aws.Context, input *ListWorkersInput, opts ...request.Option) (*ListWorkersOutput, error) {
	req, out := c.ListWorkersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkersPages iterates over the pages of a ListWorkers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListWorkers operation.
//	pageNum := 0
//	err := client.ListWorkersPages(params,
//	    func(page *iotroborunner.ListWorkersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTRoboRunner) ListWorkersPages(input *ListWorkersInput, fn func(*ListWorkersOutput, bool) bool) error {
	return c.ListWorkersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkersPagesWithContext same as ListWorkersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTRoboRunner) ListWorkersPagesWithContext(ctx aws.Context, input *ListWorkersInput, fn func(*ListWorkersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorkersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opUpdateDestination = "UpdateDestination"

// UpdateDestinationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDestination for more information on using the UpdateDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDestinationRequest method.
//	req, resp := client.UpdateDestinationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/UpdateDestination
func (c *IoTRoboRunner) UpdateDestinationRequest(input *UpdateDestinationInput) (req *request.Request, output *UpdateDestinationOutput) {
	op := &request.Operation{
		Name:       opUpdateDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/updateDestination",
	}

	if input == nil {
		input = &UpdateDestinationInput{}
	}

	output = &UpdateDestinationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDestination API operation for AWS IoT RoboRunner.
//
// # Grants permission to update a destination
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT RoboRunner's
// API operation UpdateDestination for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     Exception thrown if an invalid parameter is provided to an API.
//
//   - ResourceNotFoundException
//     Exception thrown if a resource referenced in the request doesn't exist.
//
//   - ThrottlingException
//     Exception thrown if the api has been called too quickly be the client.
//
//   - InternalServerException
//     Exception thrown if something goes wrong within the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/UpdateDestination
func (c *IoTRoboRunner) UpdateDestination(input *UpdateDestinationInput) (*UpdateDestinationOutput, error) {
	req, out := c.UpdateDestinationRequest(input)
	return out, req.Send()
}

// UpdateDestinationWithContext is the same as UpdateDestination with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTRoboRunner) UpdateDestinationWithContext(ctx aws.Context, input *UpdateDestinationInput, opts ...request.Option) (*UpdateDestinationOutput, error) {
	req, out := c.UpdateDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSite = "UpdateSite"

// UpdateSiteRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSite operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSite for more information on using the UpdateSite
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSiteRequest method.
//	req, resp := client.UpdateSiteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/UpdateSite
func (c *IoTRoboRunner) UpdateSiteRequest(input *UpdateSiteInput) (req *request.Request, output *UpdateSiteOutput) {
	op := &request.Operation{
		Name:       opUpdateSite,
		HTTPMethod: "POST",
		HTTPPath:   "/updateSite",
	}

	if input == nil {
		input = &UpdateSiteInput{}
	}

	output = &UpdateSiteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSite API operation for AWS IoT RoboRunner.
//
// # Grants permission to update a site
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT RoboRunner's
// API operation UpdateSite for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     Exception thrown if an invalid parameter is provided to an API.
//
//   - ResourceNotFoundException
//     Exception thrown if a resource referenced in the request doesn't exist.
//
//   - ThrottlingException
//     Exception thrown if the api has been called too quickly be the client.
//
//   - InternalServerException
//     Exception thrown if something goes wrong within the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/UpdateSite
func (c *IoTRoboRunner) UpdateSite(input *UpdateSiteInput) (*UpdateSiteOutput, error) {
	req, out := c.UpdateSiteRequest(input)
	return out, req.Send()
}

// UpdateSiteWithContext is the same as UpdateSite with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSite for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTRoboRunner) UpdateSiteWithContext(ctx aws.Context, input *UpdateSiteInput, opts ...request.Option) (*UpdateSiteOutput, error) {
	req, out := c.UpdateSiteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorker = "UpdateWorker"

// UpdateWorkerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorker for more information on using the UpdateWorker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateWorkerRequest method.
//	req, resp := client.UpdateWorkerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/UpdateWorker
func (c *IoTRoboRunner) UpdateWorkerRequest(input *UpdateWorkerInput) (req *request.Request, output *UpdateWorkerOutput) {
	op := &request.Operation{
		Name:       opUpdateWorker,
		HTTPMethod: "POST",
		HTTPPath:   "/updateWorker",
	}

	if input == nil {
		input = &UpdateWorkerInput{}
	}

	output = &UpdateWorkerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateWorker API operation for AWS IoT RoboRunner.
//
// # Grants permission to update a worker
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT RoboRunner's
// API operation UpdateWorker for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     Exception thrown if an invalid parameter is provided to an API.
//
//   - ResourceNotFoundException
//     Exception thrown if a resource referenced in the request doesn't exist.
//
//   - ThrottlingException
//     Exception thrown if the api has been called too quickly be the client.
//
//   - InternalServerException
//     Exception thrown if something goes wrong within the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/UpdateWorker
func (c *IoTRoboRunner) UpdateWorker(input *UpdateWorkerInput) (*UpdateWorkerOutput, error) {
	req, out := c.UpdateWorkerRequest(input)
	return out, req.Send()
}

// UpdateWorkerWithContext is the same as UpdateWorker with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTRoboRunner) UpdateWorkerWithContext(ctx aws.Context, input *UpdateWorkerInput, opts ...request.Option) (*UpdateWorkerOutput, error) {
	req, out := c.UpdateWorkerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkerFleet = "UpdateWorkerFleet"

// UpdateWorkerFleetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkerFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkerFleet for more information on using the UpdateWorkerFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateWorkerFleetRequest method.
//	req, resp := client.UpdateWorkerFleetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/UpdateWorkerFleet
func (c *IoTRoboRunner) UpdateWorkerFleetRequest(input *UpdateWorkerFleetInput) (req *request.Request, output *UpdateWorkerFleetOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkerFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/updateWorkerFleet",
	}

	if input == nil {
		input = &UpdateWorkerFleetInput{}
	}

	output = &UpdateWorkerFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateWorkerFleet API operation for AWS IoT RoboRunner.
//
// # Grants permission to update a worker fleet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT RoboRunner's
// API operation UpdateWorkerFleet for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ValidationException
//     Exception thrown if an invalid parameter is provided to an API.
//
//   - ResourceNotFoundException
//     Exception thrown if a resource referenced in the request doesn't exist.
//
//   - ThrottlingException
//     Exception thrown if the api has been called too quickly be the client.
//
//   - InternalServerException
//     Exception thrown if something goes wrong within the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/UpdateWorkerFleet
func (c *IoTRoboRunner) UpdateWorkerFleet(input *UpdateWorkerFleetInput) (*UpdateWorkerFleetOutput, error) {
	req, out := c.UpdateWorkerFleetRequest(input)
	return out, req.Send()
}

// UpdateWorkerFleetWithContext is the same as UpdateWorkerFleet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkerFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTRoboRunner) UpdateWorkerFleetWithContext(ctx aws.Context, input *UpdateWorkerFleetInput, opts ...request.Option) (*UpdateWorkerFleetOutput, error) {
	req, out := c.UpdateWorkerFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// User does not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Cartesian coordinates in 3D space relative to the RoboRunner origin.
type CartesianCoordinates struct {
	_ struct{} `type:"structure"`

	// X coordinate.
	//
	// X is a required field
	X *float64 `locationName:"x" type:"double" required:"true"`

	// Y coordinate.
	//
	// Y is a required field
	Y *float64 `locationName:"y" type:"double" required:"true"`

	// Z coordinate.
	Z *float64 `locationName:"z" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CartesianCoordinates) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CartesianCoordinates) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CartesianCoordinates) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CartesianCoordinates"}
	if s.X == nil {
		invalidParams.Add(request.NewErrParamRequired("X"))
	}
	if s.Y == nil {
		invalidParams.Add(request.NewErrParamRequired("Y"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetX sets the X field's value.
func (s *CartesianCoordinates) SetX(v float64) *CartesianCoordinates {
	s.X = &v
	return s
}

// SetY sets the Y field's value.
func (s *CartesianCoordinates) SetY(v float64) *CartesianCoordinates {
	s.Y = &v
	return s
}

// SetZ sets the Z field's value.
func (s *CartesianCoordinates) SetZ(v float64) *CartesianCoordinates {
	s.Z = &v
	return s
}

// Exception thrown if a resource in a create request already exists.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateDestinationInput struct {
	_ struct{} `type:"structure"`

	// JSON document containing additional fixed properties regarding the destination
	AdditionalFixedProperties *string `locationName:"additionalFixedProperties" min:"1" type:"string"`

	// Token used for detecting replayed requests. Replayed requests will not be
	// performed multiple times.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// Human friendly name of the resource.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Site ARN.
	//
	// Site is a required field
	Site *string `locationName:"site" min:"1" type:"string" required:"true"`

	// The state of the destination. Default used if not specified.
	State *string `locationName:"state" type:"string" enum:"DestinationState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDestinationInput"}
	if s.AdditionalFixedProperties != nil && len(*s.AdditionalFixedProperties) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AdditionalFixedProperties", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Site == nil {
		invalidParams.Add(request.NewErrParamRequired("Site"))
	}
	if s.Site != nil && len(*s.Site) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Site", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalFixedProperties sets the AdditionalFixedProperties field's value.
func (s *CreateDestinationInput) SetAdditionalFixedProperties(v string) *CreateDestinationInput {
	s.AdditionalFixedProperties = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateDestinationInput) SetClientToken(v string) *CreateDestinationInput {
	s.ClientToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDestinationInput) SetName(v string) *CreateDestinationInput {
	s.Name = &v
	return s
}

// SetSite sets the Site field's value.
func (s *CreateDestinationInput) SetSite(v string) *CreateDestinationInput {
	s.Site = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateDestinationInput) SetState(v string) *CreateDestinationInput {
	s.State = &v
	return s
}

type CreateDestinationOutput struct {
	_ struct{} `type:"structure"`

	// Destination ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Timestamp at which the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// Filters access by the destination's identifier
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// State of the destination.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"DestinationState"`

	// Timestamp at which the resource was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDestinationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateDestinationOutput) SetArn(v string) *CreateDestinationOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateDestinationOutput) SetCreatedAt(v time.Time) *CreateDestinationOutput {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateDestinationOutput) SetId(v string) *CreateDestinationOutput {
	s.Id = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateDestinationOutput) SetState(v string) *CreateDestinationOutput {
	s.State = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CreateDestinationOutput) SetUpdatedAt(v time.Time) *CreateDestinationOutput {
	s.UpdatedAt = &v
	return s
}

type CreateSiteInput struct {
	_ struct{} `type:"structure"`

	// Token used for detecting replayed requests. Replayed requests will not be
	// performed multiple times.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A valid ISO 3166-1 alpha-2 code for the country in which the site resides.
	// e.g., US.
	//
	// CountryCode is a required field
	CountryCode *string `locationName:"countryCode" min:"2" type:"string" required:"true"`

	// A high-level description of the site.
	Description *string `locationName:"description" type:"string"`

	// Human friendly name of the resource.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSiteInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.CountryCode == nil {
		invalidParams.Add(request.NewErrParamRequired("CountryCode"))
	}
	if s.CountryCode != nil && len(*s.CountryCode) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("CountryCode", 2))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateSiteInput) SetClientToken(v string) *CreateSiteInput {
	s.ClientToken = &v
	return s
}

// SetCountryCode sets the CountryCode field's value.
func (s *CreateSiteInput) SetCountryCode(v string) *CreateSiteInput {
	s.CountryCode = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSiteInput) SetDescription(v string) *CreateSiteInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSiteInput) SetName(v string) *CreateSiteInput {
	s.Name = &v
	return s
}

type CreateSiteOutput struct {
	_ struct{} `type:"structure"`

	// Site ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Timestamp at which the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// Filters access by the site's identifier
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// Timestamp at which the resource was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSiteOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateSiteOutput) SetArn(v string) *CreateSiteOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateSiteOutput) SetCreatedAt(v time.Time) *CreateSiteOutput {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateSiteOutput) SetId(v string) *CreateSiteOutput {
	s.Id = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CreateSiteOutput) SetUpdatedAt(v time.Time) *CreateSiteOutput {
	s.UpdatedAt = &v
	return s
}

type CreateWorkerFleetInput struct {
	_ struct{} `type:"structure"`

	// JSON blob containing additional fixed properties regarding the worker fleet
	AdditionalFixedProperties *string `locationName:"additionalFixedProperties" min:"1" type:"string"`

	// Token used for detecting replayed requests. Replayed requests will not be
	// performed multiple times.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// Human friendly name of the resource.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Site ARN.
	//
	// Site is a required field
	Site *string `locationName:"site" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkerFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkerFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkerFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkerFleetInput"}
	if s.AdditionalFixedProperties != nil && len(*s.AdditionalFixedProperties) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AdditionalFixedProperties", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Site == nil {
		invalidParams.Add(request.NewErrParamRequired("Site"))
	}
	if s.Site != nil && len(*s.Site) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Site", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalFixedProperties sets the AdditionalFixedProperties field's value.
func (s *CreateWorkerFleetInput) SetAdditionalFixedProperties(v string) *CreateWorkerFleetInput {
	s.AdditionalFixedProperties = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateWorkerFleetInput) SetClientToken(v string) *CreateWorkerFleetInput {
	s.ClientToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateWorkerFleetInput) SetName(v string) *CreateWorkerFleetInput {
	s.Name = &v
	return s
}

// SetSite sets the Site field's value.
func (s *CreateWorkerFleetInput) SetSite(v string) *CreateWorkerFleetInput {
	s.Site = &v
	return s
}

type CreateWorkerFleetOutput struct {
	_ struct{} `type:"structure"`

	// Full ARN of the worker fleet.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Timestamp at which the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// Filters access by the worker fleet's identifier
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// Timestamp at which the resource was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkerFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkerFleetOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateWorkerFleetOutput) SetArn(v string) *CreateWorkerFleetOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateWorkerFleetOutput) SetCreatedAt(v time.Time) *CreateWorkerFleetOutput {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateWorkerFleetOutput) SetId(v string) *CreateWorkerFleetOutput {
	s.Id = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CreateWorkerFleetOutput) SetUpdatedAt(v time.Time) *CreateWorkerFleetOutput {
	s.UpdatedAt = &v
	return s
}

type CreateWorkerInput struct {
	_ struct{} `type:"structure"`

	// JSON blob containing unstructured worker properties that are fixed and won't
	// change during regular operation.
	AdditionalFixedProperties *string `locationName:"additionalFixedProperties" min:"1" type:"string"`

	// JSON blob containing unstructured worker properties that are transient and
	// may change during regular operation.
	AdditionalTransientProperties *string `locationName:"additionalTransientProperties" min:"1" type:"string"`

	// Token used for detecting replayed requests. Replayed requests will not be
	// performed multiple times.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// Full ARN of the worker fleet.
	//
	// Fleet is a required field
	Fleet *string `locationName:"fleet" min:"1" type:"string" required:"true"`

	// Human friendly name of the resource.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Worker orientation measured in units clockwise from north.
	Orientation *Orientation `locationName:"orientation" type:"structure"`

	// Supported coordinates for worker position.
	Position *PositionCoordinates `locationName:"position" type:"structure"`

	// Properties of the worker that are provided by the vendor FMS.
	VendorProperties *VendorProperties `locationName:"vendorProperties" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkerInput"}
	if s.AdditionalFixedProperties != nil && len(*s.AdditionalFixedProperties) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AdditionalFixedProperties", 1))
	}
	if s.AdditionalTransientProperties != nil && len(*s.AdditionalTransientProperties) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AdditionalTransientProperties", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Fleet == nil {
		invalidParams.Add(request.NewErrParamRequired("Fleet"))
	}
	if s.Fleet != nil && len(*s.Fleet) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Fleet", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Position != nil {
		if err := s.Position.Validate(); err != nil {
			invalidParams.AddNested("Position", err.(request.ErrInvalidParams))
		}
	}
	if s.VendorProperties != nil {
		if err := s.VendorProperties.Validate(); err != nil {
			invalidParams.AddNested("VendorProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalFixedProperties sets the AdditionalFixedProperties field's value.
func (s *CreateWorkerInput) SetAdditionalFixedProperties(v string) *CreateWorkerInput {
	s.AdditionalFixedProperties = &v
	return s
}

// SetAdditionalTransientProperties sets the AdditionalTransientProperties field's value.
func (s *CreateWorkerInput) SetAdditionalTransientProperties(v string) *CreateWorkerInput {
	s.AdditionalTransientProperties = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateWorkerInput) SetClientToken(v string) *CreateWorkerInput {
	s.ClientToken = &v
	return s
}

// SetFleet sets the Fleet field's value.
func (s *CreateWorkerInput) SetFleet(v string) *CreateWorkerInput {
	s.Fleet = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateWorkerInput) SetName(v string) *CreateWorkerInput {
	s.Name = &v
	return s
}

// SetOrientation sets the Orientation field's value.
func (s *CreateWorkerInput) SetOrientation(v *Orientation) *CreateWorkerInput {
	s.Orientation = v
	return s
}

// SetPosition sets the Position field's value.
func (s *CreateWorkerInput) SetPosition(v *PositionCoordinates) *CreateWorkerInput {
	s.Position = v
	return s
}

// SetVendorProperties sets the VendorProperties field's value.
func (s *CreateWorkerInput) SetVendorProperties(v *VendorProperties) *CreateWorkerInput {
	s.VendorProperties = v
	return s
}

type CreateWorkerOutput struct {
	_ struct{} `type:"structure"`

	// Full ARN of the worker.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Timestamp at which the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// Filters access by the workers identifier
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// Site ARN.
	//
	// Site is a required field
	Site *string `locationName:"site" min:"1" type:"string" required:"true"`

	// Timestamp at which the resource was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkerOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateWorkerOutput) SetArn(v string) *CreateWorkerOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateWorkerOutput) SetCreatedAt(v time.Time) *CreateWorkerOutput {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateWorkerOutput) SetId(v string) *CreateWorkerOutput {
	s.Id = &v
	return s
}

// SetSite sets the Site field's value.
func (s *CreateWorkerOutput) SetSite(v string) *CreateWorkerOutput {
	s.Site = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CreateWorkerOutput) SetUpdatedAt(v time.Time) *CreateWorkerOutput {
	s.UpdatedAt = &v
	return s
}

type DeleteDestinationInput struct {
	_ struct{} `type:"structure"`

	// Destination ARN.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDestinationInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteDestinationInput) SetId(v string) *DeleteDestinationInput {
	s.Id = &v
	return s
}

type DeleteDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDestinationOutput) GoString() string {
	return s.String()
}

type DeleteSiteInput struct {
	_ struct{} `type:"structure"`

	// Site ARN.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSiteInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteSiteInput) SetId(v string) *DeleteSiteInput {
	s.Id = &v
	return s
}

type DeleteSiteOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSiteOutput) GoString() string {
	return s.String()
}

type DeleteWorkerFleetInput struct {
	_ struct{} `type:"structure"`

	// Full ARN of the worker fleet.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkerFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkerFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkerFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorkerFleetInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteWorkerFleetInput) SetId(v string) *DeleteWorkerFleetInput {
	s.Id = &v
	return s
}

type DeleteWorkerFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkerFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkerFleetOutput) GoString() string {
	return s.String()
}

type DeleteWorkerInput struct {
	_ struct{} `type:"structure"`

	// Full ARN of the worker.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorkerInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteWorkerInput) SetId(v string) *DeleteWorkerInput {
	s.Id = &v
	return s
}

type DeleteWorkerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkerOutput) GoString() string {
	return s.String()
}

// Area within a facility where work can be performed.
type Destination struct {
	_ struct{} `type:"structure"`

	// JSON document containing additional fixed properties regarding the destination
	AdditionalFixedProperties *string `locationName:"additionalFixedProperties" min:"1" type:"string"`

	// Destination ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Timestamp at which the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// Filters access by the destination's identifier
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// Human friendly name of the resource.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Site ARN.
	//
	// Site is a required field
	Site *string `locationName:"site" min:"1" type:"string" required:"true"`

	// State of the destination.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"DestinationState"`

	// Timestamp at which the resource was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Destination) GoString() string {
	return s.String()
}

// SetAdditionalFixedProperties sets the AdditionalFixedProperties field's value.
func (s *Destination) SetAdditionalFixedProperties(v string) *Destination {
	s.AdditionalFixedProperties = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Destination) SetArn(v string) *Destination {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Destination) SetCreatedAt(v time.Time) *Destination {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *Destination) SetId(v string) *Destination {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Destination) SetName(v string) *Destination {
	s.Name = &v
	return s
}

// SetSite sets the Site field's value.
func (s *Destination) SetSite(v string) *Destination {
	s.Site = &v
	return s
}

// SetState sets the State field's value.
func (s *Destination) SetState(v string) *Destination {
	s.State = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Destination) SetUpdatedAt(v time.Time) *Destination {
	s.UpdatedAt = &v
	return s
}

type GetDestinationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Destination ARN.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDestinationInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetDestinationInput) SetId(v string) *GetDestinationInput {
	s.Id = &v
	return s
}

type GetDestinationOutput struct {
	_ struct{} `type:"structure"`

	// JSON document containing additional fixed properties regarding the destination
	AdditionalFixedProperties *string `locationName:"additionalFixedProperties" min:"1" type:"string"`

	// Destination ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Timestamp at which the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// Filters access by the destination's identifier
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// Human friendly name of the resource.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Site ARN.
	//
	// Site is a required field
	Site *string `locationName:"site" min:"1" type:"string" required:"true"`

	// State of the destination.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"DestinationState"`

	// Timestamp at which the resource was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDestinationOutput) GoString() string {
	return s.String()
}

// SetAdditionalFixedProperties sets the AdditionalFixedProperties field's value.
func (s *GetDestinationOutput) SetAdditionalFixedProperties(v string) *GetDestinationOutput {
	s.AdditionalFixedProperties = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *GetDestinationOutput) SetArn(v string) *GetDestinationOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetDestinationOutput) SetCreatedAt(v time.Time) *GetDestinationOutput {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetDestinationOutput) SetId(v string) *GetDestinationOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetDestinationOutput) SetName(v string) *GetDestinationOutput {
	s.Name = &v
	return s
}

// SetSite sets the Site field's value.
func (s *GetDestinationOutput) SetSite(v string) *GetDestinationOutput {
	s.Site = &v
	return s
}

// SetState sets the State field's value.
func (s *GetDestinationOutput) SetState(v string) *GetDestinationOutput {
	s.State = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetDestinationOutput) SetUpdatedAt(v time.Time) *GetDestinationOutput {
	s.UpdatedAt = &v
	return s
}

type GetSiteInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Site ARN.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSiteInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetSiteInput) SetId(v string) *GetSiteInput {
	s.Id = &v
	return s
}

type GetSiteOutput struct {
	_ struct{} `type:"structure"`

	// Site ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// A valid ISO 3166-1 alpha-2 code for the country in which the site resides.
	// e.g., US.
	//
	// CountryCode is a required field
	CountryCode *string `locationName:"countryCode" min:"2" type:"string" required:"true"`

	// Timestamp at which the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// A high-level description of the site.
	Description *string `locationName:"description" type:"string"`

	// Filters access by the site's identifier
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// Human friendly name of the resource.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Timestamp at which the resource was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSiteOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetSiteOutput) SetArn(v string) *GetSiteOutput {
	s.Arn = &v
	return s
}

// SetCountryCode sets the CountryCode field's value.
func (s *GetSiteOutput) SetCountryCode(v string) *GetSiteOutput {
	s.CountryCode = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetSiteOutput) SetCreatedAt(v time.Time) *GetSiteOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetSiteOutput) SetDescription(v string) *GetSiteOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetSiteOutput) SetId(v string) *GetSiteOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetSiteOutput) SetName(v string) *GetSiteOutput {
	s.Name = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetSiteOutput) SetUpdatedAt(v time.Time) *GetSiteOutput {
	s.UpdatedAt = &v
	return s
}

type GetWorkerFleetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Full ARN of the worker fleet.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkerFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkerFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWorkerFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWorkerFleetInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetWorkerFleetInput) SetId(v string) *GetWorkerFleetInput {
	s.Id = &v
	return s
}

type GetWorkerFleetOutput struct {
	_ struct{} `type:"structure"`

	// JSON blob containing additional fixed properties regarding the worker fleet
	AdditionalFixedProperties *string `locationName:"additionalFixedProperties" min:"1" type:"string"`

	// Full ARN of the worker fleet.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Timestamp at which the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// Filters access by the worker fleet's identifier
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// Human friendly name of the resource.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Site ARN.
	//
	// Site is a required field
	Site *string `locationName:"site" min:"1" type:"string" required:"true"`

	// Timestamp at which the resource was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkerFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkerFleetOutput) GoString() string {
	return s.String()
}

// SetAdditionalFixedProperties sets the AdditionalFixedProperties field's value.
func (s *GetWorkerFleetOutput) SetAdditionalFixedProperties(v string) *GetWorkerFleetOutput {
	s.AdditionalFixedProperties = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *GetWorkerFleetOutput) SetArn(v string) *GetWorkerFleetOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetWorkerFleetOutput) SetCreatedAt(v time.Time) *GetWorkerFleetOutput {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetWorkerFleetOutput) SetId(v string) *GetWorkerFleetOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetWorkerFleetOutput) SetName(v string) *GetWorkerFleetOutput {
	s.Name = &v
	return s
}

// SetSite sets the Site field's value.
func (s *GetWorkerFleetOutput) SetSite(v string) *GetWorkerFleetOutput {
	s.Site = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetWorkerFleetOutput) SetUpdatedAt(v time.Time) *GetWorkerFleetOutput {
	s.UpdatedAt = &v
	return s
}

type GetWorkerInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Full ARN of the worker.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWorkerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWorkerInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetWorkerInput) SetId(v string) *GetWorkerInput {
	s.Id = &v
	return s
}

type GetWorkerOutput struct {
	_ struct{} `type:"structure"`

	// JSON blob containing unstructured worker properties that are fixed and won't
	// change during regular operation.
	AdditionalFixedProperties *string `locationName:"additionalFixedProperties" min:"1" type:"string"`

	// JSON blob containing unstructured worker properties that are transient and
	// may change during regular operation.
	AdditionalTransientProperties *string `locationName:"additionalTransientProperties" min:"1" type:"string"`

	// Full ARN of the worker.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Timestamp at which the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// Full ARN of the worker fleet.
	//
	// Fleet is a required field
	Fleet *string `locationName:"fleet" min:"1" type:"string" required:"true"`

	// Filters access by the workers identifier
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// Human friendly name of the resource.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Worker orientation measured in units clockwise from north.
	Orientation *Orientation `locationName:"orientation" type:"structure"`

	// Supported coordinates for worker position.
	Position *PositionCoordinates `locationName:"position" type:"structure"`

	// Site ARN.
	//
	// Site is a required field
	Site *string `locationName:"site" min:"1" type:"string" required:"true"`

	// Timestamp at which the resource was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`

	// Properties of the worker that are provided by the vendor FMS.
	VendorProperties *VendorProperties `locationName:"vendorProperties" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkerOutput) GoString() string {
	return s.String()
}

// SetAdditionalFixedProperties sets the AdditionalFixedProperties field's value.
func (s *GetWorkerOutput) SetAdditionalFixedProperties(v string) *GetWorkerOutput {
	s.AdditionalFixedProperties = &v
	return s
}

// SetAdditionalTransientProperties sets the AdditionalTransientProperties field's value.
func (s *GetWorkerOutput) SetAdditionalTransientProperties(v string) *GetWorkerOutput {
	s.AdditionalTransientProperties = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *GetWorkerOutput) SetArn(v string) *GetWorkerOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetWorkerOutput) SetCreatedAt(v time.Time) *GetWorkerOutput {
	s.CreatedAt = &v
	return s
}

// SetFleet sets the Fleet field's value.
func (s *GetWorkerOutput) SetFleet(v string) *GetWorkerOutput {
	s.Fleet = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetWorkerOutput) SetId(v string) *GetWorkerOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetWorkerOutput) SetName(v string) *GetWorkerOutput {
	s.Name = &v
	return s
}

// SetOrientation sets the Orientation field's value.
func (s *GetWorkerOutput) SetOrientation(v *Orientation) *GetWorkerOutput {
	s.Orientation = v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetWorkerOutput) SetPosition(v *PositionCoordinates) *GetWorkerOutput {
	s.Position = v
	return s
}

// SetSite sets the Site field's value.
func (s *GetWorkerOutput) SetSite(v string) *GetWorkerOutput {
	s.Site = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetWorkerOutput) SetUpdatedAt(v time.Time) *GetWorkerOutput {
	s.UpdatedAt = &v
	return s
}

// SetVendorProperties sets the VendorProperties field's value.
func (s *GetWorkerOutput) SetVendorProperties(v *VendorProperties) *GetWorkerOutput {
	s.VendorProperties = v
	return s
}

// Exception thrown if something goes wrong within the service.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListDestinationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Maximum number of results to retrieve in a single call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Pagination token returned when another page of data exists. Provide it in
	// your next call to the API to receive the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// Site ARN.
	//
	// Site is a required field
	Site *string `location:"querystring" locationName:"site" min:"1" type:"string" required:"true"`

	// State of the destination.
	State *string `location:"querystring" locationName:"state" type:"string" enum:"DestinationState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDestinationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDestinationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDestinationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDestinationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Site == nil {
		invalidParams.Add(request.NewErrParamRequired("Site"))
	}
	if s.Site != nil && len(*s.Site) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Site", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDestinationsInput) SetMaxResults(v int64) *ListDestinationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDestinationsInput) SetNextToken(v string) *ListDestinationsInput {
	s.NextToken = &v
	return s
}

// SetSite sets the Site field's value.
func (s *ListDestinationsInput) SetSite(v string) *ListDestinationsInput {
	s.Site = &v
	return s
}

// SetState sets the State field's value.
func (s *ListDestinationsInput) SetState(v string) *ListDestinationsInput {
	s.State = &v
	return s
}

type ListDestinationsOutput struct {
	_ struct{} `type:"structure"`

	// List of destinations.
	Destinations []*Destination `locationName:"destinations" type:"list"`

	// Pagination token returned when another page of data exists. Provide it in
	// your next call to the API to receive the next page.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDestinationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDestinationsOutput) GoString() string {
	return s.String()
}

// SetDestinations sets the Destinations field's value.
func (s *ListDestinationsOutput) SetDestinations(v []*Destination) *ListDestinationsOutput {
	s.Destinations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDestinationsOutput) SetNextToken(v string) *ListDestinationsOutput {
	s.NextToken = &v
	return s
}

type ListSitesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Maximum number of results to retrieve in a single ListSites call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Pagination token returned when another page of data exists. Provide it in
	// your next call to the API to receive the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSitesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSitesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSitesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSitesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSitesInput) SetMaxResults(v int64) *ListSitesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSitesInput) SetNextToken(v string) *ListSitesInput {
	s.NextToken = &v
	return s
}

type ListSitesOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token returned when another page of data exists. Provide it in
	// your next call to the API to receive the next page.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// List of facilities.
	Sites []*Site `locationName:"sites" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSitesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSitesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSitesOutput) SetNextToken(v string) *ListSitesOutput {
	s.NextToken = &v
	return s
}

// SetSites sets the Sites field's value.
func (s *ListSitesOutput) SetSites(v []*Site) *ListSitesOutput {
	s.Sites = v
	return s
}

type ListWorkerFleetsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Maximum number of results to retrieve in a single ListWorkerFleets call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Pagination token returned when another page of data exists. Provide it in
	// your next call to the API to receive the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// Site ARN.
	//
	// Site is a required field
	Site *string `location:"querystring" locationName:"site" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkerFleetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkerFleetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkerFleetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkerFleetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Site == nil {
		invalidParams.Add(request.NewErrParamRequired("Site"))
	}
	if s.Site != nil && len(*s.Site) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Site", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorkerFleetsInput) SetMaxResults(v int64) *ListWorkerFleetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkerFleetsInput) SetNextToken(v string) *ListWorkerFleetsInput {
	s.NextToken = &v
	return s
}

// SetSite sets the Site field's value.
func (s *ListWorkerFleetsInput) SetSite(v string) *ListWorkerFleetsInput {
	s.Site = &v
	return s
}

type ListWorkerFleetsOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token returned when another page of data exists. Provide it in
	// your next call to the API to receive the next page.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// List of worker fleets.
	WorkerFleets []*WorkerFleet `locationName:"workerFleets" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkerFleetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkerFleetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkerFleetsOutput) SetNextToken(v string) *ListWorkerFleetsOutput {
	s.NextToken = &v
	return s
}

// SetWorkerFleets sets the WorkerFleets field's value.
func (s *ListWorkerFleetsOutput) SetWorkerFleets(v []*WorkerFleet) *ListWorkerFleetsOutput {
	s.WorkerFleets = v
	return s
}

type ListWorkersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Full ARN of the worker fleet.
	Fleet *string `location:"querystring" locationName:"fleet" min:"1" type:"string"`

	// Maximum number of results to retrieve in a single ListWorkers call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Pagination token returned when another page of data exists. Provide it in
	// your next call to the API to receive the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// Site ARN.
	//
	// Site is a required field
	Site *string `location:"querystring" locationName:"site" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkersInput"}
	if s.Fleet != nil && len(*s.Fleet) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Fleet", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Site == nil {
		invalidParams.Add(request.NewErrParamRequired("Site"))
	}
	if s.Site != nil && len(*s.Site) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Site", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleet sets the Fleet field's value.
func (s *ListWorkersInput) SetFleet(v string) *ListWorkersInput {
	s.Fleet = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorkersInput) SetMaxResults(v int64) *ListWorkersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkersInput) SetNextToken(v string) *ListWorkersInput {
	s.NextToken = &v
	return s
}

// SetSite sets the Site field's value.
func (s *ListWorkersInput) SetSite(v string) *ListWorkersInput {
	s.Site = &v
	return s
}

type ListWorkersOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token returned when another page of data exists. Provide it in
	// your next call to the API to receive the next page.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// List of workers.
	Workers []*Worker `locationName:"workers" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkersOutput) SetNextToken(v string) *ListWorkersOutput {
	s.NextToken = &v
	return s
}

// SetWorkers sets the Workers field's value.
func (s *ListWorkersOutput) SetWorkers(v []*Worker) *ListWorkersOutput {
	s.Workers = v
	return s
}

// Worker orientation measured in units clockwise from north.
type Orientation struct {
	_ struct{} `type:"structure"`

	// Degrees, limited on [0, 360)
	Degrees *float64 `locationName:"degrees" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Orientation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Orientation) GoString() string {
	return s.String()
}

// SetDegrees sets the Degrees field's value.
func (s *Orientation) SetDegrees(v float64) *Orientation {
	s.Degrees = &v
	return s
}

// Supported coordinates for worker position.
type PositionCoordinates struct {
	_ struct{} `type:"structure"`

	// Cartesian coordinates.
	CartesianCoordinates *CartesianCoordinates `locationName:"cartesianCoordinates" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PositionCoordinates) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PositionCoordinates) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PositionCoordinates) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PositionCoordinates"}
	if s.CartesianCoordinates != nil {
		if err := s.CartesianCoordinates.Validate(); err != nil {
			invalidParams.AddNested("CartesianCoordinates", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCartesianCoordinates sets the CartesianCoordinates field's value.
func (s *PositionCoordinates) SetCartesianCoordinates(v *CartesianCoordinates) *PositionCoordinates {
	s.CartesianCoordinates = v
	return s
}

// Exception thrown if a resource referenced in the request doesn't exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Exception thrown if the user's AWS account has reached a service limit and
// the operation cannot proceed.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Facility containing destinations, workers, activities, and tasks.
type Site struct {
	_ struct{} `type:"structure"`

	// Site ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// A valid ISO 3166-1 alpha-2 code for the country in which the site resides.
	// e.g., US.
	//
	// CountryCode is a required field
	CountryCode *string `locationName:"countryCode" min:"2" type:"string" required:"true"`

	// Timestamp at which the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The name of the site. Mutable after creation and unique within a given account.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Site) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Site) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Site) SetArn(v string) *Site {
	s.Arn = &v
	return s
}

// SetCountryCode sets the CountryCode field's value.
func (s *Site) SetCountryCode(v string) *Site {
	s.CountryCode = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Site) SetCreatedAt(v time.Time) *Site {
	s.CreatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *Site) SetName(v string) *Site {
	s.Name = &v
	return s
}

// Exception thrown if the api has been called too quickly be the client.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateDestinationInput struct {
	_ struct{} `type:"structure"`

	// JSON document containing additional fixed properties regarding the destination
	AdditionalFixedProperties *string `locationName:"additionalFixedProperties" min:"1" type:"string"`

	// Destination ARN.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// Human friendly name of the resource.
	Name *string `locationName:"name" min:"1" type:"string"`

	// State of the destination.
	State *string `locationName:"state" type:"string" enum:"DestinationState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDestinationInput"}
	if s.AdditionalFixedProperties != nil && len(*s.AdditionalFixedProperties) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AdditionalFixedProperties", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalFixedProperties sets the AdditionalFixedProperties field's value.
func (s *UpdateDestinationInput) SetAdditionalFixedProperties(v string) *UpdateDestinationInput {
	s.AdditionalFixedProperties = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateDestinationInput) SetId(v string) *UpdateDestinationInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDestinationInput) SetName(v string) *UpdateDestinationInput {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateDestinationInput) SetState(v string) *UpdateDestinationInput {
	s.State = &v
	return s
}

type UpdateDestinationOutput struct {
	_ struct{} `type:"structure"`

	// JSON document containing additional fixed properties regarding the destination
	AdditionalFixedProperties *string `locationName:"additionalFixedProperties" min:"1" type:"string"`

	// Destination ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Filters access by the destination's identifier
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// Human friendly name of the resource.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// State of the destination.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"DestinationState"`

	// Timestamp at which the resource was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDestinationOutput) GoString() string {
	return s.String()
}

// SetAdditionalFixedProperties sets the AdditionalFixedProperties field's value.
func (s *UpdateDestinationOutput) SetAdditionalFixedProperties(v string) *UpdateDestinationOutput {
	s.AdditionalFixedProperties = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *UpdateDestinationOutput) SetArn(v string) *UpdateDestinationOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateDestinationOutput) SetId(v string) *UpdateDestinationOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDestinationOutput) SetName(v string) *UpdateDestinationOutput {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateDestinationOutput) SetState(v string) *UpdateDestinationOutput {
	s.State = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *UpdateDestinationOutput) SetUpdatedAt(v time.Time) *UpdateDestinationOutput {
	s.UpdatedAt = &v
	return s
}

type UpdateSiteInput struct {
	_ struct{} `type:"structure"`

	// A valid ISO 3166-1 alpha-2 code for the country in which the site resides.
	// e.g., US.
	CountryCode *string `locationName:"countryCode" min:"2" type:"string"`

	// A high-level description of the site.
	Description *string `locationName:"description" type:"string"`

	// Site ARN.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// Human friendly name of the resource.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSiteInput"}
	if s.CountryCode != nil && len(*s.CountryCode) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("CountryCode", 2))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCountryCode sets the CountryCode field's value.
func (s *UpdateSiteInput) SetCountryCode(v string) *UpdateSiteInput {
	s.CountryCode = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateSiteInput) SetDescription(v string) *UpdateSiteInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateSiteInput) SetId(v string) *UpdateSiteInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateSiteInput) SetName(v string) *UpdateSiteInput {
	s.Name = &v
	return s
}

type UpdateSiteOutput struct {
	_ struct{} `type:"structure"`

	// Site ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// A valid ISO 3166-1 alpha-2 code for the country in which the site resides.
	// e.g., US.
	CountryCode *string `locationName:"countryCode" min:"2" type:"string"`

	// A high-level description of the site.
	Description *string `locationName:"description" type:"string"`

	// Filters access by the site's identifier
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// Human friendly name of the resource.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Timestamp at which the resource was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSiteOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateSiteOutput) SetArn(v string) *UpdateSiteOutput {
	s.Arn = &v
	return s
}

// SetCountryCode sets the CountryCode field's value.
func (s *UpdateSiteOutput) SetCountryCode(v string) *UpdateSiteOutput {
	s.CountryCode = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateSiteOutput) SetDescription(v string) *UpdateSiteOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateSiteOutput) SetId(v string) *UpdateSiteOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateSiteOutput) SetName(v string) *UpdateSiteOutput {
	s.Name = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *UpdateSiteOutput) SetUpdatedAt(v time.Time) *UpdateSiteOutput {
	s.UpdatedAt = &v
	return s
}

type UpdateWorkerFleetInput struct {
	_ struct{} `type:"structure"`

	// JSON blob containing additional fixed properties regarding the worker fleet
	AdditionalFixedProperties *string `locationName:"additionalFixedProperties" min:"1" type:"string"`

	// Full ARN of the worker fleet.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// Human friendly name of the resource.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkerFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkerFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWorkerFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWorkerFleetInput"}
	if s.AdditionalFixedProperties != nil && len(*s.AdditionalFixedProperties) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AdditionalFixedProperties", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalFixedProperties sets the AdditionalFixedProperties field's value.
func (s *UpdateWorkerFleetInput) SetAdditionalFixedProperties(v string) *UpdateWorkerFleetInput {
	s.AdditionalFixedProperties = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateWorkerFleetInput) SetId(v string) *UpdateWorkerFleetInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateWorkerFleetInput) SetName(v string) *UpdateWorkerFleetInput {
	s.Name = &v
	return s
}

type UpdateWorkerFleetOutput struct {
	_ struct{} `type:"structure"`

	// JSON blob containing additional fixed properties regarding the worker fleet
	AdditionalFixedProperties *string `locationName:"additionalFixedProperties" min:"1" type:"string"`

	// Full ARN of the worker fleet.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Filters access by the worker fleet's identifier
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// Human friendly name of the resource.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Timestamp at which the resource was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkerFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkerFleetOutput) GoString() string {
	return s.String()
}

// SetAdditionalFixedProperties sets the AdditionalFixedProperties field's value.
func (s *UpdateWorkerFleetOutput) SetAdditionalFixedProperties(v string) *UpdateWorkerFleetOutput {
	s.AdditionalFixedProperties = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *UpdateWorkerFleetOutput) SetArn(v string) *UpdateWorkerFleetOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateWorkerFleetOutput) SetId(v string) *UpdateWorkerFleetOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateWorkerFleetOutput) SetName(v string) *UpdateWorkerFleetOutput {
	s.Name = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *UpdateWorkerFleetOutput) SetUpdatedAt(v time.Time) *UpdateWorkerFleetOutput {
	s.UpdatedAt = &v
	return s
}

type UpdateWorkerInput struct {
	_ struct{} `type:"structure"`

	// JSON blob containing unstructured worker properties that are fixed and won't
	// change during regular operation.
	AdditionalFixedProperties *string `locationName:"additionalFixedProperties" min:"1" type:"string"`

	// JSON blob containing unstructured worker properties that are transient and
	// may change during regular operation.
	AdditionalTransientProperties *string `locationName:"additionalTransientProperties" min:"1" type:"string"`

	// Full ARN of the worker.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// Human friendly name of the resource.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Worker orientation measured in units clockwise from north.
	Orientation *Orientation `locationName:"orientation" type:"structure"`

	// Supported coordinates for worker position.
	Position *PositionCoordinates `locationName:"position" type:"structure"`

	// Properties of the worker that are provided by the vendor FMS.
	VendorProperties *VendorProperties `locationName:"vendorProperties" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWorkerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWorkerInput"}
	if s.AdditionalFixedProperties != nil && len(*s.AdditionalFixedProperties) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AdditionalFixedProperties", 1))
	}
	if s.AdditionalTransientProperties != nil && len(*s.AdditionalTransientProperties) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AdditionalTransientProperties", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Position != nil {
		if err := s.Position.Validate(); err != nil {
			invalidParams.AddNested("Position", err.(request.ErrInvalidParams))
		}
	}
	if s.VendorProperties != nil {
		if err := s.VendorProperties.Validate(); err != nil {
			invalidParams.AddNested("VendorProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalFixedProperties sets the AdditionalFixedProperties field's value.
func (s *UpdateWorkerInput) SetAdditionalFixedProperties(v string) *UpdateWorkerInput {
	s.AdditionalFixedProperties = &v
	return s
}

// SetAdditionalTransientProperties sets the AdditionalTransientProperties field's value.
func (s *UpdateWorkerInput) SetAdditionalTransientProperties(v string) *UpdateWorkerInput {
	s.AdditionalTransientProperties = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateWorkerInput) SetId(v string) *UpdateWorkerInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateWorkerInput) SetName(v string) *UpdateWorkerInput {
	s.Name = &v
	return s
}

// SetOrientation sets the Orientation field's value.
func (s *UpdateWorkerInput) SetOrientation(v *Orientation) *UpdateWorkerInput {
	s.Orientation = v
	return s
}

// SetPosition sets the Position field's value.
func (s *UpdateWorkerInput) SetPosition(v *PositionCoordinates) *UpdateWorkerInput {
	s.Position = v
	return s
}

// SetVendorProperties sets the VendorProperties field's value.
func (s *UpdateWorkerInput) SetVendorProperties(v *VendorProperties) *UpdateWorkerInput {
	s.VendorProperties = v
	return s
}

type UpdateWorkerOutput struct {
	_ struct{} `type:"structure"`

	// JSON blob containing unstructured worker properties that are fixed and won't
	// change during regular operation.
	AdditionalFixedProperties *string `locationName:"additionalFixedProperties" min:"1" type:"string"`

	// JSON blob containing unstructured worker properties that are transient and
	// may change during regular operation.
	AdditionalTransientProperties *string `locationName:"additionalTransientProperties" min:"1" type:"string"`

	// Full ARN of the worker.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Full ARN of the worker fleet.
	//
	// Fleet is a required field
	Fleet *string `locationName:"fleet" min:"1" type:"string" required:"true"`

	// Filters access by the workers identifier
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// Human friendly name of the resource.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Worker orientation measured in units clockwise from north.
	Orientation *Orientation `locationName:"orientation" type:"structure"`

	// Supported coordinates for worker position.
	Position *PositionCoordinates `locationName:"position" type:"structure"`

	// Timestamp at which the resource was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`

	// Properties of the worker that are provided by the vendor FMS.
	VendorProperties *VendorProperties `locationName:"vendorProperties" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkerOutput) GoString() string {
	return s.String()
}

// SetAdditionalFixedProperties sets the AdditionalFixedProperties field's value.
func (s *UpdateWorkerOutput) SetAdditionalFixedProperties(v string) *UpdateWorkerOutput {
	s.AdditionalFixedProperties = &v
	return s
}

// SetAdditionalTransientProperties sets the AdditionalTransientProperties field's value.
func (s *UpdateWorkerOutput) SetAdditionalTransientProperties(v string) *UpdateWorkerOutput {
	s.AdditionalTransientProperties = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *UpdateWorkerOutput) SetArn(v string) *UpdateWorkerOutput {
	s.Arn = &v
	return s
}

// SetFleet sets the Fleet field's value.
func (s *UpdateWorkerOutput) SetFleet(v string) *UpdateWorkerOutput {
	s.Fleet = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateWorkerOutput) SetId(v string) *UpdateWorkerOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateWorkerOutput) SetName(v string) *UpdateWorkerOutput {
	s.Name = &v
	return s
}

// SetOrientation sets the Orientation field's value.
func (s *UpdateWorkerOutput) SetOrientation(v *Orientation) *UpdateWorkerOutput {
	s.Orientation = v
	return s
}

// SetPosition sets the Position field's value.
func (s *UpdateWorkerOutput) SetPosition(v *PositionCoordinates) *UpdateWorkerOutput {
	s.Position = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *UpdateWorkerOutput) SetUpdatedAt(v time.Time) *UpdateWorkerOutput {
	s.UpdatedAt = &v
	return s
}

// SetVendorProperties sets the VendorProperties field's value.
func (s *UpdateWorkerOutput) SetVendorProperties(v *VendorProperties) *UpdateWorkerOutput {
	s.VendorProperties = v
	return s
}

// Exception thrown if an invalid parameter is provided to an API.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Properties of the worker that are provided by the vendor FMS.
type VendorProperties struct {
	_ struct{} `type:"structure"`

	// JSON blob containing unstructured vendor properties that are fixed and won't
	// change during regular operation.
	VendorAdditionalFixedProperties *string `locationName:"vendorAdditionalFixedProperties" min:"1" type:"string"`

	// JSON blob containing unstructured vendor properties that are transient and
	// may change during regular operation.
	VendorAdditionalTransientProperties *string `locationName:"vendorAdditionalTransientProperties" min:"1" type:"string"`

	// The worker ID defined by the vendor FMS.
	//
	// VendorWorkerId is a required field
	VendorWorkerId *string `locationName:"vendorWorkerId" min:"1" type:"string" required:"true"`

	// The worker IP address defined by the vendor FMS.
	VendorWorkerIpAddress *string `locationName:"vendorWorkerIpAddress" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VendorProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VendorProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VendorProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VendorProperties"}
	if s.VendorAdditionalFixedProperties != nil && len(*s.VendorAdditionalFixedProperties) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VendorAdditionalFixedProperties", 1))
	}
	if s.VendorAdditionalTransientProperties != nil && len(*s.VendorAdditionalTransientProperties) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VendorAdditionalTransientProperties", 1))
	}
	if s.VendorWorkerId == nil {
		invalidParams.Add(request.NewErrParamRequired("VendorWorkerId"))
	}
	if s.VendorWorkerId != nil && len(*s.VendorWorkerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VendorWorkerId", 1))
	}
	if s.VendorWorkerIpAddress != nil && len(*s.VendorWorkerIpAddress) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VendorWorkerIpAddress", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVendorAdditionalFixedProperties sets the VendorAdditionalFixedProperties field's value.
func (s *VendorProperties) SetVendorAdditionalFixedProperties(v string) *VendorProperties {
	s.VendorAdditionalFixedProperties = &v
	return s
}

// SetVendorAdditionalTransientProperties sets the VendorAdditionalTransientProperties field's value.
func (s *VendorProperties) SetVendorAdditionalTransientProperties(v string) *VendorProperties {
	s.VendorAdditionalTransientProperties = &v
	return s
}

// SetVendorWorkerId sets the VendorWorkerId field's value.
func (s *VendorProperties) SetVendorWorkerId(v string) *VendorProperties {
	s.VendorWorkerId = &v
	return s
}

// SetVendorWorkerIpAddress sets the VendorWorkerIpAddress field's value.
func (s *VendorProperties) SetVendorWorkerIpAddress(v string) *VendorProperties {
	s.VendorWorkerIpAddress = &v
	return s
}

// A unit capable of performing tasks.
type Worker struct {
	_ struct{} `type:"structure"`

	// JSON blob containing unstructured worker properties that are fixed and won't
	// change during regular operation.
	AdditionalFixedProperties *string `locationName:"additionalFixedProperties" min:"1" type:"string"`

	// JSON blob containing unstructured worker properties that are transient and
	// may change during regular operation.
	AdditionalTransientProperties *string `locationName:"additionalTransientProperties" min:"1" type:"string"`

	// Full ARN of the worker.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Timestamp at which the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// Full ARN of the worker fleet.
	//
	// Fleet is a required field
	Fleet *string `locationName:"fleet" min:"1" type:"string" required:"true"`

	// Filters access by the workers identifier
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// Human friendly name of the resource.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Worker orientation measured in units clockwise from north.
	Orientation *Orientation `locationName:"orientation" type:"structure"`

	// Supported coordinates for worker position.
	Position *PositionCoordinates `locationName:"position" type:"structure"`

	// Site ARN.
	//
	// Site is a required field
	Site *string `locationName:"site" min:"1" type:"string" required:"true"`

	// Timestamp at which the resource was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`

	// Properties of the worker that are provided by the vendor FMS.
	VendorProperties *VendorProperties `locationName:"vendorProperties" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Worker) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Worker) GoString() string {
	return s.String()
}

// SetAdditionalFixedProperties sets the AdditionalFixedProperties field's value.
func (s *Worker) SetAdditionalFixedProperties(v string) *Worker {
	s.AdditionalFixedProperties = &v
	return s
}

// SetAdditionalTransientProperties sets the AdditionalTransientProperties field's value.
func (s *Worker) SetAdditionalTransientProperties(v string) *Worker {
	s.AdditionalTransientProperties = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Worker) SetArn(v string) *Worker {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Worker) SetCreatedAt(v time.Time) *Worker {
	s.CreatedAt = &v
	return s
}

// SetFleet sets the Fleet field's value.
func (s *Worker) SetFleet(v string) *Worker {
	s.Fleet = &v
	return s
}

// SetId sets the Id field's value.
func (s *Worker) SetId(v string) *Worker {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Worker) SetName(v string) *Worker {
	s.Name = &v
	return s
}

// SetOrientation sets the Orientation field's value.
func (s *Worker) SetOrientation(v *Orientation) *Worker {
	s.Orientation = v
	return s
}

// SetPosition sets the Position field's value.
func (s *Worker) SetPosition(v *PositionCoordinates) *Worker {
	s.Position = v
	return s
}

// SetSite sets the Site field's value.
func (s *Worker) SetSite(v string) *Worker {
	s.Site = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Worker) SetUpdatedAt(v time.Time) *Worker {
	s.UpdatedAt = &v
	return s
}

// SetVendorProperties sets the VendorProperties field's value.
func (s *Worker) SetVendorProperties(v *VendorProperties) *Worker {
	s.VendorProperties = v
	return s
}

// A collection of workers organized within a facility.
type WorkerFleet struct {
	_ struct{} `type:"structure"`

	// JSON blob containing additional fixed properties regarding the worker fleet
	AdditionalFixedProperties *string `locationName:"additionalFixedProperties" min:"1" type:"string"`

	// Full ARN of the worker fleet.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Timestamp at which the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// Filters access by the worker fleet's identifier
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// Human friendly name of the resource.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Site ARN.
	//
	// Site is a required field
	Site *string `locationName:"site" min:"1" type:"string" required:"true"`

	// Timestamp at which the resource was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkerFleet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkerFleet) GoString() string {
	return s.String()
}

// SetAdditionalFixedProperties sets the AdditionalFixedProperties field's value.
func (s *WorkerFleet) SetAdditionalFixedProperties(v string) *WorkerFleet {
	s.AdditionalFixedProperties = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *WorkerFleet) SetArn(v string) *WorkerFleet {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *WorkerFleet) SetCreatedAt(v time.Time) *WorkerFleet {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *WorkerFleet) SetId(v string) *WorkerFleet {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *WorkerFleet) SetName(v string) *WorkerFleet {
	s.Name = &v
	return s
}

// SetSite sets the Site field's value.
func (s *WorkerFleet) SetSite(v string) *WorkerFleet {
	s.Site = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *WorkerFleet) SetUpdatedAt(v time.Time) *WorkerFleet {
	s.UpdatedAt = &v
	return s
}

// State of the destination.
const (
	// DestinationStateEnabled is a DestinationState enum value
	DestinationStateEnabled = "ENABLED"

	// DestinationStateDisabled is a DestinationState enum value
	DestinationStateDisabled = "DISABLED"

	// DestinationStateDecommissioned is a DestinationState enum value
	DestinationStateDecommissioned = "DECOMMISSIONED"
)

// DestinationState_Values returns all elements of the DestinationState enum
func DestinationState_Values() []string {
	return []string{
		DestinationStateEnabled,
		DestinationStateDisabled,
		DestinationStateDecommissioned,
	}
}
