# ASUS P8Z77-V

This page describes how to run coreboot on the [ASUS P8H77-V].

## Flashing coreboot

```{eval-rst}
+---------------------+----------------+
| Type                | Value          |
+=====================+================+
| Socketed flash      | yes            |
+---------------------+----------------+
| Model               | W25Q64FVA1Q    |
+---------------------+----------------+
| Size                | 8 MiB          |
+---------------------+----------------+
| Package             | DIP-8          |
+---------------------+----------------+
| Write protection    | yes            |
+---------------------+----------------+
| Dual BIOS feature   | no             |
+---------------------+----------------+
| Internal flashing   | no             |
+---------------------+----------------+
```

The flash IC is located beside the SATA ports (circled):
![](p8z77-v.jpg)

### How to flash

The main SPI flash cannot be written because the vendor firmware disables BIOSWE
and enables BLE/SMM_BWP flags in BIOS_CNTL for their latest BIOSes. An external
programmer is required. You must flash standalone, flashing in-circuit doesn't
work. The flash chip is socketed, so it's easy to remove and reflash.

## Working

- PS/2 keyboard with SeaBIOS 1.14.0 and Debian GNU/Linux with kernel 5.10.28
- Integrated Ethernet NIC
- S3 Suspend to RAM
- USB2 on rear and front panel connectors
- USB3
- Integrated SATA
- CPU Temp sensors (tested PSensor on GNU/Linux)
- Native raminit
- Integrated graphics with libgfxinit (VGA/DVI-D/HDMI tested and working)
- PCIe in PCIe-16x slots
- Debug output from serial port

## Untested

- EHCI debugging
- S/PDIF audio
- PS/2 mouse

## Technology

```{eval-rst}
+------------------+--------------------------------------------------+
| Northbridge      | :doc:`../../northbridge/intel/sandybridge/index` |
+------------------+--------------------------------------------------+
| Southbridge      | bd82x6x                                          |
+------------------+--------------------------------------------------+
| CPU              | model_206ax                                      |
+------------------+--------------------------------------------------+
| Super I/O        | Nuvoton NCT6779D                                 |
+------------------+--------------------------------------------------+
| EC               | None                                             |
+------------------+--------------------------------------------------+
| Coprocessor      | Intel Management Engine                          |
+------------------+--------------------------------------------------+
```

## Extra resources

- [Flash chip datasheet][W25Q64FVA1Q]

[ASUS P8H77-V]: https://www.asus.com/supportonly/p8h77v/helpdesk_knowledge/
[W25Q64FVA1Q]: https://www.winbond.com/resource-files/w25q64fv%20revs%2007182017.pdf
[flashrom]: https://flashrom.org/
