// Generated by gir (https://github.com/gtk-rs/gir @ c93f8f31b6a5)
// from  (@ 3879ff8e0201)
// from gir-files (@ 01ea5f1a07cd)
// DO NOT EDIT

#![cfg(unix)]

use std::error::Error;
use std::ffi::OsString;
use std::mem::{align_of, size_of};
use std::path::Path;
use std::process::{Command, Stdio};
use std::{env, str};

use libglycin_rebind_sys::*;
use tempfile::Builder;

static PACKAGES: &[&str] = &["glycin-2"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Self, Box<dyn Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For _Generic
        args.push("-std=c11".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Self { args })
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<dyn Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {cmd:?} failed, {status}").into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<dyn Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{name} {err}").into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<dyn Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let pkg_config = env::var_os("PKG_CONFIG").unwrap_or_else(|| OsString::from("pkg-config"));
    let mut cmd = Command::new(pkg_config);
    cmd.arg("--cflags");
    cmd.args(packages);
    cmd.stderr(Stdio::inherit());
    let out = cmd.output()?;
    if !out.status.success() {
        let (status, stdout) = (out.status, String::from_utf8_lossy(&out.stdout));
        return Err(format!("command {cmd:?} failed, {status:?}\nstdout: {stdout}").into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}

#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn summary(&self) -> String {
        format!("{} passed; {} failed", self.passed, self.failed)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let mut c_constants: Vec<(String, String)> = Vec::new();

    for l in get_c_output("constant").unwrap().lines() {
        let (name, value) = l.split_once(';').expect("Missing ';' separator");
        c_constants.push((name.to_owned(), value.to_owned()));
    }

    let mut results = Results::default();

    for ((rust_name, rust_value), (c_name, c_value)) in
        RUST_CONSTANTS.iter().zip(c_constants.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {rust_name:?}\nC:    {c_name:?}");
            continue;
        }

        if rust_value != c_value {
            results.record_failed();
            eprintln!(
                "Constant value mismatch for {rust_name}\nRust: {rust_value:?}\nC:    {c_value:?}",
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let mut c_layouts = Vec::new();

    for l in get_c_output("layout").unwrap().lines() {
        let (name, value) = l.split_once(';').expect("Missing first ';' separator");
        let (size, alignment) = value.split_once(';').expect("Missing second ';' separator");
        let size = size.parse().expect("Failed to parse size");
        let alignment = alignment.parse().expect("Failed to parse alignment");
        c_layouts.push((name.to_owned(), Layout { size, alignment }));
    }

    let mut results = Results::default();

    for ((rust_name, rust_layout), (c_name, c_layout)) in RUST_LAYOUTS.iter().zip(c_layouts.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {rust_name:?}\nC:    {c_name:?}");
            continue;
        }

        if rust_layout != c_layout {
            results.record_failed();
            eprintln!("Layout mismatch for {rust_name}\nRust: {rust_layout:?}\nC:    {c_layout:?}",);
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

fn get_c_output(name: &str) -> Result<String, Box<dyn Error>> {
    let tmpdir = Builder::new().prefix("abi").tempdir()?;
    let exe = tmpdir.path().join(name);
    let c_file = Path::new("tests").join(name).with_extension("c");

    let cc = Compiler::new().expect("configured compiler");
    cc.compile(&c_file, &exe)?;

    let mut cmd = Command::new(exe);
    cmd.stderr(Stdio::inherit());
    let out = cmd.output()?;
    if !out.status.success() {
        let (status, stdout) = (out.status, String::from_utf8_lossy(&out.stdout));
        return Err(format!("command {cmd:?} failed, {status:?}\nstdout: {stdout}").into());
    }

    Ok(String::from_utf8(out.stdout)?)
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    (
        "GlyCicp",
        Layout {
            size: size_of::<GlyCicp>(),
            alignment: align_of::<GlyCicp>(),
        },
    ),
    (
        "GlyCreatorClass",
        Layout {
            size: size_of::<GlyCreatorClass>(),
            alignment: align_of::<GlyCreatorClass>(),
        },
    ),
    (
        "GlyEncodedImageClass",
        Layout {
            size: size_of::<GlyEncodedImageClass>(),
            alignment: align_of::<GlyEncodedImageClass>(),
        },
    ),
    (
        "GlyFrameClass",
        Layout {
            size: size_of::<GlyFrameClass>(),
            alignment: align_of::<GlyFrameClass>(),
        },
    ),
    (
        "GlyFrameRequestClass",
        Layout {
            size: size_of::<GlyFrameRequestClass>(),
            alignment: align_of::<GlyFrameRequestClass>(),
        },
    ),
    (
        "GlyImageClass",
        Layout {
            size: size_of::<GlyImageClass>(),
            alignment: align_of::<GlyImageClass>(),
        },
    ),
    (
        "GlyLoaderClass",
        Layout {
            size: size_of::<GlyLoaderClass>(),
            alignment: align_of::<GlyLoaderClass>(),
        },
    ),
    (
        "GlyLoaderError",
        Layout {
            size: size_of::<GlyLoaderError>(),
            alignment: align_of::<GlyLoaderError>(),
        },
    ),
    (
        "GlyMemoryFormat",
        Layout {
            size: size_of::<GlyMemoryFormat>(),
            alignment: align_of::<GlyMemoryFormat>(),
        },
    ),
    (
        "GlyMemoryFormatSelection",
        Layout {
            size: size_of::<GlyMemoryFormatSelection>(),
            alignment: align_of::<GlyMemoryFormatSelection>(),
        },
    ),
    (
        "GlyNewFrameClass",
        Layout {
            size: size_of::<GlyNewFrameClass>(),
            alignment: align_of::<GlyNewFrameClass>(),
        },
    ),
    (
        "GlySandboxSelector",
        Layout {
            size: size_of::<GlySandboxSelector>(),
            alignment: align_of::<GlySandboxSelector>(),
        },
    ),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("(gint) GLY_LOADER_ERROR_FAILED", "0"),
    ("(gint) GLY_LOADER_ERROR_NO_MORE_FRAMES", "2"),
    ("(gint) GLY_LOADER_ERROR_UNKNOWN_IMAGE_FORMAT", "1"),
    ("(gint) GLY_MEMORY_A8B8G8R8", "6"),
    ("(gint) GLY_MEMORY_A8R8G8B8", "4"),
    ("(gint) GLY_MEMORY_A8R8G8B8_PREMULTIPLIED", "1"),
    ("(gint) GLY_MEMORY_B8G8R8", "8"),
    ("(gint) GLY_MEMORY_B8G8R8A8", "3"),
    ("(gint) GLY_MEMORY_B8G8R8A8_PREMULTIPLIED", "0"),
    ("(gint) GLY_MEMORY_G16", "22"),
    ("(gint) GLY_MEMORY_G16A16", "21"),
    ("(gint) GLY_MEMORY_G16A16_PREMULTIPLIED", "20"),
    ("(gint) GLY_MEMORY_G8", "19"),
    ("(gint) GLY_MEMORY_G8A8", "18"),
    ("(gint) GLY_MEMORY_G8A8_PREMULTIPLIED", "17"),
    ("(gint) GLY_MEMORY_R16G16B16", "9"),
    ("(gint) GLY_MEMORY_R16G16B16A16", "11"),
    ("(gint) GLY_MEMORY_R16G16B16A16_FLOAT", "13"),
    ("(gint) GLY_MEMORY_R16G16B16A16_PREMULTIPLIED", "10"),
    ("(gint) GLY_MEMORY_R16G16B16_FLOAT", "12"),
    ("(gint) GLY_MEMORY_R32G32B32A32_FLOAT", "16"),
    ("(gint) GLY_MEMORY_R32G32B32A32_FLOAT_PREMULTIPLIED", "15"),
    ("(gint) GLY_MEMORY_R32G32B32_FLOAT", "14"),
    ("(gint) GLY_MEMORY_R8G8B8", "7"),
    ("(gint) GLY_MEMORY_R8G8B8A8", "5"),
    ("(gint) GLY_MEMORY_R8G8B8A8_PREMULTIPLIED", "2"),
    ("(guint) GLY_MEMORY_SELECTION_A8B8G8R8", "64"),
    ("(guint) GLY_MEMORY_SELECTION_A8R8G8B8", "16"),
    ("(guint) GLY_MEMORY_SELECTION_A8R8G8B8_PREMULTIPLIED", "2"),
    ("(guint) GLY_MEMORY_SELECTION_B8G8R8", "256"),
    ("(guint) GLY_MEMORY_SELECTION_B8G8R8A8", "8"),
    ("(guint) GLY_MEMORY_SELECTION_B8G8R8A8_PREMULTIPLIED", "1"),
    ("(guint) GLY_MEMORY_SELECTION_G16", "4194304"),
    ("(guint) GLY_MEMORY_SELECTION_G16A16", "2097152"),
    (
        "(guint) GLY_MEMORY_SELECTION_G16A16_PREMULTIPLIED",
        "1048576",
    ),
    ("(guint) GLY_MEMORY_SELECTION_G8", "524288"),
    ("(guint) GLY_MEMORY_SELECTION_G8A8", "262144"),
    ("(guint) GLY_MEMORY_SELECTION_G8A8_PREMULTIPLIED", "131072"),
    ("(guint) GLY_MEMORY_SELECTION_R16G16B16", "512"),
    ("(guint) GLY_MEMORY_SELECTION_R16G16B16A16", "2048"),
    ("(guint) GLY_MEMORY_SELECTION_R16G16B16A16_FLOAT", "8192"),
    (
        "(guint) GLY_MEMORY_SELECTION_R16G16B16A16_PREMULTIPLIED",
        "1024",
    ),
    ("(guint) GLY_MEMORY_SELECTION_R16G16B16_FLOAT", "4096"),
    ("(guint) GLY_MEMORY_SELECTION_R32G32B32A32_FLOAT", "65536"),
    (
        "(guint) GLY_MEMORY_SELECTION_R32G32B32A32_FLOAT_PREMULTIPLIED",
        "32768",
    ),
    ("(guint) GLY_MEMORY_SELECTION_R32G32B32_FLOAT", "16384"),
    ("(guint) GLY_MEMORY_SELECTION_R8G8B8", "128"),
    ("(guint) GLY_MEMORY_SELECTION_R8G8B8A8", "32"),
    ("(guint) GLY_MEMORY_SELECTION_R8G8B8A8_PREMULTIPLIED", "4"),
    ("(gint) GLY_SANDBOX_SELECTOR_AUTO", "0"),
    ("(gint) GLY_SANDBOX_SELECTOR_BWRAP", "1"),
    ("(gint) GLY_SANDBOX_SELECTOR_FLATPAK_SPAWN", "2"),
    ("(gint) GLY_SANDBOX_SELECTOR_NOT_SANDBOXED", "3"),
];
