@(SNIPPET(
    'publisher_groovy-postbuild',
    script='\n'.join([
        '// FIND UPDATED REPOSITORIES AND TRIGGER RECONFIGURE',
        'import hudson.model.Cause.UserIdCause',
        'import hudson.model.ParametersAction',
        'import hudson.model.StringParameterValue',
        'import java.io.BufferedReader',
        'import java.util.regex.Matcher',
        'import java.util.regex.Pattern',
        'import jenkins.model.Jenkins',
        '',
        'reconfigure_job_names = []',
    ] +
    ['reconfigure_job_names << "%s"' % name for name in reconfigure_job_names] +
    [
        '',
        'pattern = Pattern.compile(".*- updated \'%s\' entry for repository \'(.+)\'")' % entry_type,
        '',
        'repositories = []',
        'r = manager.build.getLogReader()',
        'br = new BufferedReader(r)',
        'def line',
        'while ((line = br.readLine()) != null) {',
        '    matcher = pattern.matcher(line)',
        '    if (matcher.matches()) {',
        '        repositories << matcher.group(1)',
        '    }',
        '}',
        '',
        'if (repositories) {',
        '    description = "Updated %s repositories:"' % entry_type,
        '    repository_names = ""',
        '    for (repo_name in repositories) {',
        '        description += " " + repo_name',
        '        if (repository_names != "") repository_names += " "',
        '        repository_names += repo_name',
        '    }',
        '    manager.build.setDescription(description)',
        '',
        '    for (job_name in reconfigure_job_names) {',
        '        p = Jenkins.instance.getItemByFullName(job_name)',
        '        if (p) {',
        '            p.scheduleBuild(1, new UserIdCause(), new ParametersAction(new StringParameterValue("repository_names", repository_names)))',
        '        }',
        '    }',
        '}',
    ]),
))@
