## Gazebo Fuel Tools 7.x

### Gazebo Fuel Tools 7.3.0 (2023-06-13)

1. Forward merges
    * [Pull request #355](https://github.com/gazebosim/gz-fuel-tools/pull/355)

1. Add bash completion
    * [Pull request #329](https://github.com/gazebosim/gz-fuel-tools/pull/329)

1. Reflect pagination of RESTful requests in iterator API
    * [Pull request #350](https://github.com/gazebosim/gz-fuel-tools/pull/350)

1. Support link referral download
    * [Pull request #333](https://github.com/gazebosim/gz-fuel-tools/pull/333)

### Gazebo Fuel Tools 7.2.2 (2023-03-29)

1. Support link referral download
    * [Pull request #333](https://github.com/gazebosim/gz-fuel-tools/pull/333)

### Gazebo Fuel Tools 7.2.1 (2023-03-22)

1. Allow Curl redirect on get.
    * [Pull request #331](https://github.com/gazebosim/gz-fuel-tools/pull/331)

1. CI and license updates.
    * [Pull request #334](https://github.com/gazebosim/gz-fuel-tools/pull/334)
    * [Pull request #335](https://github.com/gazebosim/gz-fuel-tools/pull/335)

1. Change backpack model version 2->3.
    * [Pull request #319](https://github.com/gazebosim/gz-fuel-tools/pull/319)

### Gazebo Fuel Tools 7.2.0 (2021-11-17)

1. Forward port 4.7.0.
    * [Pull request #306](https://github.com/gazebosim/gz-fuel-tools/pull/306)

### Gazebo Fuel Tools 7.1.0 (2021-08-16)

1. Ignition to Gazebo server rename effort
    * [Pull request #263](https://github.com/gazebosim/gz-fuel-tools/pull/263)

1. Remove redundant namespace references
    * [Pull request #284](https://github.com/gazebosim/gz-fuel-tools/pull/284)

1. Change `IGN_DESIGNATION` to `GZ_DESIGNATION`
    * [Pull request #278](https://github.com/gazebosim/gz-fuel-tools/pull/278)

1. Ignition -> Gazebo docs
    * [Pull request #276](https://github.com/gazebosim/gz-fuel-tools/pull/276)

1. Remove unused files (`bitbucket-pipelines`, `docs`)
    * [Pull request #273](https://github.com/gazebosim/gz-fuel-tools/pull/273)

1. Disable failing windows tests
    * [Pull request #266](https://github.com/gazebosim/gz-fuel-tools/pull/266)

1. Disable staging-fuel.ignitionrobotics.org test
    * [Pull request #257](https://github.com/gazebosim/gz-fuel-tools/pull/257)

1. Add missing header guard for `Interface.hh`
    * [Pull request #249](https://github.com/gazebosim/gz-fuel-tools/pull/249)

1. SDF from path helper
    * [Pull request #233](https://github.com/gazebosim/gz-fuel-tools/pull/233)

1.  Add Ubuntu Jammy CI
    * [Pull request #236](https://github.com/gazebosim/gz-fuel-tools/pull/236)

1. Fix trailing slashes in failing tests
    * [Pull request #237](https://github.com/gazebosim/gz-fuel-tools/pull/237)

1. Print error when unzipping fails to save a file
    * [Pull request #235](https://github.com/gazebosim/gz-fuel-tools/pull/235)

1. More checks when manipulating file system in tests
    * [Pull request #227](https://github.com/gazebosim/gz-fuel-tools/pull/227)

1. Move test cache to build folder
    * [Pull request #222](https://github.com/gazebosim/gz-fuel-tools/pull/222)

1. Improve and fix `ResultType` tests
    * [Pull request #225](https://github.com/gazebosim/gz-fuel-tools/pull/225)

1. Fix `cmdfuel` ruby script generation on Windows with MSVC
    * [Pull request #219](https://github.com/gazebosim/gz-fuel-tools/pull/219)

1. `FuelClient.cc`: include `<deque>`
    * [Pull request #213](https://github.com/gazebosim/gz-fuel-tools/pull/213)

1. APIs for retrieving models in parallel
    * [Pull request #199](https://github.com/gazebosim/gz-fuel-tools/pull/199)

### Ignition Fuel Tools 7.0.0 (2021-09-28)

1. Depend on ign-msgs8
    * [Pull request #182](https://github.com/ignitionrobotics/ign-fuel-tools/pull/182)

1. Infrastructure
    * [Pull request #184](https://github.com/ignitionrobotics/ign-fuel-tools/pull/184)
    * [Pull request #181](https://github.com/ignitionrobotics/ign-fuel-tools/pull/181)

## Ignition Fuel Tools 6.x

### Ignition Fuel Tools 6.2.0 (2022-03-25)

1. Fix trailing slashes in failing tests
    * [Pull request #237](https://github.com/ignitionrobotics/ign-fuel-tools/pull/237)

1. Print error when unzipping fails to save a file
    * [Pull request #235](https://github.com/ignitionrobotics/ign-fuel-tools/pull/235)

1. More checks when manipulating file system in tests
    * [Pull request #227](https://github.com/ignitionrobotics/ign-fuel-tools/pull/227)

1. Move test cache to build folder
    * [Pull request #222](https://github.com/ignitionrobotics/ign-fuel-tools/pull/222)

1. Improve and fix ResultType tests
    * [Pull request #225](https://github.com/ignitionrobotics/ign-fuel-tools/pull/225)

1. `FuelClient.cc`: `include <deque>`
    * [Pull request #213](https://github.com/ignitionrobotics/ign-fuel-tools/pull/213)

1. APIs for retrieving models in parallel
    * [Pull request #199](https://github.com/ignitionrobotics/ign-fuel-tools/pull/199)

### Ignition Fuel Tools 6.1.0 (2021-10-15)

1. Detect ign instead of using cmake module to check for ignition-tools
    * [Pull request #191](https://github.com/ignitionrobotics/ign-fuel-tools/pull/191)

1. Added fuel update command
    * [Pull request #185](https://github.com/ignitionrobotics/ign-fuel-tools/pull/185)

1. Fixed windows download
    * [Pull request #178](https://github.com/ignitionrobotics/ign-fuel-tools/pull/178)

1. Owner upload
    * [Pull request #179](https://github.com/ignitionrobotics/ign-fuel-tools/pull/179)

1. Infrastructure
    * [Pull request #187](https://github.com/ignitionrobotics/ign-fuel-tools/pull/187)
    * [Pull request #196](https://github.com/ignitionrobotics/ign-fuel-tools/pull/196)

### Ignition Fuel Tools 6.0.0 (2021-03-30)

1. Depend on ign-common4
    * [Pull request #163](https://github.com/ignitionrobotics/ign-fuel-tools/pull/163)

1. Depend on ign-msgs7
    * [Pull request #158](https://github.com/ignitionrobotics/ign-fuel-tools/pull/158)

1. Unset DELETE method on Windows
    * [Pull request #161](https://github.com/ignitionrobotics/ign-fuel-tools/pull/161)

1. Edifice deprecations
    * [Pull request #159](https://github.com/ignitionrobotics/ign-fuel-tools/pull/159)

1. Include windows instructions in examples README.md
    * [Pull request #176](https://github.com/ignitionrobotics/ign-fuel-tools/pull/176)

## Ignition Fuel Tools 5.x

### Ignition Fuel Tools 5.2.0 (2021-12-20)

1. FuelClient.cc: include `<deque>`
    * [Pull request #213](https://github.com/ignitionrobotics/ign-fuel-tools/pull/213)

1. APIs for retrieving models in parallel
    * [Pull request #199](https://github.com/ignitionrobotics/ign-fuel-tools/pull/199)

1. Detect `ign` instead of using cmake module to check for ignition-tools
    * [Pull request #191](https://github.com/ignitionrobotics/ign-fuel-tools/pull/191)

1. Added `ign fuel update` command
    * [Pull request #185](https://github.com/ignitionrobotics/ign-fuel-tools/pull/185)

1. Fixed Windows download and CI
    * [Pull request #178](https://github.com/ignitionrobotics/ign-fuel-tools/pull/178)
    * [Pull request #164](https://github.com/ignitionrobotics/ign-fuel-tools/pull/164)

1. Choose which owner to upload to
    * [Pull request #179](https://github.com/ignitionrobotics/ign-fuel-tools/pull/179)

1. Included private-token to `config.yaml`
    * [Pull request #156](https://github.com/ignitionrobotics/ign-fuel-tools/pull/156)

1. Add Windows Installation instructions
    * [Pull request #162](https://github.com/ignitionrobotics/ign-fuel-tools/pull/162)

1. Use semantic version and prevent crash if version is missing
    * [Pull request #151](https://github.com/ignitionrobotics/ign-fuel-tools/pull/151)

1. Document `IGN_FUEL_CACHE_PATH` on command line
    * [Pull request #149](https://github.com/ignitionrobotics/ign-fuel-tools/pull/149)

1. Infrastructure
    * [Pull request #187](https://github.com/ignitionrobotics/ign-fuel-tools/pull/187)
    * [Pull request #170](https://github.com/ignitionrobotics/ign-fuel-tools/pull/170)
    * [Pull request #167](https://github.com/ignitionrobotics/ign-fuel-tools/pull/167)
    * [Pull request #165](https://github.com/ignitionrobotics/ign-fuel-tools/pull/165)

### Ignition Fuel Tools 5.1.1 (2020-12-18)

1. Fix light map URI in materials
    * [Pull request 146](https://github.com/ignitionrobotics/ign-fuel-tools/pull/146)

### Ignition Fuel Tools 5.1.0 (2020-12-09)

1. Includes all changes up to version 4.3.0.

### Ignition Fuel Tools 5.0.0 (2020-09-28)

1. Added support for annotation parsing during model creation.
    * [Pull request 95](https://github.com/ignitionrobotics/ign-fuel-tools/pull/95)

1. Removed repeated installation instructions.
    * [Pull request 101](https://github.com/ignitionrobotics/ign-fuel-tools/pull/101)

1. Update codeowners.
    * [Pull request 108](https://github.com/ignitionrobotics/ign-fuel-tools/pull/108)

1. Hide Private headers and LocalCache.hh
    * [Pull request 109](https://github.com/ignitionrobotics/ign-fuel-tools/pull/109)

1. Fixed test - Download world 2
    * [Pull request 110](https://github.com/ignitionrobotics/ign-fuel-tools/pull/110)

## Gazebo Fuel Tools 4.x

### Gazebo Fuel Tools 4.8.3 (2023-03-29)

1. Support link referral download
    * [Pull request #333](https://github.com/gazebosim/gz-fuel-tools/pull/333)

### Gazebo Fuel Tools 4.9.0 (2023-05-03)

1. Add bash completion
    * [Pull request #329](https://github.com/gazebosim/gz-fuel-tools/pull/329)

1. Reflect pagination of RESTful requests in iterator API
    * [Pull request #350](https://github.com/gazebosim/gz-fuel-tools/pull/350)

### Gazebo Fuel Tools 4.8.3 (2023-03-29)

1. Support link referral download
    * [Pull request #333](https://github.com/gazebosim/gz-fuel-tools/pull/333)

### Gazebo Fuel Tools 4.8.2 (2023-03-21)

1. Allow Curl redirect on get.
    * [Pull request #331](https://github.com/gazebosim/gz-fuel-tools/pull/331)

1. CI and license updates.
    * [Pull request #334](https://github.com/gazebosim/gz-fuel-tools/pull/334)
    * [Pull request #335](https://github.com/gazebosim/gz-fuel-tools/pull/335)

### Gazebo Fuel Tools 4.8.1 (2023-02-07)

1. Fix model downloads for ignitionrobotics.org URIs.
    * [Pull request #318](https://github.com/gazebosim/gz-fuel-tools/pull/318)

### Gazebo Fuel Tools 4.8.0 (2022-12-07)

1. Reduce asset download sizes.
    * [Pull request #316](https://github.com/gazebosim/gz-fuel-tools/pull/316)

1. Update tutorials to use Gazebo.
    * [Pull request #303](https://github.com/gazebosim/gz-fuel-tools/pull/303)

1. Change ignitionrobotics.org to gazebosim.org.
    * [Pull request #304](https://github.com/gazebosim/gz-fuel-tools/pull/304)

### Gazebo Fuel Tools 4.7.0 (2022-11-17)

1. ign -> gz Migrate Ignition Headers : gz-fuel-tools.
    * [Pull request #285](https://github.com/gazebosim/gz-fuel-tools/pull/285)

### Gazebo Fuel Tools 4.6.0 (2022-08-15)

. Ignition to Gazebo server rename
    * [Pull request #263](https://github.com/gazebosim/gz-fuel-tools/pull/263)

1. Remove redundant namespace references
    * [Pull request #284](https://github.com/gazebosim/gz-fuel-tools/pull/284)

1. Change `IGN_DESIGNATION` to `GZ_DESIGNATION`
    * [Pull request #278](https://github.com/gazebosim/gz-fuel-tools/pull/278)

1. Ignition -> Gazebo
    * [Pull request #276](https://github.com/gazebosim/gz-fuel-tools/pull/276)

1. Remove unused files (bitbucket-pipelines, docs)
    * [Pull request #273](https://github.com/gazebosim/gz-fuel-tools/pull/273)

1. Disable `staging-fuel.gazebosim.org` test
    * [Pull request #257](https://github.com/gazebosim/gz-fuel-tools/pull/257)

### Ignition Fuel Tools 4.5.0 (2022-06-01)

1. APIs for retrieving models in parallel
    * [Pull request #199](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/199)

1. Add missing header guard for Interface.hh
    * [Pull request #249](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/249)

1. Print error when unzipping fails to save a file
    * [Pull request #235](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/235)

1. More checks when manipulating file system in tests
    * [Pull request #227](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/227)

1. Move test cache to build folder
    * [Pull request #222](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/222)

1. Improve and fix `ResultType` tests
    * [Pull request #225](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/225)

1. FuelClient.cc: include <deque>
    * [Pull request #213](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/213)

### Ignition Fuel Tools 4.4.0 (2021-06-17)

1. Remove `tools/code_check` and update codecov
    * [Pull request #187](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/187)

1. Fixed windows download
    * [Pull request #178](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/178)

1. Master branch updates
    * [Pull request #170](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/170)

1. Support private-token in `config.yaml`
    * [Pull request #156](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/156)

1. Add Windows Installation
    * [Pull request #162](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/162)

1. Use semantic version and prevent crash if version is missing
    * [Pull request #151](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/151)

1. Document `IGN_FUEL_CACHE_PATH` on command line
    * [Pull request #149](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/149)

1. Support editing/patching model files
    * [Pull request #140](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/140)

1. Set keep alive on
    * [Pull request #141](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/141)

### Ignition Fuel Tools 4.3.0 (2020-12-01)

1. Improve fork experience.
    * [Pull request 126](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/126)

1. Download dependencies.
    * [Pull request 123](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/123)

1. Includes all changes up to version 3.5.0.

### Ignition Fuel Tools 4.2.1 (2020-08-26)

1. Fix `ign fuel download`, which was missing the `-j` option.
    * [Pull request 116](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/116)

### Ignition Fuel Tools 4.2.0 (2020-08-26)

1. Set license information based on licenses available from a Fuel server
   and `legal` information in a `metadata.pbtxt` file.
    * [Pull request 69](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/69)

1. Added `edit` subcommand to the `ign fuel`. The edit command currently
   supports editing a model's privacy.
    * [Pull request 67](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/67)

1. Alphabetical listing of subcommands.
    * [Pull request 65](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/65)

1. All changes up to and including Ignition Fuel Tools 3.3.0 are included.

### Ignition Fuel Tools 4.1.0 (2020-02-27)

1. Resource deletion CLI.
    * [BitBucket pull request 119](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/119)

1. Fetch files
    * [BitBucket pull request 123](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/123)

1. README and tutorial updates:
    * [BitBucket pull request 113](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/113)
    * [BitBucket pull request 114](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/114)
    * [BitBucket pull request 115](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/115)

### Ignition Fuel Tools 4.0.0 (2019-12-10)

1. Model upload CLI, resource metadata CLI, depend on ign-msgs5.
    * [BitBucket pull request 108](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/108)

## Ignition Fuel Tools 3.x

### Ignition Fuel Tools 3.x.x (20xx-xx-xx)

### Ignition Fuel Tools 3.5.0 (2020-11-30)

1. Fix windows build.
    * [Pull request 107](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/107)

1. Resolve updated codecheck issues.
    * [Pull request 129](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/129)

1. Update Backpack model to fix tests.
    * [Pull request 132](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/132)

1. Use lowercase resource and owner names when storing assets on disk.
    * [Pull request 130](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/130)

### Ignition Fuel Tools 3.4.0 (2020-08-19)

1. Modernize github actions by updating to the new style.
    * [Pull request 94](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/94)

1. Fix test worlds.
    * [Pull request 100](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/100)

1. Add capability for downloading collections.
    * [Pull request 98](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/98)

1. Fix windows build.t
    * [Pull request 103](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/013)

### Ignition Fuel Tools 3.3.0 (2020-07-29)

1. openrobotics to OpenRobotics
    * [Pull request 75](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/75)

1. Fix world tests
    * [Pull request 76](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/76)

1. Add missing dependency in Actions CI
    * [Pull request 86](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/86)

1. Backport file fetching
    * [Pull request 84](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/84)

1. Convert model:// to Fuel URLs instead of absolute paths
    * [Pull request 85](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/85)

### Ignition Fuel Tools 3.2.2 (2020-05-18)

1. Fix URL encodings in RestClient.
    * [Pull request 70](https://gazebosim.org/gazebosim/gz-fuel-tools/pull/70)

1. Print message when downloading a resource.
    * [BitBucket pull request 102](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/102)

1. Use `${YAML_TARGET}` instead of `YAML::YAML` imported target.
    * [BitBucket pull request 103](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/103)

1. Convert emissive map file path.
    * [BitBucket pull request 105](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/105)

1. Fix windows build with `popen` and `pclose` macros.
    * [BitBucket pull request 109](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/109)

1. Remove std::experimental for filesystem (support for VS2019).
    * [BitBucket pull request 120](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/120)

### Ignition Fuel Tools 3.2.1 (2019-08-12)

1. Support actors
    * [BitBucket pull request 101](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/101)

### Ignition Fuel Tools 3.2.0 (2019-06-14)

1. FuelClient::DownloadModel accepts HTTP headers, and the `ign fuel
   download` command can accept a single HTTP header.
    * [BitBucket pull request 100](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/100)

### Ignition Fuel Tools 3.1.0 (2019-05-xx)

1. Fix PBR material URI
    * [BitBucket pull request 95](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/95)
    * [BitBucket pull request 96](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/96)

### Ignition Fuel Tools 3.0.0 (2018-02-28)

1. Integration with ign-gazebo. The following set of pull requests update
   fuel-tools to use ign-cmake2, sets api.ignitionfuel.org as the default
   server, fixes codecheck errors, removes old deprecations, and parses
   model.config files using tinyxml2.
    * [BitBucket pull request 82](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/82)
    * [BitBucket pull request 83](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/83)
    * [BitBucket pull request 84](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/84)
    * [BitBucket pull request 85](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/85)
    * [BitBucket pull request 87](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/87)
    * [BitBucket pull request 88](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/88)
    * [BitBucket pull request 89](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/89)

## Ignition Fuel Tools 1.x

### Ignition Fuel Tools 1.x.x (20xx-xx-xx)

1. Use `${YAML_TARGET}` instead of `YAML::YAML` imported target.
    * [BitBucket pull request 103](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/103)

### Ignition Fuel Tools 1.2.0 (2018-05-30)

1. Get cached model resource file
    * [BitBucket pull request 63](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/63)

1. Add some AsString functions
    * [BitBucket pull request 54](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/54)

1. Change cache directory structure and use it
    * [BitBucket pull request 57](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/57)
    * [BitBucket pull request 71](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/71)
    * [BitBucket pull request 73](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/73)

1. Client return only relevant cached models
    * [BitBucket pull request 62](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/62)

1. Model version support
    * [BitBucket pull request 65](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/65)

1. Remove server API version from model unique name
    * [BitBucket pull request 47](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/47)

1. Client handle unique names and get server info from config
    * [BitBucket pull request 55](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/55)

1. Changed model list to use headers for paging instead of iterating until
   a 404 is hit. Also added a mechanism to set the user agent
    * [BitBucket pull request 46](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/46)
    * [BitBucket pull request 61](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/61)

1. FuelClient: Don't use ServerConfig if there's ModelId
    * [BitBucket pull request 56](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/56)

1. List models from command line
    * [BitBucket pull request 43](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/43)
    * [BitBucket pull request 48](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/48)
    * [BitBucket pull request 44](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/44)
    * [BitBucket pull request 45](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/45)

1. Get cached model resource file
    * [BitBucket pull request 63](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/63)

1. Added const constructors for ModelIter and Model
    * [BitBucket pull request 42](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/42)

1. Use common::URI for server URL
    * [BitBucket pull request 59](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/59)

1. Remove server local name
    * [BitBucket pull request 58](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/58)

1. Encode url path before downloading models
    * [BitBucket pull request 41](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/41)

1. Download model from command line
    * [BitBucket pull request 68](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/68)

1. Backport code style changes
    * [BitBucket pull request 69](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/69)
    * [BitBucket pull request 67](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-fuel-tools/pull-requests/67)

### Ignition Fuel Tools 1.0.0 (2018-01-25)
