/*
 * Decompiled with CFR 0.152.
 */
package cadyts.interfaces.sumo;

import cadyts.calibrators.filebased.xml.XMLPopulationFileReader;
import cadyts.demand.PlanBuilder;
import cadyts.demand.PlanChoiceDistribution;
import cadyts.demand.PlanStep;
import cadyts.interfaces.sumo.SensorLocationLinkLoader;
import cadyts.interfaces.sumo.SensorLocationObjectiveFunction;
import cadyts.interfaces.sumo.SensorLocationVariation;
import cadyts.interfaces.sumo.SumoAgent;
import cadyts.interfaces.sumo.SumoPlan;
import cadyts.interfaces.sumo.SumoPopulationHandler;
import cadyts.utilities.math.simulatedannealing.SimulatedAnnealing;
import cadyts.utilities.misc.CommandLineParser;
import cadyts.utilities.misc.CommandLineParserElement;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SensorLocationOptimizer {
    private String popFile;
    private String relevantLinkFile;
    private String initialFile;
    private Integer sensorCnt;
    private double greedScale;
    private int iterations;
    private int prepIterations;
    private double priorOdVarScale;

    SensorLocationOptimizer() {
    }

    void run() {
        Set<Object> relevantLinks = null;
        if (this.relevantLinkFile != null) {
            try {
                relevantLinks = new SensorLocationLinkLoader().loadLinks(this.relevantLinkFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("loaded " + relevantLinks.size() + " relevant links");
        } else {
            relevantLinks = new LinkedHashSet();
        }
        Set<String> initialSolution = null;
        if (this.initialFile != null) {
            try {
                initialSolution = new SensorLocationLinkLoader().loadLinks(this.initialFile);
                this.sensorCnt = initialSolution.size();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("loaded " + this.sensorCnt + " initial links");
        }
        System.out.print("loading ");
        SensorLocationObjectiveFunction evaluation = new SensorLocationObjectiveFunction(this.priorOdVarScale);
        XMLPopulationFileReader<SumoAgent> reader = new XMLPopulationFileReader<SumoAgent>();
        SumoPopulationHandler handler = new SumoPopulationHandler(new PlanBuilder<String>(), null, 1.0);
        reader.setPopulationHandler(handler);
        int cnt = 0;
        for (SumoAgent agent : reader.getPopulationSource(this.popFile)) {
            if (cnt++ % 1000 == 0) {
                System.out.print(".");
            }
            int i = 0;
            while (i < agent.getPlans().size()) {
                SumoPlan plan = (SumoPlan)agent.getPlans().get(i);
                double prob = ((PlanChoiceDistribution)agent.getPlanChoiceModel()).getChoiceProbabilities(agent.getPlans()).get(i);
                for (PlanStep<String> step : plan) {
                    String link = step.getLink();
                    if (this.relevantLinkFile != null && !relevantLinks.contains(link)) continue;
                    relevantLinks.add(link);
                    evaluation.registerOdLink(agent.getODRelation(), step.getLink(), prob);
                }
                ++i;
            }
        }
        if (relevantLinks != null && relevantLinks.size() < this.sensorCnt) {
            throw new IllegalArgumentException("there are less relevant links than sensors");
        }
        SensorLocationVariation variation = new SensorLocationVariation(this.sensorCnt, relevantLinks);
        System.out.println();
        System.out.println("loaded " + cnt + " agents");
        System.out.println("loaded " + evaluation.odCnt() + " od pairs");
        System.out.println("loaded " + variation.linkCnt() + " links");
        System.out.println("scaling greediness");
        SimulatedAnnealing<Set<String>> sa = new SimulatedAnnealing<Set<String>>(variation, evaluation);
        double greediness = this.greedScale * sa.proposeGreediness(this.prepIterations);
        System.out.println("using scaled greediness of " + greediness);
        System.out.println("running optimization");
        sa.run(initialSolution, this.iterations, greediness);
    }

    public static void main(String[] args) {
        Integer sensorCnt;
        System.out.println("STARTED");
        Logger.getLogger("").setLevel(Level.OFF);
        String POPFILE = "-popfile";
        String ALLLINKS = "-alllinks";
        String INITIALLINKS = "-initiallinks";
        String SENSORCNT = "-sensorcnt";
        String GREEDINESS = "-greediness";
        String ITERATIONS = "-iterations";
        String PREPITERATIONS = "-prepiterations";
        String PRIORODVARSCALE = "-initialodvarscale";
        CommandLineParser clp = new CommandLineParser();
        clp.defineParameter("-popfile", true, null, "a (complete) SUMO route alternatives file");
        clp.defineParameter("-alllinks", false, null, "a file that contains all possible sensor locations");
        clp.defineParameter("-initiallinks", false, null, "a file that contains the inital sensor locations");
        clp.defineParameter("-sensorcnt", false, null, "the number of sensor (overridden by -initiallinks)");
        clp.defineParameter("-greediness", false, "1.0", "zero is random search; ~1000 is purely local search");
        clp.defineParameter("-iterations", false, "1000", "number of iterations");
        clp.defineParameter("-prepiterations", false, "100", "number of preparatory iterations");
        clp.defineParameter("-initialodvarscale", false, "1e2", "prior OD variance scale");
        if (args == null || args.length == 0) {
            for (CommandLineParserElement element : clp.getElements()) {
                System.err.println(element);
            }
            System.exit(0);
        }
        clp.parse(args);
        String popFile = clp.getString("-popfile");
        String relevantLinkFile = clp.getString("-alllinks");
        String initialFile = clp.getString("-initiallinks");
        Integer n = sensorCnt = clp.containsKey("-sensorcnt") ? Integer.valueOf(clp.getInteger("-sensorcnt")) : null;
        if (initialFile == null && sensorCnt == null) {
            throw new IllegalArgumentException("-sensorcnt parameter must be specified if there is no -initiallinks file specified");
        }
        double greedScale = clp.getDouble("-greediness");
        int iterations = clp.getInteger("-iterations");
        double priorOdVarScale = clp.getDouble("-initialodvarscale");
        int prepIterations = clp.getInteger("-prepiterations");
        System.out.println();
        System.out.println("population file is " + popFile);
        System.out.println("link file is " + relevantLinkFile);
        System.out.println("initial link file is " + initialFile);
        System.out.println("sensor count is " + sensorCnt);
        System.out.println("greediness is " + greedScale);
        System.out.println("iterations is " + iterations);
        System.out.println("prepparatory iterations is " + prepIterations);
        System.out.println("prior od variance scale is " + priorOdVarScale);
        System.out.println();
        SensorLocationOptimizer tsl = new SensorLocationOptimizer();
        tsl.popFile = popFile;
        tsl.relevantLinkFile = relevantLinkFile;
        tsl.initialFile = initialFile;
        tsl.sensorCnt = sensorCnt;
        tsl.greedScale = greedScale;
        tsl.iterations = iterations;
        tsl.prepIterations = prepIterations;
        tsl.priorOdVarScale = priorOdVarScale;
        tsl.run();
        System.out.println("DONE");
    }
}

