/*
 * Decompiled with CFR 0.152.
 */
package ui.dialogs;

import classes.TypeSelection;
import interfaces.SelectableType;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import ui.TypeSelectionTableModel;

public class DlgSelectTypes<T extends SelectableType>
extends JDialog
implements TableModelListener {
    private static final long serialVersionUID = 1L;
    private TypeSelection<T> types;
    private int answer = 2;
    private JPanel jContentPane = null;
    private JScrollPane scrlTypes = null;
    private JTable tblTypes = null;
    private JButton btnOK = null;
    private JButton btnCancel = null;
    private JLabel lblAvailableTypes = null;
    private JLabel lblTotal = null;

    public DlgSelectTypes(TypeSelection<T> types) {
        this.initialize();
        this.types = types;
        this.tblTypes.setModel(new TypeSelectionTableModel<T>(types));
        this.tblTypes.getModel().addTableModelListener(this);
        this.UpdateTotalPercentage();
    }

    private void initialize() {
        this.setSize(354, 217);
        this.setCursor(new Cursor(0));
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(false);
        this.setTitle("Select types");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.lblTotal = new JLabel();
            this.lblTotal.setBounds(new Rectangle(6, 163, 243, 19));
            this.lblTotal.setHorizontalAlignment(4);
            this.lblTotal.setText("");
            this.lblAvailableTypes = new JLabel();
            this.lblAvailableTypes.setBounds(new Rectangle(6, 4, 184, 17));
            this.lblAvailableTypes.setText("Available types:");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.getScrlTypes(), null);
            this.jContentPane.add((Component)this.getBtnOK(), null);
            this.jContentPane.add((Component)this.getBtnCancel(), null);
            this.jContentPane.add((Component)this.lblAvailableTypes, null);
            this.jContentPane.add((Component)this.lblTotal, null);
        }
        return this.jContentPane;
    }

    private JScrollPane getScrlTypes() {
        if (this.scrlTypes == null) {
            this.scrlTypes = new JScrollPane();
            this.scrlTypes.setBounds(new Rectangle(7, 27, 243, 133));
            this.scrlTypes.setViewportView(this.getTblTypes());
        }
        return this.scrlTypes;
    }

    private JTable getTblTypes() {
        if (this.tblTypes == null) {
            this.tblTypes = new JTable();
        }
        return this.tblTypes;
    }

    private JButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new JButton();
            this.btnOK.setBounds(new Rectangle(261, 125, 80, 24));
            this.btnOK.setText("OK");
            this.btnOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgSelectTypes.this.OK();
                }
            });
        }
        return this.btnOK;
    }

    protected void OK() {
        this.answer = 0;
        this.setVisible(false);
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setBounds(new Rectangle(262, 157, 81, 21));
            this.btnCancel.setText("Cancel");
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgSelectTypes.this.Cancel();
                }
            });
        }
        return this.btnCancel;
    }

    protected void Cancel() {
        this.answer = 2;
        this.setVisible(false);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.UpdateTotalPercentage();
    }

    private void UpdateTotalPercentage() {
        float totalPercentage = this.types.getTotalPercentage();
        this.lblTotal.setText("Remaining: " + String.valueOf(100.0f - totalPercentage) + " Total: " + String.valueOf(totalPercentage));
        if (totalPercentage != 100.0f) {
            this.btnOK.setEnabled(false);
        } else {
            this.btnOK.setEnabled(true);
        }
    }

    public int getAnswer() {
        return this.answer;
    }
}

