/*
 * Decompiled with CFR 0.152.
 */
package trafficdefinition;

import classes.Pair;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import roadnetwork.Edge;
import roadnetwork.Lane;
import shapes.Line2DExt;
import shapes.Point2DExt;
import shapes.Rectangle2DExt;
import trafficdefinition.Handle;
import trafficdefinition.TrafficDefinitionElement;

public class Accident
extends TrafficDefinitionElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Edge edge = null;
    private Point2DExt location = null;
    private float edgeRelativeLocation = 0.0f;
    private int endingTime;
    private Shape shape = null;
    private int startingTime;
    private List<Pair<Lane, Boolean>> affectedLanes = new ArrayList<Pair<Lane, Boolean>>();

    public Accident(Accident source) {
        super(source);
        this.startingTime = source.startingTime;
        this.endingTime = source.endingTime;
        this.edge = source.edge;
        this.shape = source.shape;
        this.location = source.location;
        this.edgeRelativeLocation = source.edgeRelativeLocation;
        for (Pair<Lane, Boolean> al : source.affectedLanes) {
            this.affectedLanes.add(new Pair<Lane, Boolean>(al.getFirst(), al.getSecond()));
        }
        this.edge.AddDependentTrafficElement(this);
    }

    public Accident(Edge edge, Point2D.Double location) {
        this.name = "Accident " + String.valueOf(increment++);
        this.edge = edge;
        this.location = new Point2DExt(location);
        this.shape = new Rectangle2DExt(location.x - 10.0, location.y - 10.0, 20.0, 20.0);
        Point2D.Double edgeStartingPoint = edge.getLanes().get(0).GetPoint(0);
        double relativeLocation = Math.min(edgeStartingPoint.distance(this.location), (double)edge.getLength());
        this.edgeRelativeLocation = relativeLocation > (double)edge.getLength() ? edge.getLength() / 2.0f : (float)relativeLocation;
        for (Lane l : edge.getLanes()) {
            this.affectedLanes.add(new Pair<Lane, Boolean>(l, true));
        }
        edge.AddDependentTrafficElement(this);
    }

    @Override
    public void Draw(Graphics2D g, double zoomFactor, boolean isDeleted, boolean isSelected) {
        Color prev = g.getColor();
        if (!isSelected) {
            g.setColor(Color.RED);
        }
        if (isSelected) {
            g.setColor(Color.GREEN);
        }
        Line2DExt l1 = new Line2DExt(new Point2DExt(this.location.x - 10.0, this.location.y - 10.0), new Point2DExt(this.location.x + 10.0, this.location.y + 10.0));
        Line2DExt l2 = new Line2DExt(new Point2DExt(this.location.x - 10.0, this.location.y + 10.0), new Point2DExt(this.location.x + 10.0, this.location.y - 10.0));
        Stroke previousStroke = g.getStroke();
        g.setStroke(new BasicStroke(6.0f, 1, 0));
        g.draw(l1);
        g.draw(l2);
        g.setColor(prev);
        g.setStroke(previousStroke);
    }

    @Override
    public TrafficDefinitionElement elementClone() {
        return new Accident(this);
    }

    public int getEndingTime() {
        return this.endingTime;
    }

    public int getStartingTime() {
        return this.startingTime;
    }

    @Override
    public String getToolTip() {
        String tooltip = "<html><b>Accident</b> " + this.name + "<br>" + "<b>Starting time: </b> " + String.valueOf(this.startingTime) + "<br>" + "<b>Ending time: </b>" + String.valueOf(this.endingTime);
        return tooltip;
    }

    @Override
    public Rectangle2DExt getBounds() {
        return new Rectangle2DExt((Rectangle2D.Double)this.shape.getBounds2D());
    }

    @Override
    public void handleLocationChanged(Handle h) {
    }

    @Override
    public boolean Hit(Point p) {
        return this.shape.getBounds2D().contains(p.x, p.y) && this.shape.contains(p.x, p.y);
    }

    @Override
    public boolean Hit(Rectangle transformedRectangle) {
        return this.shape.intersects(transformedRectangle);
    }

    public void setEndingTime(int endingTime) {
        this.endingTime = endingTime;
    }

    public void setStartingTime(int startingTime) {
        this.startingTime = startingTime;
    }

    public Edge getEdge() {
        return this.edge;
    }

    public List<Pair<Lane, Boolean>> getAffectedLanes() {
        return this.affectedLanes;
    }

    public float getEdgeRelativeLocation() {
        return this.edgeRelativeLocation;
    }

    @Override
    public String toXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<accident name=\"" + this.name + "\" streetName=\"" + this.edge.getId() + "\" startingTime=\"" + String.valueOf(this.startingTime) + "\" endingTime=\"" + String.valueOf(this.endingTime) + "\" location=\"" + String.valueOf(this.edgeRelativeLocation) + "\" >\n");
        sb.append("<affectedLanes>\n");
        for (Pair<Lane, Boolean> l : this.affectedLanes) {
            if (!l.getSecond().booleanValue()) continue;
            sb.append("<lane name=\"" + l.getFirst().getId() + "\" />\n");
        }
        sb.append("</affectedLanes>\n");
        sb.append("</accident>\n");
        return sb.toString();
    }
}

