// ==========================================================
// Definition of CelestLab "constants".  
// 
// Syntax: 
// data.name = value
// (scilab syntax)
// 
// Warning: 
// Most names are used in CelestLab, and consequently
// should not be changed. 
// ==========================================================

// Acceleration on Earth at altitude 0 due to gravity [m/s^2] - Standard value
data.g0 = 9.80665  

// deg to rad conversion 
data.deg2rad = %pi/180

// rad to deg conversion
data.rad2deg = 180/%pi

// Critical inclinations (so that drift of argument of perigee = 0) [rad]
// (mean drift due to J2 only)
data.criticalInc1 = 1.1071487177940905030170654601785370400 
data.criticalInc2 = 2.0344439357957027354455779231009658441  

// Margins for orbit types 
// if eccentricity < epsilon.cir       => circular orbit
// if eccentricity <= 1-epsilon.parab  => elliptic orbit
// if eccentricity >= 1+epsilon.parab  => hyperbolic orbit, parabolic otherwise
// if sin(inclination) < epsilon.equa  => equatorial orbit

data.epsilon.test  = %eps     // value used in regression tests
data.epsilon.cir   = 1.e-10    
data.epsilon.parab = 1.e-10  
data.epsilon.equa  = 1.e-10; 
