module Schleuder
  class EmailOutputter < Log4r::EmailOutputter
    def initialize(name, hash={})
      # The class needs to/from/subject, we don't use it
      hash = {:to => Schleuder.config.superadminaddr,
              :from => Schleuder.config.myaddr,
              :'error-to' => Schleuder.config.superadminaddr,
              :subject => 'Error',
              :immediate_at => 'ERROR, FATAL',
              :formatter => formatter,
              :domain => 'schleuder', # necessary for log4r from debian "stable"
              :buffsize => 1024**1024 # set the buff size very high otherwise we would trigger random log mails on random log statements if the buffer is full.
             }.merge(hash)
      @altmsg = "Hello,\n\nsending an encrypted error message to you failed. Therefore you receive only\nthis message and are kindly requested to take care of the encryption problem\n(e.g. fix your keys) and have a look at the logs to find the error.\n\nYours,  Schleuder\n"
      super name, hash
    end

    def format(events)
      events.map { |event| @formatter.format(event) }
    end

    def notify_admin(subject, msg)
      send_mail(makeemail(subject, msg))
    end

    def makeemail(subject=@subject, msg=nil)
      m = Mail.new
      m.subject = subject
      m.date = Time.now
      m.from = @from

      if msg
        case msg
        when String
          m.body = msg
        when Array
          m.body = ''
          m.mime_version = 1.0
          msg.each do |msgpart|
            part = Mail.new
            case msgpart
            when Mail
              # This contruction is needed to have valid boundaries. Did I mention that Tmail sucks?
              part.body = Mail.parse(msgpart.to_s).to_s
              part.content_type = 'message/rfc822'
            when String
              part.body = msgpart.to_s
              part.content_type = 'text/plain'
            else
              # This shouldn't happen (we should only have forwarded emails or
              # strings to notify admins), but who knows.
              part.body = msgpart
              part.content_type = 'application/octet-stream'
            end
            m.parts.push part
          end
        end
      else
        # Get the triggering error-msg(s).
        msg = format(@buff.select { |e| e.level > Log4r::WARN }).join
        # Get the whole log.
        backlog = format(@buff).join

        infopart = Mail.new
        infopart.body = "An error occurred working for list #{Schleuder.list.listname}:\n\n#{msg}\n\nSee also attachments.\n\n"
        m.parts.push infopart

        if Schleuder.origmsg
          origm = Mail.new
          origm.body = Schleuder.origmsg << "\n"
          origm.content_type = "message/rfc822"
          origm.set_content_disposition 'inline', { :filename => 'schleuder-orig-message.txt' }
          origm['content-description'] = "'The originally incoming message'"
          m.parts.push origm
        end

        backlogpart = Mail.new
        backlogpart.body = backlog << "\n\n"
        backlogpart['content-description'] = "'Schleuder logging output'"
        backlogpart.set_content_disposition 'inline', { :filename => 'schleuder-log.txt' }
        m.parts.push backlogpart
      end

      # Trigger re-parsing of the body, else TMail doesn't know it's multipart... :/
      m.to_s
      m
    end

    def send_mail(mail=makeemail)
      if @send_mail_lock
        self.level = Log4r::OFF # it's possible that the loglevel haven't yet been changed
        Schleuder.log.warn "This is a loop in sending a mail in the EmailOutputer, breaking!"
        return false
      end
      @send_mail_lock = true
      Schleuder.log.info 'Sending notification to admin'
      Schleuder.list.config.admins.each do |admin|
        Schleuder.log.debug { "Looping for admin #{admin}" }
        m = mail.individualize(admin)
        m.to = admin.email
        sender = Schleuder.config.superadminaddr
        if !Processor.send(m, admin, true, sender)
          m.body = @altmsg
          m.content_type = 'text/plain'
          Processor.send(m, admin, false, sender)
        end
      end
      Schleuder.log.info { 'Sending notification done' }
    rescue => e
      # switch off logging per email, else we create loops here!
      self.level = Log4r::OFF
      raise
    ensure
      @send_mail_lock = false
      @buff.clear
    end
  end
end
