/*
 * GormWizardPanel.h
 *
 * Interface declaration of the GormWizardPanel class for the
 * WizardPalette palette
 *
 * Copyright (c) 2006, by Saso Kiselkov
 *
 * For license details please see the file COPYING included with this
 * source distribution package.
 */

#import <WizardKit/WizardKit.h>

@interface GormWizardPanel : WKWizardPanel
{
  unsigned int wizardStyleMask;
  unsigned int autoPositionMask;
}

+ (BOOL) canSubstituteForClass: (Class) origClass;

- (id) initWithContentRect: (NSRect)contentRect
                 styleMask: (unsigned int)aStyle
                   backing: (NSBackingStoreType)bufferingType
                     defer: (BOOL)flag
                    screen: (NSScreen*)aScreen;

- (NSImage *) imageForViewer;

- (NSString *) objectNameForInspectorTitle;

- (NSString*) inspectorClassName;
- (NSString *) sizeInspectorClassName;

- (unsigned int) autoPositionMask;
- (void) setAutoPositionMask: (unsigned int)mask;

- (NSString *) className;

- (void) setStyleMask: (unsigned int) aMask;
- (unsigned int) styleMask;

- (void) encodeWithCoder: (NSCoder *) aCoder;

@end
