# Copyright (C) 2008-2010 LottaNZB Development Team
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

import gtk

import logging
log = logging.getLogger(__name__)

from lottanzb.config import ConfigSection
from lottanzb.modes.base import Mode as _Mode
from lottanzb.util import gproperty, _

class Config(ConfigSection):
    address = gproperty(type=str, default="localhost")
    port = gproperty(type=int, minimum=1, default=8760)
    password = gproperty(type=str, default="changeme")

class Mode(_Mode):
    title = _("Remote front-end mode")
    short = _("Remote front-end")
    description = _("Monitor a HellaNZB daemon on another computer, which is "
        "already configured and running.")
    icon = gtk.STOCK_NETWORK
    disconnect_message = "%s\n\n%s" % (
        _Mode.disconnect_message,
        _("Please make sure HellaNZB is running and the connection "
          "information are correctly set.")
    )
    
    def enter(self):
        for key in self.config:
            assert self.config[key]
        
        _Mode.enter(self)
    
    def get_connection_args(self):
        return (
            self.config.address,
            self.config.port,
            self.config.password
        )