/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////


#ifndef ESYS_LSMGRAINCOLLECTIONPY_H
#define ESYS_LSMGRAINCOLLECTIONPY_H

#include "Foundation/console.h"

#include "Geometry/GrainCollection.h"
#include "Python/esys/lsm/geometry/GrainPy.h"
#include "Python/esys/lsm/geometry/ParticleCollectionPy.h"

namespace esys
{
  namespace lsm
  {
    class GrainCollectionPy : public GrainCollection<GrainPy>
    {
    public:
      typedef GrainCollection<GrainPy>              Inherited;
      typedef IteratorPy<Inherited::GrainIterator>  GrainIteratorPy;
      typedef Inherited::ParticlePoolPtr            ParticlePoolPtr;
      typedef Inherited::GrainPoolPtr               GrainPoolPtr;

      GrainCollectionPy();

      GrainCollectionPy(ParticlePoolPtr particlePoolPtr);

      GrainCollectionPy(
        ParticlePoolPtr particlePoolPtr,
        GrainPoolPtr grainPoolPtr
      );

      GrainIteratorPy getGrainIteratorPy();

      GrainPy &createGrainPy();

      GrainPy &createGrainWithIdPy(GrainPy::Id id);

    private:
    };

    void exportGrainCollection();
  }
}

#endif
