# -*- rpm-spec -*-

Summary: Tethered shooting & control of digital cameras
Name: entangle
Version: 0.5.3
Release: 1%{?dist}%{?extra_release}
License: GPLv3+
Group: Applications/Multimedia
Source: http://entangle-photo.org/download/sources/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
URL: http://entangle-photo.org/

BuildRequires: glib2-devel >= 2.26.0
BuildRequires: gtk3-devel >= 3.0
BuildRequires: libgphoto2-devel >= 2.4.11
BuildRequires: libgudev1-devel >= 145
BuildRequires: dbus-glib-devel >= 0.60
BuildRequires: lcms-devel >= 1.18
BuildRequires: gobject-introspection-devel
BuildRequires: libpeas-devel >= 0.5.5
BuildRequires: libgexiv2-devel >= 0.2.2
BuildRequires: intltool
BuildRequires: libX11-devel
BuildRequires: libXext-devel >= 1.3.0
BuildRequires: LibRaw-devel >= 0.9.0

Requires(post): desktop-file-utils
Requires(postun): desktop-file-utils

%description
Entangle is an application which uses GTK and libgphoto2 to provide a
graphical interface for tethered photography with digital cameras.

It includes control over camera shooting and configuration settings
and 'hands off' shooting directly from the controlling computer.

%prep
%setup -q

%build

%configure --disable-schemas-compile
make %{?_smp_mflags} V=1

%install
rm -fr %{buildroot}

make install DESTDIR=$RPM_BUILD_ROOT
rm -rf %{buildroot}%{_datadir}/%{name}/website
%find_lang %{name}

%clean
rm -fr %{buildroot}

%post
update-desktop-database %{_datadir}/applications
glib-compile-schemas /usr/share/glib-2.0/schemas ||:

%postun
update-desktop-database %{_datadir}/applications
glib-compile-schemas /usr/share/glib-2.0/schemas ||:

%files -f %{name}.lang
%defattr(-, root, root)
%doc README COPYING AUTHORS NEWS ChangeLog
%{_bindir}/entangle
%{_mandir}/man1/entangle.1*
%{_datadir}/%{name}/%{name}-camera-info.xml
%{_datadir}/%{name}/%{name}-camera-manager.xml
%{_datadir}/%{name}/%{name}-camera-picker.xml
%{_datadir}/%{name}/%{name}-camera-support.xml
%{_datadir}/%{name}/%{name}-help-about.xml
%{_datadir}/%{name}/%{name}-image-popup.xml
%{_datadir}/%{name}/%{name}-preferences.xml
%{_datadir}/%{name}/%{name}-16x16.png
%{_datadir}/%{name}/%{name}-32x32.png
%{_datadir}/%{name}/%{name}-48x48.png
%{_datadir}/%{name}/%{name}-64x64.png
%{_datadir}/%{name}/%{name}-128x128.png
%{_datadir}/%{name}/%{name}-256x256.png
%{_datadir}/%{name}/%{name}.svg
%{_datadir}/%{name}/icons
%{_datadir}/%{name}/plugins.png
%{_datadir}/%{name}/plugins-22.png
%{_datadir}/%{name}/capture.png
%{_datadir}/%{name}/capture-22.png
%{_datadir}/%{name}/color-management.png
%{_datadir}/%{name}/color-management-22.png
%{_datadir}/%{name}/interface.png
%{_datadir}/%{name}/interface-22.png
%{_datadir}/%{name}/imageviewer.png
%{_datadir}/%{name}/imageviewer-22.png
%{_datadir}/%{name}/sRGB.icc
%{_datadir}/gtk-doc/html/Entangle
%{_datadir}/applications/%{name}.desktop
%{_datadir}/glib-2.0/schemas/org.entangle-photo.manager.gschema.xml
%{_datadir}/gir-1.0/Entangle-0.1.gir
%{_libdir}/girepository-1.0/Entangle-0.1.typelib
%dir %{_libdir}/%{name}
%dir %{_libdir}/%{name}/plugins
%dir %{_datadir}/%{name}/plugins

%changelog
