/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.filetree;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import javax.swing.tree.DefaultMutableTreeNode;

public class FileNode
extends DefaultMutableTreeNode
implements Transferable,
Serializable {
    private boolean explored = false;
    public static DataFlavor FILENODE = new DataFlavor(FileNode.class, "Remote file");
    static DataFlavor[] flavors = new DataFlavor[]{FILENODE, DataFlavor.stringFlavor};

    public FileNode(File file) {
        this.setUserObject(file);
    }

    public boolean getAllowsChildren() {
        return this.isDirectory();
    }

    public boolean isLeaf() {
        return !this.isDirectory();
    }

    public File getFile() {
        return (File)this.getUserObject();
    }

    public boolean isExplored() {
        return this.explored;
    }

    public boolean isDirectory() {
        File file = this.getFile();
        return file.isDirectory();
    }

    public String toString() {
        File file = (File)this.getUserObject();
        String filename = file.toString();
        int index = filename.lastIndexOf(File.separator);
        return index != -1 && index != filename.length() - 1 ? filename.substring(index + 1) : filename;
    }

    public void explore() {
        if (!this.isDirectory()) {
            return;
        }
        if (!this.isExplored()) {
            File file = this.getFile();
            this.explored = true;
            Object[] children = file.listFiles(new FilenameFilter(){

                public boolean accept(File d, String n) {
                    return !n.startsWith(".");
                }
            });
            Arrays.sort(children);
            for (int i = 0; i < children.length; ++i) {
                this.add(new FileNode((File)children[i]));
            }
        }
    }

    public void reExplore() {
        this.explored = false;
        this.removeAllChildren();
        this.explore();
    }

    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor f) {
        return f.equals(FILENODE) || f.equals(DataFlavor.stringFlavor);
    }

    public Object getTransferData(DataFlavor d) throws UnsupportedFlavorException, IOException {
        if (d.equals(FILENODE)) {
            return this;
        }
        if (d.equals(DataFlavor.stringFlavor)) {
            return this.getFile().getAbsolutePath();
        }
        throw new UnsupportedFlavorException(d);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

