#!/bin/ruby

# A test helper script that emulates apt's setting up of a pipe, that's used
# to feed input to apt-listbugs (in a way which does ont involve stdin). Meant
# for testing the patch at msg #103 in bug report #671726.
#
# This is incomplete and untested.

require 'fcntl'

read_fd, write_fd = IO.pipe

# duplicate read fd to a high-enough number that won't be reset upon fork/exec
new_read_fd = IO.open(read_fd.fcntl(Fcntl::F_DUPFD, 40))
new_read_fd.fcntl(Fcntl::FD_CLOEXEC, false)

# this variable tells apt-listbugs which fd to read from, in place of stdin
ENV['AptHookFd'] = new_read_fd.to_i.to_s
puts "AptHookFd set to #{ENV['AptHookFd']}"

if Process.fork().nil?
  # the child
  puts "invoking apt-listbugs child"
  # TODO invoke apt-listbugs
  puts "apt-listbugs child exitted"
  exit(0)
else
  # the parent
  # TODO read test data off a file and write it into write_fd
  Process.waitall
end

