<xsl:stylesheet
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
     version="1.0">

<!-- ####################################### -->
<!-- ####################################### -->
<!-- Padds end of table row with empty cells -->
<xsl:template name="endRow">
  <xsl:param name="cellsLeft"/>
  <xsl:if test="$cellsLeft">
    <td></td>
    <xsl:call-template name="endRow">
      <xsl:with-param name="cellsLeft" select="$cellsLeft - 1"/>
    </xsl:call-template>
  </xsl:if>
</xsl:template>
<!-- ####################################### -->
<!-- ####################################### -->
<!-- Converts strings to be javascript friendly (currently only escapes quotes) -->
<xsl:template name="JavaScriptString">
<xsl:param name="string"/>

 <xsl:call-template name="replace">
   <xsl:with-param name="string">
   
     <xsl:call-template name="replace">
       <xsl:with-param name="string">

       <xsl:call-template name="replace">
         <xsl:with-param name="string">
 
           <xsl:call-template name="replace">
             <!-- ###### FIRST escape the escape character ############# --> 
             <!-- ###### We must do this first so we do not escape escape characters used later on. ######## -->
             <xsl:with-param name="string" select="$string"/>
             <xsl:with-param name="pattern" select="'&#92;'"/>
             <xsl:with-param name="replacement" select="'\&#92;'"/>
           </xsl:call-template>

         </xsl:with-param>

         <!-- ###### Escape newlines in javascript strings ######## -->
         <xsl:with-param name="pattern" select="'&#10;'"/> 
         <xsl:with-param name="replacement" select="'\&#10;'"/>
       </xsl:call-template>

       </xsl:with-param>

       <!-- ###### Escape carrage returns in javascript strings ######## -->
       <xsl:with-param name="pattern" select="'&#13;'"/> 
       <xsl:with-param name="replacement" select="'\&#13;'"/>
     </xsl:call-template>

   </xsl:with-param>
 
  <!-- ###### Escape quotes in javascript strings ######## -->
   <xsl:with-param name="pattern" select="'&quot;'"/>
   <xsl:with-param name="replacement" select="'\&quot;'"/>
 </xsl:call-template>
 
</xsl:template>
<!-- ####################################### -->
<!-- ####################################### -->
<!-- Character replacement on strings -->
<xsl:template name="replace">
<xsl:param name="string"/>
<xsl:param name="pattern"/>
<xsl:param name="replacement"/>
<xsl:choose>
<xsl:when test="$pattern != '' and $string != '' and contains($string,$pattern)">
<xsl:value-of select="substring-before($string, $pattern)"/>
<!--
Use "xsl:copy-of" instead of "xsl:value-of" so that users
may substitute nodes as well as strings for $replacement.
-->
<xsl:copy-of select="$replacement"/>
<xsl:call-template name="replace">
<xsl:with-param name="string" select="substring-after($string, $pattern)"/>
<xsl:with-param name="pattern" select="$pattern"/>
<xsl:with-param name="replacement" select="$replacement"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="$string"/>
</xsl:otherwise>
</xsl:choose>
</xsl:template>
<!-- ####################################### -->
<!-- ####################################### -->
</xsl:stylesheet>
